/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msg_pack.h 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msg_pack.h $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# ifndef MSG_PACK_H
# define MSG_PACK_H

# include <string>
# include "struct.h"
# include "msg_api.h"
# include "msgs.h"

class msg_pack : private msg_api {

    unsigned long lastmsg;
    unsigned long total;
    unsigned long mbnum;
    unsigned long msgProcessed; // # of Termed Messages.

    mb_list_rec   mb;
    msgs          _msgf;

    public:
    msg_pack();
    int  ReadMessages();

    // Read in only current are and truncate mesasge base.
    void TruncCurrentArea(int iArea, int MaxMsgs);

    // Read in only current are and pack mesasge base.
    void PackCurrentArea(int iArea);
    // Change to next message area, if doesn't exist return FALSE!
    int  ChangeNextArea();
    // Loop throguh each message area and pack bases.
    void PackAllAreas();

    // Loop through and Truncate All Message areas.
    void TruncAllAreas();

};

# endif
