/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msg_api.h 110 2009-06-02 02:41:35Z frank $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msg_api.h $
// $LastChangedDate: 2009-06-01 22:41:35 -0400 (Mon, 01 Jun 2009) $
// $LastChangedRevision: 110 $
// $LastChangedBy: frank $

# ifndef MSG_API_H
# define MSG_API_H

# include <string>
# include "struct.h"
# include "msgapi.h"
# include "conio.h"
# include "msgs.h"
# include "language.h"
# include "msg_readll.h"

using namespace std;

# define MSG_QUOTE	0
# define MSG_TEXT	1
# define MSG_TEAR	2
# define MSG_ORIGIN	3

typedef enum {LOCAL, NETMAIL, ECHOMAIL, EMAIL, NEWS} MSGTYPE;
typedef enum {PUBLIC, PRIVATE} POSTTYPE;

class msg_api : public SESSION {


	public:

    std::string   buff;
	char          cinfbuf[CTLLEN];
	unsigned long buflen, cinflen;
	unsigned long MH,ML,MO,MR;

    // Handle to Current User
	UserRec *thisuser;

	typedef struct {
		char From[XMSG_FROM_SIZE];
		char To[XMSG_TO_SIZE];
		char Subj[XMSG_SUBJ_SIZE];
		char AreaName[61];
		struct _stamp date_written;
		struct _stamp date_arrived;
		char *Text;
		int colors[4];
		unsigned int replyto, replies[MAX_REPLY];
		unsigned int num_msg, cur_msg, high_msg, high_water;
		unsigned long attr;
		NETADDR orig;
		NETADDR dest;
	}MsgInfoRec;


    // Message API Handles
    MsgInfoRec      MI;
    MSGA            *AHandle;
    XMSG            xmsg;
    mb_list_rec     mr;
    MSGH            *mh;
    HMSG            hmsg;

    typedef struct MsgHead {
        char curmsg[10];
        char totmsg[10];
        char from[40];
        char to[40];
        char subj[80];
        char flags[10];
        char time[81];
        char area[50];
    }MsgHead;

    // Helper Calsses
	MsgHead        mHead;
    msg_readll     mLink;
	language       _lang;
	msgs           _msgf;

	struct
    _minf          m;   // msg API Handle

    // Mesage Packing Variables
    unsigned long msgCopied,   msgProcessed;   // per Area
    unsigned long totaloldMsg, totalmsgCopied;


	// Constructor - Initalize MSGAPI!
	msg_api() {
    	m.req_version = 2;
    	//mi.req_version = 0;
    	//mi.def_zone = 2;
    	//m.haveshare   = 1;
    	//m.def_zone  = cfg->addr[0].zone;

    	// Startup the Husky Message API
    	if (MsgOpenApi(&m)!= 0) {
			//elog("MsgOpenApi Error, Could Not INIT.");
    	}
        start_session(thisuser);
	}

	// Message Posting Functions
	char *faddr2char(char *s,fidoaddr *fa);
    int  SaveMsg(unsigned long msgarea, unsigned long msgnum, int New);
    void MakeCtrlHdr(char *reply);
    void GetMsgID(char *reply);
    void fill_xmsg(char *from, char *to, char *subj);

    // Message Main Setup functions
    void Add2MsgInfo();
    void CloseMsgArea();
    int  OpenMsgArea(unsigned long mbnum);
    time_t stampToTimeT(struct _stamp *st);
    struct _stamp *timeTToStamp(time_t tt);
    void FidoFlags(char *fflags);
    void SetupMsgHdr();
    char *strrepl(char *Str, size_t BufSiz, const char *OldStr, const char *NewStr);
    void stripCR(char *ostr);
    void stripCRONLY(char *ostr);
    void MsgSetupTxt();
    void MsgSetupQuoteTxt();
    void MsgShowTxt2();

    int  GetMsgInfo();
    int  GetMsg();

    int  SquishAreaSetLast(unsigned long usr,unsigned long lr);
    void SetLastRead(unsigned long usr, unsigned long lr);

    unsigned
    long SquishAreaGetLast(unsigned long usr);
    unsigned
    long GetLastRead(unsigned long usr);

    // Message Packing Functions
    void doArea(int marea, char *cmp);
    int  packmsgarea(int marea);
};

# endif

