/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: msg_api.cpp 152 2010-04-10 10:53:59Z mercyful $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/msg_api.cpp $
// $LastChangedDate: 2010-04-10 06:53:59 -0400 (Sat, 10 Apr 2010) $
// $LastChangedRevision: 152 $
// $LastChangedBy: mercyful $


# include <cstdio>
# include <cstring> // gcc 4.3
# include <cstdlib> // gcc 4.3

# include <string>

# include "struct.h"
# include "msg_api.h"

using namespace std;

//int TRUE  = 1;
//int FALSE = 0;

/*
                              oldArea == AHandle??? or #
    highMsg = MsgGetHighMsg(oldArea);
    numMsg  = MsgGetNumMsg(oldArea);
    hw      = MsgGetHighWater(oldArea);
    MsgSetHighWater(newArea, hw);


*/

char *msg_api::faddr2char(char *s,fidoaddr *fa) {

	if(fa->point)
		sprintf(s,"%u:%u/%u.%u",
			fa->zone,fa->net,fa->node,fa->point);
	else
		sprintf(s,"%u:%u/%u",
			fa->zone,fa->net,fa->node);
	return(s);
}

int msg_api::SaveMsg(unsigned long msgarea, unsigned long msgnum, int New) {

    if (AHandle != NULL) { CloseMsgArea(); }
    if(OpenMsgArea(msgarea)){
        if(New)
            hmsg = MsgOpenMsg(AHandle, MOPEN_CREATE, 0);
        else
            hmsg = MsgOpenMsg(AHandle, MOPEN_RW, msgnum);

        char *tbuff = new char [buff.size()+1];
        strcpy(tbuff,buff.c_str());
        MsgWriteMsg(hmsg, 0, &xmsg, (byte*)tbuff, strlen(tbuff), strlen(tbuff),
                strlen(cinfbuf), (byte*)cinfbuf);

        delete [] tbuff;
        MsgCloseMsg(hmsg);
        CloseMsgArea();
    }
    else {
         return (FALSE);
    }
    return 0;
}

void msg_api::MakeCtrlHdr(char *reply) {

    char adrs[21]={0};
    unsigned long num;
    time((time_t *)&num);

    faddr2char(adrs, &mr.aka);

    if(strlen(reply) == 0) {
        sprintf(cinfbuf,"\01MSGID: %s %ld\01PID: %s", adrs, num, BBSVERSION);
    }
    else {
        sprintf(cinfbuf,"\01MSGID: %s %ld\01%s\01PID: %s", adrs, num, reply, BBSVERSION);
    }
}

void msg_api::GetMsgID(char *reply) {

	int  iLineBeg = 0, iLineEnd = 0, iCnt = 0;
	char line[1024] = {0};

    while(iLineBeg < cinflen && iLineEnd < cinflen) {
        memset(line,0,sizeof(line));
        while(( iLineEnd < cinflen &&
                iLineEnd < (80+iLineBeg)) &&
                cinfbuf[iLineEnd] != '\01') {
            iLineEnd++;
        }
        while(((iLineEnd > iLineBeg) &&
                (iLineEnd > 0) &&
                (iLineEnd > (80+iLineBeg-10))) &&
                cinfbuf[iLineEnd] != '\01') {
            iLineEnd--;
        }
        if((iLineEnd >= iLineBeg) && iLineEnd <= cinflen){
            memcpy(line,cinfbuf+iLineBeg,iLineEnd-iLineBeg);
            stripCR(line);
            if(strncmp(line,"MSGID",5) == 0) {
                strcpy(reply,line);
                break;
            }
            iCnt++;
        }
        else{
            return;
        }
        iLineEnd++;
        iLineBeg=iLineEnd;
    }
}

void msg_api::fill_xmsg(char *from, char *to, char *subj) {

    strcpy((char*)xmsg.to,to);
    strcpy((char*)xmsg.from,from);
    strcpy((char*)xmsg.subj,subj);
}


void msg_api::Add2MsgInfo() {

    strcpy(MI.AreaName, mr.mbdisplay);
    MI.colors[0]    = mr.colors[0];
    MI.colors[1]    = mr.colors[1];
    MI.colors[2]    = mr.colors[2];
    MI.colors[3]    = mr.colors[3];

    strcpy(MI.From, (const char*)xmsg.from);
    strcpy(MI.To,   (const char*)xmsg.to);
    strcpy(MI.Subj, (const char*)xmsg.subj);
    MI.orig.zone    = xmsg.orig.zone;
    MI.orig.net     = xmsg.orig.net;
    MI.orig.node    = xmsg.orig.node;
    MI.orig.point   = xmsg.orig.point;
    MI.dest.zone    = xmsg.dest.zone;
    MI.dest.net     = xmsg.dest.net;
    MI.dest.node    = xmsg.dest.node;
    MI.dest.point   = xmsg.dest.point;
    MI.attr         = xmsg.attr;
    MI.date_written = xmsg.date_written;
    MI.date_arrived = xmsg.date_arrived;
    MI.replyto      = xmsg.replyto;

    MI.high_water   = AHandle->high_water;
    MI.high_msg     = MsgHighMsg(AHandle);
    MI.cur_msg      = MsgCurMsg(AHandle);
    MI.num_msg      = MsgNumMsg(AHandle);
    MO = MI.cur_msg;
    MH = MI.high_msg;
    ML = 1L;

    for(int i = 0; i < 10; i++) {
        if(xmsg.replies[i] != 0){
            MI.replies[i]   = xmsg.replies[i];
        }
    }
}

void msg_api::CloseMsgArea() {

    if(AHandle != NULL) {
        MsgCloseArea(AHandle);
    }
    AHandle = NULL;
}

int msg_api::OpenMsgArea(unsigned long mbnum) {

    //////errlog2("OpenMsgArea");
    char path[255];

    memset(&mr,0,sizeof(mb_list_rec));
    if(!_msgf.read_mbaselist(&mr,mbnum)){
        return (FALSE);
    }
    sprintf(path,"%s%s",mr.mbpath, mr.mbfile);

    CloseMsgArea();
    AHandle = MsgOpenArea((byte *)path, MSGAREA_CRIFNEC, mr.Type);
    if (AHandle == NULL) return (FALSE);

    Add2MsgInfo();
    return (TRUE);
}

time_t msg_api::stampToTimeT(struct _stamp *st) {

    time_t tt;
    struct tm tms;
    tms.tm_sec   = st->time.ss << 1;
    tms.tm_min   = st->time.mm;
    tms.tm_hour  = st->time.hh;
    tms.tm_mday  = st->date.da;
    tms.tm_mon   = st->date.mo - 1;
    tms.tm_year  = st->date.yr + 80;
    tms.tm_isdst = -1;
    tt = mktime(&tms);
    return tt;
}

struct _stamp *msg_api::timeTToStamp(time_t tt) {

    struct tm *tmsp;
    static struct _stamp st;
    tmsp = localtime(&tt);
    st.time.ss = tmsp->tm_sec >> 1;
    st.time.mm = tmsp->tm_min;
    st.time.hh = tmsp->tm_hour;
    st.date.da = tmsp->tm_mday;
    st.date.mo = tmsp->tm_mon + 1;
    st.date.yr = tmsp->tm_year - 80;
    return (&st);
}

void msg_api::FidoFlags(char *fflags) {

    if(MI.attr & MSGPRIVATE)
        strcat(fflags,"Private");
    if(MI.attr & MSGCRASH)
        (strlen(fflags)>0) ? strcat(fflags,", ") : strcat(fflags,"Crash");
    if(MI.attr & MSGREAD)
        (strlen(fflags)>0) ? strcat(fflags,", ") : strcat(fflags,"Read");
    if(MI.attr & MSGLOCAL)
        (strlen(fflags)>0) ? strcat(fflags,", ") : strcat(fflags,"Local");
}

void msg_api::SetupMsgHdr() {

    time_t tmt;
    struct tm *mtm;
    char faddr[81]   ={0},
         timestr[81] ={0},
         fflags[41]  ={0},
         namestr[81] ={0},
         tostr[81]   ={0};

    unsigned int repf,rept;
    std::string sFrom;
//  int id1;

    rept    = MI.replyto;
    repf    = MI.replies[0];
    *fflags = '\0';
    FidoFlags(fflags);

/*
    if(mr.Kind != LOCAL && mr.Kind != EMAIL){
        if(MI.orig.point) {
            sprintf(faddr,"%d:%d/%d.%d",
            MI.orig.zone, MI.orig.net, MI.orig.node,MI.orig.point);
            sprintf(namestr,"%s",MI.From);
		}
        else {
            sprintf(faddr,"%d:%d/%d", MI.orig.zone, MI.orig.net, MI.orig.node);
            sprintf(namestr,"%s",MI.From);
		}
    }
    else{
        sprintf(namestr,"%s",MI.From);
    }
    */

    if(mr.Kind == NETMAIL){
        if(MI.dest.point) {
            sprintf(faddr,"%d:%d/%d.%d",
            MI.dest.zone, MI.dest.net, MI.dest.node,MI.dest.point);
            sprintf(tostr,"%s@%s",MI.To,faddr);
		}
        else {
            sprintf(faddr,"%d:%d/%d", MI.dest.zone, MI.dest.net, MI.dest.node);
        	sprintf(tostr,"%s@%s",MI.To,faddr);
		}
    }
    else
        sprintf(tostr,"%s",MI.To);


    //elog2 (MI.To);
    //elog2 (MI.From);

    sprintf(tostr,"%s",MI.To);
    sprintf(namestr,"%s",MI.From);

    tmt = stampToTimeT(&MI.date_written);
    mtm = localtime(&tmt);

    //strftime(timestr,81,"%m/%d/%Y %H:%M",mtm);
    strftime(timestr,81,"%A %m/%d/%Y %I:%M %p",mtm);

    sprintf(mHead.curmsg,"%i", (unsigned int)thisuser->lastmsg);
    sprintf(mHead.totmsg,"%i", (unsigned int)MsgNumMsg(AHandle));

    // Remove for Normal Echomail

/*
    sFrom = namestr;
    id1 = sFrom.find("@",0);
    if (id1 != -1) {
        sFrom.erase(id1,sFrom.size() - id1);
    }
*/

    //strcpy(mHead.from,  sFrom.c_str());

    strcpy(mHead.from,  namestr);
    strcpy(mHead.to,    tostr);
    strcpy(mHead.subj,  MI.Subj);

    // Echomail is left Blank so set it up - Probably change to Sent!!
    (strlen(fflags) <= 1) ? strcpy(mHead.flags, "Echomail") : strcpy(mHead.flags, fflags);
    strcpy(mHead.time,  timestr);
    strcpy(mHead.area,  MI.AreaName);


}

char *msg_api::strrepl(char *Str, size_t BufSiz, const char *OldStr, const char *NewStr) {

	int OldLen, NewLen;
	char *p, *q;

	if(NULL == (p = strstr(Str, OldStr)))
		return Str;
	OldLen = strlen(OldStr);
	NewLen = strlen(NewStr);
	if ((strlen(Str) + NewLen - OldLen + 1) > BufSiz)
		return NULL;
	memmove(q = p+NewLen, p+OldLen, strlen(p+OldLen)+1);
	memcpy(p, NewStr, NewLen);
	return q;
}

void msg_api::stripCR(char *ostr) {

	while(strchr(ostr,'\n')) strrepl(ostr,500,"\n","");
	while(strchr(ostr,'\r')) strrepl(ostr,500,"\r","");
	while(strchr(ostr,'\b')) strrepl(ostr,500,"\b","");
	while(strchr(ostr,'\x1b')) strrepl(ostr,500,"\x1b","");
}

void msg_api::stripCRONLY(char *ostr) {

	while(strchr(ostr,'\n')) strrepl(ostr,500,"\n","");
	while(strchr(ostr,'\r')) strrepl(ostr,500,"\r","");
	while(strchr(ostr,'\b')) strrepl(ostr,500,"\b","");
}


/*

This needs to be updated to use FSE Word Wrapping to properly display 80 line of text

*/


// Formats Message Text into Link List.
void msg_api::MsgSetupTxt() {

    //errlog2((char *)" *** MsgSetupTxt!");

    int id1    = 0, id2    = 0, id3 = 0;
    int index1 = 0, index2 = 0,   i = 0;
    int len    = 0;
    int BegininngText = TRUE;
    char szTmp[3] = {0};

    LineRec *tmp;

    std::string Line;
    std::string sTrunc;
    std::string MsgText = buff; // Get Message Buffer!

    #define MAX_LEN 81

    // Setup the Message Header
    SetupMsgHdr();

    //errlog2((char *)" *** MsgSetupHdr!");

    // Now Read in Message Text and Populate Link List.
    while(1) {
        //errlog2((char *)" *** while 1!");
        Line.erase();
		// Each Line ends with '\r' in jam api
        // Although some Echomail doesn't use this standard.
        id1 = MsgText.find("\r", 1);
        // Make Sure only to Add New Lines when being used,
        // First Line is already Setup! So Skip it
        //if (id1 != -1) mLink.add_to_list("");
        if (id1 == -1) break;
        else {

            len = MAX_LEN;
            index1 = 0;
            // Fix for Pipe Codes, recount chars in line and compisate!
            while (1) {
                index1 = MsgText.find("|",index1);
                //elog ("pipe fixing....");
                if (index1 != -1 && id1 > len) {
                    szTmp[0] = MsgText[index1+1];  // Get First # after Pipe
                    szTmp[1] = MsgText[index1+2];  // Get Second Number After Pipe

                    //  If Color Pipe, add to max len.
                    if (isdigit(szTmp[0]) && isdigit(szTmp[1])) {
                        len      += 3;
                        index1   += 3;
                    }
                    else { break; }
                } else { break; }
            }

            index2 = 0;
            // Fix for Ansi Codes, recount chars in line and compisate!


            ///Bug, crashes out on METRO BBS Discussion Msg# 383
/*
            while (1) {

                index2 = MsgText.find("\x1b[",index2);
                //elog ("Ansi fixing....");
                if (index2 != -1 ){ // && id1 > len) {
                    index1 = -1;
                    index1 = MsgText.find("m",index2+3);
                    if (index1 != -1) {
                        len      += index1 - index2;
                        index2   += index1 - index2;
                    }
                    else index2 += 3;
                } else { break; }
            }
*/

            // Do the nextline is great then message width
            if (id1 > len) id1 = len; // Some Writers don't use newlines.

            // Chop up string into message line / row.
            Line = MsgText.substr(0,id1);
            MsgText.erase(0,id1);

            if (Line.size()-1 >= len) {
                Line = Line.substr(0,len-1);
            }

            // Clean each broken up line for proper display
            // Remove any special line chars before entering link list.
            while (1) {
                id1 = Line.find("\r", 0);
                if (id1 != -1)
                    Line.erase(id1,1);
                else break;
            }

            // Cutoff any blank Lines in the beginning of a message.
            if (BegininngText) {
                //errlog2((char *)" *** Begining!");
                if (Line != " ") {
                    if (Line.size() > 0) {
                        //mLink.current_node->data = Line;
                        mLink.add_to_list(Line);
                        ++i;
                        BegininngText = FALSE;
                    }
                }
            }
            else {
                //errlog2((char *)" *** strip Seen-by!");
                sTrunc = Line;
                id1 = sTrunc.find("SEEN-BY: ",0);
                id2 = sTrunc.find("PATH: ",0);
                id3 = sTrunc.find("Via ",0);

                if (id1 == std::string::npos &&
                    id2 == std::string::npos &&
                    id3 == std::string::npos) {
                    //mLink.current_node->data = Line;
                     mLink.add_to_list(Line);
                    ++i;
                }
            }
        }
    }


    //errlog2((char *)" *** Delete and Move up! HERE");

    // (Delete and Move Up) remove any blank lines from bottom going up...
    // For Cleaner Message Display with no extra lines.
    /*
    for (;;) {
        if (!mLink.move_down()) {

            break;
        }
    } */
    mLink.current_node = mLink.last;
    if  (mLink.current_node == 0) return;
    for (;;) {
        if (mLink.current_node->data == " " || mLink.current_node->data.size() <= 1) {
            if(mLink.current_node == 0) {
                break;
            }
            tmp = mLink.current_node;      // And Not At top of list, don't delete lines below
            ///mLink.current_node = mLink.current_node->dn_link;

            if (mLink.current_node->up_link == 0) break;
            mLink.current_node = mLink.current_node->up_link;
            //mLink.current_node->up_link = tmp->up_link;

            /// Add new
            mLink.current_node->dn_link = 0;

             //errlog2((char *)" *** before tmp !");
            //tmp->up_link->dn_link = mLink.current_node;
            delete tmp;

            //errlog2((char *)" *** before delete tmp DONE!");

            //if (!mLink.move_up()) {
            //    break;
            //}
        }
        else
            break;
    }

    //errlog2((char *)" *** MsgSetupTxt DONE!");
}


// Sets up mHead Rec with Original Message Header Info For Reply
// And Populates Link List for Message Quoter Text Selection.
void msg_api::MsgSetupQuoteTxt() {

     //////errlog2("MsgSetupQuoteTxt");
    int id1 = 0;
    int i = 0;
    int BegininngText = TRUE;

    std::string Line;
    std::string MsgText = buff; // Get Message Buffer!

    // Setup the Message Header
    SetupMsgHdr();
    while(1) {
        // Each Line ends with '\r' in jam api
        Line.erase();
        id1  = MsgText.find("\r", 1);
        if (id1 > 74) id1 = 74; // Some Writers don't use newlines.

        // Make Sure only to Add New Lines when being used,
        // First Line is already Setup! So Skip it
        //if (id1 != -1) mLink.add_to_list("");
        if (id1 == -1) break;
        else {
            Line = MsgText.substr(0,id1);
            MsgText.erase(0,id1);

            // Erase any Echomail comming in with longer
            // Lines then 79 Chars on Quoted Text, darn idiots! :)
            // Word Wrapping Quotes is ugly!
            if (Line.size()-1 > 74) {
                Line.erase(74,74-(Line.size()-1));
            }
            // Clean each broken up line for proper display
            // Remove any carriage return chars before entering link list.
            while (1) {
                id1 = Line.find("\r", 0);
                if (id1 != -1)
                    Line.erase(id1,1);
                else break;
            }

            while (1) {
                id1 = Line.find("\n", 0);
                if (id1 != -1)
                    Line.erase(id1,1);
                else break;
            }

            // Cutoff any blank Lines in the beginning of a message.
            if (BegininngText) {
                if (Line != " " || Line.size() < 1)
                    if (Line.size() > 0) {
                        //mLink.current_node->data = Line;
                        mLink.add_to_list(Line);
                        ++i;
                        BegininngText = FALSE;
                    }
            }
            else {
                if (Line.size() > 0) {
                    //mLink.current_node->data = Line;
                    mLink.add_to_list(Line);
                    ++i;
                }
            }
        }
    }
}

// Grabs Message Text into Bufer from Data Files.
int msg_api::GetMsg() {

    //////errlog2("Get Message");
    int ret = TRUE;
    buff.erase();
    cinflen = MsgGetCtrlLen(mh);

    MsgReadMsg(mh,&xmsg,0L,0L,NULL,cinflen,(byte *)cinfbuf);
    cinfbuf[cinflen] = '\0';
    buflen = MsgGetTextLen(mh);

    // Allocate
    char *tbuf = new char [buflen+1];

    MsgReadMsg(mh,NULL,0L,buflen,(byte *)tbuf,0L,NULL);
    buff.assign(tbuf);
    delete [] tbuf;

    Add2MsgInfo();
    return ret;
}

// Grabs Basic Msg Info for gih Msg Counts!
int msg_api::GetMsgInfo() {

    int ret = TRUE;
    buff.erase();

    mh = MsgOpenMsg(AHandle, MOPEN_RW, 1);
    if (mh == NULL) return FALSE;

    cinflen = MsgGetCtrlLen(mh);
    MsgReadMsg(mh,&xmsg,0L,0L,NULL,cinflen,(byte *)cinfbuf);

    MsgCloseMsg(mh);
    if (mh == NULL) return FALSE;

    Add2MsgInfo();
    return ret;
}



int msg_api::SquishAreaSetLast(unsigned long usr,unsigned long lr) {

    char path[91];
    FILE *fptr;
    int  x = false;
    unsigned long lr1;

    lr1=lr;
    sprintf(path,"%s%s.sql",mr.mbpath,mr.mbfile);
    fptr = fopen(path,"rb+");
    if(fptr == NULL) {
        fptr = fopen(path,"wb");
        if(fptr == NULL)
            return -1;
    }
    if(fseek(fptr,usr*sizeof(unsigned long),SEEK_SET)==0)
        x=fwrite(&lr1,sizeof(unsigned long),1,fptr);
    fclose(fptr);
    return(x);
}

void msg_api::SetLastRead(unsigned long usr, unsigned long lr) {

    //printf("\nSet Last Read - user: %i, lr: %i",usr,lr);
//    char outBuffer[1024]={0};
    //sprintf(outBuffer,"After cont thisuser->lastmbarea: %i. Mi.high_msg: %i",thisuser->lastmbarea, MI.high_msg);
    ////errlog2(outBuffer);

    switch(mr.Type){
        case MSGTYPE_JAM:
            _msgf.JamAreaSetLast(usr,lr,&mr);
            break;

        case MSGTYPE_SQUISH:
            if(SquishAreaSetLast(usr,lr) < 0){
                putline((char *)"\nError setting last read. ");
                sleep(1);
            }
            break;
    }
}

unsigned
long msg_api::SquishAreaGetLast(unsigned long usr) {

    char path[91];
    FILE *fptr;
    unsigned long lr1;

    sprintf(path,"%s%s.sql",mr.mbpath,mr.mbfile);
    fptr = fopen(path,"rb");
    if(fptr == NULL)
        lr1 = 1L;
    else {
        if(fseek(fptr,usr*sizeof(unsigned long),SEEK_SET)==0)
            fread(&lr1,sizeof(unsigned long),1,fptr);
        fclose(fptr);
    }
    return lr1;
}

unsigned
long msg_api::GetLastRead(unsigned long usr) {

    char outBuffer[1024]={0};
    //sprintf(outBuffer,"After cont thisuser->lastmbarea: %i. Mi.high_msg: %i",thisuser->lastmbarea, MI.high_msg);
    ////errlog2(outBuffer);


    unsigned long lr = 0L;
    switch(mr.Type) {
        case MSGTYPE_JAM:
            lr = _msgf.JamAreaGetLast(usr,&mr);
            if (lr == -1) lr = 0;
            break;
        case MSGTYPE_SQUISH:
            lr = SquishAreaGetLast(usr);
            if (lr == -1) lr = 0;
            break;
    }

    //printf("\nGet Last Read - user: %i, lr: %i",usr,lr);
    return lr;
}

