/***************************************************************************
 *   Copyright (C) 2004-2009 by Michael Griffin                            *
 *   mrmisticismo@hotmail.com                                              *
 *                                                                         *
 *   Purpose:                                                              *
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

// Enthral SVN: $Id: main_system.cpp 163 2010-10-15 22:10:34Z mercyful $
// Source: $HeadURL: http://svn.enthralbbs.com/trunk/src/main_system.cpp $
// $LastChangedDate: 2010-10-15 18:10:34 -0400 (Fri, 15 Oct 2010) $
// $LastChangedRevision: 163 $
// $LastChangedBy: mercyful $

# include <stdio.h>
# include <stdarg.h>

# include <cstring>
# include <cstdlib>
# include <string>

# include "struct.h"
# include "main_system.h"
# include "language.h"
//# include "pyenthral.h" - Testing Python Scripting.

using namespace std;

char OSSYSTEM[1024] = {0};

void strip(char *ostr) {

    int id1;
    std::string tstr = ostr;
    while ((id1=tstr.find("\r",0)) != -1) tstr.erase(id1,1);
    while ((id1=tstr.find("\n",0)) != -1) tstr.erase(id1,1);
    while ((id1=tstr.find("\b",0)) != -1) tstr.erase(id1,1);
    while ((id1=tstr.find("\t",0)) != -1) tstr.erase(id1,1);
    strcpy(ostr,(char *)tstr.c_str());
}

void main_system::start(UserRec *user) {

    //pybbs_run("test.py");
    //startpause();
    //return;

    // Startup Friend Classes
    language    _lang;

    // Start Control Sequence Resetting... Will be ignored by Non Ansi Systems.
    putline((char *)"\x1b"); putline((char *)"c");
    putline((char *)"\x1b"); putline((char *)"(U");

    pipe2ansi((char *)"|CS");

    fflush(stdout);
    open_keyboard();

    int c;
    int done = FALSE;

    char sCmd[2048]={0};
    char text[100]={0};
    char text2[100]={0};
    char text3[100]={0};

    FILE *uname;
    char os[80]={0};
    int lastchar;

    // Thanks to Frank for this quickie! :)
    uname = popen("uname -sm", "r");
    lastchar = fread(os, 1, 80, uname);
    os[lastchar] = '\0';
    pclose(uname);

    strip(os);
    sprintf(OSSYSTEM,"(%s)",os);

    sprintf(sCmd,"%s %s Telnet Node %i",BBSVERSION, OSSYSTEM, NODE_NUM);
    cspacing(sCmd);

    // have to put newline in after center spacing, or it throws it all off.
    strcat(sCmd,(char *)"\r\n");
    putline(sCmd);

    sprintf(sCmd,"Copyright (c) Michael Griffin 2004-2010, All Rights Reserved");
    cspacing(sCmd);
    strcat(sCmd,(char *)"\r\n");
    pipe2ansi(sCmd);

    // Holds for Sysop Name / Email String.
    _lang.lang_get(text,56);
    cspacing(text);
    strcat(text,(char *)"\r\n");
    pipe2ansi(text);

    sleep (1);

    putline((char *)"\r\n");
    _lang.lang_get(text,1);
    //cspacing(text);
    sprintf(text,"%s\r\n",text);
    pipe2ansi(text);

    sleep (1);

    // Ansi detection screen
    ansiPrintf((char *)"ansi");

    // Detect if were compitable.
    if (!getxy()) {
        _lang.lang_get(text,51);
        //cspacing(text);
        sprintf(text,"%s\r\n\r\n",sCmd);
        putline(text);
        _lang.lang_get(text2,52);
        sprintf(text2," .\b\b");
        pipe2ansi(text2);
        do {
            c = getkey(true);
            switch(toupper(c)) {
                case 10:
                    putkey('Y');
                    isANSI = FALSE;
                    done = TRUE;
                    break;
                case 'Y':
                    putkey('Y');
                    isANSI = FALSE;
                    done = TRUE;
                    break;
                case 'N':
                    putkey('N');
                    isANSI = TRUE;
                    done = TRUE;
                    break;
                default:
                    break;
            }
        } while(done == FALSE);

    }
    else {
        _lang.lang_get(text,2);
        //cspacing(text);
        sprintf(text,"%s|CR|CR",text);
        pipe2ansi(text);

        _lang.lang_get(text2,53);
        sprintf(text2,"%s .\b\b",text2);
        pipe2ansi(text2);

        done = FALSE;
        do{
            c = getkey(true);
            switch(toupper(c)) {
                case 10:
                    putkey('Y');
                    isANSI = TRUE;
                    done = TRUE;            //putkey(ch);
                    break;
                case 'Y':
                    putkey('Y');
                    isANSI = TRUE;
                    done = TRUE;
                    break;
                case 'N':
                    putkey('N');
                    isANSI = FALSE;
                    done = TRUE;
                    break;
                default:
                    break;
            }
        } while (done == FALSE);
    }

    if (isANSI)
        _lang.lang_get(text3,57);
    else
        _lang.lang_get(text3,58);

    sprintf(sCmd,"|CR|CR%s",text3);
    pipe2ansi(sCmd);

    sleep(2);


    if (isANSI == FALSE) {

        putline((char *)"\r\n\r\nSorry, at this time this software doesn't support a full ascii interface.\r\n");
        putline((char *)"This will be addressed in the future, for now you should get a terminal that supports\r\n");
        putline((char *)"ANSI Graphics, Syncterm, Mtelnet are reccomended.  Please call back again soon! \r\n\r\n");
        return;
    }

    // Display Welcome Screen
    ansiPrintf((char *)"welcome");

    //memset(&_mnf._premenu,0,sizeof(_mnf._premenu));
    _mnf._premenu.clear();
    _mnf._gosub.clear();
    _mnf._curmenu = "matrix";
    _mnf._loadnew = true;

    _mnf.menu_mainloop(user);

}

