#!/bin/bash
# tic-in.sh - 18 Aug 07 - R.J. Clay
#  Daily TIC processing
BBBSDIR=/opt/bbbs
WORKDIR=$BBBSDIR/work

cd $BBBSDIR

#  process incomeing tic's
$BBBSDIR/bbbs btick

#  post announcements about them, if there were any
if [ -f $WORKDIR/tickinfo.txt ]; then
#  cat freq/ftp info >> tickinfo.txt
  $BBBSDIR/bbbs btxt2bbs rocasa.stats $WORKDIR/tickinfo.txt /F Sysop /S New Files, Last 24 Hours
  $BBBSDIR/bbbs btxt2bbs files.metro $WORKDIR/tickinfo.txt /F Sysop /S New Files, Last 24 Hours
  $BBBSDIR/bbbs btxt2bbs files.new $WORKDIR/tickinfo.txt /F Rocasa BBS /S New Files, Last 24 Hours
  $BBBSDIR/bbbs btxt2bbs files.new.stn $WORKDIR/tickinfo.txt /F Rocasa BBS /S New Files, Last 24 Hours
  $BBBSDIR/bbbs bogus a
  rm $WORKDIR/tickinfo.txt
fi
if [ -f $WORKDIR/tickinfo.b ]; then
#  cat bbbsfdn info >> bbbsinfo.p
  cat $WORKDIR/tickinfo.b >> $WORKDIR/tickinfo.bbbs
  $BBBSDIR/bbbs btxt2bbs bbs.bbbs.fdn $WORKDIR/tickinfo.b /F Jame Clay /S New BBBS FDN Files
  $BBBSDIR/bbbs bogus a
  rm $WORKDIR/tickinfo.b
fi

if [ -f $WORKDIR/tickinfo.k ]; then
#  cat bbbsfdn info >> bbbsinfo.k
  cat $WORKDIR/tickinfo.k >> $WORKDIR/tickinfo.kim
  $BBBSDIR/bbbs btxt2bbs bbs.bbbs.fdn $WORKDIR/tickinfo.k /F Jame Clay /S New BBBS FDN Files from Author
  $BBBSDIR/bbbs bogus a
  rm $WORKDIR/tickinfo.k
fi

if [ -f $WORKDIR/tickinfo.p ]; then
#  cat perlfdn info >> tickinfo.p
  cat $WORKDIR/tickinfo.p >> $WORKDIR/tickinfo.perl
  $BBBSDIR/bbbs btxt2bbs prog.perl.fdn $WORKDIR/tickinfo.p /F Jame Clay /S New Perl FDN Files
  $BBBSDIR/bbbs bogus a
  rm $WORKDIR/tickinfo.p
fi

#




