#!/bin/sh
# monthly.sh - 18 Nov 06 - Robert J. Clay
# what to do monthly
BBBSDIR=/opt/bbbs
SCRIPTS=$BBBSDIR/scripts
WORKPATH=$BBBSDIR/work
RULESPATH=/opt/ftn/rules 
cd $BBBSDIR

#  Purge files
$BBBSDIR/bbbs bpurge

#  post rules & announcements
##   monthly conference stats posting
#
$SCRIPTS/bconfmth.sh 
#
nohup $SCRIPTS/chatstatmth.sh &  

nohup $SCRIPTS/sffstatmth.sh &  

$BBBSDIR/bbbs bcstat ^rec. -30 > $WORKPATH/bcstat.txt 
$BBBSDIR/bbbs btxt2bbs rocasa.stats $WORKPATH/bcstat.txt /F Sysop /S 30 Day Totals for rec* echos
#
nohup $SCRIPTS/pcstatmth.sh &  
#
nohup $SCRIPTS/osstatmth.sh &  
#
nohup $SCRIPTS/mistatsmth.sh &  
#
nohup $SCRIPTS/altstatsmth.sh &  
#
#nohup $SCRIPTS/sh/annnntpmth.sh &  
#
#nohup $SCRIPTS/sh/rhstatmth.sh &  
#
#nohup $SCRIPTS/sh/hamstatmth.sh &  
#
#nohup $SCRIPTS/sh/scistatmth.sh &  
#
nohup $SCRIPTS/ftnstatmth.sh &  
#
nohup $SCRIPTS/stn/statmth.sh &  
#
#nohup $SCRIPTS/sh/wwbstatmth.sh &  
#
##  Post rules for SEMICH echo/mailing list, OS.NIX echo/mailing list,
# STN.PROG echo/mailing list, & STN.INTERNET echo/mailing list
nohup $SCRIPTS/sh/rulespost.sh &  
nohup $SCRIPTS/stn/rulespost.sh &  
#  post monthly announcements about files received
nohup $SCRIPTS/fileannounce.sh &  

##  monthly hatching of various files 
#nohup $SCRIPTS/sh/work/monthlyhatch.sh &  

#  monthly hatching of bbbsfdn files 
nohup $SCRIPTS/bbbsfdn/hatchmonthly.sh &  
#
$BBBSDIR/bbbs bogus a

#  monthly updates of available newsgroups
$SCRIPTS/sh/getactive.sh
#$BBBSDIR/bbbs bnntp g localhost work/rocasa.org.news
$BBBSDIR/bbbs bnntp g 192.168.4.3 $WORKPATH/rocasa.net.news
#$BBBSDIR/bbbs bnntp g 192.168.19.6 $WORKPATH/rocasa.org.news
$BBBSDIR/bbbs bnntp g news.redhat.com $WORKPATH/redhat.com.news
$BBBSDIR/bbbs bnntp g news.tardis.net $WORKPATH/tardis.net.news
$BBBSDIR/bbbs bnntp g news.osirusoft.com $WORKPATH/osirusoft.com.news
$BBBSDIR/bbbs bnntp g news.dyndns.org $WORKPATH/dyndns.org.news
#


#
exit 0


