#!/bin/sh
# midnight.sh - 8 March 2004 - Robert J. Clay 
#	Rocasa BBS daily maintenance at midnight
#
BBBSDIR=/opt/bbbs
SCRIPTS=$BBBSDIR/scripts
WORKPATH=$BBBSDIR/work

cd $BBBSDIR

# Update birthday list
$BBBSDIR/bbbs bdate
#
# archive yesterday's logs by date
cd $BBBSDIR/logs
# get 4 digit year
YEAR=`date -d '1 day ago' +.%Y`
#echo "year is "$YEAR
# get short day of the week, then numerical month & day of month
DAYMONTH=`date -d '1 day ago' +.%a.%m.%d`
#echo "daymonth is "$DAYMONTH
# rename logs w/ day & month extensions
##LOGFILE=log1$DAYMONTH
#echo "logfile is "$LOGFILE
cp inet.day inet$DAYMONTH 
cp binkd.day binkd$DAYMONTH 
#cp irex.day irex$DAYMONTH 
#cp irexin.day irexin$DAYMONTH 
#cp irexout.day irexout$DAYMONTH 
cp ftn.day ftn$DAYMONTH 
cp node1.day node1$DAYMONTH 
cp node2.day node2$DAYMONTH 
cp node3.day node3$DAYMONTH 
cp node4.day node4$DAYMONTH 
cp node5.day node5$DAYMONTH 
cp node6.day node6$DAYMONTH 
cp node7.day node7$DAYMONTH 
cp wwwnotfound.day wwwnotfound$DAYMONTH 
#cp iflog.day iflog$DAYMONTH 
cp process.day process$DAYMONTH 
#mv process.day process$DAYMONTH 

# save logs to archive
ZIPFILE=RocasaBBS$YEAR.zip
#echo $ZIPFILE > /$BBBSDIR/logs/ZipFileName
#zip -jmqT RocasaBBS$YEAR *$DAYMONTH
zip -jmqT $ZIPFILE *$DAYMONTH

$SCRIPTS/bconfday.sh 
cp $WORKPATH/bconf.txt.day $BBBSDIR/menus/bull11

$SCRIPTS/adm/binkdstats.sh 


