#!/bin/sh
# do-mid.sh - 19 Jan 2004 - R.J. Clay
# run midnight maintenance scripts, started by cron
#
BBBSDIR=/opt/bbbs
SCRIPTS=$BBBSDIR/scripts
LOGSDIR=$BBBSDIR/logs

cd $BBBSDIR

#  save the most used nodes files as *day files, uncompressed, so that the
# previous days' nodes are always available.

for LOGFILE in ftn inet binkd node1 node2 node3 node4 node5 node6 node7 ; do 
  if [ -f $LOGSDIR/$LOGFILE ]; then
    mv $LOGSDIR/$LOGFILE $LOGSDIR/$LOGFILE.day;
  else
    echo > $LOGSDIR/$LOGFILE.day;
  fi ;
done

#mv $BBBSDIR/nohup.out $LOGSDIR/process.day
if [ -f $BBBSDIR/nohup.out ]; then
  mv $BBBSDIR/nohup.out $LOGSDIR/process.day
else
  echo > $LOGSDIR/process.day;
fi ;

grep HTTP $LOGSDIR/inet.day | grep -B 2 "(not found)" > $LOGSDIR/wwwnotfound.day

#  now run the individual maintenance scripts for each node in the background
nohup $SCRIPTS/midnight.sh &
#nohup $SCRIPTS/sh/midnight2.sh &

#  Run tic-in.sh daily
nohup $SCRIPTS/tic-in.sh &
#
