#!/usr/bin/perl
#  bconf2html.pl v0.01  Copyright (c) 2006 Robert James Clay 
#  Used to update the BBBS Conference Stats pages for Rocasa BBS at rocasa.biz
#  Based on the script bconfhtm.pl v0.1, by Robert James Clay
#  All Rights Reserved. This is free software;  you can redistribute
#  it and/or modify it under the same terms as Perl itself.

use warnings;
use strict;

my $Version = "0.1";

use File::Slurp;
use HTML::Template;
use Getopt::Std;
use vars qw/ $opt_t $opt_o $opt_p $opt_y $opt_s $opt_l $opt_x $opt_h /;

my ($STATFILE, $TEMPLATE, $HTMLDIR, $period, $periodly, $expires, $expirey, $logfile, $DEBUG);

getopts('t:o:p:y:s:l:xh');

&ParseCommandLine();

# set BBBS base directory
my $BBBSDIR = "/opt/bbbs";

#get current time as timestamp
my $timestamp = time();
# set page expiration time
$expires = gmtime($timestamp + $expirey);

# get local time as string
my ($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = localtime($timestamp);

# open & read the file containing the result of the command 'bbbs bconf', which is put in $bconfstats
my $bconfstats = read_file("$STATFILE");

# open the html template
my $template = HTML::Template->new(filename => "$TEMPLATE");

# fill in the template parameters
$template->param(PAGEEXPIRES => $expires);

$template->param(BCONFSTATS => $bconfstats);
$template->param(PERIOD => $period);
$template->param(PERIODLY => $periodly);

$template->param(DAY => $day);
$template->param(MON => ($mon + 1));
$template->param(YEAR => ($year + 1900));
$template->param(HOURS => $hour);
$template->param(MINS => $min);

# create new version of conference stats html page
my $newpage="$HTMLDIR/bconf$period.html";
# open filehandle FH for write
open(FH, "> $newpage") || die $!;

# use the function to send the new contents to the new version of the  file
$template->output(print_to => *FH);    

# close the filehandle
close(FH);

exit(0);

################################################
## Subroutines
##
############################################
# ParseCommandLine
############################################
sub ParseCommandLine {

    if ($opt_h) {
        &DisplayHelp();
	exit(1);
    }

    if ($opt_x) {
	$DEBUG = $opt_x;	# set debug flag
	undef $opt_x;
	print "\nDebug flag is set ...\n";
    } else {
	$DEBUG = 0;
    }
	
    if ($opt_t) {
	$TEMPLATE=$opt_t;  # this needs to be the filename & path
	undef $opt_t;
    } else {
	$TEMPLATE="/opt/bbbs/work/bconfhtml.tmpl";	# default template file
    }

    if ($opt_o) {
	$HTMLDIR=$opt_o;  # this needs to be the filename & path
	undef $opt_o;
    } else {
	$HTMLDIR="/opt/bbbs/htdocs/stats";	# default html dir
    }

    if ($opt_s) {
	$STATFILE=$opt_s;  # this needs to be the filename & path
	undef $opt_s;
    } else {
	$STATFILE="/opt/bbbs/work/bconf.txt.day";	# default stats file
    }

    if ($opt_p) {
	if ($opt_p eq "day") {
	    $period=$opt_p;  # 	period is day
	    $expirey = 86400;	# 1 day, in seconds
	    undef $opt_p;
	} elsif ($opt_p eq "week") {
	    $period=$opt_p;  # 	period is week
	    $expirey = 604800;	# 1 week (7 days), in seconds
	    undef $opt_p;
	} elsif ($opt_p eq "month") {
	    $period=$opt_p;  #	period is month 
	    $expirey = 2592000;	# 1 month (30 days), in seconds
	    undef $opt_p;
	} else {
	    # period not properly defined, exit after displaying help
	    print " The -p option is not properly defined.\n\n";
	    &DisplayHelp();
	    exit(1);    
	}
    }

    if ($opt_y) {
	if ($opt_y eq "Daily") {
	    $periodly=$opt_y;  # 	periodly is Daily
	    undef $opt_y;
	} elsif ($opt_y eq "Weekly") {
	    $periodly=$opt_y;  # 	periodly is Weekly
	    undef $opt_y;
	} elsif ($opt_y eq "Monthly") {
	    $periodly=$opt_y;  #	periodly is Monthly
	    undef $opt_y;
	} else {
	    # periodly not properly defined, exit after displaying help
	    print " The -y option is not properly defined.\n\n";
	    &DisplayHelp();
	    exit(1);    
	}
    }

    if ($opt_l) {
	$logfile=$opt_l;  # this needs to be the filename & path for a logfile 
	undef $opt_l;
    } else {
	my $logfile="/opt/bbbs/logs/wwwadm.log";	# default log file
    }
    
}
############################################
# Help
############################################
sub DisplayHelp {
    print "\nUsage:  bconfhtml.pl -t Template -o HTMLDir -s StatsFile -p [day|week|month] -l [Daily|Weekly|Monthly] [-x] [-h]\n\n";
    print "   -t   Template file;  defaults to /opt/bbbs/work/bconfhtml.tmpl. \n";
    print "   -o   Directory where the resulting HTML file should be put.\n";
    print "   -s   Path & filename for Stats file generated by 'BBBS BCONF'.\n";
    print "   -p   Period coment for page - 'day' or 'week' or 'month'\n";
    print "   -y   Periodicity comment for page - 'Daily' or 'Weekly' or 'Monthly'\n";
    print "   -l   Path & filename of logfile;  defaults to /opt/bbbs/logs/wwwadm.log.\n";
    print "   -x   Debug Mode\n";
    print "   -h   This Help\n";
    print "\n";
}

