/* Sample script for Checking and Enforcing TimeLimits
 when implementing AdeptXBBS' port functions 

Original Written by Paul Meyer, Modified Slightly by Chris Freeze
Modified Again By Paul Meyer

*/



arg line



/*  Put the Signal On Halt in to avoid the Program Interrupted Message  */
Signal On Halt



Do Forever

	Call AdeptSleep line, 120000
	Call AdeptCheckTime
	Call AdeptCheckCarrier

End



AdeptCheckTime:
  secsleft = AdeptConvert(line, '{T2')
  if(secsleft<=0) then
  do
    Call AdeptComWrite line, "\r\nYou Have Run Out Of Time!!!\r\n"
    Call AdeptComDoDTR line, '0'
    exit
  end
return



AdeptCheckCarrier:
  if(AdeptRequestsLogoff(line)==1)then
    exit
return



Halt:
  exit
