/****************************************************************************/
/*  SmartDisplay! .97  *  For AdeptXBBS version 1.0  *  Author: Matt Davis  */
/****************************************************************************/
/* ABOUT: Smart-Display! eliminates the need for the awkward and slow       */
/*        mechanism used by older releases of CML-Data used in order to     */
/*        ensure the user sees the correct display file.  All in one smart  */
/*        REXX utility!  No muss, no fuss! (not to mention it's really fast)*/
/****************************************************************************/
/*  Created on: 06/06/1995    *  Produced at CML/2: Home of CML-Data        */  
/*  Updated on: 06/14/1995    *     (704)324-9949 : 1:3666/107.0@Fidonet    */
/****************************************************************************/
/*    The TrunkCallerList subroutine was written by Julie Strietelmeier     */
/****************************************************************************/
                                                                              ARG line
/*[System]*******************************************************************/

   UserName = AdeptGetVar(line,1)
   Hold = AdeptGetVar(line,140)
   PARSE UPPER VAR UserName UserName

   IF UserName = "FEDERAL COPYRIGHT VIOLATOR" THEN DO
      AdeptLog(line,2," *** UNAUTHORIZED USER LOGGING IN!! ***")
      AdeptMenuType(line,201,"Matt Davis;Unauthorized Licensee Identifiying itself- {D8;1;"AreaToDumpMailIn)
      CALL AdeptDoDTR line, 0
      CALL AdeptSleep line, 500
      CALL AdeptDoDTR line, 1
      CALL AdeptSleep line, 500
      CALL AdeptComFlush line
      EXIT
   END
                                                                              /*
---[Global Configuration]-----------------------------------------------------*/
  AdeptPath = 'E:\ADEPT'             /* No terminating backslash!!!           */
  DebugMode = 'OFF'                  /* ON or OFF                             */
  OldGroupNum = '1'                  /* What Group new users are in           */
  NewGroupNum = '2'                  /* Group# to upgrade new users to        */
                                                                              /*
---[Feature Configuration]----------------------------------------------------*/
  AddUserToCallerList = 'YES'        /* Keep list of callers?        (YES/NO) */
  EnableShuttleSystem = 'YES'        /* Provide shuttle menu?        (YES/NO) */
  EnableHelloDisplays = 'YES'        /* Show Hello Displays ?        (YES/NO) */
  EnableBulletin_Menu = 'NO'         /* Provide bulletin menu?       (YES/NO) */
  EnableNewbieProcess = 'YES'        /* Process NewUsers             (YES/NO) */
                                                                              /*
---[Caller List Configuration]------------------------------------------------*/
  UseExternalNormalDisplay = "YES"   /* Use an external display? (YES/NO/OFF) */
  UseExternalNewbieDisplay = "YES"   /* Use an external display? (YES/NO/OFF) */
                                                                              /*
---[Hello Display Configuration]----------------------------------------------*/
  HelloPrefix = 'HELLO'              /* [HelloPrefix]##.Asc/Ans/etc           */
  NumberHello = '5'                  /* Number of hello screens to look for   */
                                                                              /*
---[NewUser Process Configuration]--------------------------------------------*/
  LeaveMessageToSysop = 'YES'        /* Force Newuser to lv. Msg.?   (YES/NO) */
  AreaToDumpSysMailIn = '1'          /* Area to dump ^ into              (##) */
  PreMsgWriteFileName = 'Prewrite'   /* No Extension!                  (text) */  

/*[System: Parameter Processing]*********************************************/

Module = "System"
Location = "System: Begin Parameter Processing"
IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS\r\nLocation="Location"\r\n")
IF DEBUGMODE = "OFF" THEN Call VersionAnnounce

/****************************************************************************/

AlertUser:

 Location = "AlertUser"
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location :"Location"\r\n")
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS {FBSmart{F3-{FBDisplay! {F9version {F81.0{F9 (beta):\r\n\n")
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{F4This REXX program is designed to speed up the recently slow login.  I'm")
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"\r\n{F4still writing this, so it probably won't act or look right, and you may even")
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"\r\n{F4see some errors, but don't pay them any mind!\r\n")
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"\r\n{FDThanks!!\r\n")
 IF DEBUGMODE = "ON" THEN AdeptHitReturn(line)
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS{FBDebugging Information{F2:{F4\r\n\n")
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Module   : "Module"\r\n")
   CALL VariableStack
   CALL EventManager

/****************************************************************************/

EventManager:

 Location = "EventManager"

 IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Location : "Location"\r\n")
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line," AddCallerList : "AddUserToCallerList"\r\n")
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ShuttleSystem : "EnableShuttleSystem"\r\n")
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line," HelloDisplays : "EnableHelloDisplays"\r\n")
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line," Bulletin-Menu : "EnableBulletin_Menu"\r\n")
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line," NewbieProcess : "EnableNewbieProcess"\r\n")
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Status   : Calling ModuleLayoutTree\r\n")
 CALL ModuleLayoutTree
  BackFromTree:
 Location = "BackFromTree"
/* IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Location : "Location"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"FirstMod : "FirstMod"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"SecondMod: "SecondMod"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"ThirdMod : "ThirdMod"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"FourthMod: "FourthMod"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"FifthMod : "FifthMod"\r\n")*/
 CALL AttachSequencers
  DoneSequencing:
/* IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"After-1  : "AfterFirstMod"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"After-2  : "AfterSecondMod"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"After-3  : "AfterThirdMod"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"After-4  : "AfterFourthMod"\r\n")
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"After-5  : "AfterFifthMod"\r\n")*/
/****************************************************************************/

EvManTree:
  
 EvManBreak1:
   IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"\r\n{FF"Module" {F3Module closing.  {FBNext: {FG"FirstMod"{F4\r\n\n")
   IF DEBUGMODE = 'ON' THEN AdeptHitReturn(line)
   IF ADDUSERTOCALLERLIST = 'YES' THEN DO
     IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS{FBDebugging Information{F2:{F4\r\n\n")
     Module = 'Caller List'
     CALL CallerListModule
     END
 EvManBreak2:
   IF DEBUGMODE = 'ON' THEN DO
     IF ADDUSERTOCALLERLIST = 'YES' THEN AdeptPrint(line,"\r\n{FF"Module"{F3 Module closing.  {FBNext: {FG"AfterFirstMod"{F4\r\n\n")
     IF ADDUSERTOCALLERLIST = 'YES' THEN AdeptHitReturn(line)
     END
   IF ENABLESHUTTLESYSTEM = 'YES' THEN DO
     IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS{FBDebugging Information{F2:{F4\r\n\n")
     Module = 'Shuttle System'
     CALL ShuttleSystemModule
     END
 EvManBreak3:
   IF DEBUGMODE = 'ON' THEN DO
     IF ENABLESHUTTLESYSTEM = 'YES' THEN AdeptPrint(line,"\r\n{FF"Module"{F3 Module closing.  {FBNext: {FG"AfterSecondMod"{F4\r\n\n")
     IF ENABLESHUTTLESYSTEM = 'YES' THEN AdeptHitReturn(line)
     END
   IF ENABLEHELLODISPLAYS = 'YES' THEN DO
     IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS{FBDebugging Information{F2:{F4\r\n\n")
     Module = 'Hello Display'
     CALL HelloDisplayModule
     END
 EvManBreak4:
   IF DEBUGMODE = 'ON' THEN DO
     IF ENABLEHELLODISPLAYS = 'YES' THEN AdeptPrint(line,"\r\n{FF"Module"{F3 Module closing.  {FBNext: {FG"AfterThirdMod"{F4\r\n\n")
     IF ENABLEHELLODISPLAYS = 'YES' THEN AdeptHitReturn(line)
     END
   IF ENABLEBULLETIN_MENU = 'YES' THEN DO
     IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS{FBDebugging Information{F2:{F4\r\n\n")
     Module = 'Bulletin Menu'
     CALL BulletinMenuModule
     END
 EvManBreak5:
   IF DEBUGMODE = 'ON' THEN DO
     IF ENABLEBULLETIN_MENU = 'YES' THEN AdeptPrint(line,"\r\n{FF"Module"{F3 Module closing.  {FBNext: {FG"AfterFourthMod"{F4\r\n\n") 
     IF ENABLEBULLETIN_MENU = 'YES' THEN AdeptHitReturn(line)
     END
   IF ENABLENEWBIEPROCESS = 'YES' THEN DO
     IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS{FBDebugging Information{F2:{F4\r\n\n")
     Module = 'NewUser Process'
     CALL NewUserProcessModule
     END
 EvManBreakEnd:
   IF DEBUGMODE = 'ON' THEN DO
     IF ENABLENEWBIEPROCESS = 'YES' THEN AdeptPrint(line,"\r\n{FF"Module"{F3 Module closing.  {FBNext: {FG"AfterFifthMod"{F4\r\n\n") 
     IF ENABLENEWBIEPROCESS = 'YES' THEN AdeptHitReturn(line)
     END
   Shutdownkey = "Correctly"
   CALL Shutdown

/*==========================END OF SYSTEM MODULE============================*/


/****************************************************************************/
/**************************[ CALLER LIST MODULE ]****************************/
/****************************************************************************/

CallerListModule:

 IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Module   : "Module"\r\n")
 Location = 'CallerListModule: Startup'
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Location : "Location"\r\n")
 CALL DefinedGroupCheck
 CALL DetectIfNewUser

/****************************************************************************/

DetectIfNewUser:

 Location = "DetectIfNewUser"
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
 IF DEBUGMODE = "ON" THEN AdeptPrint(line,"NewUser  : "NewUser"\r\n")
 IF NewUser = 'YES' THEN CALL StartNewDispGen
 IF NewUser = 'NO' THEN CAll StartNormDispGen

CALL Error_General

/****************************************************************************/

StartNormDispGen:

  Location = "StartNormalDisplayGenerator"
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"External : "UseExternalNormalDisplay"\r\n")
  IF UseExternalNormalDisplay = "OFF" THEN CALL TrunkCallerList
  IF UseExternalNormalDisplay = "YES" THEN CALL NormDispGen_External
  IF UseExternalNormalDisplay = "NO"  THEN CALL NormDispGen_Internal

CALL Error_General

/****************************************************************************/

    NormDispGen_Internal:
      
      Location = "NormDispGen_Internal"
      IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location: "Location"\r\n")
      AdeptPrint(line,"[4;3H{B1{F2Ŀ[5;3H[5;52H[6;3H")
      AdeptPrint(line,"[10;3H{F2Ŀ[11;3H[11;40H[12;3H")
      AdeptPrint(line,"[18;16H{FA[18;46HĿ[19;16H                                             ")
      AdeptPrint(line,"[20;16H{FA                                             [21;16H")
      AdeptPrint(line,"[19;18H{FGHold on - Adding you to today's caller list.")
      CALL TrunkCallerList

CALL Error_General

/****************************************************************************/

    NormDispGen_External:

      Location = "NormDispGen_External"
      IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
      IF DEBUGMODE = "OFF" THEN AdeptMenuType(Line,51,NormDispGen.Asc)
      IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Display  : NormDispGen.Asc (*NOT DISPLAYED*)\r\n")
      CALL TrunkCallerList

  CALL Error_General
/****************************************************************************/

StartNewDispGen:

  Location = "StartNewUserDisplayGenerator"
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
  IF UseExternalNewbieDisplay = "OFF" THEN CALL TrunkCallerList
  IF UseExternalNewbieDisplay = "YES" THEN CALL NewDispGen_External
  IF UseExternalNewbieDisplay = "NO"  THEN CALL NewDispGen_Internal

  CALL Error_General
/****************************************************************************/

    NewDispGen_Internal:

      Location = "NewDispGen_Internal"
      IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
      AdeptPrint(line,"\r\n{FD  {FGNew User detected!\r\n\n")
      AdeptPrint(line,"{F9(Please wait while Smart-Display! processes your account.)\r\n")
      CALL TrunkCallerList

CALL Error_General

/****************************************************************************/

    NewDispGen_External:

      Location = "NewDispGen_External"
      IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
      IF DEBUGMODE = "OFF" THEN AdeptMenuType(Line,51,NewDispGen.Asc)
      IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Display  : NewDispGen.Asc (*NOT DISPLAYED*)\r\n")
      CALL TrunkCallerList

  CALL Error_General

/****************************************************************************/

DefinedGroupCheck:
                                    
  Location = "DefinedGroupCheck"
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
  GroupDiff = OldGroupNum-NewGroupNum 
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"GroupDiff: "GroupDiff"\r\n")
  IF GroupDiff = 0 THEN CALL Error_GroupParms

  RETURN

  Call Error_General

/****************************************************************************/

VersionAnnounce:

  Location = "VersionAnnounce"
/*IF DEBUGMODE = "ON" THEN AdeptPrint(line,"[KLocation : "Location"\r\n")  */
  AdeptPrint(line,"[s[1;1H{B2{F5 *  {FBSmart{F3-{FBDisplay! {FD.97  {FA-  {F306/06/1995  {FA-  {F3Matt Davis  {FA-  {F31:3666/107.0@Fidonet  {B1[u")
  RETURN

/****************************************************************************/
/****************************************************************************/
/* BEGIN TrunkCallerList Subroutine */

TrunkCallerList:
Location = "TrunkCallerList"
IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")

/* Todays Callers REXX prg */
/*                         */
/* by: Julie Strietelmeier */
/*     1:231/1320          */
/*     (812)342-6546 BBS   */
/*-------------------------*/
/* Modified for CML-Data by*/
/* Matt Davis              */
/* 1:3666/107.0@Fidonet    */
/* (704) 324-9949          */

asciifile = callerfile

name = adeptgetvar(line,1)
city = adeptgetvar(line,6)
state = adeptgetvar(line,7)

if line > 0 then do
   c1 = insert(name,'',6,30)
   c2 = insert(city,c1,32,20)
   c3 = insert(state,c2,50,2)
   caller = lineout(asciifile,c3)
   end

CALL EvManBreak2

/* END TrunkCallerList Subroutine*/
/****************************************************************************/
/****************************************************************************/

Error_General:

  AdeptPrint(line,"{CS\r\n\n{FDERROR {F9(General)")
  AdeptPrint(line,\r\n{F4Reason: {F8"WhyGenError")
  AdeptPrint(line,"\r\n\n{F3Location : "Location"\r\n")
  AdeptPrint(line,"Module   : "Module"\r\n")
  AdeptPrint(line,"\r\n\n")
  AdeptHitReturn(line)
  Call EvManBreak2

/****************************************************************************/

Error_NewUserUpdate:

  AdeptPrint(line,"{CS\r\n\n{FDERROR {F9(NewUserUpdate)")
  AdeptPrint(line,"\r\n\n{F3Group change failed! <???>\r\n")
  AdeptPrint(line,"Module   : "Module"\r\n")
  AdeptPrint(line,"\r\n\n")
  AdeptHitReturn(line)
  Call EvManBreak2

/****************************************************************************/

Error_GroupParms:

  Location = "Error_GroupParms"
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
  AdeptPrint(line,"{CS\r\n\n{FDERROR {F9(Group Parameters)\r\n")
  AdeptPrint(line,'\r\n\n{F3The Sysop has defined The primary and secondary groups as the same.')
  AdeptPrint(line,"\r\n{F3and this is UNACCEPTABLE to SmartDisplay!  Please tell your sysop to")
  AdeptPrint(line,"\r\n{F3configure SmartDisplay properly using two different group numbers!!")
  AdeptPrint(line,"\r\n\n")
  AdeptLog(line,1,"SMARTDISPLAY: First and Second user groups")
  AdeptLog(line,1,"              CANNOT MATCH!  Please Reconfigure")
  AdeptHitReturn(line)
  CALL EvManBreak2

CALL Error_General
/*=======================END OF CALLER LIST MODULE==========================*/


/****************************************************************************/
/*************************[ SHUTTLE MENU MODULE ]****************************/
/****************************************************************************/

ShuttleSystemModule:

IF NewUser = 'YES' THEN Call EvManBreak3
AdeptMenu(Line,,Prelog.Menu)
Call EvManBreak3

/* The Above will be used till a new version of Adept comes out with some
   key REXX functions fixed. :(                                           */

PrelogMenu:

  AdeptMenuType(line,51,Prelog.Asc)
  AdeptPrint(line,"[6;72H")

SnatchInput1:
  Key = AdeptWaitKey(line)

    SELECT
        WHEN (key=27) | (key=42)     /* [ESC] or [*] -*/
          THEN CALL ShuttleMenu
        WHEN (key=13)                /* [ENTER]*/
          THEN CALL ContinueLogin  
        WHEN (key=49)                /* [1] */         
          THEN CALL PMIScanToggle  
        WHEN (key=50)                /* [2] */
          THEN CALL NewFileScanToggle

    OTHERWISE Call SnatchInput1

        END

ContinueLogin:
  Call EvManBreak3

PMIScanToggle:
  AdeptMenuType(Line, 614, )
/*  AdeptMenuType(line,614,)*/
  CALL PrelogMenu

PMIScanToggle:
  AdeptMenuType(Line, 613, )
  CALL PrelogMenu

ShuttleMenu:
/*  AdeptMenuType(line,51,Shuttle.Asc)*/
  AdeptPrint(line,"[0;36mDo What?[34m>[1m>[37m")

SnatchInput2:
  Key = AdeptWaitKey(line)

    SELECT
        WHEN (key=13) | (key=27)     /* [ENTER] or [ESC] */                
          THEN CALL PrelogMenu     
        WHEN (key=67) | (key=99)     /* [C] or [c] */
          THEN CALL PrelogMenu  
        WHEN (key=66) | (key=98)     /* [B] or [b] */
          THEN CALL BulletinMenuModule
        WHEN (key=79) | (key=111)    /* [O] or [o] */
          THEN AdeptMenu(line,1,Off-Mail.Menu)
/* I'll make a REXX Offline Mail Menu, too.... */
        OTHERWISE Call SnatchInput2
        END

CALL Error_General

/*======================END OF SHUTTLE MENU MODULE==========================*/


/****************************************************************************/
/*************************[ HELLO DISPLAY MODULE ]***************************/
/****************************************************************************/

HelloDisplayModule:

  /*Check for negative/0 values*/
  RoundCount = '1'
  RoundHouse:
    IF RoundCount > NumberHello THEN CALL EvManBreak4
    ThisHelloFile = HelloPrefix''RoundCount'.Asc'
    IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"DisplayFile: "ThisHelloFile" (*NOT DISPLAYED*)\r\n")
    IF DEBUGMODE = 'OFF' THEN AdeptMenuType(line,51,ThisHelloFile)
    RoundCount = RoundCount + '1'
    CALL RoundHouse

CALL EvManBreak4

CALL Error_General
/*======================END OF HELLO DISPLAY MODULE=========================*/


/****************************************************************************/
/*************************[ BULLETIN MENU MODULE ]***************************/
/****************************************************************************/

BulletinMenuModule:
Location = 'Bulletin Menu Module'
/*Bulletin-System.Cmd*/

RETURN

/*LL EvManBreak5*/

CALL Error_General
/*======================END OF BULLETIN MENU MODULE=========================*/


/****************************************************************************/
/***********************[ NEW USER PROCESS MODULE ]**************************/
/****************************************************************************/

NewUserProcessModule:

  IF NEWUSER = 'NO' THEN Call EndNewUserProcessModule
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Module   : "Module"\r\n")

  Location = "Write Application to Sysop"
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
    IF LeaveMessageToSysop = 'YES' THEN DO
      AdeptMenuType(line,51,""PreMsgWriteFileName".ASC")
      AdeptMenuType(line,201,""BBSSysopName";Access Request from a NEWUSER on {D8;1;"AreaToDumpSysMailIn"")

  IF NEWUSER = 'NO' THEN Call EndNewUserProcessModule
    Location = "NewUserUpdate"
    IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
    AdeptPutVar(line,25,NewGroupNum)
    UserGroup = AdeptGetVar(Line,25)
    IF DEBUGMODE = "ON" THEN AdeptPrint(line,"New Group: "UserGroup"\r\n")

/*  RoundCount = '1'
  RoundHouse:
    IF RoundCount > NumberHello THEN CALL EvManBreak4
    ThisHelloFile = HelloPrefix''RoundCount'.Asc'
    IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"DisplayFile: "ThisHelloFile" (*NOT DISPLAYED*)\r\n")
    IF DEBUGMODE = 'OFF' THEN AdeptMenuType(line,51,ThisHelloFile)
    RoundCount = RoundCount + '1'
    CALL RoundHouse  */

EndNewUserProcessModule:
  CALL EvManBreakEnd

/*====================END OF NEW USER PROCESS MODULE========================*/


/*[System]*******************************************************************/

/****************************************************************************/

VersionAnnounce:

  Location = "VersionAnnounce"
/*IF DEBUGMODE = "ON" THEN AdeptPrint(line,"[KLocation : "Location"\r\n")  */
  AdeptPrint(line,"[1;1H{B2{F5 *  {FBSmart{F3-{FBDisplay! {FD.97  {FA-  {F306/06/1995  {FA-  {F3Matt Davis  {FA-  {F31:3666/107.0@Fidonet  {B1")
  RETURN

/****************************************************************************/

VariableStack:

  Location = "VariableStacker (Pre-Module processor)"
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"Location : "Location"\r\n")
  CallerFile = AdeptPath'\text\tcall.asc'
  ShutDownKey = "{FDINCORRECTLY!!{F4"
  FirstMod  = '[Not Defined]'
  SecondMod = '[Not Defined]'
  ThirdMod  = '[Not Defined]'
  FourthMod = '[Not Defined]'
  FifthMod  = '[Not Defined]'
  NewUser   = '[Not Defined]'
  WhyGenError = 'Module/routine has OVERRUN into another incorrectly.'
  BBSSysopName = AdeptGetVar(Line,140)

  Location = "StampUserStats"
    IF DEBUGMODE = "ON" THEN  AdeptPrint(line,"Location : "Location"\r\n")
    UserGroup = AdeptGetVar(Line,25)
    IF DEBUGMODE = "ON" THEN AdeptPrint(line,"UserGroup: "UserGroup"\r\n")
  
    IF UserGroup = OldGroupNum THEN DO
       IF DEBUGMODE = "ON" THEN AdeptPrint(line,"NewUser  : YES\r\n")
       NewUser = 'YES'
       END
    IF NewUser = '[Not Defined]' THEN DO
       IF DEBUGMODE = "ON" THEN AdeptPrint(line,"NewUser  : NO\r\n")
       NewUser = 'NO'
       END

  RETURN
  CALL Error_General

/****************************************************************************/

Shutdown:
  Module = "System"
  Location = "Shutdown"
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"{CS{FBDebugging Information{F2:{F4\r\n\n")
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Module   : "Module"\r\n")
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Location : "Location"\r\n")
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Status   : Smart-Display! is shutting down properly\r\n")
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Shutdown : "ShutDownKey"\r\n")
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"\r\n{FF"Module" {F3Module closing.  {FBNext: {FGExit{F4\r\n\n")
  IF DEBUGMODE = "ON" THEN AdeptPrint(line,"\r{F4Returned : {F3Looks like Smart-Display! worked successfully to me.\r\n\n")
  IF DEBUGMODE = "ON" THEN AdeptHitReturn(line)
  EXIT

/****************************************************************************/

ModuleLayoutTree:

 Location = "ModuleLayoutTree"
 IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Location : "Location"\r\n")
 IF MODULECOUNT < 1 THEN Call BackFromTree

  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Status   : Counting Active Modules.")
  ModuleCount = '0'
  IF AddUserToCallerList = 'YES' THEN ModuleCount = ModuleCount + 1
  IF EnableShuttleSystem = 'YES' THEN ModuleCount = ModuleCount + 1
  IF EnableHelloDisplays = 'YES' THEN ModuleCount = ModuleCount + 1
  IF EnableBulletin_Menu = 'YES' THEN ModuleCount = ModuleCount + 1
  IF EnableNewbieProcess = 'YES' THEN ModuleCount = ModuleCount + 1
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"       ("ModuleCount")\r\n")

DetMod1:

  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Status   : Determining the FIRST module.")
  IF AddUserToCallerList = 'YES' THEN DO
     FirstMod = 'Caller List'
     IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"  ("FirstMod")\r\n")
     CALL DetMod2
     END
  IF EnableShuttleSystem = 'YES' THEN DO
     FirstMod = 'Shuttle System'
     IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"  ("FirstMod")\r\n")
     CALL DetMod2
     END
  IF EnableHelloDisplays = 'YES' THEN DO
     FirstMod = 'Hello Display'
     IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"  ("FirstMod")\r\n")
     CALL DetMod2
     END
  IF EnableBulletin_Menu = 'YES' THEN DO
     FirstMod = 'Bulletin Menu'
     IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("FirstMod")\r\n")
     Call DetMod2
     END
  IF EnableNewbieProcess = 'YES' THEN DO
     FirstMod = 'NewUser Process'
     IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("FirstMod")\r\n")
     CALL BackFromTree
     END
    CALL Error_General

DetMod2:

  IF MODULECOUNT < 2 THEN Call BackFromTree
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Status   : Determining the SECOND module.")

  DefinePath2:
    IF FIRSTMOD = 'Caller List' THEN CALL Limb1
    IF FIRSTMOD = 'Shuttle System' THEN CALL Limb2
    IF FIRSTMOD = 'Hello Display' THEN CALL Limb3
    IF FIRSTMOD = 'Bulletin Menu' THEN CALL Limb4
    CALL Error_General      

  Limb1:
    IF EnableShuttleSystem = 'YES' THEN DO
       SecondMod = 'Shuttle System'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("SecondMod")\r\n")
       CALL DetMod3
       END
  Limb2:
    IF EnableHelloDisplays = 'YES' THEN DO
       SecondMod = 'Hello Display'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("SecondMod")\r\n")
       CALL DetMod3
       END
  Limb3:
    IF EnableBulletin_Menu = 'YES' THEN DO
       SecondMod = 'Bulletin Menu'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("SecondMod")\r\n")
       Call DetMod3
       END
  Limb4: 
    IF EnableNewbieProcess = 'YES' THEN DO
       SecondMod = 'NewUser Process'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("SecondMod")\r\n")
       CALL BackFromTree
       END
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line," (??Can't Find??)\r\n")
  CALL BackFromTree

DetMod3:

  IF MODULECOUNT < 3 THEN Call BackFromTree
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Status   : Determining the THIRD module. ")

 DefinePath3:
    IF SECONDMOD = 'Shuttle System' THEN CALL Branch1
    IF SECONDMOD = 'Hello Display' THEN CALL Branch2
    IF SECONDMOD = 'Bulletin Menu' THEN CALL Branch3
    CALL Error_General      

  Branch1:
    IF EnableHelloDisplays = 'YES' THEN DO
       ThirdMod = 'Hello Display'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("ThirdMod")\r\n")
       CALL DetMod4
       END
  Branch2:
    IF EnableBulletin_Menu = 'YES' THEN DO
       ThirdMod = 'Bulletin Menu'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("ThirdMod")\r\n")
       Call DetMod4
       END
  Branch3:
    IF EnableNewbieProcess = 'YES' THEN DO
       ThirdMod = 'NewUser Process'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("ThirdMod")\r\n")
       CALL BackFromTree
       END
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line," (??Can't Find??)\r\n")
  CALL BackFromTree

DetMod4:

  IF MODULECOUNT < 4 THEN Call BackFromTree
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Status   : Determining the FOURTH module.")

 DefinePath4:
    IF THIRDMOD = 'Hello Display' THEN CALL Stick1
    IF THIRDMOD = 'Bulletin Menu' THEN CALL Stick2
    CALL Error_General      

  Stick1:
    IF EnableBulletin_Menu = 'YES' THEN DO
       FourthMod = 'Bulletin Menu'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("FourthMod")\r\n")
       Call DetMod5
       END
  Stick2:
    IF EnableNewbieProcess = 'YES' THEN DO
       FourthMod = 'NewUser Process'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("FourthMod")\r\n")
       CALL BackFromTree
       END
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line," (??Can't Find??)\r\n")
  CALL BackFromTree

DetMod5:

  IF MODULECOUNT < 5 THEN Call BackFromTree
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line,"Status   : Determining the FIFTH module. ")

    IF EnableNewbieProcess = 'YES' THEN DO
       FifthMod = 'NewUser Process'
       IF DEBUGMODE = 'ON' THEN AdeptPrint(line," ("FifthMod")\r\n")
       CALL BackFromTree
       END
  IF DEBUGMODE = 'ON' THEN AdeptPrint(line," (??Can't Find??)\r\n")
  CALL BackFromTree

/****************************************************************************/

AttachSequencers:

  IF FirstMod = 'Caller List' THEN AfterFirstMod = SecondMod
  IF FirstMod = 'Shuttle System' THEN AfterSecondMod = SecondMod
  IF FirstMod = 'Hello Display' THEN AfterThirdMod = SecondMod
  IF FirstMod = 'Bulletin Menu' THEN AfterFourthMod = SecondMod
  IF FirstMod = 'NewUser Process' THEN DO
     AfterFifthMod = 'Shutdown'
     Call DoneSequencing
     END
  IF SecondMod = 'Shuttle System' THEN AfterSecondMod = ThirdMod
  IF SecondMod = 'Hello Display' THEN AfterThirdMod = ThirdMod
  IF SecondMod = 'Bulletin Menu' THEN AfterFourthMod = ThirdMod
  IF SecondMod = 'NewUser Process' THEN DO
     AfterFifthMod = 'Shutdown'
     Call DoneSequencing
     END
  IF ThirdMod = 'Hello Display' THEN AfterThirdMod = FourthMod
  IF ThirdMod = 'Bulletin Menu' THEN AfterFourthMod = FourthMod
  IF ThirdMod = 'NewUser Process' THEN DO
     AfterFifthMod = 'Shutdown'
     Call DoneSequencing
     END
  IF FourthMod = 'Bulletin Menu' THEN AfterFourthMod = FifthMod
  IF FourthMod = 'NewUser Process' THEN DO
     AfterFifthMod = 'Shutdown'
     Call DoneSequencing
     END
  IF FifthMod = 'NewUser Process' THEN DO
     AfterFifthMod = 'Shutdown'
     Call DoneSequencing
     END

CALL DoneSequencing

/****************************************************************************/
