/*--------------------------------------------------------------------------*/
/* LORD Information System .97 for AdeptXBBS 1.0                            */
/* Author: Matt Davis     At: CML/2 (704-324-9949) 1:3666/107.0@Fidonet     */
/*==========================================================================*/

 ARG line          /* Passes the line# arg to script (This is REQUIRED!!!!) */
/****************************************************************************/

ErrorChecking  = 'ON'      /* Don't disable unless you're haivng BIG probs! */
ErrorRecovery  = 'ON'      /* Don't disable unless you're having BIG probs! */
BatchToRun     = '1.BAT'   /* Located in .\Adept\                           */
Parameters     = '{LN'     /* parms to pass to the above batch/cmd file     */
LORDScores     = '9'       /* Scores file in .\Text\ - No extension!        */
LORDMsgArea    = 'LORD'    /* The name of your LORD message area            */
                           /* Please don't change this (YET!!)              */
DoorMenuDisp   = 'Door'    /* Your door.menu's display file - no extension! */
LORDisDisp     = 'LordMenu' /* Lord Info-sys display - no extension!        */
Direction2Move = 'UP'  /* LORD.Cmd has to circumvent a bug in Adept in order 
                          to determine how many messages are in the LORD
                          message area.  To do this, it must do one of the
                          following:

                          Move UP, and then back down to the LORD Msg Area

                          or

                          Move DOWN and then back up to the LORD Msg Area   */

PARSE UPPER VAR ErrorChecking ErrorChecking
PARSE UPPER VAR ErrorRecovery ErrorRecovery
PARSE UPPER VAR Direction2Move Direction2Move
PreMsgDiff = ''

ShowMenu:

      /* Show the menu         */
  AdeptMenuType(line,51,LORDisDisp".Asc")

      /* Goto Msg Area 8 (LORD)*/
  AdeptMenuType(line,62,LORD)  

      /* Circumvent bugs in    
         Adept. :(             */
  IF Direction2Move = 'UP' THEN DO
    AdeptMenuType(line,64,1)
    AdeptMenuType(line,64,-1)
    END
  IF Direction2Move = 'DOWN' THEN DO
    AdeptMenuType(line,64,-1)
    AdeptMenuType(line,64,1)
    END

      /* Grab # of messages in 
         LORD, and how many the 
         user has read.        */  
  LastMessageRead = AdeptConvert(Line,"{M8")
  TotalMsgsInHere = AdeptConvert(Line,"{M7")

      /* Get # of new messages 
         by subtracting what 
         they've read, by the     
          number in that 
         message area          */
  MsgDifference = TotalMsgsInHere - LastMessageRead

      /* Stuff numbers under 
         10 with an extra zero 
         to make them look 
         better                */
  IF MsgDifference < '10' THEN PreMsgDiff = '{F30{FB'

      /* Some error checking.. */

ErrorRecoverCheck:
  IF ErrorRecovery = 'OFF' THEN DO
    Call ErrorMapping
    END
ErrorRecovery:
  IF MsgDifference < '0' THEN DO
    AdeptPrint(line,"[20;1H[8C{B8{FG{F9{B1")
    AdeptPrint(line,'[21;1H[8C{B8{FG {F2LORD Info-Sys detected an error.  Trying to Correct..  {F9{B1') 
    AdeptPrint(line,"[22;1H[8C{B8{FG{F9{B1[23;1H")
    AdeptSleep(line,2000)
    AdeptMenuType(line,62,LORD)
    AdeptMenuType(line,64,1)
    AdeptMenuType(line,64,-1)
    END
  IF MsgDifference < '0' THEN DO
    AdeptMenuType(line,62,LORD)
    AdeptMenuType(line,64,-1)
    AdeptMenuType(line,64,1)
    END
  IF MsgDifference < '0' THEN DO
    AdeptPrint(line,"[21;1H[8C{B8{FG {B1{FC I'm sorry, I couldn't fix the problem. {FBPress any key.{B8 {F9{B1") 
    AdeptPause(line)
    AdeptMenuType(line,51,LordError.Asc)
    BBSSysopName = AdeptGetVar(Line,140)
    AdeptHitReturn(line)
    AdeptMenuType(line,201,""BBSSysopName";LORD.Cmd is broke! -  {D8;1;"AreaToDumpSysMailIn"")
    Call Exit
    END
  Call NumberOfNewDialog

/****************************************************************************/

ErrorMapping:
  IF MsgDifference < '0' THEN DO
    IF ErrorChecking = 'ON' THEN MsgDifference = '[D[D{FDERROR'
    END
Call NumberOfNewDialog

/****************************************************************************/

SnatchInput:

      /* Getting input from 
         the user              */
  Key = AdeptWaitKey(line)

    SELECT
        WHEN (key=13) | (key=27)     /* [ENTER] or [ESC] */                
          THEN CALL Exit     
        WHEN (key=65) | (key=97)     /* [A] or [a] */                
          THEN CALL Exit     
        WHEN (key=76) | (key=108)    /* [L] or [l] */
          THEN CALL RunLord  
        WHEN (key=82) | (key=114)    /* [R] or [r] */
          THEN CALL ShowNewRules
        WHEN (key=80) | (key=112)    /* [P] or [p] */
          THEN CALL RankPlayers
        OTHERWISE Call SnatchInput
        END

/****************************************************************************/

ShowNewRules:

  IF ReadMsgs = 'NO' THEN Call SnatchInput

      /* Check for 0 new first */
  IF MsgDifference = '0' THEN DO
    AdeptPrint(line,'[21;1H[8C{B8{FG {F2There are no {FAnew {F2Rules{FA/{F2Messages.  {F1Read from msg {F51{F1? {B1{F2[ ]{B8 {F9{B1[21;63H{FGY[21;63H') 
    Call ReadFromScratch
    END

      /* Read new messages     */
  IF LastMessageRead > '1' THEN AdeptRead(Line,1,,LastMessageRead + 1)
  IF LastMessageRead = '1' THEN AdeptRead(line,1,,2)
  IF LastMessageRead = '0' THEN AdeptRead(line,1,,1)

      /* WARNING!!!  Make sure 
         there are AT LEAST 
         TWO messages in the 
         conference you are 
         reading messages out 
         of!!  Else, it WILL 
         NOT work!!!!          */

      /* Redraw the doors menu */
  AdeptMenuType(line,51,DoorMenuDisp".Asc")

      /* Redraw the Lord menu  */  
  Call ShowMenu

/****************************************************************************/

ReadFromScratch:

  Key = AdeptWaitKey(line)

    SELECT
        WHEN (key=13)                /* [ENTER] */
          THEN DO
            AdeptRead(line,1,,1)
            AdeptMenuType(line,51,DoorMenuDisp".Asc")
            Call ShowMenu
            END

        WHEN (key=27)                /* [ESC]   */                
          THEN DO  
            AdeptPrint(line,'[21;1H[8C{B8{FG {F2There are {B1    {B8 new messages in the {F1"{F5{M0{F1"{F2 message area {F9{B1[21;22H{FB'PreMsgDiff''MsgDifference'[23;1H') 
            Call SnatchInput
            END
                    
        WHEN (key=89) | (key=121)    /* [Y] or [y] */                
          THEN DO
            AdeptRead(line,1,,1)
            AdeptMenuType(line,51,DoorMenuDisp".Asc")
            Call ShowMenu
            END

        WHEN (key=78) | (key=110)    /* [N] or [n] */
          THEN DO
            AdeptPrint(line,'[21;1H[8C{B8{FG {F2There are {B1    {B8 new messages in the {F1"{F5{M0{F1"{F2 message area {F9{B1[21;22H{FB'PreMsgDiff''MsgDifference'[23;1H') 
            Call SnatchInput
            END
        OTHERWISE Call ReadFromScratch:
        END


RankPlayers:                   

      /* This shows the user 
         x:\Adept\Text\9.Asc, 
         which is created by 
         LORD on every normal 
         exit. (9.Ans/Asc is 
         also used by 
         Bulletin-System.Cmd)  */
  AdeptPrint(line,"{CS")
  AdeptMenuType(line,51,LordScores".ASC")
  AdeptPrint(line,"\r\n")
  AdeptHitReturn(line)

      /* Redraw the Door Menu  */
  AdeptMenuType(line,51,DoorMenuDisp".Asc")

      /* Redraw LordMenu       */
  Call ShowMenu

/****************************************************************************/

NumberOfNewDialog:

Conf = AdeptConvert(line,"{M0")
IF Conf <> LORDMsgArea THEN DO
  ReadMsgs = 'NO'
  AdeptPrint(line,"[20;1H[8C{B8{FG{F9{B1")
  AdeptPrint(line,'[21;1H[8C{B8{FG  {F2Please tell your sysop to setup a LORD message area.  {F9{B1') 
  AdeptPrint(line,"[22;1H[8C{B8{FG{F9{B1[23;1H")
   Call SnatchInput
END
ELSE DO
  AdeptPrint(line,"[20;1H[8C{B8{FG{F9{B1")
  AdeptPrint(line,'[21;1H[8C{B8{FG {F2There are {B1    {B8 new messages in the {F1"{F5{M0{F1"{F2 message area {F9{B1[21;22H{FB'PreMsgDiff''MsgDifference'') 
  AdeptPrint(line,"[22;1H[8C{B8{FG{F9{B1[23;1H")
   Call SnatchInput
END

Call SnatchInput

/****************************************************************************/

RunLord:                       

      /* Call LORD via 
         x:\Adept\1.Bat. (1.Bat
         is also used by 
         Door.Menu             */
  AdeptCall(Line,1,,"cmd.exe /c "BatchToRun" "Parameters)
  AdeptLog(line,2,"  Invoking LORD")
  Call Exit

/****************************************************************************/

Exit:
  EXIT
