/* ************************************* */
/* Ŀ */
/*  Ŀ    ĿĿĿĿĿ  */
/*           Ŀ          */
/*               */
/*    CF2AM v1.0     */
/*                                     */
/* CF2AM is a utility for AdeptXBBS to */
/* converts fast and easy:             */
/*     Fidonet.na -> Message_Areas     */
/*     Fidonet.na -> Areas.Control     */
/*                                     */
/*  By Koen Koster  */
/* Any comments, questions, thanks msgs? */
/* Send them to:     kkoster@cistron.nl  */
/*                   2:281/602.0@FidoNet */
/*                   55:66/0.0@AdeptNet  */
/* ************************************* */

/* ************************************* */
/*  Begin of the Configuration Section   */
/* ************************************* */

AREAFILE = 'Fidonet.na'        /*  Name of Fido fidonet.na file           */

MOUTFILE = 'Message_Areas'     /*  Name of the Message_Areas output file  */
AOUTFILE = 'Area.Control'      /*  Name of the Area.Control output file   */

STARTNR  = '100'               /*  nr of area to start with               */
MORIGIN  = 'ClipArT BBS (31-172-439373 - 31-172-410373)'/*  origin line   */
MRSEC1   = '30'                                   /*  Read  Security 1    */
MRSEC2   = '30'                                   /*  Read  Security 2    */
MWSEC1   = '50'                                   /*  Write Security 1    */
MWSEC2   = '50'                                   /*  Write Security 2    */
MSSEC1   = '100'                                  /*  Sysop Security 1    */
MSSEC2   = '100'                                  /*  Sysop Security 2    */
MFLAGS   = '100'                                  /*  Message Area Flags  */
MYADDRESS = '2:281/602.0@FidoNet'                 /*  My Address          */
EXADDRESS = '2:281/631.0@FidoNet'                 /*  Export Address      */

/* ************************************* */
/*  *END* of the Configuration Section   */
/* ************************************* */

Call SysCls
rc = stream( areafile, 'c', 'open read' )
rc = stream( moutfile, 'c', 'open write' )
rc = stream( aoutfile, 'c', 'open write' )

oldstartnr = startnr
starttime = time('E')

    check = lines(areafile)
    Do While check > 0
    line = LineIn(areafile)
    aname = substr(line,1,20)
    adesc = substr(line,21,57)
     Call LineOut moutfile,'AREABEGIN'
     Call LineOut moutfile,'  NAME     'aname
     Call LineOut moutfile,'  NUMBER   'startnr
     Call LineOut moutfile,'  DESC     'adesc
     Call LineOut moutfile,'  ORIGIN   'morigin
     Call LineOut moutfile,'  RSEC1    'mrsec1
     Call LineOut moutfile,'  RSEC2    'mrsec2
     Call LineOut moutfile,'  WSEC1    'mwsec1
     Call LineOut moutfile,'  WSEC2    'mwsec2
     Call LineOut moutfile,'  SSEC1    'mssec1
     Call LineOut moutfile,'  SSEC2    'mssec2
     Call LineOut moutfile,'  FLAGS    'mflags
     Call LineOut moutfile,'  ADDRESS  'MyAddress
     Call LineOut moutfile,'AREAEND'
     Call LineOut Aoutfile,'ECHO 'aname' 'startnr'   'ExAddress
     Say 'Writing Out Msgs Area -> 'startnr
     startnr = startnr + 1
    check = lines(areafile)
    End

Back:
totalnr = (startnr - oldstartnr)
curtime = time('R')
newtime = format(curtime,,2)
Say ' '
Say ' '
Say 'Total of 'totalnr' Areas processed in 'newtime' seconds by CF2AM.'
Say ' '
Say 'OutPut Message_Areas  : 'moutfile
Say 'OutPut Area.Control   : 'aoutfile
Say ' '
Say 'Thanks for using CF2AM and have a Nice Day!'
rc = stream( areafile, 'c', 'close' )
rc = stream( moutfile, 'c', 'close' )
rc = stream( aoutfile, 'c', 'close' )
