/*-------------------------------------------------------------------------*
 * NODELIST.CMD                                                            *
 *                                                                         *
 * Rexx procedure to update and/or create all nodelist files.              *
 *                                                                         *
 * Arg(1) : If "force", then all nodelists will be re-compiled regardless  *
 *          if new nodediffs/nodelists are in the inbound directory.       *
 *                                                                         *
 *-------------------------------------------------------------------------*/


/* trace results */

/*-------------------------------------------------------------------------*
 * Declare global variables                                                *
 *-------------------------------------------------------------------------*/

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

donelistfile    = "e:\nodelist\done.lst"

inbounddir      = "e:\nodelist"
fastlistdir     = "e:\nodelist"

/*
 * Since we use the MOVE command for the two following paths, we cannot
 * have a drive specification in them since MOVE will not move files
 * across drives.  (Brain dead program....)
 */

nodelistdir     = "\nodelist"
workdir         = "\nodelist"

FALSE = 0
TRUE  = 1

/*-------------------------------------------------------------------------*
 * MainLine                                                                *
 *-------------------------------------------------------------------------*/

if arg(1) = "force" then
    force_compile = TRUE
else
    force_compile = FALSE

/*
 * Change to drive which have 'nodelistdir' and 'workdir' directories
 */

"e:"

/*
 * Process FidoNet nodelist/nodediff
 */

cnt = 0

cnt = cnt + UncompressNodelist( "nodediff.a*", "e:\adept\system\arcp xo", TRUE )
cnt = cnt + UncompressNodelist( "nodelist.a*", "e:\adept\system\unzip -o", TRUE )

if (cnt > 0) | (force_compile = TRUE) then
    status = CompileNodelist( "node", "fidonet.cfg" )

/*
 * Process OS2NET nodelist/nodediff
 */

cnt = 0

cnt = cnt + UncompressNodelist( "os2diff.z*", "e:\adept\system\unzip -o", FALSE )
cnt = cnt + UncompressNodelist( "os2list.z*", "e:\adept\system\unzip -o", FALSE )

if (cnt > 0) | (force_compile = TRUE) then
    status = CompileNodelist( "os2", "os2net.cfg" )

cd fastlistdir

exit

/*
 * Process RIPNET nodelist/nodediff
 */

cnt = 0

cnt = cnt + UncompressNodelist( "RIP_diff.z*", "e:\adept\system\unzip -o", FALSE )
cnt = cnt + UncompressNodelist( "ripnet.z*", "e:\adept\system\unzip -o", FALSE )

if (cnt > 0) | (force_compile = TRUE) then
    status = CompileNodelist( "rip", "ripnet.cfg" )

cd fastlistdir

exit



/*-------------------------------------------------------------------------*
 * CompileNodelist                                                         *
 *                                                                         *
 * Compile the nodelist                                                    *
 *                                                                         *
 * Arg(1) : Prefix for the nodelist                                        *
 * Arg(2) : Configuration file for FastLst                                 *
 *                                                                         *
 *-------------------------------------------------------------------------*/

CompileNodelist:

    prefix = arg(1)
    configfilename = fastlistdir'\'arg(2)

    nodelist = prefix"list"
    nodediff = prefix"diff"


    /*
     * Note:   'nodelistdir' and 'workdir' must be on the same drive for
     *         the MOVE command to work correctly.
     */

    cd workdir

    fastlistdir"\"fastlst "-c"fastlst.cfg  "-l"fastlistdir"\fastlst.log"

    if rc > 0 then
        do
        return(FALSE)
        end

    if nodelist = "nodelist" then
        do
        /*
         * If we just compiled FidoNet's nodelist, move the SYSOP index
         * file also.
         */
        end

return(TRUE)

/*-------------------------------------------------------------------------*
 * UncompressNodelist                                                      *
 *                                                                         *
 * Uncompress the list to the nodelist WORK directory.                     *
 *                                                                         *
 * Arg(1) : Name of NODELIST/NODEDIFF file                                 *
 * Arg(2) : Command line to execute unarchive program                      *
 * Arg(3) : TRUE=delete nodelist archive after unarc, FALSE=keep it        *
 *                                                                         *
 * The file will only be unarced if it does NOT exist in the "done list"   *
 * file.                                                                   *
 *                                                                         *
 * This list file should be checked since there are times when TIC does    *
 * not toss the incoming nodelist/nodediff from the inbound directory and  *
 * it will just sit there until I do something about it manually.          *
 *                                                                         *
 *-------------------------------------------------------------------------*/

UncompressNodelist:

    filename        = inbounddir'\'arg(1)
    unarc_command   = arg(2)
    delete_file     = arg(3)

    fcnt = 0

    cd workdir

    /*
     * Get list of files
     */

    CALL SysFileTree filename, 'file', 'FO', '*****'

    do i = 1 to file.0

        if IsInList( file.i ) = FALSE then
            do
            unarc_command file.i
            if rc > 0 then
                do
                end
            else
                do
                /* add filename to "done list" */
                echo file.i">>"donelistfile
                fcnt = fcnt + 1
                if delete_file = TRUE then
                    del file.i  /* delete archive from inbound directory */
                end
            end

    end

return( fcnt )

/*-------------------------------------------------------------------------*
 * IsInList                                                                *
 *                                                                         *
 * Check the "done list" file for the existence of a filename.             *
 *                                                                         *
 * Arg(1) : Name of file to test                                           *
 *                                                                         *
 *-------------------------------------------------------------------------*/

IsInList:

    testfilename = arg(1)

    parse upper var testfilename testfilename

    found = FALSE

    status = stream( donelistfile, 'c', 'open' )

    do forever
        linestr = linein( donelistfile )    /* read in a line */

        parse upper var linestr linestr

        if linestr = "" then
            leave                           /* all done reading file */

        if compare( testfilename, linestr ) = 0 then
            do
            found = TRUE                    /* file already processed */
            leave
            end
    end

    status = stream( donelistfile, 'c', 'close' )

return(found)
