<?php
/*
 * ----------------------------------------------------------------------------
 * Post-Email.php                                                    11/11/2005
 * Allows a user to send a new email message or reply.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Mobile: Sending Email';

require_once('include_dir.php');
require_once($includeDir . 'va-functions.inc.php');
require_once($includeDir . 'va-database.inc.php');
require_once($includeDir . 'va-main.inc.php');
require_once($includeDir . 'va-networks.inc.php');

if (isset($_POST['referer'])) {
    $referer = $_POST['referer'];
} else {
    $referer = '';
}

if (isset($_GET['referer'])) {
    $referer = $_GET['referer'];
}

if (isset($_POST['m'])) {
    $m = $_POST['m'];
} else {
    $m = '';
}

if (isset($_GET['m'])) {
    $m = $_GET['m'];
}

$db = SetEmailInfo($USER['userno']);
$VA_NETWORKS = GetNetworkInfo();

// Check user's write security level.
if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct'])) {
    RedirectUser('email.php');
}

if ($USER['securitylevel'] < $db['minwritesl']) {
    if ((!isset($_GET['u'])) || ($_GET['u'] != 1)) {
        RedirectUser('email.php');
    }
}

if ((isset($_POST['reply'])) && ($_POST['reply'] != 0)) {   // Set the passed variables.
    $reply = (integer) $_POST['reply'];
    $msgInfo = GetMessageInfo($db, $reply);
} else {
    $reply = 0;
}

if ((isset($_GET['reply'])) && ($_GET['reply'] != 0)) {
    $reply = (integer) $_GET['reply'];
    $msgInfo = GetMessageInfo($db, $reply);
}

include_once('wml_header.php');

// Determine if there is a message to be sent.
if ((isset($_POST['msgflag'])) && ($_POST['msgflag'] == 1)) {
    if (isset($_POST['touser'])) {
        $toUser = trim($_POST['touser']);
        if (isset($_POST['tonetid'])) {
            $toNetId = (integer) $_POST['tonetid'];
            if ($toNetId == 0) {            // Determine if a local or network email.
                $toUserString = $toUser . '@0*' . $toNetId;
            } else {
                $atpos = strpos($toUser, '@');
                if ($atpos === FALSE) {
                    RedirectUser('post-email.php');
                }
                $toUserString = $toUser . '*' . $toNetId;
            }
        } else {
            RedirectUser('post-email.php');
        }
    } else {
        RedirectUser('post-email.php');
    }

    if (isset($_POST['subject'])) {
        $msgSubject = $_POST['subject'];
    } else {
        RedirectUser('post-email.php');
    }

    if (isset($_POST['msgbody'])) {
        $msgBody = $_POST['msgbody'];
    } else {
        RedirectUser('post-email.php');
    }

    $log = 'Mob E-Mail Sent "' . $USER['handle'] . '" --> "' . $toUserString . '" - ' . $msgSubject;
    WriteLog('VADV-PHP.LOG', $log);         // Log the email.
    WriteEmail($USER['userno'], $toUserString, $msgSubject, $msgBody, $reply);

    // Redirect the user using WML to erase the variables.
    RedirectUser('email.php', 0, 't', '', 'n', '', 's', '', 'b', '');
}
?>

<wml>

    <head>
        <meta http-equiv="Cache-Control" content="must-revalidate" forua="true" />
        <meta http-equiv="Cache-Control" content="no-cache" forua="true" />
    </head>

    <card title="VADV-PHP Send Email">
        <do type="prev" label="Back"><prev /></do>
        <p mode="wrap" align="center">
            <b>Mobile VADV-PHP Send Email</b><br />
            <?php print WMLSpecialChars($VA_MAIN['bbsname']) . "\n"; ?>
        </p>
        <p mode="nowrap">

            <?php
            if ($reply > 0) {
                print '<b>To: </b><br />' . WMLSpecialChars($msgInfo['fromhandle']) . '@' . $msgInfo['fromnetnode'] . ' ' . WMLSpecialChars($VA_NETWORKS[$msgInfo['fromnetid']]['desc']) . "\n";
            } else {
                print '<b>To: </b><br /><input name="t" size="16" maxlength="40" type="text" />' . "\n";
            }
            ?>

            <br />

            <?php
            if ($reply == 0) {
            ?>

            <b>Network: </b><br />
            <select name="n" ivalue="1">
                <option value="0">Local</option>

                <?php
                $pos = 0;
                $cnt = 0;
                $net = array();
                for ($x = 1; $pos < $VA_NETWORKS[0]; $x++) {
                    if (isset($VA_NETWORKS[$x])) {
                        if (($VA_NETWORKS[$x]['nettype'] != 2) &&   // If not a VLive network
                            ($VA_NETWORKS[$x]['nettype'] != 5)) {   // If not a QWK network
                            if (($USER['securitylevel'] >= 255) ||
                                ($VA_NETWORKS[$x]['accflag'] == '') ||                              // If a access flag is set..
                                (strpos($USER['flags'], $VA_NETWORKS[$x]['accflag']) !== FALSE)) {  // If the user has the flag
                                switch ($VA_NETWORKS[$x]['nettype']) {
                                    case 1:
                                        $type = 'VirtualNET';
                                        break;
                                    case 3:
                                        $type = 'Internet';
                                        break;
                                    case 4:
                                        $type = 'FIDOnet';
                                        break;
                                    case 9:
                                        $type = 'WWIVnet';
                                        break;
                                    default:
                                        $type = 'Unknown';
                                        break;
                                }
                                $net[$cnt]['netno']    = $VA_NETWORKS[$x]['netno'];
                                $net[$cnt]['desc']     = $VA_NETWORKS[$x]['desc'];
                                $net[$cnt]['sortdesc'] = strtolower($VA_NETWORKS[$x]['desc']);
                                $net[$cnt]['type']     = $type;
                                $cnt++;
                            }
                        }
                        $pos++;
                    }
                }
                // Organize the array alphabetically by description.
                $sortarr = array();
                foreach ($net as $row) {
                    $sortarr[] = $row['sortdesc'];
                }
                array_multisort($sortarr, $net);

                // Display the listing.
                for ($x = 0; $x < count($net); $x++) {
                    print '<option value="' . $net[$x]['netno'] . '">' . WMLSpecialChars($net[$x]['desc']) . ' (' . WMLSpecialChars($net[$x]['type']) . ')</option>' . "\n";
                }
            ?>

            </select>
            <br />

            <?php
            }
            ?>

            <b>Subject: </b><br /><input name="s" size="16" maxlength="64" type="text" value="<?php if ($reply > 0) print $msgInfo['subject']; ?>" />
            <br />
            <b>Message: </b><br /><input name="b" size="16" maxlength="250" type="text" />
            <br /><br />
            <anchor>Send<go href="post-email.php" method="post">
                <postfield name="referer" value="<?php print $referer; ?>" />
                <postfield name="reply" value="<?php print $reply; ?>" />
                <postfield name="m" value="<?php print $m; ?>" />

            <?php
            if ($reply > 0) {
                print '<postfield name="touser" value="' . $msgInfo['fromhandle'] . '@' . $msgInfo['fromnetnode'] . '" />' . "\n";
                print '<postfield name="tonetid" value="' . $msgInfo['fromnetid'] . '" />' . "\n";
            } else {
                print '<postfield name="touser" value="$t" />' . "\n";
                print '<postfield name="tonetid" value="$n" />' . "\n";
            }
            ?>

                <postfield name="subject" value="$s" />
                <postfield name="msgbody" value="$b" />
                <postfield name="msgflag" value="1" /></go></anchor>
            &nbsp;|&nbsp;

            <?php
            if ($reply > 0) {
                print '<anchor>Cancel<go href="email.php" method="get">' . "\n";
                print '<postfield name="referer" value="' . $referer . '" />' . "\n";
                print '<postfield name="m" value="' . $m . '" />' . "\n";
                print '<postfield name="read" value="1" />' . "\n";
                print '<setvar name="t" value="" />' . "\n";
                print '<setvar name="n" value="" />' . "\n";
                print '<setvar name="s" value="" />' . "\n";
                print '<setvar name="b" value="" /></go></anchor>' . "\n";
            } else {
                print '<anchor>Cancel<go href="email.php" method="get">' . "\n";
                print '<setvar name="t" value="" />' . "\n";
                print '<setvar name="n" value="" />' . "\n";
                print '<setvar name="s" value="" />' . "\n";
                print '<setvar name="b" value="" /></go></anchor>' . "\n";
            }
            ?>

        </p>

        <?php include('mobile_footer.php'); ?>
    </card>

</wml>