<?php
/*
 * ----------------------------------------------------------------------------
 * VConfig_Paths_Process.php                                         10/02/2006
 * This script processes the info from the vconfig_paths.php script.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    RedirectUser($rootDir . 'index.php');
}
if ($USER['securitylevel'] < 255) {
    $log = 'VConfig Error!  "' . $USER['handle'] . '" - Attempted Unauthorized VConfig Entry';
    WriteLog('VADV-PHP.LOG', $log);
    RedirectUser($rootDir . 'index.php');
}

// Check for system password.
if ($CONFIG['syspass']) {
    if (isset($_SESSION['systempw'])) {
        if ($_SESSION['systempw'] !== $VA_MAIN['systempw']) {
            RedirectUser($rootDir . 'index.php');
        }
    } else {
        RedirectUser($rootDir . 'index.php');
    }
}

if ((!isset($_SERVER['HTTP_REFERER'])) ||
    (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
    die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
}

if ((!isset($_POST['process'])) || ($_POST['process'] != 1)) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}
if (!isset($_POST['submit'])) {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if ($_POST['submit'] == 'Reset') {
    RedirectUser($_POST['referer']);
}
if ($_POST['submit'] == 'Cancel') {
    RedirectUser('vconfig.php');
}

if ((isset($_POST['main']))    && ($_POST['main']    != $VA_SYSPATHS['main']))    $syspaths['main']    = trim(strtoupper($_POST['main']));
if ((isset($_POST['script']))  && ($_POST['script']  != $VA_SYSPATHS['script']))  $syspaths['script']  = trim(strtoupper($_POST['script']));
if ((isset($_POST['data']))    && ($_POST['data']    != $VA_SYSPATHS['data']))    $syspaths['data']    = trim(strtoupper($_POST['data']));
if ((isset($_POST['network'])) && ($_POST['network'] != $VA_SYSPATHS['network'])) $syspaths['network'] = trim(strtoupper($_POST['network']));
if ((isset($_POST['text']))    && ($_POST['text']    != $VA_SYSPATHS['text']))    $syspaths['text']    = trim(strtoupper($_POST['text']));
if ((isset($_POST['control'])) && ($_POST['control'] != $VA_SYSPATHS['control'])) $syspaths['control'] = trim(strtoupper($_POST['control']));
if ((isset($_POST['temp']))    && ($_POST['temp']    != $VA_SYSPATHS['temp']))    $syspaths['temp']    = trim(strtoupper($_POST['temp']));
if ((isset($_POST['db']))      && ($_POST['db']      != $VA_SYSPATHS['db']))      $syspaths['db']      = trim(strtoupper($_POST['db']));
if ((isset($_POST['sysop']))   && ($_POST['sysop']   != $VA_SYSPATHS['sysop']))   $syspaths['sysop']   = trim(strtoupper($_POST['sysop']));
if ((isset($_POST['fdx']))     && ($_POST['fdx']     != $VA_SYSPATHS['fdx']))     $syspaths['fdx']     = trim(strtoupper($_POST['fdx']));

if (isset($syspaths)) {
    $fileString = ReadSysPaths();                       // Get the file string.
    $fileString = PutSysPaths($fileString, $syspaths);  // Put the new information into the file string.
    WriteSysPaths($fileString);                         // Write the new file.
}

RedirectUser($_POST['referer']);

?>