<?php
/*
 * ----------------------------------------------------------------------------
 * Todays_Callers.php                                                10/14/2006
 * This script will display the users who have called the BBS for today's date.
  * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing Today\'s Callers';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include the main BBS configuration.
require_once($includeDir . 'va-misc.inc.php');      // Include miscellaneous functions.

$callers  = GetTodaysCallers();              // Get today's callers.
$netcalls = GetNetworkCallers();            // Get today's network callers.

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[Today&#39;s Callers] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.boldBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.boldBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .body              { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    .boldBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .footer            { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF }
    .header            { font-family: Courier New;               font-size: 12pt; color: #FFFFFF; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .nocalls           { font-family: Courier New;               font-size: 10pt; color: #FFFF52; }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>
</head>

<body bgcolor="#000000">

<p class="title" align="right">Virtual Advanced Today&#39;s Callers
<hr color="#525552">

<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a>
            </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <center>
    <table border="0" cellspacing="10" cellpadding="0">
        <tr>
            <td align="center" valign="top" width="80" style="border-bottom: 1px solid #525552"><b>
                <span class="header">Call #</span></td>
            <td align="left" valign="top" width="80" style="border-bottom: 1px solid #525552"><b>
                <span class="header">User #</span></td>
            <td align="left" valign="top" width="230" style="border-bottom: 1px solid #525552"><b>
                <span class="header">Handle</span></td>
            <td align="left" valign="top" width="40" style="border-bottom: 1px solid #525552"><b>
                <span class="header">Ch #</span></td>
            <td align="left" valign="top" width="60" style="border-bottom: 1px solid #525552"><b>
                <span class="header">Time</span></td>
            <td align="left" valign="top" width="80" style="border-bottom: 1px solid #525552"><b>
                <span class="header">Baud</span></td>
        </tr>
<?php
if ($callers[0] <> 0) {
?>
        <tr>
            <td class="body" align="right" valign="top">
<?php
    for ($x = 1; $x <= $callers[0]; $x++) {
        print '<span style="color: #FFFF52">' . $callers[$x]['callno'] . '</span><span style="color: #52FF52">:</span><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
    for ($x = 1; $x <= $callers[0]; $x++) {
        print '<span style="color: #5255FF">#' . $callers[$x]['userno'] . '</span><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
    for ($x = 1; $x <= $callers[0]; $x++) {
        print '<a href="userinfo.php?u=' . $callers[$x]['userno'] . '"><span style="color: #52FF52">' . HtmlSpace($callers[$x]['handle']) . '</span></a><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
    for ($x = 1; $x <= $callers[0]; $x++) {
        print '<span style="color: #52FFFF">' . HtmlSpace($callers[$x]['channel']) . '</span><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
    for ($x = 1; $x <= $callers[0]; $x++) {
        $time = $callers[$x]['time'] . ' ' . date("O");
        $dateTime = ConvertDateTime($time, '', 'H:i');
        print '<span style="color: #FF5552">' . $dateTime['time'] . '</span><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top">
<?php
    for ($x = 1; $x <= $callers[0]; $x++) {
        print '<span style="color: #52FF52">' . $callers[$x]['baudrate'] . '</span><br />' . "\n";
    }
?>
            </td>
        </tr>
<?php
}

if ($netcalls[0] <> 0) {
?>
        <tr>
            <td class="body" align="right" valign="top" width="80">
<?php
    for ($x = 1; $x <= $netcalls[0]; $x++) {
        print '<span style="color: #FFFF52">' . $netcalls[$x]['callno'] . '</span><span style="color: #52FF52">:</span><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top" width="80">
<?php
    for ($x = 1; $x <= $netcalls[0]; $x++) {
        print '<span style="color: #FF5552">@' . $netcalls[$x]['nodeno'] . '</span><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top" width="230">
<?php
    for ($x = 1; $x <= $netcalls[0]; $x++) {
        print '<span style="color: #52FF52">' . HtmlSpace($netcalls[$x]['network']) . '</span><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top" width="40">
<?php
    for ($x = 1; $x <= $netcalls[0]; $x++) {
        print '<span style="color: #52FFFF">' . HtmlSpace($netcalls[$x]['channel']) . '</span><br />' . "\n";
    }
?>
            </td>
            <td class="body" align="left" valign="top" width="60">
<?php
    for ($x = 1; $x <= $netcalls[0]; $x++) {
        $time = $netcalls[$x]['time'] . ' ' . date("O");
        $dateTime = ConvertDateTime($time, '', 'H:i');
        print '<span style="color: #FF5552">' . $dateTime['time'] . '</span><br />' . "\n";
    }
?>
            </td>
        </tr>
<?php
}
?>
    </table>
    </center>
</div>

<?php GlobalFooter(1); ?>

</body>

</html>