<?php
/*
 * ----------------------------------------------------------------------------
 * SysInfo.inc.php                                                   11/14/2006
 * This script will display system statistics and information to the user.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing System Information';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-stats.inc.php');     // Include statistics information.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.

$stats    = GetStats();
$networks = GetNetworkInfo();
$hours    = GetHourStats();
$connect  = GetConnectionStats();
$dow      = GetDOWStats();

// Determine the hour with the most minutes used.
$pre = 'am';
$hour = 1;
$high = 0;
for ($x = 1; $x <= 24; $x++) {
    if ($x > 12) {
        $pre = 'pm';
        $hour = $x - 12;
    }
    if ($x == 24) {
        $pre = 'am';
    }
    if ($hours[$hour . $pre] > $high) {
        $high = $hours[$hour . $pre];
    }
}
$hours['high'] = $high;
if ($hours['high'] == 0) {
    $hours['high'] = 1;
}

// Determine the dow with the most connections.
$high = 0;
if ($dow['sunday'] > $high) {
    $high = $dow['sunday'];
}
if ($dow['monday'] > $high) {
    $high = $dow['monday'];
}
if ($dow['tuesday'] > $high) {
    $high = $dow['tuesday'];
}
if ($dow['wednesday'] > $high) {
    $high = $dow['wednesday'];
}
if ($dow['thursday'] > $high) {
    $high = $dow['thursday'];
}
if ($dow['friday'] > $high) {
    $high = $dow['friday'];
}
if ($dow['saturday'] > $high) {
    $high = $dow['saturday'];
}
$dow['high'] = $high;
if ($dow['high'] == 0) {
    $dow['high'] = 1;
}

// Determine the connect type with the most minutes used.
$high = 0;
if ($connect['1200'] > $high) {
    $high = $connect['1200'];
}
if ($connect['2400'] > $high) {
    $high = $connect['2400'];
}
if ($connect['9600'] > $high) {
    $high = $connect['9600'];
}
if ($connect['14400'] > $high) {
    $high = $connect['14400'];
}
if ($connect['19200'] > $high) {
    $high = $connect['19200'];
}
if ($connect['24000'] > $high) {
    $high = $connect['24000'];
}
if ($connect['28800'] > $high) {
    $high = $connect['28800'];
}
$connect['high'] = $high;
if ($connect['high'] == 0) {
    $connect['high'] = 1;
}
$connect['other'] = $stats['callstotal'] - $connect['total'];
if ($connect['other'] < 1) {
    $connect['other'] = 0;
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[System Information] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    a:active           { color: #FF0000 }
    a:link             { color: #0000D0 }
    a:visited          { color: #0000D0 }
    a:hover            { color: #FF0000 }
    a.body:link        { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    a.body:visited     { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    a.boldBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.boldBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    a.msgBack:link     { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    a.msgBack:visited  { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .body              { font-family: Courier New;               font-size: 10pt; color: #FFFFFF }
    .boldBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight: bold }
    .msgBack           { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FF0000; font-weight: bold }
    .result            { font-family: Verdana, Arial, Helvetica; font-size: 12pt; color: #FFFF00; font-weight: bold; font-style: italic }
    .title             { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight: bold; font-style: italic }
-->
</style>
</head>

<body bgcolor="#000000">

<p class="title" align="right">Virtual Advanced System Information
<hr color="#525552">
<div align="center">
    <table cellspacing="0" cellpadding="0" width="100%">
        <tr>
            <td class="msgBack" align="left" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">&lt;- Back</a> </td>
            <td class="msgBack" align="right" valign="top">
                <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a>
            </td>
        </tr>
    </table>
</div>
<hr color="#525552">
<div align="center">
    <center>
    <table border="0" cellspacing="0" cellpadding="0" width="750">
        <tr>
            <td class="body" align="left" width="750">
                <b><?php print $VA_MAIN['bbsname']; ?></b><br />
                <span style="color: #FF5552">Virtual Advanced&nbsp;&nbsp;</span><span style="color: #5255FF">v2.10</span><br />
                <span style="color: #FF5552">VADV-PHP&nbsp;&nbsp;</span><span style="color: #FFFF52"><?php print UserDate("m-d-Y"); ?>&nbsp;&nbsp;</span><span style="color: #52FF52"><?php print UserDate("H:i:s"); ?></span><br />
                <span style="color: #5255FF"><?php print $stats['daysonline']; ?> days online</span>
            </td>
        </tr>
    </table>
    </center>
</div>
<br />
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" width="150" valign="top" align="left"><b>Statistics</b></td>
            <td class="body" width="150" align="right"><b>Total</b></td>
            <td class="body" width="150" align="right"><b>Today</b></td>
            <td class="body">&nbsp;</td>
        </tr>
        <tr>
            <td class="body" width="150" valign="top" align="left">
                <span style="color: #ADAAAD">
                Calls<br />
                Nets<br />
                Posts<br />
                Emails<br />
                Downloads<br />
                Uploads<br />
                Active<br />
                Idle<br />
                Duty Cycle %<br />
                Web Calls<br />
                Web Hits<br />
                Highest Web Usage
                </span>
            </td>
            <td class="body" width="150" align="right" valign="top">
                <span style="color: #FF5552">
            <?php
                // Display Total Stats...
                print $stats['callstotal'] . "<br />\n";
                print $stats['netcallstotal'] . "<br />\n";
                print $stats['poststotal'] . "<br />\n";
                print $stats['emailstotal'] . "<br />\n";
                print $stats['downloadstotal'] . "<br />\n";
                print $stats['uploadstotal'] . "<br />\n";
                print $stats['activemintotal'] . "<br />\n";
                print $stats['idlemintotal'] . "<br />\n";
                $totalmin = $stats['activemintotal'] + $stats['idlemintotal'];
                if ($totalmin > 0) {
                    print round(($stats['activemintotal'] / $totalmin) * 100) . "<br />\n";
                } else {
                    print '0' . "<br />\n";
                }
                print $stats['webcallstotal'] . "<br />\n";
                print $stats['webhitstotal'] . "<br />\n";
                print $stats['webmaxusers'];
            ?>
                </span>
            </td>
            <td class="body" width="150" align="right" valign="top">
                <span style="color: #FFFF52">
            <?php
                // Display Todays Stats...
                print $stats['callstoday'] . "<br />\n";
                print $stats['netcallstoday'] . "<br />\n";
                print $stats['poststoday'] . "<br />\n";
                print $stats['emailstoday'] . "<br />\n";
                print $stats['downloadstoday'] . "<br />\n";
                print $stats['uploadstoday'] . "<br />\n";
                print $stats['activemintoday'] . "<br />\n";
                print $stats['idlemintoday'] . "<br />\n";
                $todaymin = $stats['activemintoday'] + $stats['idlemintoday'];
                if ($todaymin > 0) {
                    print round(($stats['activemintoday'] / $todaymin) * 100);
                } else {
                    print '0';
                }
            ?>
                </span>
            <td class="body">&nbsp;</td>
        </tr>
    </table>
</div>
<br />
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" align="left" valign="top" height="20"><b>Configured Networks</b></td>
        </tr>
    </table>
</div>
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
    <?php
        foreach($networks as $netInfo) {
            if ((isset($netInfo['settings']['systemid'])) && ($netInfo['settings']['systemid'] != '0')) {
    ?>
        <tr>
            <td class="body" width="150" valign="top" align="left"><span style="color: #5255FF"><?php print $netInfo['desc']; ?></span></td>
            <td class="body" align="left" valign="top">(<span style="color: #52FF52">@<?php print $netInfo['settings']['systemid']; ?>*<?php print $netInfo['netno']; ?></span>)</td>
        </tr>
    <?php
            }
        }
    ?>
    </table>
</div>
<br />
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" align="left" valign="top" height="20"><b>Hour by Hour Statistics (Minutes)</b></td>
        </tr>
    </table>
</div>
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" width="60" align="left" valign="top">12am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['12am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">1am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['1am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">2am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['2am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">3am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['3am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">4am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['4am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">5am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['5am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">6am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['6am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">7am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['7am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">8am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['8am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">9am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['9am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">10am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['10am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">11am</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['11am'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">12pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['12pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">1pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['1pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">2pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['2pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">3pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['3pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">4pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['4pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">5pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['5pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">6pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['6pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">7pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['7pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">8pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['8pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">9pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['9pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">10pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['10pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">11pm</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($hours['high'] > 0) {
                            $pct = round($hours['11pm'] / $hours['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>
<br />
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" align="left" valign="top" height="20"><b>Day of Week Statistics (Calls)</b></td>
        </tr>
    </table>
</div>
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" width="60" align="left" valign="top">Sun</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($dow['high'] > 0) {
                            $pct = round($dow['sunday'] / $dow['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">Mon</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($dow['high'] > 0) {
                            $pct = round($dow['monday'] / $dow['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">Tues</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($dow['high'] > 0) {
                            $pct = round($dow['tuesday'] / $dow['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">Wed</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($dow['high'] > 0) {
                            $pct = round($dow['wednesday'] / $dow['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">Thurs</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($dow['high'] > 0) {
                            $pct = round($dow['thursday'] / $dow['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">Fri</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($dow['high'] > 0) {
                            $pct = round($dow['friday'] / $dow['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">Sat</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($dow['high'] > 0) {
                            $pct = round($dow['saturday'] / $dow['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>
<br />
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" align="left" valign="top" height="20"><b>User Baud Rate Statistics (Calls)</b></td>
        </tr>
    </table>
</div>
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" width="60" align="left" valign="top">Other</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($connect['high'] > 0) {
                            $pct = round($connect['other'] / $connect['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">28800</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($connect['high'] > 0) {
                            $pct = round($connect['28800'] / $connect['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">24000</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($connect['high'] > 0) {
                            $pct = round($connect['24000'] / $connect['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">19200</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($connect['high'] > 0) {
                            $pct = round($connect['19200'] / $connect['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">14400</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($connect['high'] > 0) {
                            $pct = round($connect['14400'] / $connect['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">9600</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($connect['high'] > 0) {
                            $pct = round($connect['9600'] / $connect['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">2400</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($connect['high'] > 0) {
                            $pct = round($connect['2400'] / $connect['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
        <tr>
            <td class="body" width="60" align="left" valign="top">1200</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        if ($connect['high'] > 0) {
                            $pct = round($connect['1200'] / $connect['high'] * 100);
                        } else {
                            $pct = 0;
                        }
                        $rightbar = 100 - $pct;
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $pct; ?>%">&nbsp;</td>
                        <td width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>

<br />
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" align="left" valign="top" height="20"><b>Total Call Ratio - <span style="color: #FF5552">BBS</span> : <span style="color: #5255FF">Web</span></b></td>
        </tr>
    </table>
</div>
<div align="center">
    <table cellpadding="0" cellspacing="0" width="750">
        <tr>
            <td class="body" width="60" align="left" valign="top">Calls</td>
            <td width="690" align="left" valign="top">
                <table cellspacing="0" cellpadding="0" width="100%">
                    <tr>
                        <?php
                        $totalcalls = $stats['callstotal'] + $stats['webcallstotal'];
                        if ($totalcalls == 0) {
                            $leftbar = 50;
                            $rightbar = 50;
                        } else {
                            $leftbar = round($stats['callstotal'] / $totalcalls * 100);
                            $rightbar = 100 - $leftbar;
                        }
                        ?>
                        <td bgcolor="#FF0000" width="<?php print $leftbar; ?>%">&nbsp;</td>
                        <td bgcolor="#0000FF" width="<?php print $rightbar; ?>%">&nbsp;</td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>
<?php GlobalFooter(1); ?>

</body>

</html>