<?php
/*
 * ----------------------------------------------------------------------------
 * DispLog.php                                                       10/14/2006
 * This script will display the VADV-PHP log.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing Log';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}
if ($USER['securitylevel'] < 255) {
    die('<br /><h4>You do not have access to this page. Press the BACK button on your browser.</h4>');
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[VADV-PHP Log] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
</head>

<body>
<pre>
<?php
$file = $VA_SYSPATHS['data'] . '/VADV-PHP.LOG';
if (is_file($file)) {
    readfile($file);
} else {
    print 'VADV-PHP.LOG was not found.';
}

print "\r\n\r\n";
print "VADV BBS Log\r\n";
print "-------------------------------------------------------------------------------\r\n";

$file = $VA_SYSPATHS['data'] . '/BBS.LOG';
if (is_file($file)) {
    readfile($file);
} else {
    print 'BBS.LOG was not found.';
}
?>
</pre>
</body>

</html>