<?php
/*
 * ----------------------------------------------------------------------------
 * Index.php                                                         10/14/2006
 * This is the main menu and home page for your Virtual Advanced web bbs!
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Viewing Home Page';

require_once('include_dir.php');                    // Get Include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include the main BBS configuration.
require_once($includeDir . 'va-control.inc.php');   // Include the BBS control information.
require_once($includeDir . 'va-misc.inc.php');      // Include miscellaneous functions.
require_once($includeDir . 'va-random.inc.php');    // Include random quotes.
require_once($includeDir . 'va-stats.inc.php');     // Include BBS statistics.
require_once($includeDir . 'va-vote.inc.php');      // Include the voting booth.
require_once($includeDir . 'at2k.inc.php');         // Include AT2k functions.
require_once($includeDir . 'forms.inc.php');        // Uses the common html functions.

$stats = GetStats();

// Determine if browswer is not HTML capable.
// Check whether the browser/gateway says it accepts WML.
if ((isset($_SERVER['HTTP_ACCEPT'])) &&
    ((strpos(strtolower($_SERVER['HTTP_ACCEPT']), 'vnd.wap.wml') !== FALSE))) {
    $br = 'WML';
} else {
    if (isset($_SERVER['HTTP_USER_AGENT'])) {
        $browser = substr(trim($_SERVER['HTTP_USER_AGENT']), 0, 4);
    } else {
        $browser = '';
    }
    if ($browser == 'Noki' ||            // Nokia phones and emulators
        $browser == 'Eric' ||            // Ericsson WAP phones and emulators
        $browser == 'WapI' ||            // Ericsson WapIDE 2.0
        $browser == 'MC21' ||            // Ericsson MC218
        $browser == 'AUR ' ||            // Ericsson R320
        $browser == 'R380' ||            // Ericsson R380
        $browser == 'UP.B' ||            // UP.Browser
        $browser == 'WinW' ||            // WinWAP browser
        $browser == 'UPG1' ||            // UP.SDK 4.0
        $browser == 'upsi' ||            // another kind of UP.Browser ??
        $browser == 'QWAP' ||            // unknown QWAPPER browser
        $browser == 'Jigs' ||            // unknown JigSaw browser
        $browser == 'Java' ||            // unknown Java based browser
        $browser == 'Alca' ||            // unknown Alcatel-BE3 browser (UP based?)
        $browser == 'MITS' ||            // unknown Mitsubishi browser
        $browser == 'MOT-' ||            // unknown browser (UP based?)
        $browser == 'My S' ||            // unknown Ericsson devkit browser ?
        $browser == 'WAPJ' ||            // Virtual WAPJAG www.wapjag.de
        $browser == 'fetc' ||            // fetchpage.cgi Perl script from www.wapcab.de
        $browser == 'ALAV' ||            // yet another unknown UP based browser ?
        $browser == 'Wapa')              // another unknown browser (Web based "Wapalyzer"?)
    {
        $br = 'WML';
    } else {
        $br = 'HTML';
    }
}

if ($br == 'WML') {
    RedirectUser('./wap/index.php');
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title><?php print HtmlSpace($VA_MAIN['bbsname']); ?>'s VADV-PHP Home</title>
<meta name="robots" content="index,follow">
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn">
<?php
if ($CONFIG['refresh'] > 0) {
    print '<meta http-equiv="refresh" content="' . $CONFIG['refresh'] . '">' . "\n";
}
?>
<link rel="stylesheet" type="text/css" href="VADVPHP.css">
</head>

<body background="images/home_background.gif">

<div align="center">
    <center>
    <table border="0" cellpadding="10" cellspacing="0" style="border-collapse: collapse" width="750" bgcolor="#FFFFFF">
        <tr>
            <td>
                <div align="center">
                    <center>
                    <table border="0" cellpadding="0" cellspacing="0" style="border-collapse: collapse" width="730" bgcolor="#FFFFFF">
                        <tr>
                            <td valign="top">
                                <div align="center">
                                    <center>
                                    <table border="0" cellpadding="5" cellspacing="0" style="border-collapse: collapse" width="100%" height="50">
                                        <tr>
                                            <td align="left" width="550" bgcolor="#000080"><span class="bbsHeader"><?php print HtmlSpace($VA_MAIN['bbsname']); ?>'s VADV-PHP Home</span></td>
                                            <td align="right" width="180" bgcolor="#000080"><a href="http://www.vadvphp.com"><img border="0" src="images/vadv-php_blue.gif" alt="VADV-PHP" width="50" height="50" align="right"></a></td>
                                        </tr>
                                    </table>
                                    </center>
                                </div>
                                <div align="center">
                                    <center>
                                    <table border="0" cellpadding="5" cellspacing="0" style="border-collapse: collapse" width="100%">
                                        <tr>
                                            <td width="530" valign="top">
                                                <div align="center">
                                                    <center>
                                                    <table border="0" cellpadding="5" cellspacing="0" style="border-collapse: collapse" width="100%">
                                                        <tr>
                                                            <td class="topic" bgcolor="#000080" align="left">
                                                                Welcome, <?php print HtmlSpace($USER['handle']); ?>!</td>
                                                            <td class="infoBarBody" bgcolor="#000080" align="right">
                                                                <?php print UserDate("g:ia l, F j, Y"); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td class="body" align="left" valign="top" colspan="2">
                                                                <p><span class="boldBody">Thank
                                                                you for visiting our Virtual Advanced webpage!</span><br />
                                                                This is the web based version of our BBS. With it
                                                                you will be able to access most areas of the
                                                                system using only your web browser. So, sit
                                                                back, relax and browse around!</p>
                                                                <span class="boldBody">
                                                                <?php
                                                                if ((!IsHttps()) && ($CONFIG['sslredirect'] != '')) {
                                                                    print '<p><a href="' . $CONFIG['sslredirect'] . '">Click here to goto the SSL secured website.</a></p>';
                                                                }

                                                                if (($USER['userno'] > 0) &&
                                                                    ($USER['userno'] != $CONFIG['guestacct'])) {
                                                                    print '<a class="body" href="forums/post-email.php?u=1&referer=' . urlencode(GetCurrentURL()) . '">' . $VA_MAIN['sysopname'] . "</a>\n";
                                                                } else {
                                                                    print $VA_MAIN['sysopname'] . "\n";
                                                                }
                                                                print '<br />' . HtmlSpace($VA_MAIN['bbsname']) . "\n";

                                                                if ($CONFIG['telnet'] != '') {
                                                                    print '<br /><a class="body" href="telnet://' . $CONFIG['telnet'] . '">telnet://' . $CONFIG['telnet'] . "</a>\n";
                                                                }

                                                                if (is_file($VA_SYSPATHS['main'] . '/PAGER.FLG')) {
                                                                    print '<br /><br /><span style="color: #FF0000">The SysOp is available for chat!</span>' . "\n";
                                                                }
                                                                ?>
                                                                </span><br />&nbsp;
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        if (($USER['userno'] > 0) &&
                                                            ($USER['userno'] != $CONFIG['guestacct'])) {
                                                            $msgcnt = GetEmailCount($USER['userno']);

                                                            $notice   = '';
                                                            $noticeNo = FALSE;
                                                            // New email check...
                                                            if ($msgcnt['unread'] > 0) {
                                                                $notice = $notice . '<span style="color: #FF0000">You have new email!</span><br />' . "\n";
                                                                $noticeNo = TRUE;
                                                            } else {
                                                                $notice = $notice . "You have no new email.<br />\n";
                                                            }

                                                            // System News check...
                                                            if ($CONFIG['sysnews']) {
                                                                $sysnews = GetSysNewsConfig();                                      // Get System News configuration.
                                                                if ($sysnews != FALSE) {
                                                                    $db = GetDbInfo($sysnews['topicno'], $sysnews['db']);               // Get database info.
                                                                    $msgPointer = GetMessagePointer($db, $USER['userno']);              // Get message pointer.
                                                                    if ($msgPointer < $db['msgno']) {
                                                                        $notice = $notice . '<a style="color: #0000FF" href="./misc/system_news.php"><span style="color: #0000FF">You have unread System News!</span></a><br />' . "\n";
                                                                        $noticeNo = TRUE;
                                                                    }
                                                                }
                                                            }

                                                            // Validate messages...
                                                            if (($USER['securitylevel'] >= 255) &&
                                                                (phpversion() != '4.3.7') &&
                                                                (phpversion() != '4.3.8')) {
                                                                $file = $VA_SYSPATHS['data'] . '/VALIDATE.*';
                                                                $files = glob($file);
                                                                if ($files != FALSE) {
                                                                    foreach ($files as $filename) {
                                                                        if (filesize($filename) > 0) {
                                                                            $notice = $notice . '<span style="color: #008000">There are messages needing validation!</span><br />' . "\n";
                                                                            $noticeNo = TRUE;
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                            }

                                                            // New uploads check...
                                                            if ($USER['securitylevel'] >= 255) {
                                                                $uploads = SetUploadInfo();
                                                                $msgcnt = GetMessageCount($uploads, 0);
                                                                if ($msgcnt > 0) {
                                                                    $notice = $notice . '<span style="color: #008000">There are new uploads to review!</span><br />' . "\n";
                                                                    $noticeNo = TRUE;
                                                                }
                                                            }

                                                            // Oneliners check...
                                                            $db = SetOnelinerInfo();
                                                            $oneliners = SearchMessagesTo($db, $USER['userno']);
                                                            if ($oneliners[0] > 0) {
                                                                $msgPointer = GetMessagePointer($db, $USER['userno']);
                                                                for ($x = 1; $x <= $oneliners[0]; $x++) {
                                                                    if ($msgPointer < $oneliners[$x]) {
                                                                        $msgInfo = GetMessageInfo($db, $oneliners[$x]);             // Get message information.
                                                                        $subject = trim(StripBBSCodes($msgInfo['subject']));
                                                                        if (strlen($subject) > 50) {
                                                                            $subject = substr($subject, 0, 50);
                                                                        }
                                                                        //$subject = $subject . '&nbsp;&nbsp;(' . trim($msgInfo['date']) . ' ' . trim($msgInfo['time']) . ')';
                                                                        $notice = $notice . $subject . '<br />';  // Print message subject (oneliner).
                                                                        $noticeNo = TRUE;
                                                                        $msgInfo['deleted'] = 1;                                    // Mark the message for deletion.
                                                                        WriteMessageInfo($db, $oneliners[$x], $msgInfo);            // Write the new information.
                                                                        WriteMessagePointer($db, $USER['userno'], $oneliners[$x]);  // Update the message pointer.
                                                                    }
                                                                }
                                                            }
                                                            
                                                            // Retrieve the random quotes...
                                                            $quotes = GetRandomQuotes();
                                                        ?>
                                                        <tr>
                                                            <td class="topic" align="left" bgcolor="#000080" colspan="2">
                                                                <?php
                                                                if (($noticeNo) ||
                                                                    ($quotes[0] == 0)) {
                                                                       print 'User Notices';
                                                                   } else {
                                                                       print 'Random Quote';
                                                                   } ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td valign="top" colspan="2">
                                                                <div>
                                                                    <table border="0" cellspacing="10" cellpadding="0" width="530">
                                                                        <tr>
                                                                            <td class="pre" align="left" valign="top">
                                                                                <?php
                                                                                // Now print any notices...
                                                                                if (($noticeNo) ||
                                                                                    ($quotes[0] == 0)) {
                                                                                    print $notice;
                                                                                } else {
                                                                                    mt_srand((double) microtime() * 1000000);   // Seed the random number generator.
                                                                                    $rnd = mt_rand(1, $quotes[0]);
                                                                                    print StripBBSCodes($quotes[$rnd]) . "<br />\n";
                                                                                }
                                                                                ?>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                <br />
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td class="topic" align="left" bgcolor="#000080" colspan="2">
                                                                Today&#39;s Callers</td>
                                                        </tr>
                                                        <tr>
                                                            <td align="left" valign="top" colspan="2">
                                                                <?php $callers = GetTodaysCallers(); ?>
                                                                <div>
                                                                    <table border="0" cellspacing="10" cellpadding="0" width="530">
                                                                            <?php
                                                                            if ($callers[0] == 0) {
                                                                                print '<tr><td align="left" valign="top"><span style="font-family: Courier New; font-size: 10pt; color: #000000">No callers today!</span></td>' . "\n";
                                                                            } else {
                                                                            ?>
                                                                            <tr>
                                                                                <td align="left" valign="top" width="80" style="border-bottom: 1px solid #525552">
                                                                                    <span style="font-family: Courier New; font-size: 10pt; color: #000080; font-weight: bold">User #</span></td>
                                                                                <td align="left" valign="top" width="230" style="border-bottom: 1px solid #525552">
                                                                                    <span style="font-family: Courier New; font-size: 10pt; color: #000080; font-weight: bold">Handle</span></td>
                                                                                <td align="left" valign="top" width="40" style="border-bottom: 1px solid #525552">
                                                                                    <span style="font-family: Courier New; font-size: 10pt; color: #000080; font-weight: bold">Ch #</span></td>
                                                                                <td align="left" valign="top" width="60" style="border-bottom: 1px solid #525552">
                                                                                    <span style="font-family: Courier New; font-size: 10pt; color: #000080; font-weight: bold">Time</span></td>
                                                                                <td align="left" valign="top" width="80" style="border-bottom: 1px solid #525552">
                                                                                    <span style="font-family: Courier New; font-size: 10pt; color: #000080; font-weight: bold">Baud</span></td>
                                                                            </tr>
                                                                            <tr>
                                                                                <td align="left" valign="top" width="80">
                                                                                    <?php
                                                                                    for ($x = 1; $x <= $callers[0]; $x++) {
                                                                                        print '<span style="font-family: Courier New; font-size: 10pt; color: #000000">#' . $callers[$x]['userno'] . '</span><br />' . "\n";
                                                                                    }
                                                                                    ?>
                                                                                </td>
                                                                                <td align="left" valign="top" width="230">
                                                                                    <?php
                                                                                    for ($x = 1; $x <= $callers[0]; $x++) {
                                                                                        print '<span style="font-family: Courier New; font-size: 10pt; color: #000000"><a href="misc/userinfo.php?u=' . $callers[$x]['userno'] . '">' . HtmlSpace($callers[$x]['handle']) . '</a></span><br />' . "\n";
                                                                                    }
                                                                                    ?>
                                                                                </td>
                                                                                <td align="left" valign="top" width="40">
                                                                                    <?php
                                                                                    for ($x = 1; $x <= $callers[0]; $x++) {
                                                                                        print '<span style="font-family: Courier New; font-size: 10pt; color: #000000">' . $callers[$x]['channel'] . '</span><br />' . "\n";
                                                                                    }
                                                                                    ?>
                                                                                </td>
                                                                                <td align="left" valign="top" width="60">
                                                                                    <?php
                                                                                    for ($x = 1; $x <= $callers[0]; $x++) {
                                                                                        $time = $callers[$x]['time'] . ' ' . date("O");
                                                                                        $dateTime = ConvertDateTime($time, '', 'H:i');
                                                                                        print '<span style="font-family: Courier New; font-size: 10pt; color: #000000">' . $dateTime['time'] . '</span><br />' . "\n";
                                                                                    }
                                                                                    ?>
                                                                                </td>
                                                                                <td align="left" valign="top" width="80">
                                                                                    <?php
                                                                                    for ($x = 1; $x <= $callers[0]; $x++) {
                                                                                        print '<span style="font-family: Courier New; font-size: 10pt; color: #000000">' . $callers[$x]['baudrate'] . '</span><br />' . "\n";
                                                                                    }
                                                                                    ?>
                                                                                </td>
                                                                            <?php
                                                                            }
                                                                            ?>
                                                                        </tr>
                                                                    </table>
                                                                </div>
                                                                <br />
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="topic" align="left" bgcolor="#000080" colspan="2">
                                                                Who&#39;s Online?</td>
                                                        </tr>
                                                        <tr>
                                                            <td align="left" valign="top" colspan="2">
                                                                <?php
                                                                $who = GetControl();
                                                                $maxChannel = 10;   // Display only first 10 channels.
                                                                if ($VA_MAIN['maxchannelno'] < 10) {
                                                                    $maxChannel = $VA_MAIN['maxchannelno'];
                                                                }
                                                                if ($who['nodetotal'] < $maxChannel) {
                                                                    $maxChannel = $who['nodetotal'];
                                                                }
                                                                ?>
                                                                <span style="font-family: Courier New; font-size: 10pt">
                                                                <div>
                                                                    <table border="0" width="530" cellspacing="10" cellpadding="0">
                                                                        <tr>
                                                                            <td align="right" width="40" style="border-bottom: 1px solid #525552">
                                                                                <span style="font-family: Courier New; font-size: 10pt; color: #000080; font-weight: bold">Ch #</span></td>
                                                                            <td align="left" width="230" style="border-bottom: 1px solid #525552">
                                                                                <span style="font-family: Courier New; font-size: 10pt; color: #000080; font-weight: bold">Handle</span></td>
                                                                            <td align="left" width="230" style="border-bottom: 1px solid #525552">
                                                                                <span style="font-family: Courier New; font-size: 10pt; color: #000080; font-weight: bold">Action</span></td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td align="right" valign="top" width="40">
                                                                                <?php
                                                                                for ($x = 0; $x <= $maxChannel; $x++) {
                                                                                    print '<span style="font-family: Courier New; font-size: 10pt; color: #000000">' . $x . '</span><br />' . "\n";
                                                                                }
                                                                                ?>
                                                                            </td>
                                                                            <td align="left" valign="top" width="230">
                                                                                <?php
                                                                                for ($x = 0; $x <= $maxChannel; $x++) {
                                                                                    print '<span style="font-family: Courier New; font-size: 10pt; color: #000000"><a href="misc/userinfo.php?u=' . $who[$x]['userno'] . '">' . HtmlSpace($who[$x]['handle']) . '</a>&nbsp;</span><br />' . "\n";
                                                                                }
                                                                                ?>
                                                                            </td>
                                                                            <td align="left" valign="top" width="230">
                                                                                <?php
                                                                                for ($x = 0; $x <= $maxChannel; $x++) {
                                                                                    print '<span style="font-family: Courier New; font-size: 10pt; color: #000000">' . HtmlSpace($who[$x]['action']) . '&nbsp;</span><br />' . "\n";
                                                                                }
                                                                                ?>
                                                                            </td>
                                                                        </tr>
                                                                    </table>
                                                                </div>
                                                                </span>
                                                            </td>
                                                        </tr>
                                                        <!-- Cell template for future use.
                                                        <tr>
                                                            <td class="topic" align="left" bgcolor="#000080" valign="top" colspan="2">
                                                                Welcome!</td>
                                                        </tr>
                                                        <tr>
                                                            <td valign="top">&nbsp;</td>
                                                        </tr>
                                                        End cell template. -->
                                                    </table>
                                                    </center>
                                                </div>
                                            </td>
                                            <td width="200" height="100%" valign="top">
                                                <div align="center">
                                                    <center>
                                                    <table border="1" cellpadding="4" cellspacing="0" style="border-collapse: collapse" bordercolor="#FFFFFF" width="100%" height="100%" bgcolor="#0066CC">
                                                        <tr>
                                                            <td class="infoBarTopic" align="left" bgcolor="#000080">
                                                                Available Areas</td>
                                                        </tr>
                                                        <?php
                                                        // Email menu option
                                                        if (($USER['userno'] > 0) &&
                                                            ($USER['userno'] != $CONFIG['guestacct'])) {
                                                            $msgcnt = GetEmailCount($USER['userno']);
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./forums/email-dispmsg.php">Check Your Email</a>
                                                                <?php
                                                                if ($msgcnt['unread'] > 0) {
                                                                    print '<img src="images/alert.gif" border="0" alt="New email!" height="11" width="11">';
                                                                    //print '<span class="notify">(!)</span>' . "\n";
                                                                }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        // End Email menu option
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./forums/forum-disptopics.php">Message Forums</a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        if ($CONFIG['postitnt']) {
                                                            $postitnt = GetPostItConfig();
                                                            if ($postitnt != FALSE) {
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/post-it_network.php">Post-It! Network</a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                            }
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./forums/files-disptopics.php">File Area</a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        if ($VA_VOTE[0] > 0) {
                                                            // Check to see if any new polls for the user, except for guests.
                                                            $newPoll = 0;
                                                            if (($USER['userno'] > 0) &&
                                                                ($USER['userno'] != $CONFIG['guestacct'])) {
                                                                for ($x = 1; $x <= $VA_VOTE[0]; $x++) {
                                                                    if (GetUserVote($USER['userno'], $x) == 0) {
                                                                        $newPoll = 1;
                                                                        break;
                                                                    }
                                                                }
                                                            }
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/vote.php">Voting Booth</a>
                                                                <?php
                                                                if ($newPoll == 1) {
                                                                    print '<img src="images/alert.gif" border="0" alt="New questions!" height="11" width="11">';
                                                                    //print '<span class="notify">(!)</span>' . "\n";
                                                                }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/who.php">Who&#39;s Online</a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/todays_callers.php">Today&#39;s Callers</a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/userlist.php">User Listing</a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/dispnet.php">Network Listing</a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/topten.php">Top Ten List</a>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/sysinfo.php">System Statistics</a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        // System news check
                                                        if ($CONFIG['sysnews']) {
                                                            $sysnews = GetSysNewsConfig();
                                                            if ($sysnews != FALSE) {
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/system_news.php">System News</a>
                                                                <?php
                                                                if (($USER['userno'] > 0) &&
                                                                    ($USER['userno'] != $CONFIG['guestacct'])) {
                                                                    $db = GetDbInfo($sysnews['topicno'], $sysnews['db']);               // Get database info.
                                                                    $msgPointer = GetMessagePointer($db, $USER['userno']);              // Get message pointer.
                                                                    if ($msgPointer < $db['msgno']) {
                                                                        print '<img src="images/alert.gif" border="0" alt="Unread system news!" height="11" width="11">';
                                                                        //print '<span class="notify">(!)</span>' . "\n";
                                                                    }
                                                                }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                            }
                                                        }
                                                        ?>
                                                        <?php
                                                        // Edit account option
                                                        if (($USER['userno'] > 0) &&
                                                            ($USER['userno'] != $CONFIG['guestacct'])) {
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="infoBarBody" href="./misc/edituser.php">Edit Your Account</a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        // End Edit account option
                                                        }
                                                        ?>
                                                        <?php
                                                        // VConfig menu option
                                                        if ($USER['securitylevel'] >= 255) {
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="notify" href="vconfig/vconfig.php">VADV-PHP VConfig</a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        // End VConfig menu option
                                                        }
                                                        ?>
                                                        <?php
                                                        // VADV-PHP Log menu option
                                                        if ($USER['securitylevel'] >= 255) {
                                                        ?>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                - <a class="notify" href="misc/displog.php">View VADV-PHP Log</a>
                                                            </td>
                                                        </tr>
                                                        <?php
                                                        // End VADV-PHP Log menu option
                                                        }
                                                        ?>
                                                        <tr>
                                                            <td bgcolor="#FFFFFF" height="5">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarTopic" align="left" bgcolor="#000080">
                                                                Login
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                <p>
                                                                <?php
                                                                if (($USER['userno'] == 0) ||
                                                                    ($USER['userno'] == $CONFIG['guestacct'])) {
                                                                    print 'Login here using your BBS account information! If you do not have an account, ';
                                                                    if ($VA_MAIN['newuserpw'] == md5(strtoupper(''))) {
                                                                        print 'you may <a class="infoBarBody" href="bbsregister.php">create an account</a>.';
                                                                    } else {
                                                                        print 'connect to the BBS to create one.';
                                                                    }
                                                                }
                                                                ?>
                                                                </p>
                                                                <?php
                                                                // Display login box. If it returns false then focus on the username box.
                                                                if (!LoginBox()) {
                                                                    print '<script language="JavaScript" type="text/javascript">' . "\n";
                                                                    print '<!--' . "\n";
                                                                    print 'document.login.username.focus();' . "\n";
                                                                    print '//-->' . "\n";
                                                                    print '</script>' . "\n";
                                                                }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td bgcolor="#FFFFFF" height="5">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarTopic" align="left" bgcolor="#000080">
                                                                Web-Users
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                <p>Here are some of the users currently using this web-bbs!</p>
                                                                <p>
                                                                <?php
                                                                // Get number of guests...
                                                                $totalGuests = 0;
                                                                for ($x = 1; $x <= $VA_USERS[0]; $x++) {
                                                                    if (($VA_USERS[$x]['userno'] == 0) ||
                                                                        ($VA_USERS[$x]['userno'] == $CONFIG['guestacct'])) {
                                                                        $totalGuests++;
                                                                    }
                                                                }
                                                                
                                                                // Display guest information...
                                                                if ($totalGuests > 0) {
                                                                    if ($totalGuests == 1) {
                                                                        print '<span class="boldInfoBar">- Guest</span><br />' . "\n";
                                                                    } else {
                                                                        print '<span class="boldInfoBar">- Guests</span><span class="infoBarBody"> (' . $totalGuests . ")</span><br />\n";
                                                                    }
                                                                }

                                                                $totalUsers = $VA_USERS[0] - $totalGuests;
                                                                $foundUsers = 0;
                                                                // Display up to ten users...
                                                                for ($x = 1; (($foundUsers < $totalUsers) && ($foundUsers <= 10)); $x++) {
                                                                    if (($VA_USERS[$x]['userno'] > 0) &&
                                                                        ($VA_USERS[$x]['userno'] != $CONFIG['guestacct'])) {
                                                                        print '<span class="boldInfoBar">- </span><a class="infoBarBody" href="misc/userinfo.php?u=' . $VA_USERS[$x]['userno'] . '"> ' . HtmlSpace($VA_USERS[$x]['handle']) . "</a><br />\n";
                                                                        $foundUsers++;
                                                                    }
                                                                }
                                                                ?>
                                                                </p>
                                                                <span class="infoBarBody">Total online users: <?php print $VA_USERS[0]; ?></span>
                                                                <?php
                                                                // View webusers option
                                                                if ($USER['securitylevel'] >= 255) {
                                                                ?>
                                                                <br /><br /><a class="infoBarBody" href="./misc/webuserlist.php">View All Web-Users</a>
                                                                <?php
                                                                // End view webusers option
                                                                }
                                                                ?>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td bgcolor="#FFFFFF" height="5">
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarTopic" align="left" bgcolor="#000080">
                                                                Mobile VADV-PHP
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="infoBarBody" align="left">
                                                                This website is enhanced for mobile devices! Just point your web-enabled mobile device to this URL.
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td bgcolor="#FFFFFF" height="100%">
                                                            </td>
                                                        </tr>
                                                    </table>
                                                    </center>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                    </center>
                                </div>
                                <?php GlobalFooter(); ?>
                                <?php print '<p align="center"><span class="boldBody">.: ' . number_format($stats['webhitstotal']) . ' :.</span></p>'; ?>
                            </td>
                        </tr>
                    </table>
                    </center>
                </div>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>