<?php
///////////////////////////////////////////////////////////////////////////////
// VADV-PHP Configuration File (06.05.02)                                    //
// You must edit the settings in this file in order to setup your server     //
// configuration to work with VADV-PHP. Edit ONLY the information between    //
// the single quotations! To set a value as blank, then put nothing between  //
// the two single quotation marks. To set a value as the default, then       //
// comment out that variable.                                                //
//                                                                           //
// This file should be located in your VADV-PHP include directory.           //
//                                                                           //
// Comments can be made by placing // at the beginning of the line.          //
///////////////////////////////////////////////////////////////////////////////


// -- Required VADV-PHP Settings --

// [BBS Telnet Address]
// If your BBS is available to your users by telnet, then place the telnet
// address between the quotes.
// Default = none

$config['telnet'] = '';

// [Hostname]
// If your web server is not on the same computer as your BBS, then on the first
// line, put the computer hostname or IP. If it is on the same computer, then
// leave it blank. You should not set this to an Internet hostname or IP! The
// BBS should be accessible through a local network only.
// Default = none

$config['hostname'] = '';

// [File Hostname]
// Like the hostname above, if your BBS files reside on a computer other than
// the one the BBS is on, you will need to specify an IP address or hostname to
// prefix all paths to that computer. The actual file directory is set below.
// Default = none

$config['filehost'] = '';

// [BBS Directory]
// You must tell the program what directory your BBS lies in on the BBS server.
// Enter the full path to the main BBS directory.
// Default = c:\va

$config['bbsdir'] = 'c:\va';

// [Require System Password]
// If enabled, then when trying to access VConfig scripts, you will be prompted
// for the system password. You must still be logged in with a SysOp account
// to access these scripts. Disable this by setting it to zero (0), or enable it
// by setting it to one (1).
// Default = 1 (on)

$config['syspass'] = '1';

// [WebMaster Email]
// Set this to the email address of the webmaster. If users have any problems,
// they can email this person about the webpages.
// Default = webmaster@

$config['webmaster'] = 'webmaster@';


// -- Default User Settings --

// [Guest Account Number]
// You can setup a guest account on your BBS and use its settings as the ones
// given to guest web users. If this value is set, then the guest settings
// below are NOT used! To turn this off, leave it blank or set to zero.
// Default = 0

$config['guestacct'] = '0';

// [Web User Security Level]
// You should set this to the minimum security level that web users should have.
// This will affect things like access to message areas, file areas or other
// parts of your BBS that they should not have access to. This is not used if you
// have specified a guest account above.
// Default = 15

$config['usersl'] = '15';

// [Web User Access Flags]
// If you would like to give your web users special access flags, then set them
// here. Do not put any spaces in between the flags. Ex: useraccflags=ABC
// This is not used if you have specified a guest account above.
// Default = none

$config['useraccflags'] = '';

// [Web User Age]
// You can set a default age for your web users so they will not have access to
// adult sections defined on your BBS. This is not used if you have specified a
// guest account above.
// Default = 0

$config['userage'] = '0';


// -- Other VADV-PHP Settings --

// [User Account Purge Time]
// You can set the number of days that an account may be idle before it is
// overwritten by a new user. This helps keep the number of inactive accounts
// down. To disable this feature, set it to 0 (zero). Be sure to also set the
// purge security levels or some special accounts may be accidentally erased!
// Default = 0

$config['purgetime'] = '0';

// [Purge Minimum Security Level]
// Working with the purge time, you can set the minimum and maximum security
// levels so special accounts and administrator account can be exempt.
// To disable this feature, set it to 0 (zero). Note: If the purge time or
// the minimum security level is set at zero, then this feature is disabled.
// Default = 0;

$config['purgeminlevel'] = '0';

// [Purge Maximum Security Level]
// The maximum security level to be purged. If set to zero, then the maximum
// limit is set at 254. See above for more information about the purge settings.
// Default = 254;

$config['purgemaxlevel'] = '254';

// [Required New User Information]
// You may specify the required fields a new user must fill out during
// the registration process. This setting is in the form of an integer and is
// derived by adding up the values of the fields you wish to require. The values
// are:
//     Real Name:       1
//     Address:         2
//     City:            4
//     State:           8
//     Zip Code:        16
//     Phone Number:    32
//     Fax/Data Phone:  64
//     Birthday:        128
// Just select the fields you wish to require and add up the values. VADV-PHP
// requires that an username and password be entered, and is not an option.
// Default = 141 (Real Name, City, State, Birthday)

$config['newuserreq'] = '141';

// [Banned Account Numbers]
// You can ban certain user account numbers from being able to login to VADV-PHP.
// This is useful for system accounts, QWK accounts, guest accounts, or just to
// keep unruly users from having full access. To use this, enter the user account
// number inside of the quotes. Separate multiple accounts with a comma.
// Default = ''

$config['banned'] = '';

// [Page Refresh]
// Certain pages can be made to refresh after a number of seconds have expired.
// At this time it is the who's online pages (index.php and who.php). To disable
// set it to zero.
// Default = 0 (Disabled)

$config['refresh'] = '0';

// [Cookie Life]
// You can set the login cookie to remember the user for a certain length of time
// specified in days. You can disable this feature by setting it to zero.
// Default = 7 (one week)

$config['cookielife'] = '7';

// [File Uploads]
// You can enable or disable the ability of users to upload files to the file
// area. If you do not need file upload capability, then it is safer to turn
// it off completely. Please read the VADV-PHP documentation for more about
// file uploads. This does not affect email attachments. To control email
// attachments, you do so by setting the security level allowed in the main
// configuration of VConfig. Disable this by setting it to zero (0), or enable it
// by setting it to one (1).
// Default = 0 (off)

$config['fileupload'] = '0';

// [File Upload Security Level]
// This is the minimum security level that has access to upload files into the
// file area. This has no effect if the file upload option above is disabled.
// Default = 255 (SysOp only)

$config['fileuploadsl'] = 255;

// [SSL Redirect]
// If you also have VADV-PHP available with SSL encryption, then enter the full
// URL to that site. A link will be displayed on the home page for your users
// to access this site instead of using the non encrypted site.
// Default = ''

$config['sslredirect'] = '';

// -- AT2k Script Options --

// [NewsList]
// Enable or disable the AT2k NewsList support. Disable this by setting it to
// zero (0), or enable it by setting it to one (1).
// Default = 1 (on)

$config['newslist'] = '1';

// [Post-It! Network]
// Enable or disable the AT2k Post-It! Network support. Disable this by setting
// it to zero (0), or enable it by setting it to one (1).
// Default = 1 (on)

$config['postitnt'] = '1';

// [System News]
// Enable or disable the AT2k System News support. Disable this by setting it to
// zero (0), or enable it by setting it to one (1).
// Default = 1 (on)

$config['sysnews'] = '1';

?>