<?php
/*
 * ----------------------------------------------------------------------------
 * Va-Upload.inc.php                                                 11/24/2006
 * This script will retrieve all of the informaton related to the configured
 * upload protocols that are found in UPLOAD.CFG.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* Va-Upload.inc.php :: GetUpload()
*
* Retrieve all of the upload protocol information and store it into a
* multidimensional array.
*
* Array format: $upload[1]['setting']
*               $upload[0] = Total number of upload protocols.
*
* @return array
*/
function GetUpload() {
    $fileString = ReadUpload();
    if ($fileString === FALSE) {
        trigger_error(VA_Error(3));
    }

    $upload = array();                      // Create the array.
    $offset = 0;

    for ($x = 1; $offset < strlen($fileString); $x++) {
        $upload[$x]['hotkey']  = GetString($fileString, 1 + $offset, 1);
        $upload[$x]['desc']    = GetString($fileString, 2 + $offset, 23);
        $upload[$x]['batch']   = GetChar($fileString, 25 + $offset);
        $upload[$x]['command'] = GetString($fileString, 26 + $offset, 48);
        $offset = 73 * $x;
    }

    $upload[0] = $x - 1;                    // Put the number of upload protocols in position 0.

    return $upload;                         // Return the upload protocols.

}


/**
* Va-Upload.inc.php :: PutUpload()
*
* This function will change the upload.cfg to match the configuration variable
* passed. It then returns the new file string. The configuration variable MUST
* be in the format of $variable[1]['setting'].
*
* @param string $fileString
* @param array $configVariable
* @return string
*/
function PutUpload($fileString, $configVariable) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }
    if (!is_array($configVariable)) {
        trigger_error(VA_Error(1));
    }

    $length  = count($configVariable);      // Get the number of elements in the config variable.
    $pointer = 0;                           // Reset the pointer.
    $offset  = 0;

    if (isset($configVariable[0])) {
        $length--;
    }

    for ($x = 1; $pointer < $length; $x++) {
        $total = intval(strlen($fileString) / 73);
        if ($x > $total) {
            $fileString = $fileString . str_pad('', 73, chr(0));
        }

        if (isset($configVariable[$x])) {
            $pointer++;
            if (isset($configVariable[$x]['hotkey']))  $fileString = PutString($fileString, $configVariable[$x]['hotkey'], 1 + $offset, 1);
            if (isset($configVariable[$x]['desc']))    $fileString = PutString($fileString, $configVariable[$x]['desc'], 2 + $offset, 23);
            if (isset($configVariable[$x]['batch']))   $fileString = PutChar($fileString, $configVariable[$x]['batch'], 25 + $offset);
            if (isset($configVariable[$x]['command'])) $fileString = PutString($fileString, $configVariable[$x]['command'], 26 + $offset, 48);
        }
        $offset = 73 * $x;
    }

    return $fileString;                     // Return the new file string.
}


/**
* Va-Upload.inc.php :: ReadUpload()
*
* This function will read the upload.cfg file.
*
* @return string
*/
function ReadUpload() {
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/UPLOAD.CFG';
    $fileString = ReadCfgFile($file);       // Read the file.

    return $fileString;                     // Return the file string.
}


/**
* Va-Upload.inc.php :: WriteUpload()
*
* This function will write a new upload.cfg file based on the file string
* passed to it. If the file string is not in the correct format, then your
* upload.cfg file will become corrupt and the BBS could stop functioning!
*
* @param string $fileString
* @return mixed
*/
function WriteUpload($fileString) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }

    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/UPLOAD.CFG';
    $status = WriteCfgFile($file, $fileString);

    return $status;                         // Return the result status.
}


// Retrieve the upload protocols automatically.
$VA_UPLOAD = GetUpload();

?>