<?php
/*
 * ----------------------------------------------------------------------------
 * Va-Main.inc.php                                                   02/13/2006
 * This script will read the main.cfg file and store its information into an
 * array.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* Va-Main.inc.php :: GetMainConfig()
*
* This function will retrieve the information stored in the main.cfg file.
* This file contains all of you general BBS configuration information.
*
* @return array
*/
function GetMainConfig() {
    $fileString = ReadMainConfig();
    if ($fileString === FALSE) {
        trigger_error(VA_Error(3));
    }

    $main = array();
    $main['bbsname']       = GetString($fileString, 1, 40);
    $main['sysopname']     = GetString($fileString, 41, 40);
    $main['timeout']       = GetLongInt($fileString, 81);
    $main['phoneformat']   = GetString($fileString, 85, 24);
    $main['sblank']        = GetInteger($fileString, 134);
    $main['dailydate']     = GetString($fileString, 136, 6);
    $main['reservekb']     = GetInteger($fileString, 142);
    $main['timezone']      = GetString($fileString, 144, 12);
    $main['creditcost']    = GetInteger($fileString, 156);
    $main['allowhandle']   = GetInteger($fileString, 158);
    $main['allowremote']   = GetInteger($fileString, 160);
    // New user password is encrypted with md5 for security purposes.
    $main['newuserpw']     = md5(strtoupper(GetString($fileString, 162, 8)));
    // System password is encrypted with md5 for security purposes.
    $main['systempw']      = md5(strtoupper(GetString($fileString, 170, 16)));
    $main['nucredits']     = GetInteger($fileString, 204);
    $main['wfcdrives']     = GetString($fileString, 206, 5);
    $main['maxchannelno']  = GetInteger($fileString, 211);
    $main['netlowtime']    = GetString($fileString, 213, 5);
    $main['nethightime']   = GetString($fileString, 218, 5);
    $main['redials']       = GetInteger($fileString, 223);
    $main['polldelay']     = GetInteger($fileString, 225);
    $main['dialstring']    = GetString($fileString, 227, 12);
    $main['autopostsl']    = GetInteger($fileString, 239);
    $main['emlothers']     = GetInteger($fileString, 241);
    $main['emlsysfile']    = GetInteger($fileString, 243);
    $main['emlotherfile']  = GetInteger($fileString, 245);
    $main['multimail']     = GetInteger($fileString, 247);
    $main['carboncopy']    = GetInteger($fileString, 249);
    $main['fileratio']     = GetSingle($fileString, 251, 2);
    $main['uplev']         = GetString($fileString, 255, 34);
    $main['autosysopsl']   = GetInteger($fileString, 289);
    $main['autosysoptime'] = GetInteger($fileString, 291);
    $main['qwklimit']      = GetInteger($fileString, 293);
    $main['needwfcpw']     = GetInteger($fileString, 295);
    $main['mailholdtime']  = GetInteger($fileString, 297);
    $main['newusersl']     = GetInteger($fileString, 299);
    $main['newusertime']   = GetInteger($fileString, 301);
    $main['startscript']   = GetString($fileString, 303, 12);
    $main['maxtimebank']   = GetInteger($fileString, 315);
    $main['logdetail']     = GetInteger($fileString, 317);
    $main['qwkfilename']   = GetString($fileString, 319, 6);
    $main['forcefilename'] = GetInteger($fileString, 325);
    $main['inversebar']    = GetInteger($fileString, 327);
    $main['displaynet']    = GetInteger($fileString, 329);
    $main['logoffbat']     = GetInteger($fileString, 331);
    $main['ringtoanswer']  = GetInteger($fileString, 333);
    $main['forcefeedback'] = GetInteger($fileString, 337);
    $main['uploadscan']    = GetInteger($fileString, 339);
    $main['modemtest']     = GetInteger($fileString, 341);
    $main['cbvsl']         = GetInteger($fileString, 343);
    $main['cbvtime']       = GetInteger($fileString, 345);
    $main['checkpolls']    = GetInteger($fileString, 347);
    $main['directmail']    = GetInteger($fileString, 349);
    $main['credperpost']   = GetInteger($fileString, 351);
    $main['credperuplk']   = GetInteger($fileString, 353);
    $main['credperdlk']    = GetInteger($fileString, 355);
    $main['multitasker']   = GetInteger($fileString, 357);
    $main['secuploads']    = GetInteger($fileString, 359);
    $main['detectfido']    = GetInteger($fileString, 361);
    $main['vcbkground']    = GetInteger($fileString, 363);
    $main['vcfrground']    = GetInteger($fileString, 365);
    $main['ignoreext']     = GetInteger($fileString, 367);
    $main['tossopt']       = GetInteger($fileString, 369);
    $main['sysfkey']       = GetInteger($fileString, 371);

    return $main;                           // Return the main configuration.
}


/**
* Va-Main.inc.php :: PutMainConfig()
*
* This function will write a new file string based on the configuration variable
* passed to it. The new file string can be used to create a new configuration
* file, but you must be careful that the configuration variable is valid.
*
* @param string $fileString
* @param array $configVariable
* @return string
*/
function PutMainConfig($fileString, $configVariable) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }
    if (!is_array($configVariable)) {
        trigger_error(VA_Error(1));
    }

    if (isset($configVariable['bbsname']))       $fileString = PutString($fileString, $configVariable['bbsname'], 1, 40);
    if (isset($configVariable['sysopname']))     $fileString = PutString($fileString, $configVariable['sysopname'], 41, 40);
    if (isset($configVariable['timeout']))       $fileString = PutLongInt($fileString, $configVariable['timeout'], 81);
    if (isset($configVariable['phoneformat']))   $fileString = PutString($fileString, $configVariable['phoneformat'], 85, 24);
    if (isset($configVariable['sblank']))        $fileString = PutInteger($fileString, $configVariable['sblank'], 134);
    if (isset($configVariable['dailydate']))     $fileString = PutString($fileString, $configVariable['dailydate'], 136, 6);
    if (isset($configVariable['reservekb']))     $fileString = PutInteger($fileString, $configVariable['reservekb'], 142);
    if (isset($configVariable['timezone']))      $fileString = PutString($fileString, $configVariable['timezone'], 144, 12);
    if (isset($configVariable['creditcost']))    $fileString = PutInteger($fileString, $configVariable['creditcost'], 156);
    if (isset($configVariable['allowhandle']))   $fileString = PutInteger($fileString, $configVariable['allowhandle'], 158);
    if (isset($configVariable['allowremote']))   $fileString = PutInteger($fileString, $configVariable['allowremote'], 160);
    // To change the passwords, they must be in plain text.
    // If it is encrypted with md5, then it has a length of 32 characters and will not write it.
    if ((isset($configVariable['newuserpw'])) &&
        (strlen($configVariable['newuserpw']) <= 8))
                                                 $fileString = PutString($fileString, $configVariable['newuserpw'], 162, 8);
    // The system password is disabled for writing. There is no good reason to allow writing of this password.
//    if (isset($configVariable['systempw']))      $fileString = PutString($fileString, $configVariable['systempw'], 170, 16);
    if (isset($configVariable['nucredits']))     $fileString = PutInteger($fileString, $configVariable['nucredits'], 204);
    if (isset($configVariable['wfcdrives']))     $fileString = PutString($fileString, strtoupper($configVariable['wfcdrives']), 206, 5);
    if (isset($configVariable['maxchannelno']))  $fileString = PutInteger($fileString, $configVariable['maxchannelno'], 211);
    if (isset($configVariable['netlowtime']))    $fileString = PutString($fileString, $configVariable['netlowtime'], 213, 5);
    if (isset($configVariable['nethightime']))   $fileString = PutString($fileString, $configVariable['nethightime'], 218, 5);
    if (isset($configVariable['redials']))       $fileString = PutInteger($fileString, $configVariable['redials'], 223);
    if (isset($configVariable['polldelay']))     $fileString = PutInteger($fileString, $configVariable['polldelay'], 225);
    if (isset($configVariable['dialstring']))    $fileString = PutString($fileString, $configVariable['dialstring'], 227, 12);
    if (isset($configVariable['autopostsl']))    $fileString = PutInteger($fileString, $configVariable['autopostsl'], 239);
    if (isset($configVariable['emlothers']))     $fileString = PutInteger($fileString, $configVariable['emlothers'], 241);
    if (isset($configVariable['emlsysfile']))    $fileString = PutInteger($fileString, $configVariable['emlsysfile'], 243);
    if (isset($configVariable['emlotherfile']))  $fileString = PutInteger($fileString, $configVariable['emlotherfile'], 245);
    if (isset($configVariable['multimail']))     $fileString = PutInteger($fileString, $configVariable['multimail'], 247);
    if (isset($configVariable['carboncopy']))    $fileString = PutInteger($fileString, $configVariable['carboncopy'], 249);
//    if (isset($configVariable['fileratio']))     $fileString = PutSingle($fileString, $configVariable['fileratio'], 251);
    if (isset($configVariable['uplev']))         $fileString = PutString($fileString, $configVariable['uplev'], 255, 34);
    if (isset($configVariable['autosysopsl']))   $fileString = PutInteger($fileString, $configVariable['autosysopsl'], 289);
    if (isset($configVariable['autosysoptime'])) $fileString = PutInteger($fileString, $configVariable['autosysoptime'], 291);
    if (isset($configVariable['qwklimit']))      $fileString = PutInteger($fileString, $configVariable['qwklimit'], 293);
    if (isset($configVariable['needwfcpw']))     $fileString = PutInteger($fileString, $configVariable['needwfcpw'], 295);
    if (isset($configVariable['mailholdtime']))  $fileString = PutInteger($fileString, $configVariable['mailholdtime'], 297);
    if (isset($configVariable['newusersl']))     $fileString = PutInteger($fileString, $configVariable['newusersl'], 299);
    if (isset($configVariable['newusertime']))   $fileString = PutInteger($fileString, $configVariable['newusertime'], 301);
    if (isset($configVariable['startscript']))   $fileString = PutString($fileString, $configVariable['startscript'], 303, 12);
    if (isset($configVariable['maxtimebank']))   $fileString = PutInteger($fileString, $configVariable['maxtimebank'], 315);
    if (isset($configVariable['logdetail']))     $fileString = PutInteger($fileString, $configVariable['logdetail'], 317);
    if (isset($configVariable['qwkfilename']))   $fileString = PutString($fileString, $configVariable['qwkfilename'], 319, 6);
    if (isset($configVariable['forcefilename'])) $fileString = PutInteger($fileString, $configVariable['forcefilename'], 325);
    if (isset($configVariable['inversebar']))    $fileString = PutInteger($fileString, $configVariable['inversebar'], 327);
    if (isset($configVariable['displaynet']))    $fileString = PutInteger($fileString, $configVariable['displaynet'], 329);
    if (isset($configVariable['logoffbat']))     $fileString = PutInteger($fileString, $configVariable['logoffbat'], 331);
    if (isset($configVariable['ringtoanswer']))  $fileString = PutInteger($fileString, $configVariable['ringtoanswer'], 333);
    if (isset($configVariable['forcefeedback'])) $fileString = PutInteger($fileString, $configVariable['forcefeedback'], 337);
    if (isset($configVariable['uploadscan']))    $fileString = PutInteger($fileString, $configVariable['uploadscan'], 339);
    if (isset($configVariable['modemtest']))     $fileString = PutInteger($fileString, $configVariable['modemtest'], 341);
    if (isset($configVariable['cbvsl']))         $fileString = PutInteger($fileString, $configVariable['cbvsl'], 343);
    if (isset($configVariable['cbvtime']))       $fileString = PutInteger($fileString, $configVariable['cbvtime'], 345);
    if (isset($configVariable['checkpolls']))    $fileString = PutInteger($fileString, $configVariable['checkpolls'], 347);
    if (isset($configVariable['directmail']))    $fileString = PutInteger($fileString, $configVariable['directmail'], 349);
    if (isset($configVariable['credperpost']))   $fileString = PutInteger($fileString, $configVariable['credperpost'], 351);
    if (isset($configVariable['credperuplk']))   $fileString = PutInteger($fileString, $configVariable['credperuplk'], 353);
    if (isset($configVariable['credperdlk']))    $fileString = PutInteger($fileString, $configVariable['credperdlk'], 355);
    if (isset($configVariable['multitasker']))   $fileString = PutInteger($fileString, $configVariable['multitasker'], 357);
    if (isset($configVariable['secuploads']))    $fileString = PutInteger($fileString, $configVariable['secuploads'], 359);
    if (isset($configVariable['detectfido']))    $fileString = PutInteger($fileString, $configVariable['detectfido'], 361);
    if (isset($configVariable['vcbkground']))    $fileString = PutInteger($fileString, $configVariable['vcbkground'], 363);
    if (isset($configVariable['vcfrground']))    $fileString = PutInteger($fileString, $configVariable['vcfrground'], 365);
    if (isset($configVariable['ignoreext']))     $fileString = PutInteger($fileString, $configVariable['ignoreext'], 367);
    if (isset($configVariable['tossopt']))       $fileString = PutInteger($fileString, $configVariable['tossopt'], 369);
    if (isset($configVariable['sysfkey']))       $fileString = PutInteger($fileString, $configVariable['sysfkey'], 371);

    return $fileString;                     // Return the new file string.
}


/**
* Va-Main.inc.php :: ReadMainConfig()
*
* This function will read the main.cfg file.
*
* @return string
*/
function ReadMainConfig() {
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/MAIN.CFG';
    $fileString = ReadCfgFile($file);       // Read the file.

    return $fileString;                     // Return the file string.
}


/**
* Va-Main.inc.php :: WriteMainConfig()
*
* This function will write a new main.cfg file based on the file string passed
* to it. If the file string is not in the correct format, then your main.cfg
* file will become corrupt and the BBS could stop functioning!
*
* @param string $fileString
* @return mixed
*/
function WriteMainConfig($fileString) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }
    
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/MAIN.CFG';
    $status = WriteCfgFile($file, $fileString);
    
    return $status;                         // Return the result status.
}


// Load all of the main.cfg variables automatically.
$VA_MAIN = GetMainConfig();

?>