<?php
/*
 * ----------------------------------------------------------------------------
 * Va-Colors.inc.php                                                 09/01/2004
 * This script will retrieve all of the informaton related to the configured
 * colors that are found in COLOR.CFG.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.


/**
* Va-Colors.inc.php :: GetColors()
*
* Retrieve all of the color information and store it into a multidimensional
* array.
*
* Array format: $color[1]['setting']
*
* @return array
*/
function GetColors() {
    $fileString = ReadColors();
    if ($fileString === FALSE) {
        trigger_error(VA_Error(3));
    }

    $colors = array();                      // Create the array.
    $offset = 0;
    $y = 0;

    for ($x = 1; $offset < strlen($fileString); $x++) {
        if ($y > 8) {
            if ($y == 9) {
                $y = 65;
            } else {
                $y++;
            }
            $z = chr($y);
        } else {
            $y++;
            $z = $y;
        }
        $colors[$z]['intensity']  = GetInteger($fileString, 1 + $offset);
        $colors[$z]['foreground'] = GetInteger($fileString, 3 + $offset);
        $colors[$z]['background'] = GetInteger($fileString, 5 + $offset);
        $offset = 6 * $x;
    }

    return $colors;                          // Return the doors.

}


/**
* Va-Colors.inc.php :: PutColors()
*
* This function will change the color.cfg to match the configuration variable
* passed. It then returns the new file string. The configuration variable MUST
* be in the format of $variable[1]['setting'].
*
* @param string $fileString
* @param array $configVariable
* @return string
*/
function PutColors($fileString, $configVariable) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }
    if (!is_array($configVariable)) {
        trigger_error(VA_Error(1));
    }

    $length  = count($configVariable);      // Get the number of elements in the config variable.
    $pointer = 0;                           // Reset the pointer.
    $offset  = 0;
    $y = 0;

    for ($x = 1; $pointer < $length; $x++) {
        $total = intval(strlen($fileString) / 6);
        if ($x > $total) {
            $fileString = $fileString . str_pad('', 6, chr(0));
        }
        
        if ($y > 8) {
            if ($y == 9) {
                $y = 65;
            } else {
                $y++;
            }
            $z = chr($y);
        } else {
            $y++;
            $z = $y;
        }

        if (isset($configVariable[$z])) {
            $pointer++;
            if (isset($configVariable[$z]['intensity']))  $fileString = PutInteger($fileString, $configVariable[$z]['intensity'], 1 + $offset);
            if (isset($configVariable[$z]['foreground'])) $fileString = PutInteger($fileString, $configVariable[$z]['foregournd'], 3 + $offset);
            if (isset($configVariable[$z]['background'])) $fileString = PutInteger($fileString, $configVariable[$z]['background'], 5 + $offset);
        }
        $offset = 6 * $x;
    }

    return $fileString;                     // Return the new file string.
}


/**
* Va-Colors.inc.php :: ReadColors()
*
* This function will read the color.cfg file.
*
* @return string
*/
function ReadColors() {
    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/COLOR.CFG';
    $fileString = ReadCfgFile($file);       // Read the file.

    return $fileString;                     // Return the file string.
}


/**
* Va-Colors.inc.php :: WriteColors()
*
* This function will write a new color.cfg file based on the file string
* passed to it. If the file string is not in the correct format, then your
* color.cfg file will become corrupt and the BBS could stop functioning!
*
* @param string $fileString
* @return mixed
*/
function WriteColors($fileString) {
    if (!is_string($fileString)) {
        $fileString = (string) $fileString;
    }

    global $VA_SYSPATHS;                    // Include the global variable.

    // Set the filename.
    $file = $VA_SYSPATHS['main'] . '/COLOR.CFG';
    $status = WriteCfgFile($file, $fileString);

    return $status;                         // Return the result status.
}


// Retrieve the doors automatically.
$VA_COLORS = GetColors();

?>