<?php
/*
 * ----------------------------------------------------------------------------
 * VConfig_VADV-PHP_Help.php                                         10/14/2006
 * VADV-PHP Configuration Help File
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'SysOp Function';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>VADV-PHP VConfig Help</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="HELP.css">
</head>

<body class="body" align="left" bgcolor="#000000">
<a name="telnet" />
<p>
    <span style="color: #FFFFFF"><b>BBS Telnet Address</b></span>
    <br />
    If your BBS is available to your users by telnet, then place the telnet
    address in this field.
    <br />
    Default = none
</p>

<a name="hostname" />
<p>
    <span style="color: #FFFFFF"><b>Hostname</b></span>
    <br />
    If your web server is not on the same computer as your BBS, then
    put the computer hostname or IP. If it is on the same computer, then
    leave it blank. You should not set this to an Internet hostname or IP! The
    BBS should be accessible through a local network only.
    <br />
    Default = none
</p>

<a name="filehost" />
<p>
    <span style="color: #FFFFFF"><b>File Hostname</b></span>
    <br />
    Like the hostname above, if your BBS files reside on a computer other than
    the one the BBS is on, you will need to specify an IP address or hostname to
    prefix all paths to that computer. The actual file directory is set below.
    <br />
    Default = none
</p>

<a name="bbsdir" />
<p>
    <span style="color: #FFFFFF"><b>BBS Directory</b></span>
    <br />
    You must tell the program what directory your BBS lies in on the BBS server.
    Enter the full path to the main BBS directory.
    <br />
    Default = c:\va
</p>

<a name="syspass" />
<p>
    <span style="color: #FFFFFF"><b>Required System Password</b></span>
    <br />
    If enabled, then when trying to access VConfig scripts, you will be prompted
    for the system password. You must still be logged in with a SysOp account
    to access these scripts. Disable this by setting it to zero (0), or enable
    it by setting it to one (1).
    <br />
    Default = 1 (on)
</p>

<a name="webmaster" />
<p>
    <span style="color: #FFFFFF"><b>Webmaster Email</b></span>
    <br />
    Set this to the email address of the webmaster. If users have any problems,
    they can email this person.
    <br />
    Default = webmaster@
</p>

<a name="guestacct" />
<p>
    <span style="color: #FFFFFF"><b>Guest Account Number (Optional)</b></span>
    <br />
    You can setup a guest account on your BBS and use its settings as the ones
    given to guest web users. If this value is set, then the guest settings
    below are NOT used! To turn this off, leave it blank or set to zero.
    <br />
    Default = 0
</p>

<a name="usersl" />
<p>
    <span style="color: #FFFFFF"><b>Web User Security Level</b></span>
    <br />
    You should set this to the security level that web users should have. This
    will affect things like access to message areas, file areas or other parts
    of your BBS that they should not have access to. This is not used if you
    have specified a guest account above.
    <br />
    Default = 15
</p>

<a name="useraccflags" />
<p>
    <span style="color: #FFFFFF"><b>Web User Access Flags</b></span>
    <br />
    If you would like to give your web users special access flags, then set them
    here. Do not put any spaces in between the flags. Ex: useraccflags=ABC. This
    is not used if you have specified a guest account above.
    <br />
    Default = none
</p>

<a name="userage" />
<p>
    <span style="color: #FFFFFF"><b>Web User Age</b></span>
    <br />
    You can set a default age for your web users so they will not have access to
    adult sections defined on your BBS. This is not used if you have specified
    a guest account above.
    <br />
    Default = 0
</p>

<a name="purgetime" />
<p>
    <span style="color: #FFFFFF"><b>User Account Purge Time</b></span>
    <br />
    You can set the number of days that an account may be idle before it is
    overwritten by a new user. This helps keep the number of inactive accounts
    down. To disable this feature, set it to 0 (zero).
    <br />
    Default = 0
</p>

<a name="purgeminlevel" />
<p>
    <span style="color: #FFFFFF"><b>Purge Minimum Security Level</b></span>
    <br />
    Working with the purge time, you can set the minimum and maximum security
    levels so special accounts and administrator account can be exempt.
    To disable this feature, set it to 0 (zero). Note: If the purge time or
    the minimum security level is set at zero, then this feature is disabled.
    <br />
    Default = 0
</p>

<a name="purgemaxlevel" />
<p>
    <span style="color: #FFFFFF"><b>Purge Maximum Security Level</b></span>
    <br />
    The maximum security level to be purged. If set to zero, then the maximum
    limit is set at 254. See above for more information about the purge settings.
    <br />
    Default = 0
</p>

<a name="newuserreq" />
<p>
    <span style="color: #FFFFFF"><b>Required New User Information</b></span>
    <br />
    You may specify the required fields a new user must fill out during
    the registration process. This setting is in the form of an integer and is
    derived by adding up the values of the fields you wish to require. The values
    are:
    <br />
    &nbsp;&nbsp;Real Name:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;1<br />
    &nbsp;&nbsp;Address:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;2<br />
    &nbsp;&nbsp;City:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;4<br />
    &nbsp;&nbsp;State:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;8<br />
    &nbsp;&nbsp;Zip Code:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;16<br />
    &nbsp;&nbsp;Phone Number:&nbsp;&nbsp;&nbsp;&nbsp;32<br />
    &nbsp;&nbsp;Fax/Data Phone:&nbsp;&nbsp;64<br />
    &nbsp;&nbsp;Birthday:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;128<br />
    Just select the fields you wish to require and add up the values. VADV-PHP
    requires that an username and password be entered, and is not an option.
    <br />
    Default = 141 (Real Name, City, State, Birthday)
</p>

<a name="banned" />
<p>
    <span style="color: #FFFFFF"><b>Banned Account Numbers</b></span>
    <br />
    You can ban certain user account numbers from being able to login to VADV-PHP.
    This is useful for system accounts, QWK accounts, guest accounts, or just to
    keep unruly users from having full access. To use this, enter the user account
    number in the field. Separate multiple accounts to be banned with a comma.
    <br />
    Default = none
</p>

<a name="refresh" />
<p>
    <span style="color: #FFFFFF"><b>Page Refresh</b></span>
    <br />
    Certain pages can be made to refresh after a number of seconds have expired.
    At this time it is the who's online pages (index.php and who.php). To disable
    set it to zero.
    <br />
    Default = 0 (Disabled)
</p>

<a name="cookielife" />
<p>
    <span style="color: #FFFFFF"><b>Cookie Life</b></span>
    <br />
    You can set the login cookie to remember the user for a certain length of time
    specified in days. You can disable this feature by setting it to zero.
    <br />
    Default = 7 (one week)
</p>

<a name="fileupload" />
<p>
    <span style="color: #FFFFFF"><b>File Uploads</b></span>
    <br />
    You can enable or disable the ability of users to upload files to the file
    area. If you do not need file upload capability, then it is safer to turn
    it off completely. Please read the VADV-PHP documentation for more about
    file uploads. This does not affect email attachments. To control email
    attachments, you do so by setting the security level allowed in the main
    configuration of VConfig. Disable this by setting it to zero (0), or enable
    it by setting it to one (1).
    <br />
    Default = 0
</p>

<a name="fileuploadsl" />
<p>
    <span style="color: #FFFFFF"><b>File Upload Security Level</b></span>
    <br />
    This is the minimum security level that has access to upload files into the
    file area. This has no effect if the file upload option above is disabled.
    <br />
    Default = 255 (SysOp only)
</p>

<a name="sslredirect" />
<p>
    <span style="color: #FFFFFF"><b>SSL Redirect</b></span>
    <br />
    If you also have VADV-PHP available with SSL encryption, then enter the full
    URL to that site. A link will be displayed on the home page for your users
    to access this site instead of using the non encrypted site.
    <br />
    Default = ''
</p>

<a name="newslist" />
<p>
    <span style="color: #FFFFFF"><b>NewsList Support</b></span>
    <br />
    Enable or disable the AT2k NewsList support. Disable this by setting it to
    zero (0), or enable it by setting it to one (1).
    <br />
    Default = 1
</p>

<a name="postitnt" />
<p>
    <span style="color: #FFFFFF"><b>Post-It! Network Support</b></span>
    <br />
    Enable or disable the AT2k Post-It! Network support. Disable this by setting
    it to zero (0), or enable it by setting it to one (1).
    <br />
    Default = 1
</p>

<a name="sysnews" />
<p>
    <span style="color: #FFFFFF"><b>System News Support</b></span>
    <br />
    Enable or disable the AT2k System News support. Disable this by setting it
    to zero (0), or enable it by setting it to one (1).
    <br />
    Default = 1
</p>
</body>

</html>