<?php
/*
 * ----------------------------------------------------------------------------
 * Upload_Help.php                                                   10/14/2006
 * Upload Help File
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2005 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Uploading a File';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>Upload Help</title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<link rel="stylesheet" type="text/css" href="HELP.css">
</head>

<body class="body" align="left" bgcolor="#000000">
<a name="post" />
<p>
    <span style="color: #FFFFFF"><b>Uploading a File</b></span>
    <br />
    To upload a file to the system follow these easy steps:
    <br /><br />
    You must first enter the filename of the file that you wish to send. You
    can either type in the full path to the file, or you can click the Browse
    button to search your hard drive for the file. When you have found the file,
    click Ok, and the path to the file will be automatically entered for you.
    <br /><br />
    Next you must give a description of the file that you are about to send.
    This description should be brief, but explains what the file is. If it
    contains a program, then give the program's name and a short description of
    what the program does.
    <br /><br />
    The long description is where you can go into more detail about the file.
    If the file is compressed and contains a FILE_ID.DIZ file, then you may
    want to copy and paste the contents of that file into the long description
    field.
    <br /><br />
    When you are completed and ready to upload, just click the Submit button.
    Depending on the file size, it could take a moment for the file to be sent.
    If an error occurs, you will be notified.
</p>
</body>

</html>