<?php
/*
 * ----------------------------------------------------------------------------
 * SentEmail-ViewMsg.php                                             06/28/2006
 * This script will display the selected sent email message to the user.
 * The variable $m is passed to the script to set the message number.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Reading Email';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration variable.
require_once($includeDir . 'va-userfile.inc.php');  // Include user functions.
require_once($includeDir . 'va-networks.inc.php');  // Include network information.
require_once($includeDir . 'vadv-php_dat.inc.php'); // Include user settings.
require_once('layout_email.inc.php');               // Webpage header and footer.

$VA_NETWORKS = GetNetworkInfo();            // Get network information.

if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] == 0)) {
    die(VA_LoginError());
}

$userno = $USER['userno'];

if (isset($_GET['ansi'])) {                 // Set the passed variables.
    $ansi = (integer) $_GET['ansi'];
} else {
    $ansi = 0;
}

if (isset($_GET['color'])) {                // Set the passed variables.
    $color = (integer) $_GET['color'];
} else {
    $color = 0;
}

if (isset($_GET['html'])) {                 // Set the passed variables.
    $html = (integer) $_GET['html'];
} else {
    $html = 0;
}

if (isset($_GET['routing'])) {              // Set the passed variable.
    $routing = (integer) $_GET['routing'];
} else {
    $routing = 0;
}

$db = SetSentEmailInfo($userno);            // Retrieve the database information.

$msgno  = $db['msgno'];                     // Retrieve the number of messages.
if ($msgno == 0) {
    die('<br /><h4>Invalid message. Please press the BACK button on your browser.</h4>');
}
if ($USER_SETTINGS['hidedeleted'] == 1) {
    $msgstat = GetSentEmailCount($userno, 0);   // Retrieve the number of user messages.
} else {
    $msgstat = GetSentEmailCount($userno);
}
$msgcnt  = $msgstat['msgno'];
if ($msgcnt == 0) {
    die('<br /><h4>Invalid message. Please press the BACK button on your browser.</h4>');
}

if (isset($_GET['m'])) {                    // Set the passed variables.
    $m = (integer) $_GET['m'];
} else {
    $m = $msgcnt;
}
if ($m > $msgcnt) {
    $m = $msgcnt;
}
if ($m <= 0) {
    $m = 1;
}

$msgInfo = GetMessageInfo($db, $msgstat[$m - 1]);         // Get the message information.
if ($msgInfo['fromuserno'] != $userno) {
    die('<br /><h4>You do not have access to this message. Press the BACK button on your browser.</h4>');
}

// Check for delete message flag.
if (isset($_GET['delete'])) {
    if ($_GET['delete'] == 1) {
        /*
        // If an attached file, then delete it. Non-reversible!
        if ($msgInfo['attfilename'] != '') {
            if ($CONFIG['hostname'] != '') {
                $file = ConvertDir($CONFIG['hostname'], $db['filepath']) . '/' . $msgInfo['attfilename'];
            } else {
                $file = $db['filepath'] . '/' . $msgInfo['attfilename'];
            }

            if ($msgInfo['attfilepath'] == '') {
                if (is_file($file)) {
                    unlink($file);
                }
            } else {
                if ($CONFIG['hostname'] != '') {
                    $userDir = ConvertUnc($VA_SYSPATHS['sysop'] . '/' . $USER['userno'] . '/' . $msgInfo['attfilename']);
                } else {
                    $userDir = $VA_SYSPATHS['sysop'] . '/' . $USER['userno'] . '/' . $msgInfo['attfilename'];
                }
                if ($msgInfo['attfilepath'] == $userDir) {
                    if ($CONFIG['hostname'] != '') {
                        $file = ConvertDir($CONFIG['hostname'], $msgInfo['attfilepath']);
                    } else {
                        $file = $msgInfo['attfilepath'];
                    }
                }
                if (is_file($file)) {
                    unlink($file);
                }
            }
            $msgInfo['attfilesize'] = 0;
            $msgInfo['attfilename'] = '';
            $msgInfo['attfilepath'] = '';
        }
        */
        // $msgInfo['deleted'] = 1;
        // WriteMessageInfo($db, $msgstat[$m - 1], $msgInfo);
        // Until this database is added to vcleandb, all messages are permanently
        // deleted if you uncomment this next line.
        DeleteMessage($db, $msgstat[$m - 1]);
        RedirectUser('sentemail-dispmsg.php');
    } else if ($_GET['delete'] == 0) {
        $msgInfo['deleted'] = 0;
        WriteMessageInfo($db, $msgstat[$m - 1], $msgInfo);
    }
}

EmailHeader();                              // Display the webpage header.
?>

<script language="JavaScript" type="text/javascript">
<!--
    function MessageInfo(t, d, m) {
        var url = "msginfo.php?t=" + t + "&d=" + d + "&m=" + m;
        var newwindow = window.open(url, "messageinfo", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, width=620, height=210");
        newwindow.focus();
    }
//-->
</script>

<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 1) {
    $num = $m - 1;
    print '<a class="msgBack" href="sentemail-viewmsg.php?m=' . $num . '">Previous Email</a> |' . "\n";
}

if ($m < $msgcnt) {
    $num = $m + 1;
    print '<a class="msgBack" href="sentemail-viewmsg.php?m=' . $num . '">Next Email</a> |' . "\n";
}

if ($m >= $msgcnt - 25) {
    print '<a class="msgBack" href="sentemail-dispmsg.php">Back to ' . HtmlSpace($db['desc']) . '</a></td>' . "\n";
} else if ($m <= 25) {
    print '<a class="msgBack" href="sentemail-dispmsg.php?m=25">Back to ' . HtmlSpace($db['desc']) . '</a></td>' . "\n";
} else {
    print '<a class="msgBack" href="sentemail-dispmsg.php?m=' . $m . '">Back to ' . HtmlSpace($db['desc']) . '</a></td>' . "\n";
}
?>

        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>
<table border="1" width="750" cellspacing="0" cellpadding="2" bordercolor="#666666" style="border-collapse: collapse">
    <tr>
        <td colspan="5" bgcolor="#416DBF" height="33">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td align="left" width="100%">
                        <span class="msgTitle">&nbsp;&nbsp;<?php print HtmlSpace(htmlspecialchars($db['desc'])) . '&nbsp;&nbsp;-&nbsp;&nbsp;(' . $m . '&nbsp;/&nbsp;' . $msgcnt . ')'; ?></span></td>
                    <?php if (($USER['userno'] > 0) && ($USER['userno'] != $CONFIG['guestacct']) && ($USER['securitylevel'] >= $VA_MAIN['emlothers'])) { ?>
                    <form action="post-email.php" name="post" method="POST">
                        <td align="right">
                            <input type="hidden" name="referer" value="<?php print GetCurrentURL(); ?>">
                            <input type="hidden" name="reply" value="0">
                            <input type="image" name="submit" src="<?php print $rootDir; ?>images/email.gif" border="0" alt="Send a New Email" width="90" height="25">
                        </td>
                    </form>
                    <?php } ?>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td class="msgHeader" width="30" height="15" bgcolor="#000080"></td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="left">&nbsp;From&nbsp;</td>
        <td class="msgHeader" width="100" height="15" bgcolor="#000080" align="left">&nbsp;To&nbsp;</td>
        <td class="msgHeader" width="370" height="15" bgcolor="#000080" align="left">&nbsp;Subject&nbsp;</td>
        <td class="msgHeader" width="150" height="15" bgcolor="#000080" align="center">&nbsp;Date/Time&nbsp;</td>
    </tr>

<?php

$dateTime = ConvertDateTime($msgInfo['creation'], 'F j, Y');

// Check for any files.
if ($msgInfo['attfilename'] != '') {
    if ($msgInfo['attfilepath'] != '') {    // If a local attachment.
        $filepath = str_replace('/', "\\", $msgInfo['attfilepath']);
        $pos = strrpos($filepath, "\\");
        $filepath = substr($filepath, 0, $pos);
    } else {
        $filepath = $db['filepath'];
    }
    if ($CONFIG['filehost'] != '') {
        $file = ConvertDir($CONFIG['hostname'], $filepath) . '/' . $msgInfo['attfilename'];
    } else {
        $file = $filepath . '/' . $msgInfo['attfilename'];
    }
} else {
    $file = '';
}

if ($file != '') {
    if (!is_file($file)) {
        $filesize = '0 bytes';
    } else {
        $filesize = filesize($file);
        if ($filesize >= 1073741824) {
            $filesize = round($filesize / 1073741824, 1) . 'GB';
        } else if ($filesize >= 1048576) {
            $filesize = round($filesize / 1048576, 1) . 'MB';
        } else if ($filesize >= 1024) {
            $filesize = intval($filesize / 1024) . 'KB';
        } else {
            $filesize = $filesize . ' bytes';
        }
    }
}

$from = $msgInfo['fromhandle'];
$char = substr($from, 0, 1);
if ($char == '<') {
    $from = substr($from, 1);
}
if ($char == '"') {
    $pos = strpos($from, '"', 1);
    $from = substr($from, 1, $pos - 1);
}
$from = trim(htmlspecialchars($from));

if ($msgInfo['subject'] == '') {
    $subject = '(No Subject)';
} else {
    $subject = htmlspecialchars(StripANSICodes(StripBBSCodes($msgInfo['subject'])));
}

$to = $msgInfo['tohandle'];
$char = substr($to, 0, 1);
if ($char == '<') {
    $to = substr($to, 1);
}
if ($char == '"') {
    $pos = strpos($to, '"', 1);
    $to = substr($to, 1, $pos - 1);
}
$to = trim(htmlspecialchars($to));
?>

    <tr>
        <td width="30" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <img border="0" <?php
                            if ($msgInfo['deleted'] == 0) {
                                print 'src="' . $rootDir . 'images/message.gif" alt="Message"';
                            } else {
                                print 'src="' . $rootDir . 'images/message-deleted.gif" alt="Message Marked for Deletion"';
                            }
                            ?> width="11" height="11"><?php
                                                      if ($msgInfo['attfilename'] != '') {
                                                          print '<img border="0" src="' . $rootDir . 'images/paperclip.gif" alt="Attached File" width="11" height="11">';
                                                      }
                                                      ?></td>
        <td width="100" height="30" align="left" nowrap>
            <span class="boldBody">&nbsp;<?php
                                         if (($msgInfo['fromnetid'] == 1) &&
                                             ($msgInfo['fromnetnode'] == $VA_NETWORKS[1]['settings']['systemid']) &&
                                             ($msgInfo['fromuserno'] > 0) &&
                                             ($USER['securitylevel'] >= 255)) {
                                             $fromUser = GetUser($msgInfo['fromuserno']);
                                             if (strtolower($fromUser['handle']) == strtolower($msgInfo['fromhandle'])) {
                                                 print '<a href="' . $rootDir . 'misc/usereditor.php?u=' . $msgInfo['fromuserno'] . '">' . HtmlSpace($from) . '</a>';
                                             } else {
                                                 print HtmlSpace($from);
                                             }
                                         } else {
                                             print HtmlSpace($from);
                                         }
                                         ?>&nbsp;</span></td>
        <td width="100" height="30" bgcolor="#E2E2E2" align="left" nowrap>
            <span class="body">&nbsp;<?php print HtmlSpace($to); ?>&nbsp;</span></td>
        <td width="370" height="30" align="left">
            <span class="heading">&nbsp;<?php print HtmlSpace($subject); ?>&nbsp;</span></td>
        <td width="150" height="30" bgcolor="#E2E2E2" align="center" nowrap>
            <span class="body">&nbsp;<?php print $dateTime['date']; ?></span><span class="msgTime"><br />&nbsp;<?php print $dateTime['time']; ?><?php
                                                                                                                                                if (!$dateTime['tz']) {
                                                                                                                                                    print '*';
                                                                                                                                                }
                                                                                                                                                ?>&nbsp;</span></td>
    </tr>

<?php
if ($html == 0) {
    $h = 2;
} else {
    $h = $html;
}
$message = GetMessage($db, $msgstat[$m - 1], $h, '', $msgInfo); // Get the message to display.
if ($routing == 0) {
    $message = StripRouting($message);
}
if ($color == 0) {
    $message = StripBBSCodes($message);
}
if ($ansi == 0) {
    $message = StripANSICodes($message);
}
$message = HTMLEncode($message, $USER_SETTINGS['htmlencode']);  // Encode the HTML text.
?>

    <tr>
        <td width="750" align="left" colspan="5" valign="top">

<?php
if ($msgInfo['deleted'] == 1) {
    print '<span class="msgBack">(Message Marked for Deletion)</span><span class="body"> - </span>' . "\n";
    print '<span class="msgBack"><a href="sentemail-viewmsg.php?m=' . $m . '&delete=0">UnMark this Message for Deletion</a></span>' . "\n";
} else {
    print '<span class="msgBack"><a href="sentemail-viewmsg.php?m=' . $m . '&delete=1">Delete this Message</a></span>' . "\n";
    //print '<span class="msgBack"><a href="sentemail-viewmsg.php?m=' . $m . '&delete=1">Mark this Message for Deletion</a></span>' . "\n";
}
// If there is an attached file, then display its link.
if ($file != '') {
?>

    <form name="download" action="<?php print $rootDir; ?>download.php" method="POST">
        <input type="hidden" name="t" value="email">
        <input type="hidden" name="d" value="email">
        <input type="hidden" name="m" value="<?php print $msgstat[$m - 1]; ?>">
        <input type="image" value="Download" src="<?php print $rootDir; ?>images/download.gif" alt="Download <?php print $msgInfo['attfilename']; ?>" width="80" height="25" align="absmiddle">
        <span class="filename">&nbsp;Attached file: <?php print $msgInfo['attfilename']; ?></span><span class="filesize"> (<?php print $filesize; ?>)</span>
    </form>

<?php
} else {
    print '<br />';
}
?>

            <pre><?php print $message; ?></pre>
        </td>
    <tr>
        <td bgcolor="#416DBF" align="left" colspan="5" height="25" width="750">
            <table border="0" style="border-collapse: collapse" cellpadding="0" cellspacing="0" width="100%" height="100%">
                <tr>
                    <td class="msgHeader" align="left">&nbsp;
                        <?php
                        if (($ansi == '') || ($ansi == 0)) {
                            print '<a class="msgHeader" href="sentemail-viewmsg.php?m=' . $m . '&ansi=1&color=' . $color . '&html=' . $html . '&routing=' . $routing . '">Show ANSI Codes</a> |' . "\n";
                        } else {
                            print '<a class="msgHeader" href="sentemail-viewmsg.php?m=' . $m . '&ansi=0&color=' . $color . '&html=' . $html . '&routing=' . $routing . '">Strip ANSI Codes</a> |' . "\n";
                        }
                        if (($color == '') || ($color == 0)) {
                            print '<a class="msgHeader" href="sentemail-viewmsg.php?m=' . $m . '&ansi=' . $ansi . '&color=1&html=' . $html . '&routing=' . $routing . '">Show Color Codes</a> |' . "\n";
                        } else {
                            print '<a class="msgHeader" href="sentemail-viewmsg.php?m=' . $m . '&ansi=' . $ansi . '&color=0&html=' . $html . '&routing=' . $routing . '">Strip Color Codes</a> |' . "\n";
                        }
                        if (($html == '') || ($html == 0)) {
                            print '<a class="msgHeader" href="sentemail-viewmsg.php?m=' . $m . '&ansi=' . $ansi . '&color=' . $color . '&html=1&routing=' . $routing . '">Strip HTML Tags</a> |' . "\n";
                        } else {
                            print '<a class="msgHeader" href="sentemail-viewmsg.php?m=' . $m . '&ansi=' . $ansi . '&color=' . $color . '&html=0&routing=' . $routing . '">Show HTML Tags</a> |' . "\n";
                        }
                        if (($routing == '') || ($routing == 0)) {
                            print '<a class="msgHeader" href="sentemail-viewmsg.php?m=' . $m . '&ansi=' . $ansi . '&color=' . $color . '&html=' . $html . '&routing=1">Show Routing</a>' . "\n";
                        } else {
                            print '<a class="msgHeader" href="sentemail-viewmsg.php?m=' . $m . '&ansi=' . $ansi . '&color=' . $color . '&html=' . $html . '&routing=0">Strip Routing</a>' . "\n";
                        }
                        ?>
                    </td>
                    <td class="msgHeader" align="right">
                        <script language="JavaScript" type="text/javascript">
                        <!--
                            document.write('<a class="msgHeader" href="Javascript:MessageInfo(\'s\', \'s\', \'<?php print $msgstat[$m - 1]; ?>\');">Message Info</a>&nbsp;');
                        -->
                        </script>
                        <noscript>
                            <a class="msgHeader" href="msginfo.php?t=s&d=s&m=<?php print $msgstat[$m - 1]; ?>" target="messageinfo">Message Info</a>&nbsp;
                        </noscript>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
<table border="0" cellspacing="0" cellpadding="0" width="100%" style="border-collapse: collapse" bordercolor="#111111">
    <tr>
        <td class="msgBack" align="left">

<?php
if ($m > 1) {
    $num = $m - 1;
    print '<a class="msgBack" href="sentemail-viewmsg.php?m=' . $num . '">Previous Email</a> |' . "\n";
}

if ($m < $msgcnt) {
    $num = $m + 1;
    print '<a class="msgBack" href="sentemail-viewmsg.php?m=' . $num . '">Next Email</a> |' . "\n";
}

if ($m >= $msgcnt - 25) {
    print '<a class="msgBack" href="sentemail-dispmsg.php">Back to ' . HtmlSpace($db['desc']) . '</a></td>' . "\n";
} else if ($m <= 25) {
    print '<a class="msgBack" href="sentemail-dispmsg.php?m=25">Back to ' . HtmlSpace($db['desc']) . '</a></td>' . "\n";
} else {
    print '<a class="msgBack" href="sentemail-dispmsg.php?m=' . $m . '">Back to ' . HtmlSpace($db['desc']) . '</a></td>' . "\n";
}
?>

        <td class="msgBack" align="right">
            <a class="msgBack" href="<?php print $rootDir; ?>index.php">Return to Home Page</a></td>
    </tr>
</table>

<?php
// Update the message as read if not already marked.
if ($msgInfo['offline'] == 0) {
    $msgInfo['offline'] = 1;
    WriteMessageInfo($db, $msgstat[$m - 1], $msgInfo);
}

EmailFooter();                              // Display the webpage footer.

?>