<?php
/*
 * ----------------------------------------------------------------------------
 * Post-Message.php                                                  10/10/2006
 * This script displays the new message/reply form to the user.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

session_cache_limiter('nocache');                   // Useful if a user hits the back button.

$VA_ACTION = 'Posting Messages';
$TIMEOUT = 1800;                                    // Set timeout to 30 mins.

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once('layout_forum.inc.php');               // Webpage header and footer.

if (!isset($_POST['referer'])) {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}

$error = 0;
if (isset($_POST['t'])) {                   // Set the passed variables.
    $t = (integer) $_POST['t'];
} else {
    $error = 1;
}

if (isset($_POST['d'])) {                   // Set the passed variables.
    $d = (integer) $_POST['d'];
} else {
    $error = 1;
}

$dbInfo = GetDbInfo($t, $d);

// Check user's write security level.
if (($USER['userno'] == 0) ||
    ($USER['userno'] == $CONFIG['guestacct']) ||
    ($USER['securitylevel'] < $dbInfo['minwritesl'])) {
    die('<br /><h4>You do not have access to post in this area. Please press the BACK button on your browser.</h4>');
}

if ((isset($_POST['reply'])) && ($_POST['reply'] != 0)) {   // Set the passed variables.
    $reply = (integer) $_POST['reply'];
    $msgInfo = GetMessageInfo($dbInfo, $reply);
} else {
    $reply = 0;
}

if ($error == 1) {
    die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
}

if ((isset($_POST['msgflag'])) && ($_POST['msgflag'] == 1)) {
    if ((!isset($_SERVER['HTTP_REFERER'])) ||
        (strpos($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST']) === FALSE)) {
        die('<br /><h4>You are not allowed to access this script from an outside source.<br />Press the BACK button on your browser.</h4>');
    }

    if (isset($_POST['subject'])) {
        $msgSubject = $_POST['subject'];
    } else {
        die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
    }

    if (isset($_POST['msgbody'])) {
        $msgBody = $_POST['msgbody'];
    } else {
        die('<br /><h4>Invalid message parameters. Please press the BACK button on your browser.</h4>');
    }

    $log = 'Message Sent    "' . $USER['handle'] . '" --> "' . $dbInfo['desc'] . '" - ' . $msgSubject;
    WriteLog('VADV-PHP.LOG', $log);         // Log the email.
    WriteMessage($dbInfo, $USER['userno'], $msgSubject, $msgBody, $reply);

    // Return to message listing.
    $pos = strrpos($_POST['referer'], '/');
    $url = substr($_POST['referer'], 0, $pos);
    RedirectUser($url . '/forum-dispmsg.php?t=' . $t . '&d=' . $d);
}

if (trim($dbInfo['desc']) != '') {
    $dbDesc = htmlspecialchars($dbInfo['desc']);
} else {
    $dbDesc = '(No Description)';
}
        
ForumHeader();
?>
<script language="JavaScript" type="text/javascript">
<!--
    var submitted = 0;
    function validate(form) {
        if (submitted == 0) {
            if ((form.subject.value.length == 0) ||
                (form.msgbody.value.length == 0)) {
                alert("Please enter a subject and a message.");
                form.subject.focus();
                return false;
            }
            submitted = 1;
            form.submit.disabled = true;
            form.reset.disabled = true;
            form.cancel.disabled = true;
            return true;
        } else {
            return false;
        }
    }

    function HelpWindow(bmark) {
        var url = "<?php print $rootDir; ?>help/post-message_help.php#" + bmark;
        var newwindow = window.open(url, "helpwindow", "toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=yes, resizable=no, width=350, height=450");
        newwindow.focus();
    }
//-->
</script>
<form name="postmsg" method="POST" action="post-message.php" onsubmit="return validate(postmsg)">
    <input type="hidden" name="referer" value="<?php print $_POST['referer']; ?>">
    <input type="hidden" name="t" value="<?php print $t; ?>">
    <input type="hidden" name="d" value="<?php print $d; ?>">
    <input type="hidden" name="reply" value="<?php print $reply; ?>">
    <input type="hidden" name="msgflag" value="1">
    <div align="center">
        <center>
        <table border="1" cellpadding="2" cellspacing="0" style="border-collapse: collapse" width="750" bordercolor="#666666" bgcolor="#E2E2E2">
            <tr>
                <td class="msgTitle" height="25" colspan="2" bgcolor="#416DBF" align="left">
                    &nbsp;&nbsp;<?php print HtmlSpace($dbDesc); ?> - New Message</td>
            </tr>
            <tr>
                <td class="msgHeader" height="15" colspan="2" bgcolor="#000080" align="left">
                    &nbsp;</td>
            </tr>
            <tr>
                <td align="center" valign="top">
                    <table border="0" cellspacing="1" style="border-collapse: collapse" bordercolor="#111111" width="639">
                        <tr>
                            <td class="boldBody" width="90" height="25" align="left" valign="top">
                                To:</td>
                            <td class="boldBody" height="25" align="left">
                                <?php
                                if ($reply > 0) {
                                    print HtmlSpace($msgInfo['fromhandle']);
                                } else {
                                    print 'All';
                                }
                                ?></td>
                        </tr>
                        <tr>
                            <td class="boldBody" width="90" height="25" align="left" valign="top">
                                Subject:</td>
                            <td height="25" align="left">
                                <input name="subject" type="text" size="64" maxlength="64" value="<?php if ($reply > 0) print $msgInfo['subject']; ?>" tabindex="1">
                                <script language="JavaScript" type="text/javascript">
                                <!--
                                    document.write('<a href="Javascript:HelpWindow()"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Message Help" width="15" height="15" align="middle"></a>');
                                -->
                                </script>
                                <noscript>
                                    <a href="<?php print $rootDir; ?>help/post-message_help.php" target="helpwindow"><img border="0" src="<?php print $rootDir; ?>images/help.gif" alt="Message Help" width="15" height="15" align="middle"></a>
                                </noscript>
                            </td>
                        </tr>
                        <tr>
                            <td class="boldBody" width="90" height="25" align="left" valign="top">
                                Message:</td>
                            <td align="left">
                                <textarea name="msgbody" rows="15" cols="80" wrap="soft" tabindex="2"><?php
                                                                                                      if ($reply > 0) {
                                                                                                          print 'Re: ' . $msgInfo['subject'] . QuoteMessage(StripRouting(GetMessage($dbInfo, $reply, 0, '', $msgInfo))) . "\r\n";
                                                                                                      }
                                                                                                      ?></textarea>
                                <table border="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#111111" width="100%" cellpadding="2">
                                    <tr>
                                        <td align="right" width="340">
                                            <input type="submit" value="Submit" name="submit" tabindex="3">
                                            <input type="reset" value="Reset" name="reset" tabindex="4">
                                        </td>
                                        <td align="left">
                                            <input type="button" value="Cancel" name="cancel" tabindex="5" onclick="javascript:document.location.href='<?php print $_POST['referer']; ?>'">
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2" bgcolor="#416DBF" align="left">&nbsp;</td>
            </tr>
        </table>
        </center>
    </div>
</form>
<script language="JavaScript" type="text/javascript">
<!--
    document.postmsg.subject.focus();
//-->
</script>
<?php

ForumFooter();

?>