<?php
/*
 * ----------------------------------------------------------------------------
 * MsgInfo.php                                                       10/14/2006
 * This script displays information about the specified message.
 * The variable $t is passed to the script to set the topic number.
 * The variable $d is passed to the script to set the database number.
 * The variable $m is passed to the script to set the message number.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Reading Messages';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-networks.inc.php');  // Include network functions.

$userno = $USER['userno'];

if (isset($_GET['t'])) {                    // Set the passed variables.
    $t = $_GET['t'];
} else {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if (isset($_GET['d'])) {                    // Set the passed variables.
    $d = $_GET['d'];
} else {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if (isset($_GET['m'])) {                    // Set the passed variables.
    $m = (integer) $_GET['m'];
} else {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

$networks = GetNetworkInfo();               // Get the local network info.

if (($t == 'e') || ($d == 'e')) {           // Get the database information.
    $t = 'e';
    $d = 'e';
    $db = SetEmailInfo($userno);
    $msgInfo = GetMessageInfo($db, $m);     // Get the message information.
    if ($msgInfo['touserno'] != $userno) {  // Check to see if the user has access to this email message.
        die('<br /><h4>You do not have access to this message. Press the BACK button on your browser.</h4>');
    }
} else if (($t == 's') || ($d == 's')) {
    $t = 's';
    $d = 's';
    $db = SetSentEmailInfo($userno);
    $msgInfo = GetMessageInfo($db, $m);         // Get the message information.
    if ($msgInfo['fromuserno'] != $userno) {    // Check to see if the user has access to this email message.
        die('<br /><h4>You do not have access to this message. Press the BACK button on your browser.</h4>');
    }
} else {
    $t = (integer) $t;
    $d = (integer) $d;
    $db = GetDbInfo($t, $d);
    if (!DbAccess($db)) {
        die('<br /><h4>You do not have access to this section.</h4>');
    }
    $msgInfo = GetMessageInfo($db, $m);     // Get the message information.
    if ($USER['securitylevel'] < $db['minreadsl']) {
        die('<br /><h4>You do not have access to this message. Press the BACK button on your browser.</h4>');
    }
}

$netInfo = ReadNetworksLst();               // Get network information.

// To/From user information.
if ($msgInfo['fromuserno'] == 0) {
    $fromuserno = '';
} else {
    $fromuserno = ' #' . $msgInfo['fromuserno'];
}
if ($msgInfo['touserno'] == 0) {
    $touserno = '';
} else {
    $touserno = ' #' . $msgInfo['touserno'];
}

$fromnet = $msgInfo['fromnetid'];
$tonet   = $msgInfo['tonetid'];

if ($fromnet == 0) {
    $fromnetdesc = '';
    $fromnetnode = '';
} else {
    if (isset($netInfo[$fromnet]['desc'])) {
        $fromnetdesc = $netInfo[$fromnet]['desc'];
    } else {
        $fromnetdesc = 'UnknownNET';
    }
    $fromnetnode = ' @' . $msgInfo['fromnetnode'];
}
if ($tonet == 0) {
    $tonetdesc = '';
    $tonetnode = '';
} else {
    if (isset($netInfo[$tonet]['desc'])) {
        $tonetdesc = $netInfo[$tonet]['desc'];
    } else {
        $tonetdesc = 'UnknownNET';
    }
    $tonetnode = ' @' . $msgInfo['tonetnode'];
}

// Determine the type of database.
switch ($db['dbtype']) {
    case 'E':
        $type = 'Email';
        break;
    case 'F':
        $type = 'File';
        break;
    case 'M':
        $type = 'Message';
        break;
    default:
        $type = 'Message';
        break;
}

require_once($includeDir. 'html_header.php');
?>

<html>
<head>
<title>[<?php print $type; ?> Information] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,nofollow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    .body { font-family: Courier New; font-size: 10pt; color: #C0C0C0; }
-->
</style>
</head>

<body class="body" align="left" bgcolor="#000000">

<span style="color: #FFFFFF"><b><?php print $type; ?> Information</b></span>
<hr color="#525552">
<br />
Subject:&nbsp;&nbsp; <?php print HtmlSpace(htmlspecialchars(StripBBSCodes($msgInfo['subject']))); ?>
<br />
Date:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php print htmlspecialchars($msgInfo['creation'] . ' (' . $msgInfo['daysold'] . ' days old)'); ?>
<br />
Length:&nbsp;&nbsp;&nbsp;&nbsp;<?php print $msgInfo['msglength'] . ' bytes'; ?>
<br />
From:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php print htmlspecialchars($msgInfo['fromhandle'] . $fromuserno . $fromnetnode . ' ' . $fromnetdesc); ?>
<br />
To:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <?php print htmlspecialchars($msgInfo['tohandle'] . $touserno . $tonetnode . ' ' . $tonetdesc); ?>
<br />
Deleted:&nbsp;&nbsp; <?php
         if ($msgInfo['deleted'] == 0) {
             print 'NO';
         } else {
             print 'YES';
         }
         ?>
<br />
<?php
if ($db['dbtype'] == 'F') {
    print 'Offline:&nbsp;&nbsp; ';
} else {
    print 'Read:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; ';
}
if ($msgInfo['offline'] == 0) {
    print 'NO';
} else {
    print 'YES';
}
?>
<br />
Att. File: <?php
           if ($msgInfo['attfilename'] == '') {
               print 'NONE';
           } else {
               $filesize = $msgInfo['attfilesize'];
               if ($filesize >= 1073741824) {
                   $filesize = round($filesize / 1073741824, 1) . 'GB';
               } else if ($filesize >= 1048576) {
                   $filesize = round($filesize / 1048576, 1) . 'MB';
               } else if ($filesize >= 1024) {
                   $filesize = intval($filesize / 1024) . 'KB';
               } else {
                   $filesize = $filesize . ' bytes';
               }
               print $msgInfo['attfilename'] . ' (' . $filesize . ') (' . $msgInfo['downloadno'] . ' downloads)';
           }
           ?>
</body>

</html>