<?php
/*
 * ----------------------------------------------------------------------------
 * EditDesc.php                                                      10/14/2006
 * This script allows the sysop to edit a file's description.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Editing Files';

require_once('include_dir.php');                    // Get include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-database.inc.php');  // Include database functions.
require_once($includeDir . 'va-main.inc.php');      // Include main configuration.

$userno = $USER['userno'];

if ($USER['securitylevel'] < 255) {
    die('<br /><h4>You do not have access to this section. Please press the BACK button on your browser.</h4>');
}

if (isset($_GET['t'])) {                    // Set the passed variables.
    $t = (integer) $_GET['t'];
} else {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if (isset($_GET['d'])) {                    // Set the passed variables.
    $d = (integer) $_GET['d'];
} else {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

if (isset($_GET['m'])) {                    // Set the passed variables.
    $m = (integer) $_GET['m'];
} else {
    die('<br /><h4>Invalid parameters. Please press the BACK button on your browser.</h4>');
}

$db = GetDbInfo($t, $d);
if (!DbAccess($db)) {
    die('<br /><h4>You do not have access to this section.</h4>');
}

$msgInfo = GetMessageInfo($db, $m);     // Get the message information.
if ($USER['securitylevel'] < $db['minreadsl']) {
    die('<br /><h4>You do not have access to this message. Press the BACK button on your browser.</h4>');
}

if ((isset($_POST['desc'])) && (isset($_POST['e']))) {
    $desc = trim($_POST['desc']);
    if ($desc == '') {
        $desc = ' ';
    }
    EditMessage($db, $m, $desc);

    print '<script language="JavaScript" type="text/javascript">' . "\r\n";
    print '<!--' . "\r\n";
    print "window.opener.location.href = window.opener.location.href;\r\nwindow.close();\r\n";
    print '//-->' . "\r\n";
    print '</script>' . "\r\n";
    die();
}

require_once($includeDir . 'html_header.php');
?>

<html>
<head>
<title>[Edit File Desc] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow" />
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn" />
<style type="text/css">
<!--
    .body { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #000000; font-weight: bold }
-->
</style>
</head>

<body bgcolor="#000000" onload="document.editdesc.desc.focus();">
<div align="center">
<form name="editdesc" action="editdesc.php?t=<?php print $t; ?>&d=<?php print $d; ?>&m=<?php print $m; ?>" method="POST">
<input type="hidden" name="e" value="1">
    <table border="1" width="600" height="125" cellspacing="0" cellpadding="4" bordercolor="#000080" bgcolor="#416DBF">
        <tr>
            <td align="center">
                <table cellpadding="4" cellspacing="0" width="100%" height="100%" border="0">
                    <tr>
                        <td valign="top" colspan="2">
                            <div align="center">
                                <table cellpadding="0" cellspacing="0" width="100%" height="100%" bgcolor="#C0C0C0">
                                    <tr>
                                        <td class="body" align="center">Description:</td>
                                        <td align="center">
                                            <input type="text" name="desc" value="<?php print $msgInfo['subject']; ?>" size="64" maxlength="64"></td>
                                    </tr>
                                </table>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td align="right" width="55%">
                            <input type="submit" value="Submit" name="submit" tabindex="2">
                            <input type="reset" value="Reset" name="reset" tabindex="3">
                        </td>
</form>
<form name="cancelPost" action="javascript: window.close()">
                        <td align="left">
                            <input type="submit" value="Cancel" name="submit" tabindex="4">
                        </td>
</form>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</div>
</body>

</html>