<?php
/*
 * ----------------------------------------------------------------------------
 * BBSLogin.php                                                      10/14/2006
 * This is a login screen for the BBS's VADV-PHP page.
 * ----------------------------------------------------------------------------
 * Copyright (C) 2002-2006 Steve Winn. All Rights Reserved.
 *
 * The source code contains a fair amount of comments, which may aid anyone
 * attempting to follow the program or to modify it.
 *
 * For licensing and copyright information, view LICENSE.TXT.
 * ----------------------------------------------------------------------------
 */

$VA_ACTION = 'Logging In...';

require_once('include_dir.php');                    // Get Include directory.
require_once($includeDir . 'va-functions.inc.php'); // A VADV-PHP script.
require_once($includeDir . 'va-main.inc.php');      // Main configuration.
require_once($includeDir . 'forms.inc.php');

if (($USER['userno'] > 0) &&
    ($USER['userno'] != $CONFIG['guestacct']) &&
    ($USER['securitylevel'] > 0) &&
    (isset($_GET['url']))) {
    RedirectUser(urldecode($_GET['url']));
}

require_once($includeDir. 'html_header.php');
?>

<html>

<head>
<title>[VADV-PHP Login] - <?php print HtmlSpace($VA_MAIN['bbsname']); ?></title>
<meta name="robots" content="noindex,follow">
<meta name="copyright" content="Copyright  <?php print date("Y"); ?>, Steve Winn">
<style type="text/css">
<!--
a.infoBarBody:link    { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.infoBarBody:visited { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.navBar:link         { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.navBar:visited      { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
a.return:link         { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
a.return:visited      { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.infoBarBody          { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; }
.navBar               { font-family: Verdana, Arial, Helvetica; font-size: 8pt;  color: #FFFFFF; font-weight:bold }
.return               { font-family: Verdana, Arial, Helvetica; font-size: 10pt; color: #FFFF00; font-weight:bold }
.yellowTitle          { font-family: Verdana, Arial, Helvetica; font-size: 14pt; color: #FFFF00; font-weight:bold; font-style:italic }
-->
</style>
</head>

<body bgcolor="#000000" onload="document.login.username.focus();">

<div align="center">
    <center>
    <table border="1" width="640" cellspacing="0" cellpadding="5" bgcolor="#000080" bordercolor="#FFFFFF">
        <tr>
            <td align="center" valign="top">
                <p class="yellowTitle"><?php print HtmlSpace($VA_MAIN['bbsname']); ?>'s VADV-PHP Login</p>
                <table cellspacing="1" width="100%">
                    <tr>
                        <td valign="top">
                            <p align="center">
                                <a class="return" href="index.php">Return to main BBS page.</a>
                            </p>
                            <?php if (($USER['userno'] == 0) ||
                                      ($USER['userno'] == $CONFIG['guestacct'])) {
                                       print '<p class="infoBarBody" align="center">If you do not have an account, ';
                                       if ($VA_MAIN['newuserpw'] == md5(strtoupper(''))) {
                                           print 'you may <a class="infoBarBody" href="bbsregister.php">create an account</a>.';
                                       } else {
                                           print 'connect to the BBS to create one.';
                                       } print '</p>';
                                  }
                            ?>
                            <?php LoginBox(); ?>
                        </td>
                    </tr>
                </table>
                <p class="navBar">This page is powered
                by <a class="navBar" href="http://www.vadvphp.com">VADV-PHP</a></p>
                <p class="infoBarBody">If you experience any problems
                with this website or need help, contact the
                <a class="infoBarBody" href="mailto:<?php print $CONFIG['webmaster']; ?>">webmaster</a>.<br />
                VADV-PHP Copyright  2002-<?php print date('Y'); ?> Aspect
                Technologies. All Rights Reserved.</p>
            </td>
        </tr>
    </table>
    </center>
</div>

</body>

</html>