set exclusive on
PUBLIC MAXGAL curGALNUM,CURKEY,CURPLYR,CURSKOR,CURPLAN,workdir,SN,FN,LASTPKT
public gamedir,routidx[99],FNS[99],FTSTR,LATER,towho,BEENUSED
PUBLIC CFG_DAYA,CFG_DAYB,CFG_BBN,CFG_LOC,CFG_BRD,CFG_EML,CFG_REG,CFG_IBN
PUBLIC ESC,LRED,DRED,LGRN,DGRN,YELO,BRWN,LBLU,LMAG,DMAG,LCYN,DCYN,LWHT,DWHT,XCOL
public axseed,ayseed,rnd_ret,RAND_RESULT

*   01=Message
*   02=Trade            (&01,A,01,A,02,food,ore,troops)
*   03=Raid             (&01,A,01,A,03,troops,fighters,HeavyCruisers)
*   04=Probe            (&01,A,01,A,04)
*   05=Return from raid (&01,A,01,A,05,troops,fighters,HeavyCruisers,foodp,orep,soldierp,money)
*   06=Return from probe(&01,A,01,A,06,troops,defstations,insurgency)

ESC=CHR(27)+"["
LRED=ESC+"1;31m"
DRED=ESC+"0;31m"
LGRN=ESC+"1;32m"
DGRN=ESC+"0;32m"
YELO=ESC+"1;33m"
BRWN=ESC+"0;33m"
LBLU=ESC+"1;34m"
DBLU=ESC+"0;34m"
LMAG=ESC+"1;35m"
DMAG=ESC+"0;35m"
LCYN=ESC+"1;36m"
DCYN=ESC+"0;36m"
LWHT=ESC+"1;37m"
DWHT=ESC+"0;37m"
XCOL=ESC+"0m"



DO MAINPROC
SAVE TO "LASTPKT.MEM" ALL LIKE LASTPKT
CLOSE ALL
quit

PROCEDURE FILEWAIT
PARAMETERS ISTR
IF ERROR() = 108                        && File in use by another?
    ? "Waiting for access..."
    A=INKEY(1)                          && delay 1 second
    RETRY                               && Try to open the file again
ENDIF
? "Try another time.."
?   ISTR
HALT MESSAGE()
RETURN


PROCEDURE OPENGLXY
ON ERROR DO FILEWAIT WITH "GLXY"
SELECT 1
sdi=workdir+"sdGLXY.DBF"
SDJ=workdir+"GALSCOR"
USE &SDI INDEX &SDJ ALIAS GLXY
RETURN

PROCEDURE OPENIBBS
ON ERROR DO FILEWAIT WITH "IBBS"
SELECT 2
sdi=workdir+"sdibbs"
SDJ=workdir+"SKORE"
USE &SDI INDEX &SDJ ALIAS IBBS
RETURN

PROCEDURE OPENOTHR
ON ERROR DO FILEWAIT WITH gamedir+"SDOTHR.DBF"
SELECT 3
SDP=gamedir+"SDPLYR"
USE &SDP ALIAS OTHR
RETURN

PROCEDURE OPENHIST
ON ERROR DO FILEWAIT WITH "HIST"
SELECT 4
USE HISTORY ALIAS HIST
RETURN

PROCEDURE OPENNODE
ON ERROR DO FILEWAIT WITH "NODE"
SELECT 5
USE SDNODES ALIAS NODE
RETURN


PROCEDURE ONEKEY
PARAMETERS CHOICES, DEF
DO WHILE .T.
    ONECH=UPPER(CHR(INKEY(0)))
    IF ONECH=CHR(13)
        ONECH=DEF
        RETURN
    ELSE
        IF ONECH $ CHOICES
            RETURN
        ENDIF
    ENDIF
ENDDO
RETURN

PROCEDURE RANDOMIZE
  AXSEED = SECONDS()*100
  AYSEED = 1
RETURN

PROCEDURE RANDOM
PARAMETERS LIMIT
IF LIMIT<=0
    LIMIT=1
ENDIF
AXSEED = MOD(40014*AXSEED,2147483563)
AYSEED = MOD(40692*AYSEED,2147483399)
RAND_RESULT = MOD(AXSEED + AYSEED,2147483563)/(2147483563/limit)
RETURN

PROCEDURE HILO
PARAMETERS LO,HI
DO RANDOM WITH (HI-LO)
RND_RET=RAND_RESULT+LO
RETURN




PROCEDURE INIT
do randomize
gamedir=HOMEPATH()
ODATA=UPPER(OPDATA())
IF "/D:" $ ODATA
    gamedir=gamedir+TRIM(LTRIM(SUBSTR(ODATA,AT("/D:",ODATA)+3,LEN(ODATA))))+"\"
ENDIF
workdir=homepath()+"work\"
ODATA=UPPER(OPDATA())
IF "/CONFIG" $ ODATA
    DO CONFIG
ENDIF
SDI=workdir+"SDIBBS.DBF"
IF .NOT. FILE(SDI)
    DO MAKEIBBS
ENDIF

IF .NOT. FILE("HISTORY.DBF")
    DO MAKEHIST
ENDIF


sdi=workdir+"sdGLXY.DBF"
IF FILE(SDI)
    ERASE &SDI
ENDIF

IF FILE("SDCFG.MEM")
    RESTORE FROM "SDCFG.MEM" ADDITIVE
ENDIF

IF FILE("LASTPKT.MEM")    
    RESTORE FROM "LASTPKT.MEM" ADDITIVE
ELSE
    LASTPKT=0
ENDIF
DO MAKEGLXY
DO OPENGLXY
DO OPENIBBS
DO OPENOTHR
DO OPENHIST
DO OPENNODE
SELECT 5
GO TOP
DO WHILE .NOT. EOF()
    SELECT 1
    APPEND BLANK
    REPLACE GLXY->CGALNUM WITH NODE->NUMBER
    replace GLXY->CGALNAM with NODE->BBSNAME
    REPLACE GLXY->NETSCORE WITH 0
    SELECT 5
    SKIP
ENDDO
do galaxy
do readrout
i=1
do while i<=99
    fns[i]=""
    i=i+1
enddo
do makepkts



SELECT 2
GO TOP
DO WHILE .NOT. EOF()
    REPLACE IBBS->LASTSEEN WITH IBBS->LASTSEEN + 1
    skip
ENDDO
RETURN

PROCEDURE W2MAIL
PARAMETERS STR, FNAME
IF .NOT. FILE(FNAME)
    FCREATE FPTR &FNAME 3
    FCLOSE FPTR
ENDIF
FOPEN FPTR &FNAME 11 2048
FLWRITE FPTR SIZE STR + CHR(13) + CHR(10)
FCLOSE FPTR
RETURN


PROCEDURE MAINPROC
DO INIT
DO UPDATE1
DO UPDATE2
DO FILLGLXY
DO POSTIT
a=inkey(3)
RETURN

PROCEDURE MAKEIBBS
IF FILE("NEWDBF.DBF")
    ERASE NEWDBF.DBF
ENDIF
CREATE NEWDBF
USE NEWDBF
APPEND BLANK
REPLACE FIELD_NAME WITH "GALNUM", FIELD_TYPE WITH "N", FIELD_LEN WITH 3
APPEND BLANK
REPLACE FIELD_NAME WITH "KEY", FIELD_TYPE WITH "C", FIELD_LEN WITH 1
APPEND BLANK
REPLACE FIELD_NAME WITH "DYNASTYNAM", FIELD_TYPE WITH "C", FIELD_LEN WITH 35
APPEND BLANK
REPLACE FIELD_NAME WITH "PLANETS", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "SKORE", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "TROOPS", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "DEFSTATNS", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "INSURGENCY", FIELD_TYPE WITH "N", FIELD_LEN WITH 10
APPEND BLANK
REPLACE FIELD_NAME WITH "LASTSEEN", FIELD_TYPE WITH "N", FIELD_LEN WITH 2
sdi=workdir+"sdibbs"
CREATE &sdi FROM NEWDBF
use &sdi
sdi=workdir+"skore"
index on descend(skore) to &sdi
sdi=workdir+"IBBSKEY"
index on KEY to &sdi
ERASE NEWDBF.DBF
RETURN

PROCEDURE MAKEGLXY
IF FILE("NEWDBF.DBF")
    ERASE NEWDBF.DBF
ENDIF
CREATE NEWDBF
USE NEWDBF
APPEND BLANK
REPLACE FIELD_NAME WITH "CGALNUM", FIELD_TYPE WITH "N", FIELD_LEN WITH 3
APPEND BLANK
REPLACE FIELD_NAME WITH "CGALNAM", FIELD_TYPE WITH "C", FIELD_LEN WITH 35
APPEND BLANK
REPLACE FIELD_NAME WITH "NETSCORE", FIELD_TYPE WITH "N", FIELD_LEN WITH 19
sdi=workdir+"sdGLXY"
CREATE &sdi FROM NEWDBF
use &sdi
sdi=workdir+"GALSCOR"
index on descend(NETSCORE) to &sdi
sdi=workdir+"GALNUM"
index on cgalnum to &sdi
ERASE NEWDBF.DBF
RETURN

procedure makehist
if file("newdbf.dbf")
    erase newdbf.dbf
endif
create newdbf
use newdbf
append blank
replace field_name with "SN", FIELD_TYPE WITH "C", FIELD_LEN WITH 13
APPEND BLANK
REPLACE FIELD_NAME WITH "ORGBBS", FIELD_TYPE WITH "N", FIELD_LEN WITH 2
APPEND BLANK
REPLACE FIELD_NAME WITH "THEDATE", FIELD_TYPE WITH "N", FIELD_LEN WITH 7
APPEND BLANK
REPLACE FIELD_NAME WITH "thetime", FIELD_TYPE WITH "N", FIELD_LEN WITH 8
creatE history from newdbf
USE HISTORY ALIAS HIST
erase newdbf.dbf
return

PROCEDURE GALAXY
?   chr(251) + " Reading Nodelist"
IBBSGAME=.F.
IF CFG_IBN>0
    DONE=.F.
    SELECT 5
    GO TOP
    SKIP CFG_IBN - 1
    IBBSGAME=.T.
    GO BOTTOM
    MAXGAL=recno()
ENDIF
RETURN


procedure readrout
gl=homepath()+"sdroute.ctl"
if .not. file(gl)
    ?   "File not found: " + gl
    return
endif
i=1
do while i<=99
    routidx[i]=i
    I=I+1
ENDDO
FOPEN FPTR &gl 10 2048
I=1
DONE=.F.
DO WHILE .NOT. DONE
    FLREAD FPTR SIZE REC
    IF SIZE > 4
        str1=crtrim(rec)
        n1=val(substr(str1,1,at(" ",str1)-1))
        n2=val(ltrim(substr(str1,at(" ",str1),len(str1)-1)))
        routidx[n1]=n2
    ELSE
        DONE=.T.
        fclose fptr
    ENDIF
enddo
RETURN



PROCEDURE UPDATE1
I=1
DO WHILE I<=MAXGAL
    FN=workdir+"GALAXY."+LTRIM(STR(I))
    IF FILE(FN)
        FOPEN FPTR &fn 10 2048    
        FLREAD FPTR SIZE REC
        DO WHILE SIZE>0
            STR1=CRTRIM(REC)
            DO PARSE1 WITH STR1
            FLREAD FPTR SIZE REC
        ENDDO
        fclose fptr
    ENDIF
    I=I+1
ENDDO
RETURN

PROCEDURE PARSE1
PARAMETERS STR1
curGALNUM=val(SUBSTR(STR1,2,2))
STR1=SUBSTR(STR1,AT(",",STR1)+1,LEN(STR1))
CURKEY=substr(str1,1,1)
STR1=SUBSTR(STR1,AT(",",STR1)+1,LEN(STR1))
CURPLYR=SUBSTR(STR1,1,AT(",",STR1)-1)
STR1=SUBSTR(STR1,AT(",",STR1)+1,LEN(STR1))
CURPLAN=val(SUBSTR(STR1,1,AT(",",STR1)-1))
STR1=SUBSTR(STR1,AT(",",STR1)+1,LEN(STR1))
CURSKOR=val(SUBSTR(STR1,1,AT(",",STR1)-1))
STR1=SUBSTR(STR1,AT(",",STR1)+1,LEN(STR1))
CURSN=val(SUBSTR(STR1,1,AT(".",STR1)-1))


select 2
go top
foundit=.f.
do while .not. eof()
    if ibbs->key=curkey .and. ibbs->galnum=curgalnum
        foundit = .t.
        replace ibbs->dynastynam with curplyr
        replace ibbs->planets with curplan
        replace ibbs->skore with curskor
        replace ibbs->lastseen with 0
    endif
    skip
enddo

if .not. foundit
    append blank
    replace ibbs->key with curkey
    replace ibbs->galnum with curgalnum
    replace ibbs->dynastynam with curplyr
    replace ibbs->planets with curplan
    replace ibbs->skore with curskor
    replace ibbs->lastseen with 0
ENDIF
RETURN


PROCEDURE POSTIT
private stuff[25]
?   CHR(251) + " Posting the messages"
K=1
SELECT 5
STR5=workdir+"actions.out"
STR1=workdir+"GALAXY."+LTRIM(STR(CFG_IBN))
DO WHILE K<=MAXGAL
    IF K<>CFG_IBN
        IF FILE(STR1)
            FOPEN FPTR1 &STR1 10 2048    
            FLREAD FPTR1 SIZE1 REC1
            DO WHILE SIZE1>0
                DO W2MAIL WITH CRTRIM(REC1),FNS[K]
                flread fptr1 size1 rec1
            ENDDO
            FCLOSE FPTR1
        ENDIF
        IF FILE(STR5)
            FOPEN FPTR1 &STR5 10 2048    
            FLREAD FPTR1 SIZE1 REC1
            do while size1>0
                rec1=crtrim(rec1)
                nn1=substr(rec1,2,2)
                if val(nn1)=k
                    do w2mail with rec1,FNS[K]
                endif
                flread fptr1 size1 rec1
            enddo
            fclose fptr1
        else
            ?   "# No outbound actions to process"
        ENDIF
        DO W2MAIL WITH "=END=",FNS[K]
        DO OPENNODE
        GO TOP
        SKIP K - 1
        ?   "   Outbound for " + TRIM(NODE->BBSNAME)
        DOTBBS TYPE 7 OPTDATA NODE->BOARD+" /C:"+FNS[K]
        fn1=fns[k]
        erase &fn1
    ENDIF
    K=K+1
enddo
if file(str5)
    erase &str5
endif
if file(str1)
    erase &str1
endif
RETURN

PROCEDURE UPDATE2
?
STR1=FINDFIRST(STR2,HOMEPATH()+"INBOUND\*.SDN")
IF LEN(STR1)>0
    DO INBOUND WITH HOMEPATH()+"INBOUND\"+STR1
ELSE
    RETURN
ENDIF
STR1=FINDNEXT(STR2)
DO WHILE LEN(STR1)>0
    DO INBOUND WITH HOMEPATH()+"INBOUND\"+STR1
    STR1=FINDNEXT(STR2)
ENDDO
RETURN

PROCEDURE PARSE2
PARAMETERS STR1
FOPEN FPTR1 &STR1 10 2048    
FLREAD FPTR1 SIZE REC
DO WHILE SIZE>0
    STR2=CRTRIM(REC)
    IF SUBSTR(STR2,1,2)="S:"
        FN=SUBSTR(STR2,4,LEN(STR2))
    ENDIF
    FLREAD FPTR1 SIZE REC
ENDDO

RETURN


PROCEDURE FILLGLXY
SELECT 1
GO TOP
DO WHILE .NOT. EOF()
    SELECT 2
    GO TOP
    DO WHILE .NOT. EOF()
        IF GLXY->CGALNUM = IBBS->GALNUM
            SELECT 1
            REPLACE GLXY->NETSCORE WITH GLXY->NETSCORE + IBBS->SKORE
        ENDIF
        SELECT 2
        SKIP
    ENDDO
    SELECT 1
    SKIP
ENDDO
RETURN

PROCEDURE CONFIG
DO WHILE .T.
    ?   "   Space Dynasty Inter-BBS Config Menu"
    ?
    ?   "(A) BBS Setup"
    ?   "(B) Nodelist Editor (League Coordinators Only)"
    ?   "(X) Save and Exit"
    ?
    ?   "Command: "
    DO ONEKEY WITH "ABX","X"
    DO CASE
        CASE ONECH="Q"
            RETURN
    ENDCASE
ENDDO
RETURN

PROCEDURE MAKESN
D1=DATE()
T1=TIME()
Y1=RIGHT(STR(YEAR(D1)),1)
M2="0"+LTRIM(STR(MONTH(D1)))
M2=RIGHT(M2,2)
M1="0"+LTRIM(STR(CFG_IBN))
M1=RIGHT(M1,2)
D2="0"+LTRIM(STR(DAY(D1)))
D2=RIGHT(D2,2)
T2=SUBSTR(T1,1,2)
T3=SUBSTR(T1,4,2)
T4=SUBSTR(T1,7,2)
SN="SN"+Y1+M2+D2+M1+T2+T3+T4
RETURN

PROCEDURE MAKEPKTS
I=1
do while i<=maxgal
    if I<>CFG_IBN
        beenmade=.f.
        if i>1
            j=i-1
            do while j>0
                if routidx[j]=routidx[i]
                    g=j
                    beenmade=.t.
                endif
                j=j-1
            enddo
        endif
        if .not. beenmade
            SELECT 5
            GO TOP
            SKIP I-1
            ?   chr(254)+ " Creating packet for: " + trim(node->bbsname)
            do makefn
            DO MAKESN
            fns[i]=fn
            IF "@" $ CFG_EML
                FRM=SUBSTR(CFG_EML,1,AT("@",CFG_EML)-1)
            ELSE
                FRM=CFG_EML
            ENDIF
            DO W2MAIL WITH "F:"+FRM,FN
            DO W2MAIL WITH "T:"+TRIM(NODE->ADDRESS),FN
            DO W2MAIL WITH "S:"+SN,FN
            DO W2MAIL WITH "",FN
            DO W2MAIL WITH "=START=",FN
        else
            fns[i]=fns[g]
        endif
    else
        fns[i]="MYNODE.LOG"
    endif
    i=i+1
enddo
return

procedure makefn
fn="0"+ltrim(str(CFG_IBN))
LP="0000000"+LTRIM(STR(LASTPKT))
LP=RIGHT(LP,6)
FN=HOMEPATH()+"OUTBOUND\"+FN+LP+".SDN"
LASTPKT=LASTPKT+1
RETURN

PROCEDURE ADDHIST
PARAMETERS INSTR
AT1=AT("SN",INSTR)
IF AT1>0
    AT2=LEN(INSTR)-(AT1+1)
    INSTR=SUBSTR(INSTR,AT1+2,AT2)
ENDIF
SELECT 4
GO TOP
LOCATE FOR HIST->SN=INSTR
IF FOUND()
    BEENUSED=.T.
ELSE
    BEENUSED=.F.
    APPEND BLANK
    REPLACE HIST->SN WITH INSTR
ENDIF
RETURN

PROCEDURE INBOUND
PARAMETERS GL

IF FILE(gl)
    ?   "@ Reading file " + gl
    ?
    STARTIT=.F.
    FOPEN FPTR3 &gl 10 2048
    FLREAD FPTR3 SIZE REC
    DO WHILE SIZE>0
        ibstr=crtrim(rec)
        if len(ibstr)>0
            if AT("S: SN",IBSTR)>0
                do addhist with ibstr
                STARTIT=.F.
            endif
            IF STARTIT
                IF SUBSTR(IBSTR,1,1)="!"
                    ?   "Parsing " + ibstr
                    DO PARSE1 WITH IBSTR
                ENDIF
                IF SUBSTR(IBSTR,1,1)="&"
                    DO ACTION WITH IBSTR
                ENDIF
            ENDIF
            if at("=START=",IBSTR)>0
                STARTIT=.T.
            ENDIF
            IF AT("=END=",IBSTR)>0
                STARTIT=.F.
            ENDIF
        endif
        FLREAD FPTR3 SIZE REC
    ENDDO
    fclose fptr3
    erase &gl
else
    ?   "! Error opening file: " + gl
endif
RETURN

*   01=Message
*   02=Trade            (&01,A,01,A,02,food,ore,troops)
*   03=Raid             (&01,A,01,A,03,troops,fighters,HeavyCruisers)
*   04=Probe            (&01,A,01,A,04)
*   05=Return from raid (&01,A,01,A,05,troops,fighters,HeavyCruisers,foodp,orep,soldierp,money)
*   06=Return from probe(&01,A,01,A,06,troops,defstations,insurgency)

procedure action
parameters instr
private acts[12]

?   "Performing action on " + instr

i=1
do while i<=12
    acts[i]=""
    i=i+1
enddo

i=1
tstr=substr(instr,2,len(instr)-2)
xyz=at(',',tstr)
do while i<=12
    acts[i]=trim(substr(tstr,1,xyz-1))
    tstr=trim(substr(tstr,xyz+1,len(tstr)-xyz+1))
    xyz=at(',',tstr)
    ?   "acts["+ltrim(str(i))+"]="+acts[i]
    i=i+1
enddo
wait

IbSyfrom=val(acts[1])
IbDyFrom=acts[2]
IbSyto  =val(acts[3])
IbDyTo  =acts[4]
IbAct   =val(acts[5])

FTSTR="&"+acts[3]+","+acts[4]+","+acts[1]+","+acts[2]+","

DO TOFROM WITH ibsyto, ibdyto, ibsyfrom, ibdyfrom

if IbAct=1 
    IF "MESSAGE START" $ upper(acts[6])
        ?   ACTS[7]
        WAIT
        DO ADDHIST WITH ACTS[7]
        do gettowho with ibdyto
        do w2mail with ibbs->key,towho
        do w2mail with ltrim(str(ibbs->galnum)),towho
    else
        IF .not. "MESSAGE END" $ upper(acts[6])
            DO w2mail WITH ACTS[6],towho
        ENDIF
    ENDIF
endif

IF IBACT=2
    DO ADDHIST WITH ACTS[9]
    IF .NOT. BEENUSED
        PRIVATE IBS[3],ibs1[3]
        IBS[1]="FOOD"
        IBS[2]="CREDITS"
        IBS[3]="TROOPS"
        ibs1[1]=" Megatons worth of Food"
        ibs1[2]=" Credits worth of Ore"
        ibs1[3]=" Troops for your army"
        I=7
        DO WHILE I<=9
            IF VAL(ACTS[I])>0
                SELECT 3
                ibsstr=ibs[i-6]
                REPLACE OTHR->&IBSstr with OTHR->&IBSstr + val(acts[i]) 
                select 5
                go top
                skip ibbs->galnum - 1
                DO W2MAIL WITH "("+DTOC(DATE())+")("+TIME()+")",HOMEPATH()+"MAIL\GLOBAL."+OTHR->KEY
                do W2MAIL with trim(ibbs->dynastynam)+ " of " + trim(node->bbsname) + " has sent you " + acts[i] + ibs1[i-6],HOMEPATH()+"MAIL\GLOBAL."+OTHR->KEY
            ENDIF
            I=I+1
        ENDDO
    ENDIF
ENDIF

IF IBACT=4
    DO ADDHIST WITH ACTS[6]
    IF .NOT. BEENUSED
        I=1
        LIVE=.T.
        DO WHILE I>0 .AND. LIVE
            DO HILO WITH 1,100
            IF RND_RET > 50
                LIVE=.F.
            ENDIF
            I=I-1
        ENDDO
        IF LIVE
            select 5
            go top
            skip ibbs->galnum - 1
            STR1="&"+FTSTR+"06,"+LTRIM(STR(OTHR->TROOPS))+","+LTRIM(STR(OTHR->DEFSTATNS))+","+ltrim(str(othr->insurgency))+acts[6]
            DO W2MAIL WITH workdir+STR1,"ACTIONS.OUT"
            DO W2MAIL WITH "("+DTOC(DATE())+")("+TIME()+")",HOMEPATH()+"MAIL\GLOBAL."+OTHR->KEY
            do W2MAIL with trim(ibbs->dynastynam)+"'s probe has evaded all your Cover Agents",HOMEPATH()+"MAIL\GLOBAL."+OTHR->KEY
            do W2MAIL with "and is returning to "+trim(node->bbsname)+" with your vital information!",HOMEPATH()+"MAIL\GLOBAL."+OTHR->KEY
        ELSE
            select 5
            go top
            skip ibbs->galnum - 1
            STR1="&"+FTSTR+"06,0,0,0,"+acts[6]
            DO W2MAIL WITH workdir+STR1,"ACTIONS.OUT"
            DO W2MAIL WITH "("+DTOC(DATE())+")("+TIME()+")",HOMEPATH()+"MAIL\GLOBAL."+OTHR->KEY
            do W2MAIL with trim(ibbs->dynastynam)+" of " + trim(node->bbsname)+ " attempted to probe your dynasty.",HOMEPATH()+"MAIL\GLOBAL."+OTHR->KEY
        ENDIF
    ENDIF
ENDIF

return


procedure tofrom
parameters t1,t2,f1,f2

select 2
go top
done=.f.
do while .not. done .and. .not. eof()
    if ibbs->galnum=f1 .and. ibbs->key=f2
        done=.t.
    endif
    skip
enddo

select 3
go top
locate for upper(trim(othr->key))=upper(trim(t2))
if found()
else
endif

select 5
go top
locate for ltrim(str(node->number))=ltrim(str(f1))
if found()
else
    ?   "Error finding proper node!"
    wait
endif

G1="0"+LTRIM(STR(IBBS->GALNUM))
G1=RIGHT(G1,2)
G2="0"+LTRIM(STR(NODE->NUMBER))
G2=RIGHT(G2,2)
return

PROCEDURE LATERPROC
PARAMETERS INSTR1,INSTR2
INSTR1=SUBSTR(INSTR1,3,LEN(INSTR1)-3)
INSTR2=SUBSTR(INSTR3,3,LEN(INSTR3)-3)
Y1=VAL(SUBSTR(INSTR1,1,1))+90
Y2=VAL(SUBSTR(INSTR2,1,1))+90
M1=VAL(SUBSTR(INSTR1,2,2))
M2=VAL(SUBSTR(INSTR2,2,2))
D1=VAL(SUBSTR(INSTR1,4,2))
D2=VAL(SUBSTR(INSTR2,4,2))

H1=VAL(SUBSTR(INSTR1,8,2))
H2=VAL(SUBSTR(INSTR2,8,2))
N1=VAL(SUBSTR(INSTR1,10,2))
N2=VAL(SUBSTR(INSTR2,10,2))
S1=VAL(SUBSTR(INSTR1,12,2))
S2=VAL(SUBSTR(INSTR2,12,2))

IF Y1>Y2
    LATER=.T.
ELSE
    IF M1>M2
        LATER=.T.
    ELSE
        IF D1>D2
            LATER=.T.
        ELSE
            IF H1>H2
                LATER=.T.
            ELSE
                IF N1>N2
                    LATER=.T.
                ELSE
                    IF S1>S2
                        LATER=.T.
                    ELSE
                        LATER=.F.
                    ENDIF
                ENDIF
            ENDIF
        ENDIF
    ENDIF
ENDIF
RETURN


PROCEDURE GETTOWHO
PARAMETERS OTHRKEY
I=1
DO WHILE I<=999
    A=LTRIM(STR(I))
    FN="MAIL\MAIL"+OTHRKEY+"."+A
    IF .NOT. FILE(FN)
        TOWHO=FN
        RETURN
    ENDIF
    I=I+1
ENDDO
RETURN
