program Onelinerz;
{
Tiny's Onelinerz  - Version 0.03/DOS
Last Updated: 08/20/2010

 - Display the live bbs-scene.org onelinerz list.

 Todo

 Done - Menu to add a oneliner or quit
      - Header ascii for it
      - Figure out a whole batchfile mess for running / etc.

 History
        - 02/03/2010 - version 0.01
        - 08/10/2010 - version 0.02
        - 08/20/2010 - version 0.03 - Fix always display tiny's bbs when adding a new 1liner
}
uses
  door, 												{Dos Edoor}
  dos,
  crt,
  dspin;

var
  Quit: Boolean;
  TheDataFile: String;
  Sendnewliner: String;
  OneLogin: String;
  OnePassword: String;
  OneBBS: String;

function delfile(s: string): boolean;
var f: file;
begin
  assign(f, s);
  {$I-}erase(f);{$I+}
  if ioresult<>0 then delfile:=false else delfile:=true;
end;

function copyfile(source, dest: string): byte;
const bufsize = 64000;
var
  src, dst: file;
  buf: pchar;
  len, nwritten: Integer;
begin
  getmem(buf, bufsize);
  assign(src, source);
  {$I-} reset(src, 1); {$I+}
  if ioresult<>0 then
    begin
      copyfile:=1;
      exit;
    end;
  assign(dst, dest);
  {$I-} rewrite(dst, 1); {$I+}
  if ioresult<>0 then
    begin
      copyfile:=2;
      exit;
    end;
  repeat
    blockread(src, buf^, bufsize, len);
    blockwrite(dst, buf^, len, nwritten);
  until (len = 0) or (len <> nwritten);
  close(src);
  close(dst);
  freemem(buf, bufsize);
  copyfile:=0;
end;

procedure convertunixfile(filename: string);
var
  f: file;
  f1: text;
  s,fn: string;

  fbuf: array[1..2048] of char;
  bufpos: integer;
  buflen: integer;
  ferror: boolean;

  procedure fReadLn(var f : file; var s : string);
  begin
     s[0] := #0;
     repeat
        inc(bufpos);
        if bufpos > buflen then
        begin
           blockread(f,fbuf,sizeof(fbuf),buflen);   { read some more .. }
           if buflen = 0 then        { is this the end of the file? }
           begin
              ferror := true;
              s:='';
              exit;
           end;
           bufpos := 1;              { reset buffer counter }
        end;
        if not (fbuf[bufpos] in [#13, #10]) then
          begin
            s[byte(s[0])+1] := fbuf[bufpos];   { add char to string }
            inc(s[0]); { make pascal string bigger }
          end;
     until (s[0] = #255) or (fbuf[bufpos] = #10); { check for lf or eostring }
     if ((pos(#13, s)>0) or (pos(#10, s)>0)) then s:='';
  end;

begin
  bufpos := 0;
  buflen := 0;
  ferror:=false;

  randomize;
  assign(f, filename);
  {$I-} reset(f,1); {$I+}
  if ioresult<>0 then exit;
  str(random(1000), fn);
  assign(f1, fn);
  {$I-} rewrite(f1); {$I+}
  while ferror=false do
    begin
      freadln(f, s);
      if ferror=false then writeln(f1, s);
    end;
  close(f);
  close(f1);
  delfile(filename);
  copyfile(fn, filename);
  delfile(fn);
end;


Procedure HitEnter;
var
  X,Y: Byte;
  ch: Char;
begin
  X   := WhereX;                          (* Where am I ??         *)
  Y   := WhereY;
  repeat
    DGotoXY(X,Y);
    DPipe(Center('|15Press |04<|12ENTER|04> |15To continue.'));
    ch := ReadKeySpin(40);
  until ch = #13;
end;

Procedure ReadTheConfig;
var
  f: Text;
  s: String;
begin
  Assign(F, cfgfn);
  Reset(F);
  ReadLn(F, s);
  ReadLn(F, s);
  ReadLn(F, s);
  ReadLn(F, s);
  ReadLn(F, TheDataFile);
  ReadLn(F, SendNewLiner);
  ReadLn(F, Onelogin);
  ReadLn(F, OnePassword);
  ReadLN(F, OneBBS);
  Close(F);
end;


Procedure ReadDataFile;
var
  F: Text;
  S: String; {JUnk String}
  Allfinished: Boolean;
begin
  Allfinished:= False;
  Assign(F, TheDataFile);
  {$I-}reset(F);{$I+}
  if ioresult<>0 then 								{Error checking on this one}
  begin
    DCLrSCr;
    DWriteLN('data file does not exist.');
    HitEnter;
    Halt;
  end;
  ReadLn(F, s);         {xml version}
  ReadLn(F, s);         {root}
  {Now get to the root ie: reading between <node> and </node> }
  While not EOF(F) do
  begin
    ReadLn(F, s);         {Node}
    ReadLn(f, s);         {ID}
    ReadLN(f, s);         {OneLIner}
    Delete(s, 1, Pos('>', s));
    Delete(s, Pos('<', s), Length(s));
    DPipe('|07' + s);
    ReadLN(f, s);         {Alias}
    Delete(s, 1, Pos('>', s));
    Delete(s, Pos('<', s), Length(s));
    DPipe('[|15' + s + '|07]');
    ReadLN(f, s);         {BBSName}
    Delete(s, 1, Pos('>', s));
    Delete(s, Pos('<', s), Length(s));
    DPipeLn(' - |09' + s);
    ReadLn(f, s);         {timestamp}
    ReadLn(f, s);         {Node}
    if s = '</root>' then allfinished := true;
  end;
  Close(F);
  DPipeLn('|07 ---------------------------------------------------------------------------');
end;

Procedure Addliner;
var
  Addthis: String;
  AddHandle: String;
  F: Text;
  Saveit: Boolean;
begin
  DClrScr;
  DPipe('|14Say what? ');
  Inpt(Addthis, 55, 11, 1);
  AddHandle := UserH;
  Delete(Addhandle, 16, Length(Addhandle));
  DCrlf;
  DPipeLn('|07' + AddThis + ' [|15' + AddHandle + '|07] - |11' + bbsname);
  saveit:=Dnylb('Add this?', '|18|12 Yes |16 |01no', '|16|01 yes |17 |12No |16');
  if saveit = true then
  begin
    Assign(F, sendnewliner);
    ReWrite(F);
    Write(F, 'curl.exe -u ' + OneLogin + ':' + OnePassword + ' -X POST -d ');
    Write(F, '"oneliner=' + Addthis + '&alias=' + AddHandle + '&bbsname=' + OneBBS + '"');
    WriteLN(F, ' http://bbs-scene.org/api/onelinerz.xml');
    WriteLn(F, 'exit');
    Close(F);
    Halt;
  end;
end;

Procedure Header;
begin
  DPipe('|07 |15/(_____|07_|15__|07_|15__|07_|15_|07___|15_|07_______|15_');
  DPipeLn('|07_________      __|15_|07_____________________________)\');
  DPipe('|07 |15\   .   |07__|15_|07_|15_|07_      __|15_|07_  _____    |_|15_|07___(_______');
  DPipeLn('____  ____|15_|07_____    /');
DPipeLn('|08:|15/   :   \|08jp|15/   |07:    ||08:|07/  ___||15_|07|_   :     /   \/   :    ||08:|07/  ___|_|_   .   /|08ZZz');
  DPipeLn('|15/    |    |07\/|15__|07_|15_|    |07||15/   |     |07/___     /_________|    |/   |     /___|   \|08:::');
  DPipe('|15`-------|07-|15-''|08:::::|07`--|15-|07-''`-|15-|07------''|08::::|07`-|15-|07-''|08::::::::::|07`--');
  DPipeLn('|15-|07-''`--------''|08::::|07`----''|08::');
  DPipeLn('|04>> |07bbs-scene.org global onlinerz |08::::::::::::::::::::::::::::::::::::::::::::::|07');
end;

Procedure DotheWait;
var
 x,y,j,percent: Integer;
begin
 x:=wherex;
 y:=wherey;
 x:= 20;
 y:= 23;
 percent := 0;
 j := 0;
repeat
   percent:=percent+1;
   Dgotoxy(x,y);
   DPipe('|15Waiting: ');
   for j := 1 to percent div 5 do DPipe('|01');
   for j := 1 to 20-percent div 5 do DPipe('|09');
   DPipe('|15 ');
   DPipe(ItoS(percent));
   DPipe('|13% |15Complete');
   delay (3);
until percent = 100;
(*  DGotoXY(1,23);
  DClrEol;
  DGotoXY(1,23);
  HitEnter;*)
end;


Procedure Menu;
var
  ch: Char;

begin
{ Display the onelinerz }
{ (A)dd a oneliner or (Q)uit }
  While Ch <> 'Q' do
  begin
    DClrScr;
    Header;
    DPipeLn('|07 ---------------------------------------------------------------------------');
    ReadDataFile;              {Redisply file}
    DGotoXY(1, 23);   {Goto bottom of screen past border and ask what to do}
    DPipe(Center('|07(|15A|07)dd Oneliner, (|15Q|07)uit / [|15ENTER|07] Quit'));   {Menu Prompt from Config}
    repeat
      Ch := Upcase(ReadKeySpin(40));
    until Ch in ['A','Q',#13];
    case ch of
      'A': AddLiner;
      #13: ch := 'Q';
    end;
    {Put closing add here}
    DClrscr;
    DPipeLn('|07Internet access using the great |12CURL|07 for Windows.');
    DPipeLn('|15Door Library is the amazing |12Edoor|15 for DOS.');
    DpipeLn('|11Freeware by: |10Shawn Highfield');
    Dcrlf;
    DPipeLn('|13http://www.tinysbbs.com');
    Dcrlf;
    DPipeLn('|09telnet://tinysbbs.com');
    Dcrlf;
    DoTheWait;
  end;
end;


begin
  if (ParamStr(1) = '/?') or (ParamStr(1) = '?') then
  begin
    DClrScr;
    WriteLn('           Tiny''s Onelinerz Version 0.01');
    WriteLn('           -----------------------------');
    WriteLn;
    WriteLn('/?   - This screen ');
    WriteLn('/B#  - Sets the locked baud rate to #, ex. 1linerz.exe /B57600 ');
    WriteLn('/D?  - Path to where the Drop file is found, ex. 1linerz.exe /Dc:\bbs ');
    WriteLn('/L   - Local Mode ');
    WriteLn('/Nx  - x is the node number, ex. 1linerz.exe /N1 ');
    Halt(1);
  end;
{Edoor Begin}
  doorname := 'Tiny''s Onelinerz';
  cfgfn := '1linerz.cfg';
  loadcfg;
{Edoor Ends}
  quit := False;
  fg(7);
  ReadTheConfig;
  ConvertUnixFIle(TheDataFile);
  DClrScr;
  Menu;
end.
