#!/usr/bin/perl

# Enthral SVN: $Id: rdmliner.pl 82 2010-10-13 00:36:32Z frank $
# Source: $HeadURL$
# $LastChangedDate: 2010-10-12 20:36:32 -0400 (Tue, 12 Oct 2010) $
# $LastChangedRevision: 82 $
# $LastChangedBy: frank $

# bbs-scene.org random onelinerz
# written by Frank Linhares aka Netsurge
# frank@bbs-scene.org
#
# Simply run the script in your command shell where you want the radom oneliner to appear:
#
# ./rdmliner.pl
#
# Configure your variables below

# Use modules
use XML::Simple;

# Configure your bbs-scene.org username and password
my $username   = "email\@bbs-scene.org"; 	     # bbs-scene.org username. Remember to escape the @ with a \
my $password   = "password";					 # bbs-scene.org password.
my $linerzpath = "/usr/sbbs/mods/rdmliner/";     # Path to rdmliner directory
my $curlpath   = "/usr/bin/curl";                # Path to Curl

# DO NOT EDIT BELOW

# Grab random onelinerz

system("$curlpath --max-time 2 -u $username:$password http://bbs-scene.org/api/onelinerz.php?random > rdmliner.xml 2>/dev/null");

# create xml object
$xml = new XML::Simple();

&stripIllegal($xml);

# read XML file
$data = $xml->XMLin("rdmliner.xml") or die "Can't process rdmliner.xml : $!";


    $oneliner = " \e[37;0m"
      . $data->{node}->{oneliner}
      . " \e[30;1m(\e[37;1m"
      . $data->{node}->{alias}
      . "\e[34;1m/\e[36;1m" . $data->{node}->{bbsname} . "\e[30;1m) \e[30;0m";

    $oneliner = substr($oneliner,0,121);

    print $oneliner
      . "\n";

sub stripIllegal {
        my ( $input ) = @_;
        # allowed: [#x1-#xD7FF] | [#xE000-#xFFFD] | [#x10000-#x10FFFF]
        $input =~ s/[^\x01-\x{D7FF}\x{E000}-\x{FFFD}\x{10000}-\x{10FFFF}]//go;
        # restricted:[#x1-#x8][#xB-#xC][#xE-#x1F][#x7F-#x84][#x86-#x9F]
        $input =~ s/[\x01-\x08\x0B-\x0C\x0E-\x1F\x7F-\x84\x86-\x9F]//go;
        # Strip any backslashes and illegal characters from the user input
    $input =~ s/\\\\([^\\\\])/$1/g;
}