#!/usr/bin/perl

# Enthral SVN: $Id: onelinerz.pl 72 2010-10-03 04:10:17Z frank $
# Source: $HeadURL$
# $LastChangedDate: 2010-10-03 00:10:17 -0400 (Sun, 03 Oct 2010) $
# $LastChangedRevision: 72 $
# $LastChangedBy: frank $

# bbs-scene.org global onelinerz
# written by Frank Linhares aka Netsurge
# frank@bbs-scene.org
#
# Pass the user's alias on the commandline like this:
#
# ./onelinerz.pl "users_alias"
#
# Configure your variables below

# Use modules
use XML::Simple;
use LWP::UserAgent;

# Configure your bbs-scene.org username and password
my $bbsname    = "BBS Name";              		 # set your bbs name
my $username   = "email\@bbs-scene.org"; 	     # bbs-scene.org username. Remember to escape the @ with a \
my $password   = "password";					 # bbs-scene.org password.
my $linerzpath = "/usr/sbbs/mods/onelinerz/";    # Path to onelinerz directory
my $header     = "onelinerz.ans";                # header file name
my $limit      = 13;                             # Last x oneliners
my @twit	   = ("Guest","Jackass");   		 # Aliases not allowed to post

# User input backspaces
system("stty erase ^H");

$oheader = $linerzpath . "/" . $header;
my $url	= "http://bbs-scene.org/api/onelinerz.php?limit";
my $api = $url . "=" . $limit;

my $xmlresponse = &bbssceneApiGet($username, $password, $api);

# Display Header
open( FILE, "< $oheader" ) or die "Can't open $header : $!";

while (<FILE>) {
    print;
}

close FILE;
print
"\e[30;1m-------------------------------------------------------------------------------\n";

# create xml object
$xml = new XML::Simple( KeyAttr => [] );

&stripIllegal($xml);  

# read XML file
$data = $xml->XMLin("$xmlresponse") or die "Can't process onelinerz.xml : $!";

my $i = 0;

# access <node> array
foreach $e ( @{ $data->{node} } ) {

    $oneliner = " \e[30;1m(\e[37;1m"
      . $e->{alias}
      . "\e[34;1m/\e[36;1m" . $e->{bbsname} . "\e[30;1m) \e[30;0m"
      . $e->{oneliner};

        $oneliner = substr($oneliner,0,121);

    print $oneliner
      . "\n";

    # Increment the loop counter
    $i++;

    # Check if we've hit the limit
    if ( $i >= $limit ) {

        # Leave the loop
        last;
    }
}

# Print footer
print
"\e[30;1m-------------------------------------------------------------------------------\n";

# If matches no user
if (grep /^$ARGV[$0]$/i, @twit ) {

	print "\e[30;0myou're not allowed to post a oneliner.\n";

	sleep 3;
	print"\e[2J";
	exit 0;
	
} else {
	
	# Add a oneliner ?
	$addliner = &promptUser("\e[30;0madd a oneliner to bbs-scene.org \e[30;1m.\e[37;1my\e[30;1m/\e[37;1mn\e[30;1m. ");

# Process answer
	if ( $addliner =~ m/y/ ) {
    	$response = oneliner();
    	&bbssceneApiPost($username, $password, $bbsname, $ARGV[$0], $response);
		print "\e[2J";
	}
	else {
    	print "\e[2J";
    	exit 0;
	}
}

sub stripIllegal {
	my ( $input ) = @_;
	# allowed: [#x1-#xD7FF] | [#xE000-#xFFFD] | [#x10000-#x10FFFF]
	$input =~ s/[^\x01-\x{D7FF}\x{E000}-\x{FFFD}\x{10000}-\x{10FFFF}]//go;
	# restricted:[#x1-#x8][#xB-#xC][#xE-#x1F][#x7F-#x84][#x86-#x9F]
	$input =~ s/[\x01-\x08\x0B-\x0C\x0E-\x1F\x7F-\x84\x86-\x9F]//go;
	# Strip any backslashes and illegal characters from the user input
    $input =~ s/\\\\([^\\\\])/$1/g;
}

sub promptUser {
    my ( $prompt, $default ) = @_;
    my $defaultValue = $default ? "[$default]" : "";
    print "$prompt$defaultValue: ";
    chomp( my $input = <STDIN> );
    return $input ? $input : $default;
}

sub oneliner {
    # Prompt for oneliner
    $oneliner = &promptUser("");

    # If oneliner is empty clear screen then exit
    if ( $oneliner eq "" ) {
        print "\e[2J";
        exit 0;
    }
	
	&stripIllegal($oneliner);
	return $oneliner;
}
 
sub bbssceneApiGet {
	my ( $username, $password, $api) = @_;
	my $entrybrowser = LWP::UserAgent->new;                 
	$entrybrowser->agent('bbssceneapi/1.01');
	$entrybrowser->timeout(2);
	$entrybrowser->credentials('bbs-scene.org:80','bbs-scene.org api',$username => $password);
	my $entry = $entrybrowser->get($api);
	$output = $entry->decoded_content;
	return $output;
}

sub bbssceneApiPost {
	my ( $username, $password, $bbsname, $alias, $oneliner) = @_;
	my $postbrowser = new LWP::UserAgent;
	$postbrowser->agent('bbssceneapi/1.01');
	$postbrowser->timeout(2);
	$postbrowser->credentials('bbs-scene.org:80','bbs-scene.org api',$username => $password);
	my $post = $postbrowser->post('http://bbs-scene.org/api/onelinerz.xml', 
	{ bbsname => $bbsname, 
	alias => $alias,
	oneliner => $oneliner, 
	});	
}