Uses Cfg

Type
	NLRec	= Record
	Zone	: String
	Net	: String
	Node	: String
	Region	: String
	BBS	: String
	Loc	: String
	Sysop	: String
	Extra	: String
	URL	: String
End

Var NLFiles	: Array [1..20] Of String
Var Entry	: NLRec
Var NLI		: Byte
Var num		: String
Var NTyp	: String
Var F1		: File


Function FindRawNodeList(NL: String):String
Var JD	: Integer
Var Dt,S: String
Begin
	Dt:=DateStr(DateTime,1)
	Delete(Dt,1,6)
	Dt:='01/01/'+Dt
	JD:=DaysAgo(Date2Julian(Dt))+1

	Repeat
		S:=NL+'.'+PadLt(Int2Str(JD),3,'0')
		JD:=JD-1
	Until FileExist(S) or JD<1
	FindRawNodeList:=S
End

Function ReadConfig : Boolean
Var	fptr	: File
VAr	Ret	: Boolean=False
Begin
	fAssign(fptr,CfgDataPath+'parsenl.cfg',66)	
	fReset(fptr)
	If IOResult = 0 Then Begin
		NLI:=0
		While Not fEof(Fptr) Do Begin
			NLI:=NLI+1
			fReadLn(fptr,NLFiles[NLI])
		End
		Ret:=True	
		fClose(fptr)
	End
	ReadConfig:=Ret
End

Procedure ParseNL(NL: String)
VAr NLPtr	: File
Var S		: String
Begin
	fAssign(NLPtr,NL,66)
	fReset(NLPtr)	
	If IOResult = 0 Then Begin
		While Not fEof(NLPtr) Do Begin
			fReadLn(NLPtr,S)
			If Pos(';',S) <> 1 Then Begin
				S:=Replace(S,'_',' ')
				If Pos(',',S) <> 1 Then Begin
					NTyp :=WordGet(1,S,',')
					Entry.Node :=WordGet(2,S,',')
					Entry.BBS  :=WordGet(3,S,',')
					Entry.Loc  :=WordGet(4,S,',')
					Entry.Sysop:=WordGet(5,S,',')
					Entry.Extra:=WordGet(6,S,',')
				End Else Begin
					NTyp :='Node'
					Entry.Node :=WordGet(1,S,',')
					Entry.BBS  :=WordGet(2,S,',')
					Entry.Loc  :=WordGet(3,S,',')
					Entry.Sysop:=WordGet(4,S,',')
					Entry.Extra:=WordGet(5,S,',')
				End
				Entry.URL:=''
				If Pos(':',S) > 0 Then Begin
					Entry.URL:=WordGet(2,S,':')
					Entry.URL:=WordGet(1,Entry.URL,',')
				End

				If NTyp = 'Zone' Then Begin
					Entry.Zone:=Entry.Node
					Entry.Net:=Entry.Node
					Entry.Node:='0'
				End
				If NTyp = 'Host' Then Begin
					Entry.Net:=Entry.Node
					Entry.Node:='0'
				End
				If NTyp = 'Hub' Then Begin
					Entry.Node:=Entry.Node
				End
				If NTyp = 'Pvt' Then Begin
					Entry.Node:=Entry.Node
				End
				If NTyp = 'Region' Then Begin
					Entry.Region:=Entry.Node
					Entry.Net:=Entry.Node
				End
				Num:=Entry.Zone+':'+Entry.Net+'/'+Entry.Node
				WriteLn(PadRt(Num,11,' ')+' '+PadRt(Entry.Sysop,20,' ')+' '+PadRt(Entry.BBs,20,' ')+' '+Entry.URL)
				fWrite(F1,Entry,SizeOf(Entry))
			End
		End
		fClose(NLPtr)
	End
End

Procedure Main
Var I		: Byte
Var Path	: String
Begin
	Path:=CfgDataPath+'nodelist.dat'
	fAssign(F1,Path,66)
	fReWrite(F1)
	If ReadConfig Then Begin
		For I:=1 To NLI Do Begin
			ParseNL(FindRawNodeList(NLFiles[I]))
		End
	End
	fClose(F1)
End

Begin
	Main
	pause
End
