Uses Cfg
Uses User

Const
	ProgName	= 'Gryphon''s Greed'
	ProgVer 	= 'v1.0'
	ProgAuth	= 'Darryl Perry, aka Gryphon, 2012'
	COLS		= 80
	ROWS		= 22
	ScoreFile	= 'scor5.ans'

Type
	Top10Rec	= Record
	Alias	: String[30]
	Date	: String[10]
	Cleared : LongInt
End

Var Top10	: Array [1..11] of Top10Rec
Var TT		: Top10Rec
Var Me		: Top10Rec
Var NUMB	: Array [1..80,1..22] of Byte
Var COLR  	: Array [1..80,1..22] of Byte
Var MyX,MyY	: Byte
Var Score 	: LongInt
Var Top10f	: String
Var Top10p	: File 
Var GameOver 	: Boolean
Var M		: String


Procedure SaveTT
Var L : Byte
Begin
	fAssign(Top10p,Top10f,66)
	fReWrite(Top10p)
	L:=1
	While L <= 10 Do Begin
		TT:=Top10[L]
		fWrite(Top10p,TT,SizeOf(TT))
		L:=L+1
	End
	fClose(Top10p)
End

Procedure ReadTopTen 
Var P1	: File
Var L	: Byte
Begin
	L:=1
	If FileExist(Top10f) Then Begin
		fAssign(Top10p,Top10f,66)
		fReset(Top10p)
		While Not fEof(Top10p) And L <= 10 Do Begin
			fRead(Top10p,TT,SizeOf(TT))
			Top10[L]:=TT
			L:=L+1
		End
		fClose(Top10p)
	End Else Begin
		For L:=1 To 10 Do Begin
			Top10[L].Alias:='No Name'
			Top10[L].Date:='11/11/11'
			Top10[L].Cleared:=0
		End
		SaveTT
	End
	
End


Function Score2Str(Sc:LongInt):String
Var F,B	: Integer
Begin
	Score:=(sc*100)/(COLS*ROWS)*100
	F:=Score/100
	B:=Score-(F*100)
	Score2Str:=Int2Str(F)+'.'+PadLt(Int2Str(B),2,'0')
End

Procedure MakeTopTenScores 
Var L	: Byte
Var F	: File
Begin
	fAssign(F,CfgTextPath+ScoreFile,66)
	fRewrite(F)
	fWriteLn(F,'|CL|CR|CR            |03/-|01[|10'+ProgName+' ' + ProgVer + ' |09Top Ten Scores |01]|03------|03\')
	fWriteLn(F,'            |03:                                             |03:') 
	fWriteLn(F,'            |03: |11Rank Player          Date     Score Perecnt |03:')
	fWriteLn(F,'            |03: ---- --------------- -------- ----- ------- |03:')
	L:=1
	While L <= 10 Do Begin
		FWriteLn(F,'            |03: |01'+PadLt(Int2Str(L),4,' ')+ ' |10' + PadRt(Top10[L].Alias,15,' ') + ' |08' + Top10[L].Date + ' |12' + PadLt(Int2Str(Top10[L].Cleared),5,' ')  + ' |11' + PadLt(Score2Str(Top10[L].Cleared),6,' ')+'% |03:')
		L:=L+1
	End
	fWriteLn(F,'            |03>---------------------------------------------<')
	fWriteLn(F,'            |03:   |11A Mystic BBS MPL by Darryl Perry, 2012    |03:')
	fWriteLn(F,'            |03\---------------------------------------------/')
	fWriteLn(F,'                          |11:|08:|03: |09Any Key |03:|08:|11:|PN')
	fClose(F)
End

Procedure Insert2TT
Var L,X	: Byte
Begin
	Top10[11]:=Me
	For L:=1 To 10 Do Begin
		For X:=1 To 10 Do Begin
			If Top10[X+1].Cleared > Top10[X].Cleared Then Begin
				TT:=Top10[X]
				Top10[X]:=Top10[X+1]
				Top10[X+1]:=TT		
			End
		End
	End
	SaveTT	
End


Procedure UpdateField(A:Boolean)
Var  X,Y	: Byte
Begin
	Me.Cleared:=0
	For X:=1 to COLS Do Begin
		For Y:=1 to ROWS Do Begin
			If COLR[X,Y] = 0 Or NUMB[X,Y] = 0 Then Begin
				GoToXy(X,Y)
				Write('|16|00 ')
				Me.Cleared:=Me.Cleared+1
			End Else Begin
				If A Then Begin
					GoToXy(X,Y)
					Write('|16|'+PadLt(Int2Str(COLR[X,Y]),2,'0')+Int2Str(NUMB[X,Y]))
				End
			End
		End
	End
End

Procedure InitGame
Var  X,Y  : Byte
Begin
	ClrScr
	For X:=1 to COLS Do Begin
		For Y:=1 to ROWS Do Begin
			NUMB[X,Y]:=Random(9)+1
			COLR[X,Y]:=Random(15)+1
		End
	End
	MyX:=Random(COLS)+1
	MyY:=Random(ROWS)+1
	NUMB[MyX,MyY]:=0
	COLR[MyX,MyY]:=0
End

Procedure TestDir(StartX,StartY, Dr : Byte; Vis : Boolean):Boolean
Var Ret	: Boolean
Var X,Y : Byte
Var A,B : Byte
Var C,D : Byte
Var J,K	: Byte
Begin
	Ret:=True
	Case Dr of
		1:Begin // South West 
			B:=StartX-1
			C:=StartY+1
			K:=NUMB[B,C]
			A:=StartX-K
			D:=StartY+K
			If D > ROWS or C > D Then 
				Ret:=False
			If B > COLS or A > B Then
				Ret:=False
			If Ret Then Begin
				J:=1
				While J <= K And Ret Do Begin
					If NUMB[StartX-J,StartY+J] = 0 Then
						Ret:=False
					If Ret And Vis Then Begin
						GoToXY(StartX-J,StartY+J)
						Write('|23|'+PadLt(Int2Str(COLR[StartX-J,StartY+J]),2,'0')+Int2Str(NUMB[StartX-J,StartY+J]))
					End
					J:=J+1
				End
			End
		  End
		2:Begin // Down
			C:=StartY+1
			D:=StartY+NUMB[StartX,C]
			K:=NUMB[StartX,C]
			If D > ROWS or C > D Then 
				Ret:=False
			If Ret Then Begin
				J:=1
				While J <= K And Ret Do Begin
					If NUMB[StartX,StartY+J] = 0 Then
						Ret:=False
					If Ret And Vis Then Begin
						GoToXy(StartX,StartY+J)
						Write('|23|'+PadLt(Int2Str(COLR[StartX,StartY+J]),2,'0')+Int2Str(NUMB[StartX,StartY+J]))
					End
					J:=J+1
				End
			End
		  End	
		3:Begin // South East
			C:=StartY+1
			A:=StartX+1
			K:=NUMB[A,C]
			D:=StartY+K
			B:=StartX+K
			If D > ROWS or C > D Then 
				Ret:=False
			If B > COLS or A > B Then 
				Ret:=False
			If Ret Then Begin
				J:=1
				While J <= K And Ret Do Begin
					If NUMB[StartX+J,StartY+J] = 0 Then 
						Ret:=False
					If Ret And Vis Then Begin
						GoToXY(StartX+J,StartY+J)
						Write('|23|'+PadLt(Int2Str(COLR[StartX+J,StartY+J]),2,'0')+Int2Str(NUMB[StartX+J,StartY+J]))
					End
					J:=J+1
				End
			End
		  End
		4:Begin	// To the Left 
			B:=StartX-1
			A:=StartX-NUMB[B,StartY]	
			K:=NUMB[B,StartY]
			If A < 1 or A > B Then 
				Ret:=False
			If Ret Then Begin
				J:=1
				While J <= K And Ret Do Begin
					If NUMB[StartX-J,StartY] = 0 Then
						Ret:=False
					If Ret And Vis Then Begin
						GoToXy(StartX-J,StartY)
						Write('|2323|'+PadLt(Int2Str(COLR[StartX-J,StartY]),2,'0')+Int2Str(NUMB[StartX-J,StartY]))
					End
					J:=J+1
				End
			End
		  End
		5:Ret:=False
		6:Begin	// To the Right
			A:=StartX+1
			B:=StartX+NUMB[A,StartY]	
			K:=NUMB[A,StartY]
			If B > COLS Or A > B Then 
				Ret:=False
			If Ret Then Begin
				J:=1
				While J <= K And Ret Do Begin
					If NUMB[StartX+J,StartY] = 0 Then
						Ret:=False
					If Ret And Vis Then Begin	
						GoToXy(StartX+J,StartY)
						Write('|23|'+PadLt(Int2Str(COLR[StartX+J,StartY]),2,'0')+Int2Str(NUMB[StartX+J,StartY]))
					End
					J:=J+1
				End
			End
		  End
		7:Begin // North East
			D:=StartY-1
			B:=StartX-1
			K:=NUMB[B,D]
			C:=StartY-K
			A:=StartX-K
			If C < 1 or C > D Then
				Ret:=False
			If A < 1 or A > B Then 
				Ret:=False
			If Ret Then Begin
				J:=1
				While J <= K And Ret Do Begin
					If NUMB[StartX-J,StartY-J] = 0 Then
						Ret:=False
					If Vis And Ret Then Begin
						GoToXY(StartX-J,StartY-J)
						Write('|23|'+PadLt(Int2Str(COLR[StartX-J,StartY-J]),2,'0')+Int2Str(NUMB[StartX-J,StartY-J]))
					End
					J:=J+1
				End
			End
		  End
		8:Begin // Up
			D:=StartY-1
			C:=StartY-NUMB[StartX,D]
			K:=NUMB[StartX,D]
			If C < 1 or C > D Then
				Ret:=False
			J:=1
			While J <= K And Ret Do Begin
				If NUMB[StartX,StartY-J] = 0 Then
					Ret:=False
				If Ret And Vis Then Begin
					GoToXy(StartX,StartY-J)
					Write('|23|'+PadLt(Int2Str(COLR[StartX,StartY-J]),2,'0')+Int2Str(NUMB[StartX,StartY-J]))
				End
				J:=J+1
			End
		  End
		9:Begin // North East
			D:=StartY-1
			A:=StartX+1
			K:=NUMB[A,D]
			C:=StartY-K
			B:=StartX+K
			If C < 1 Or C > D Then 
				Ret:=False
			If B > COLS Or A > B Then 
				Ret:=False

			If Ret Then Begin
				J:=1
				While J <= K And Ret Do Begin
					If NUMB[StartX+J,StartY-J] = 0 Then
						Ret:=False
					If Vis And Ret Then Begin
						GoToXY(StartX+J,StartY-J)
						Write('|23|'+PadLt(Int2Str(COLR[StartX+J,StartY-J]),2,'0')+Int2Str(NUMB[StartX+J,StartY-J]))
					End
					J:=J+1
				End
			End
		  End
	End
	TestDir:=Ret
End

Procedure GoDir(Ch:Char)
Var A,B	: Byte
Var C,D	: Byte
Var J,K	: Byte
Begin
	Case Ch Of
		'1':Begin // Left Down
			If TestDir(MyX,MyY,1,FALSE) Then Begin
				C:=MyY+1
				A:=MyX-1
				K:=NUMB[A,C]
				D:=MyY+K
				B:=MyX-K
				for J:=1 To K Do Begin
					NUMB[MyX-J,MyY+J]:=0
					GoToXY(MyX-J,MyY+J)
					Write('|11|16 ')
				End
				MyX:=MyX-K
				MyY:=MyY+K
			End Else M:='Bad move.'
		End
		'2':Begin // Down
			If TestDir(MyX,MyY,2,FALSE) Then Begin
				C:=MyY+1
				D:=MyY+NUMB[MyX,C]
				K:=NUMB[MyX,C]
				For J:=1 To K Do Begin
					NUMB[MyX,MyY+J]:=0
					COLR[MyX,MyY+J]:=0
					GoToXy(MyX,MyY+J)
					Write('|23|11@|16')
				End
				MyY:=MyY+K
			End Else M:='Bad Move.'
		End
		'3':Begin // Right Down
			If TestDir(MyX,MyY,3,FALSE) Then Begin
				C:=MyY+1
				A:=MyX+1
				K:=NUMB[A,C]
				D:=MyY+K
				B:=MyX+K
				for J:=1 To K Do Begin
					NUMB[MyX+J,MyY+J]:=0
					GoToXY(MyX+J,MyY+J)
					Write('|11|16 ')
				End
				MyX:=MyX+K
				MyY:=MyY+K
			End Else M:='Bad Move.'
		End
		'4':Begin // Left
			If TestDir(MyX,MyY,4,FALSE) Then Begin
				B:=MyX-1
				A:=MyX-NUMB[B,MyY]
				K:=NUMB[B,MyY]
				If A <= B And B <= COLS Then Begin
					For J:=1 To K Do Begin
						NUMB[MyX-J,MyY]:=0
						COLR[MyX-J,MyY]:=0
						GoToXy(MyX-J,MyY)
						Write('|11|23@|16')
					End
					MyX:=MyX-K
				End
			End Else M:='Bad Move.'
		End
		'6':Begin // Right
			If TestDir(MyX,MyY,6,FALSE) Then  Begin
			A:=MyX+1
				B:=MyX+NUMB[A,MyY]
				K:=NUMB[A,MyY]
				If A <= B And B <= COLS Then Begin
					For J:=1 To K Do Begin
						NUMB[MyX+J,MyY]:=0
						COLR[MyX+J,MyY]:=0
						GoToXy(MyX+J,MyY)
						Write('|11|23@|16')
					End
					MyX:=MyX+K
				End
			End Else M:='Bad Move.'
		End
		'7':Begin // Left Up 
			If TestDir(MyX,MyY,7,FALSE) Then Begin
				B:=MyX-1
				D:=MyY-1
				K:=NUMB[B,D]
				A:=MyX-K
				C:=MyY-K
				for J:=1 To K Do Begin
					NUMB[MyX-J,MyY-J]:=0
					GoToXY(MyX-J,MyY-J)
					Write('|11|16 ')
				End
				MyX:=MyX-K
				MyY:=MyY-K
			End Else M:='Bad Move.'
		End
		'8':Begin // Up
			If TestDir(MyX,MyY,8,FALSE) Then Begin
				D:=MyY-1
				C:=MyY-NUMB[MyX,D]
				K:=NUMB[MyX,D]
				If C <= D And C >= 1  Then Begin
					For J:=1 To K Do Begin
						NUMB[MyX,MyY-J]:=0
						COLR[MyX,MyY-J]:=0
						GoToXy(MyX,MyY-J)
						Write('|11|23@|16')
					End
					MyY:=MyY-K
				End
			End Else M:='Bad Move.'
		    End	
		'9':Begin // Right Up 
			If TestDir(MyX,MyY,9,FALSE) Then Begin
				A:=MyX+1
				D:=MyY-1
				K:=NUMB[A,D]
				B:=MyX+K
				C:=MyY-K
				for J:=1 To K Do Begin
					NUMB[MyX+J,MyY-J]:=0
					GoToXY(MyX+J,MyY-J)
					Write('|11|16 ')
				End
				MyX:=MyX+K
				MyY:=MyY-K
			End Else M:='Bad Move.'
		End
	End
	UpdateField(False)
End

Procedure ShowScore(Msg:String)
Begin
	GoToXy(1,24)
	Write('Score : '+PadLt(Int2Str(Me.Cleared),5,' ') + '  ' +Score2Str(Me.Cleared)+'%')
	GoToXy(40,24)
	Write(PadRt(Msg,38,' '))
End

Procedure GameOverProc
Begin
	GoToXy(23,3) Write('                             ')
	GoToXy(23,4) Write('|03 /------:|01[|10Game Over|01]|03:------\ ')
	GoToXy(23,5) Write('|03 : |11You Cleared '+PadLt(Int2Str(Me.Cleared),4,' ') + ' Spaces |03: ')
	GoToXy(23,6) Write('|03 : |11 for a total of '+PadLt(Score2Str(Me.Cleared),5,' ')+'%  |03: ')
	GoToXy(23,7) Write('|03 \------:|01[|12Space Bar|01]|03:------/|16|07 ')
	GoToXy(23,8) Write('                             ')
	GoToXy(35,8) OneKey(' ',False)
	
	GameOver:=True
End


Procedure Main
VAr Ch	: Char
Var A,B	: Byte
Var C,D	: Byte
var J,K	: Byte
Begin
	UpdateField(True)
	GameOver:=False
	M:=ProgName+' - Hit "?" for Help'
	Repeat
		GoToXy(MyX,MyY)
		Write('|23|11@|16')
		GoToXy(1,24)
		ShowScore(M)
		M:=ProgName+' - Hit "?" for Help'
		Ch:=ReadKey
		If IsArrow Then Begin
			Case Ch Of
				#72:GoDir('8')
				#80:GoDir('2')
				#75:GoDir('4')
				#77:GoDir('6')
			End
		End Else Begin
			Ch:=Upper(Ch)
			Case Ch Of
				'1':GoDir('1')
				'2':GoDir('2')
				'3':GoDir('3')
				'4':GoDir('4')
				'6':GoDir('6')
				'7':GoDir('7')
				'8':GoDir('8')
				'9':GoDir('9')
				'T': Begin
					For J:=1 To 9 Do Begin
						TestDir(MyX,MyY,J,True)	
					End
				End
				'R': UpdateField(True)
				'?': begin DispFile('greedhlp') ; UpdateField(True) End
			End
			
		End
		GameOver:=True
		For J:=1 To 9 Do Begin
			If TestDir(MyX,MyY,J,FALSE) Then
				GameOver:=False
		End
		If GameOver Then
			GameOverProc
	Until Ch = 'Q' Or GameOver
End

Procedure ShowBest
Begin
	WriteLn('|11:|08:|03: |14'+ProgName + ' ' + ProgVer + ' |12by |09' + ProgAuth)
	WriteLn('')
	WriteLn('|14For the Best Play experience:')
	WriteLn('')
	WriteLn(' |12o |14Turn off the terminal status bar (if on)')
	WriteLn('')
	WriteLn(' |12o |14Turn on your NUM LOCK key')
	WriteLn('')
	WriteLn(' |12o |14Use the |09NUMBER PAD |14on the |12RIGHT |14to move the curser')
	WriteLn('')
	WriteLN('                        |147 8 9')
	WriteLn('                        |04 \|/ ')
	WriteLn('                        |144|04-|01o|04-|146')
	WriteLn('                        |04 /|\ ')
	WriteLn('                        |141 2 3')
	WriteLn('')
	WriteLn(' |12o |14Enjoy!')
	WriteLn('')
	Pause
End

Begin
	GetThisUser
	MenuCmd('NA','Playing GREED')
	Me.Alias:=UserAlias
	Me.Date:=DateStr(DateTime,1)
	Top10f:=CfgDataPath+'greed10.dat'
	DispFile('grdsplsh')	
	ReadTopTen
	InitGame
	ShowBest
	Main
	Insert2TT
	MakeTopTenScores
	DispFile(ScoreFile)
End

