// ecFunctions.js v1.0
// echicken@bbs.electronicchicken.com

var bs = String.fromCharCode(8);
var esc = String.fromCharCode(27);

// Strips tags and other unwanted stuff from strings that should be plain text
function clean_input(string) {
	string = strip_exascii(string);
	string = strip_ctrl(string);
	string = truncsp(string);
	string = string.replace(/<(.|\n)*?>/g, "");
	return string;
}

/*	A line input function that parses pipe colour codes on the fly
	len is the length of the input box / maximum number of characters to accept
	paletteX and paletteY are the x and y coordinates of the top left corner of
	the pop-up colour-chooser. (If omitted, the colour-chooser is disabled.) */
// To do: truncate i to zero length if at the end of this function it contains
// only pipe codes and no actual content.
function lineInput(len, paletteX, paletteY) {
	var xy = console.getxy();
	var x = 0;
	var i = "";
	var l = 0;
	while(ascii(x) != 27 && ascii(x) != 13 && l <= len) {
		x = console.getkey();
		if(ascii(x) == 8) {
			if(i.substr(i.length - 3, 3).search(/\|\d\d/) > -1 || i.substr(i.length - 4, 3).search(/\|\d\d/) > -1) {
				if(i.substr(i.length - 4, 3).search(/\|\d\d/) > -1) {
					i = i.substr(0, i.length -4);
				}
				while(i.substr(i.length - 3, 3).search(/\|\d\d/) > -1) {
					i = i.substr(0, i.length - 3);
				}
				if(paletteX && paletteY) {
					var colourFound = 0;
					for(z = i.length; z > 3; z = z - 1) {
						if(i.substr(z - 4, 3).search(/\|\d\d/) > -1) {
							popUpPalette(paletteX, paletteY, i.substr(z - 4, 3));
							colourFound = 1;
							break;
						}
					}
					if(colourFound == 0) {
						popUpPalette(paletteX, paletteY, "|07");
					}
				}
			} else {
				i = i.substr(0, i.length - 1);
			}
			console.gotoxy(xy);
			console.putmsg(i + " " + bs);
			l = l - 1;
			if(l < 0) { l = 0; }
		} else if(ascii(x) == 9 && paletteX && paletteY) {
			i = i + popUpPalette(paletteX, paletteY);
			console.gotoxy(xy);
			console.putmsg(i);
		} else if(l < len && ascii(x) != 13 && ascii(x) != 27 && ascii(x) != 30 && ascii(x) != 29 && ascii(x) != 10 && ascii(x) != 6) {
			i = i + x;
			if(i.substr(i.length - 3, 3).search(/\|\d\d/) > -1) {
				if(paletteX && paletteY) {
					popUpPalette(paletteX, paletteY, i.substr(i.length - 3, 3));
				}
				console.gotoxy(xy);
				console.putmsg(i + "   " + bs + bs + bs);
				l = l - 2;
			} else {
				console.gotoxy(xy);
				console.putmsg(i);
				l++;
			}
		}
	}
	console.print(esc + "[0;37;40m");
	if(ascii(x) == 27) {
		i = "";
	}
	return i;
}

/*	Pops up a colour-chooser and returns the selected colour as a pipe code
	x and y are the coordinates of the top left corner of the palette.
	If b (an optional pipe colour code) is supplied, the palette will not be
	displayed and the "Current color" dialog will be updated to reflect the
	value of b. */
function popUpPalette(x, y, b) {
	drawBox(x, y, x + 31, y + 3, 1, "[1;37;40m", "[0;30;40m");
	console.gotoxy(x + 1, y + 1);
	for(z = 1; z < 16; z++) {
		if(z < 10) {
			var c = "0" + z.toString();
		} else {
			var c = z.toString();
		}
		console.putmsg("|" + c + String.fromCharCode(219) + String.fromCharCode(219));
	}
	if(!b) {
		var a = 0;
		var b = 1;
		while(ascii(a) != 13 && ascii(a) != 9) {
			console.gotoxy(x + b, y + 2);
			console.print(String.fromCharCode(239) + String.fromCharCode(239) + String.fromCharCode(27) + "[0;30;40m");
			console.gotoxy(x + b, y + 2);
			a = console.getkey();
			console.print("  " + String.fromCharCode(27) + "[1;37;40m");
			if(ascii(a) == 29 || ascii(a) == 10) {
				b = b - 2;
				if(b < 1) {
					b = 29;
				}
			} else if(ascii(a) == 6 || ascii(a) == 30) {
				b = b + 2;
				if(b > 29) {
					b = 1;
				}
			}
		}
		switch(b) {
			case 1: b = "|01"; break;
			case 3: b = "|02"; break;
			case 5: b = "|03"; break;
			case 7: b = "|04"; break;
			case 9: b = "|05"; break;
			case 11: b = "|06"; break;
			case 13: b = "|07"; break;
			case 15: b = "|08"; break;
			case 17: b = "|09"; break;
			case 19: b = "|10"; break;
			case 21: b = "|11"; break;
			case 23: b = "|12"; break;
			case 25: b = "|13"; break;
			case 27: b = "|14"; break;
			case 29: b = "|15"; break;
		}
	}
	console.gotoxy(x + 1, y + 1);
	for(z = 1; z < 16; z++) {
		console.putmsg(b + String.fromCharCode(219) + String.fromCharCode(219));
	}
	console.gotoxy(x + 1, y + 2);
	console.print(" Current color selection: " + b);
	return b;
}

/*	Draw a box (or a line)
	tlX & tlY are the x and y coordinates of the top left corner of the box
	brX & brY are the x and y coordinates of the bottom right corner of the box
	thickness is 1, 2 or 3, 1 being thinnest, 2 being cheesy and 3 the thickest
	colour is an ANSI sequence describing the colour of the box border
	(eg. "[1;37;40m" for bright white, "[0;35;40m" for vagenta)
	blackout is an ANSI sequence describing the colour inside the box, if any
	(as above, but if omitted the interior of the box will not be redrawn, so
	any characters present prior to the drawBox() call will remain on screen.)
*/
function drawBox(tlX, tlY, brX, brY, thickness, colour, blackout) {
	var xy = console.getxy();
	switch(thickness) {
		case 1:	var tl = String.fromCharCode(218);
				var tr = String.fromCharCode(191);
				var bl = String.fromCharCode(192);
				var br = String.fromCharCode(217);
				var hl = String.fromCharCode(196);
				var vl = String.fromCharCode(179);
				break;
		case 2:	var tl = String.fromCharCode(201);
				var tr = String.fromCharCode(187);
				var bl = String.fromCharCode(200);
				var br = String.fromCharCode(188);
				var hl = String.fromCharCode(205);
				var vl = String.fromCharCode(186);
				break;
		case 3:	var tl = String.fromCharCode(219);
				var tr = String.fromCharCode(219);
				var bl = String.fromCharCode(219);
				var br = String.fromCharCode(219);
				var hl = String.fromCharCode(219);
				var vl = String.fromCharCode(219);
				break;
	}
	console.gotoxy(tlX, tlY);
	console.print(esc + colour + tl);
	for(x = tlX + 1; x < brX; x++) {
		console.gotoxy(x, tlY);
		console.print(esc + colour + hl);
		console.gotoxy(x, brY);
		console.print(esc + colour + hl);
	}
	console.gotoxy(brX, tlY);
	console.print(esc + colour + tr);
	for(y = tlY + 1; y < brY; y++) {
		console.gotoxy(tlX, y);
		console.print(esc + colour + vl);
		console.gotoxy(brX, y);
		console.print(esc + colour + vl);
	}
	console.gotoxy(tlX, brY);
	console.print(esc + colour + bl);
	console.gotoxy(brX, brY);
	console.print(esc + colour + br);
	if(blackout && tlY !== brY) {
		for(y = tlY + 1; y < brY; y++) {
			for(x = tlX + 1; x < brX; x++) {
				console.gotoxy(x, y);
				console.print(esc + blackout + " ");
			}
		}
	}
	console.gotoxy(xy);
}