// onelinerz.js v2.1
// bbs-scene.org global oneliners for Synchronet bulletin board systems
// echicken - echicken@bbs.electronicchicken.com

load("sbbsdefs.js");
load("echttp.js");
var esc = String.fromCharCode(27);

iniFile = new File(system.ctrl_dir + "bbs-scene.ini");
iniFile.open("r");
var BBSSceneAccount = iniFile.iniGetObject("Account");
var onelinerzPrefs = iniFile.iniGetObject("onelinerz");
iniFile.close();

// Some of this is probably redundant, but just in case anybody tries any funny business . . .
function clean_input(string) {
	string = strip_exascii(string);
	string = strip_ctrl(string);
	string = truncsp(string);
	string = string.replace(/<(.|\n)*?>/g, "");
	return string;
}
var onelinerz = httpget(BBSSceneAccount.server, BBSSceneAccount.port, BBSSceneAccount.timeout, BBSSceneAccount.apiPath + "onelinerz.php", "limit=" + onelinerzPrefs.limit, BBSSceneAccount.username, BBSSceneAccount.password);
if(onelinerz != "undefined") {
	console.clear();
	bbs.menu(onelinerzPrefs.displayFile);
	for(x = 1; x <= 79; x++) { console.print(esc + "[1;30;40m-"); }
	console.crlf();
	onelinerz = stripHeaders(onelinerz);	
	var x = new XML(onelinerz);
	for each(var node in x.node) {
		console.print(esc + "[1;30;40m" + "(" + esc + onelinerzPrefs.ansiColourAlias + node.alias.substr(0, onelinerzPrefs.aliasLength) + esc + "[1;34;40m@" + esc + onelinerzPrefs.ansiColourBBSName + node.bbsname.substr(0, onelinerzPrefs.BBSNameLength) + esc + "[1;30;40m) " + esc + onelinerzPrefs.ansiColourOneliner + html_decode(node.oneliner.substr(0, onelinerzPrefs.oneLinerLength)));
		console.crlf();
	}
	for(x = 1; x <= 79; x++) { console.print(esc + "[1;30;40m-"); }
	console.crlf();
	
	var banned = 0;
	var userrealname = user.name.toUpperCase();
	var useralias = user.alias.toUpperCase();
	var userhandle = user.handle.toUpperCase();
	var bannedUsers = onelinerzPrefs.bannedUsers.split(/,/);
	for(i in bannedUsers) {
		if(userrealname == bannedUsers[i].toUpperCase() || useralias == bannedUsers[i].toUpperCase() || userhandle == bannedUsers[i].toUpperCase() || useralias == "") {
			banned = 1;
		}
	}
	if(banned == 0) {
		console.pushxy();
		if(!console.noyes("Post a oneliner to bbs-scene.org")) {
			console.popxy(); console.clearline();
			console.print(esc + "[1;30;40m" + "(" + esc + onelinerzPrefs.ansiColourAlias + user.alias.substr(0, onelinerzPrefs.aliasLength) + esc + "[1;34;40m@" + esc + onelinerzPrefs.ansiColourBBSName + onelinerzPrefs.BBSName.substr(0, onelinerzPrefs.BBSNameLength) + esc + "[1;30;40m) " + esc + "[1;37;40m");
			var oneliner = console.getstr("", onelinerzPrefs.oneLinerLength, K_EDIT|K_LINE|K_AUTODEL);
			if(oneliner != "" && oneliner != null && oneliner != "undefined") {
				oneliner = clean_input(oneliner);
				httppost(BBSSceneAccount.server, BBSSceneAccount.port, BBSSceneAccount.timeout, BBSSceneAccount.apiPath + "onelinerz.xml", "bbsname=" + onelinerzPrefs.BBSName + "&alias=" + user.alias + "&oneliner=" + oneliner, BBSSceneAccount.username, BBSSceneAccount.password);
			}
		}
	} else {
		console.print(esc + "[1;37;40m" + "You do not have permission to post oneliners to bbs-scene.org.");
	}
}