// onelinerz.js v2.0
// bbs-scene.org global oneliners for Synchronet bulletin board systems
// echicken - echicken@bbs.electronicchicken.com

load("sbbsdefs.js");
load("echttp.js");
var esc = String.fromCharCode(27);

// Configuration section
// For a typical setup, just edit the first three variables
var bbsname = "example"; // Your board's name, preferably in its shortest form
var username = "ex@am.ple"; // Your bbs-scene.org API username
var password = "3x4mpl3"; // Your bbs-scene.org API password
var displayfile = "onelinerz"; // A header file, location relative to sbbs/text/menu, no extension (file must be .asc or .ans.)
var limit = 14; // How many oneliners to display in the listing
var onelinerlength = 59; // Size of the oneliner input box & truncated length of fetched oneliners
var aliaslength = 8; // Truncated length of a user's alias
var bbsnamelength = 10; // Truncated length of a BBS name
var ansi_colour_oneliner = esc + "[0;37;40m"; // ANSI sequence, the colour of the oneliner text
var ansi_colour_alias = esc + "[1;37;40m"; // ANSI sequence, the colour of the user's alias
var ansi_colour_bbsname = esc + "[1;36;40m"; // ANSI sequence, the colour of the BBS names
var bannedusers = new Array("guest", "spidy", "chinaman"); // Users disallowed from posting oneliners (case insensitive), can match alias, chat handle, or real name
														   // As a bare minimum, "guest" should be a banned user.
var server = "bbs-scene.org"; // The server (FQDN only) where onelinerz.php and onelinerz.xml are located
var port = 80; // The port to connect to on the server
var timeout = 2; // If the server takes more than this many seconds to respond, abort the script
// End of configuration section.

// Some of this is probably redundant, but just in case anybody tries any funny business . . .
function clean_input(string) {
	string = strip_exascii(string);
	string = strip_ctrl(string);
	string = truncsp(string);
	string = string.replace(/<(.|\n)*?>/g, "");
	return string;
}

var onelinerz = httpget(server, port, timeout, "/api/onelinerz.php", "limit=" + limit, username, password);
if(onelinerz != "undefined") {
	console.clear();
	bbs.menu(displayfile);
	for(x = 1; x <= 79; x++) { console.print(esc + "[1;30;40m-"); }
	console.crlf();
	onelinerz = onelinerz.replace(/^HTTP.+/, "");
	onelinerz = onelinerz.replace(/\nServer.+/, "");
	onelinerz = onelinerz.replace(/\nContent-Type.+/, "");
	onelinerz = onelinerz.replace(/\nContent-Length.+/, "");
	onelinerz = onelinerz.replace(/\nDate.+/, "");
	onelinerz = onelinerz.replace(/\nConnection.+/, "");
	onelinerz = onelinerz.replace(/\nX-Powered-By.+/, "");
	onelinerz = onelinerz.replace(/\nAllow.+/, "");
	onelinerz = onelinerz.replace(/\nAccept-Ranges.+/, "");
	onelinerz = onelinerz.replace(/\n\s+\n/, "");
	onelinerz = onelinerz.replace(/<\?xml\s+version=.+\sstandalone=.+\?>/, "");
	
	var x = new XML(onelinerz);
	for each(var node in x.node) {
		thisoneliner = html_decode(node.oneliner.substr(0, onelinerlength));
		thisalias = node.alias.substr(0, aliaslength);
		thisbbsname = node.bbsname.substr(0, bbsnamelength);
		console.print(esc + "[1;30;40m" + "(" + ansi_colour_alias + thisalias + esc + "[1;34;40m@" + ansi_colour_bbsname + thisbbsname + esc + "[1;30;40m) " + ansi_colour_oneliner + thisoneliner); console.crlf();
	}
	for(x = 1; x <= 79; x++) { console.print(esc + "[1;30;40m-"); }
	console.crlf();
	
	var banned = 0;
	var userrealname = user.name.toUpperCase();
	var useralias = user.alias.toUpperCase();
	var userhandle = user.handle.toUpperCase();
	for(i in bannedusers) {
		if(userrealname == bannedusers[i].toUpperCase() || useralias == bannedusers[i].toUpperCase() || userhandle == bannedusers[i].toUpperCase() || useralias == "") {
			banned = 1;
		}
	}
	if(banned == 0) {
		console.pushxy();
		if(!console.noyes("Post a oneliner to bbs-scene.org")) {
			thisalias = user.alias;
			console.popxy(); console.clearline();
			thisbbsname = bbsname.substr(0, bbsnamelength);
			console.print(esc + "[1;30;40m" + "(" + ansi_colour_alias + thisalias.substr(0, aliaslength) + esc + "[1;34;40m@" + ansi_colour_bbsname + thisbbsname + esc + "[1;30;40m) " + esc + "[1;37;40m");
			var oneliner = console.getstr("", onelinerlength, K_EDIT|K_LINE|K_AUTODEL);
			if(oneliner != "" && oneliner != null && oneliner != "undefined") {
				oneliner = clean_input(oneliner);
				httppost(server, port, timeout, "/api/onelinerz.xml", "bbsname=" + bbsname + "&alias=" + thisalias + "&oneliner=" + oneliner, username, password);
			}
		}
	} else {
		console.print(esc + "[1;37;40m" + "You do not have permission to post oneliners to bbs-scene.org.");
	}
}