// onelinerz.js v1.9 - DeLuxe Edition
// bbs-scene.org global oneliners for Synchronet bulletin board systems
// echicken - echicken@bbs.electronicchicken.com
// New in v1.8: grab a non-XML feed of the bbs-scene.org global oneliners via bbs.electronicchicken.com
// (Good for people who can't update their Sync install to a version with XML parsing in the JS engine.)
// New in v1.9: Some changes for Lux, who wants to run this script without a user logged in

load("sbbsdefs.js");
load("echttp.js");
var esc = String.fromCharCode(27);

// Configuration section
// For a typical setup, just edit the first three variables
var bbsname = "example"; // Your board's name, preferably in its shortest form
var username = "ex@am.ple"; // Your bbs-scene.org API username
var password = "3x4mpl3"; // Your bbs-scene.org API password
var displayfile = "onelinerz"; // A header file, location relative to sbbs/text/menu, no extension (file must be .asc or .ans.)
var limit = 14; // How many oneliners to display in the listing
var onelinerlength = 60; // Size of the oneliner input box & truncated length of fetched oneliners
var aliaslength = 8; // Truncated length of a user's alias
var bbsnamelength = 10; // Truncated length of a BBS name
var ansi_colour_oneliner = esc + "[0;37;40m"; // ANSI sequence, the colour of the oneliner text
var ansi_colour_alias = esc + "[1;37;40m"; // ANSI sequence, the colour of the user's alias
var ansi_colour_bbsname = esc + "[1;36;40m"; // ANSI sequence, the colour of the BBS names
var bannedusers = new Array("guest", "spidy", "chinaman"); // Users disallowed from posting oneliners (case insensitive), can match alias, chat handle, or real name
														   // As a bare minimum, "guest" should be a banned user.
var guestposting = 1; // Allow posts by unauthenticated users? 1 = yes, 0 = no.  For most people, 0.
// It's unlikely that you'll need to change any of the next three variables
var server = "bbs-scene.org"; // The server (FQDN only) where onelinerz.php and onelinerz.xml are located
var port = 80; // The port to connect to on the server
var timeout = 2; // If the server takes more than this many seconds to respond, abort the script

// Most people can leave the following four options untouched.
var nonxmlmethod = 0; // Fetch oneliners via nonxmlserver? 1 = yes, 0 = no.  For most people, 0.
var nonxmlserver = "bbs.electronicchicken.com"; // Server relaying a non-XML version of the oneliners
var nonxmlport = 80; // Port number on nonxmlserver
var nonxmlpath = "/onelinerz/preparsed.ssjs"; // Page to request from nonxmlserver

// End of configuration section.

// Some of this is probably redundant, but just in case anybody tries any funny business . . .
function clean_input(string) {
	string = strip_exascii(string);
	string = strip_ctrl(string);
	string = truncsp(string);
	string = string.replace(/<(.|\n)*?>/g, "");
	return string;
}

if(nonxmlmethod == 0) {
	// Fetch the current XML from onelinerz.php, if this fails, don't display anything
	var onelinerz = httpget(server, port, timeout, "/api/onelinerz.php", "limit=" + limit, username, password);
} else {
	// Fetch the current flat-text oneliners from nonxmlserver + nonxmlpath, if this fails, don't display anything
	var onelinerz = httpget(nonxmlserver, nonxmlport, timeout, nonxmlpath, "limit=" + limit + "&un=" + base64_encode(username) + "&pw=" + base64_encode(password) + "&srv=" + server + "&prt=" + port);
}
if(onelinerz != "undefined") {
	console.clear();
	bbs.menu(displayfile);
	for(x = 1; x <= 79; x++) { console.print(esc + "[1;30;40m-"); }
	console.crlf();
	onelinerz = onelinerz.replace(/^HTTP.+/, "");
	onelinerz = onelinerz.replace(/\nServer.+/, "");
	onelinerz = onelinerz.replace(/\nContent-Type.+/, "");
	onelinerz = onelinerz.replace(/\nContent-Length.+/, "");
	onelinerz = onelinerz.replace(/\nDate.+/, "");
	onelinerz = onelinerz.replace(/\nConnection.+/, "");
	onelinerz = onelinerz.replace(/\nX-Powered-By.+/, "");
	onelinerz = onelinerz.replace(/\nAllow.+/, "");
	onelinerz = onelinerz.replace(/\nAccept-Ranges.+/, "");
	onelinerz = onelinerz.replace(/\n\s+\n/, "");
	onelinerz = onelinerz.replace(/<\?xml\s+version=.+\sstandalone=.+\?>/, "");
	
	if(nonxmlmethod == 0) {		
		var x = new XML(onelinerz);
		for each(var node in x.node) {
			thisoneliner = html_decode(node.oneliner.substr(0, onelinerlength));
			thisalias = node.alias.substr(0, aliaslength);
			thisbbsname = node.bbsname.substr(0, bbsnamelength);
			console.print(esc + "[1;30;40m" + "(" + ansi_colour_alias + thisalias + esc + "[1;34;40m@" + ansi_colour_bbsname + thisbbsname + esc + "[1;30;40m) " + ansi_colour_oneliner + thisoneliner); console.crlf();
		}
	} else {
		var onelinerzarray = onelinerz.split(String.fromCharCode(30));
		for(i in onelinerzarray) {
			var onelinerline = onelinerzarray[i].replace(/(\n|\r)+/, "");
			var onelinerarray = onelinerline.split(String.fromCharCode(31));
			thisalias = onelinerarray[0].substr(0, aliaslength);
			thisbbsname = onelinerarray[1].substr(0, bbsnamelength);
			thisoneliner = html_decode(onelinerarray[2].substr(0, onelinerlength));
			console.print(esc + "[1;30;40m" + "(" + ansi_colour_alias + thisalias + esc + "[1;34;40m@" + ansi_colour_bbsname + thisbbsname + esc + "[1;30;40m) " + ansi_colour_oneliner + thisoneliner);
			if(i < limit - 1) { console.crlf(); }
		}
	}
	for(x = 1; x <= 79; x++) { console.print(esc + "[1;30;40m-"); }
	console.crlf();
	
	var banned = 0;
	if(guestposting == 0) {
		var userrealname = user.name.toUpperCase();
		var useralias = user.alias.toUpperCase();
		var userhandle = user.handle.toUpperCase();
		for(i in bannedusers) {
			if(userrealname == bannedusers[i].toUpperCase() || useralias == bannedusers[i].toUpperCase() || userhandle == bannedusers[i].toUpperCase() || useralias == "") {
				banned = 1;
			}
		}
	}
	if(banned == 0) {
		console.pushxy();
		if(!console.noyes("Post a oneliner to bbs-scene.org")) {
			thisalias = user.alias;
			while(thisalias == "" && guestposting == 1) {
				console.popxy(); console.clearline();			
				console.print(esc + "[1;37;40m" + "Enter your alias: ");
				var thisalias = console.getstr("", aliaslength, K_EDIT|K_LINE|K_AUTODEL);
			}
			console.popxy(); console.clearline();
			thisbbsname = bbsname.substr(0, bbsnamelength);
			console.print(esc + "[1;30;40m" + "(" + ansi_colour_alias + thisalias.substr(0, aliaslength) + esc + "[1;34;40m@" + ansi_colour_bbsname + thisbbsname + esc + "[1;30;40m) " + esc + "[1;37;40m");
			var oneliner = console.getstr("", onelinerlength, K_EDIT|K_LINE|K_AUTODEL);
			if(oneliner != "" && oneliner != null && oneliner != "undefined") {
				oneliner = clean_input(oneliner);
				httppost(server, port, timeout, "/api/onelinerz.xml", "bbsname=" + bbsname + "&alias=" + thisalias + "&oneliner=" + oneliner, username, password);
			}
		}
	} else {
		console.print(esc + "[1;37;40m" + "You do not have permission to post oneliners to bbs-scene.org.");
	}
}