/*
                 __,,---,__ _    __,,--, __ _
                 |  ___/---,,__,-|  ___//___,,----,______,,---,__ __ _
       _ __ _____|  \_   _  \_   | \\_  __  \_  __   (___)      \ tdmHz
           \\_  __  _|   ____|_ \_/  |  \|   |  \|   | \_   |__//_
            _|  \|  \__  |/  _// |   |_  |  _|   |  _|  _|   |'  _/'' '
     ==== = \\     ___// '  _|   |____/' ' \\____| \\___\__      | = ====
   - -- ---- \____// \_____/__,,-'   \\__,,---'  |____/   \\_,,--' --- -- -
             daydream bbs : litebar bulletin menu door v1.0

	This is another door that I've written that takes advantage of
	#define's for configuration.  I don't like crowding my bbs with
	configuration files everywhere.  So set it up in this before you
	compile!  I have it currently set up for my bbs, montereybbs.com,
	and your settings will likely be different.  NOTE:  This looks for
	/home/bbs/bulletins/bulletin.##.gfx.  It's not configured for
	anything else.  If your settings are different, change them :)

*/

#include <stdio.h>
#include <stdlib.h>
#include <dd.h>
#include <ddlib.h>

struct dif *d;

#define LITEBARX1 1	// X coordinate of first row of litebars, left side
#define LITEBARX2 37	// X coordinate of second row of litebars, right side

#define LITEBARY 6	// Y coordinate for start of litebars

#define CHOICE1		"\e[0m\e[35mo1"
#define CHOICE2		"\e[0m\e[35mo2"
#define CHOICE3		"\e[0m\e[35mo3"
#define CHOICE4		"\e[0m\e[35mo4"
#define CHOICE5		"\e[0m\e[35mo5"
#define CHOICE6		"\e[0m\e[35mo6"
#define CHOICE7		"\e[0m\e[35mo7"
#define CHOICE8		"\e[0m\e[35mo8"
#define CHOICE9		"\e[0m\e[35mo9"
#define CHOICE10	"\e[0m\e[35m1o"
#define CHOICE11	"\e[0m\e[35m11"
#define CHOICE12	"\e[0m\e[35m12"
#define CHOICE13	"\e[0m\e[35m13"
#define CHOICE14	"\e[0m\e[35m14"
#define CHOICE15	"\e[0m\e[35m15"
#define CHOICE16	"\e[0m\e[35m16"
#define CHOICE17	"\e[0m\e[35m17"
#define CHOICE18	"\e[0m\e[35m18"
#define CHOICE19	"\e[0m\e[35m19"
#define CHOICE20	"\e[0m\e[35m2o"

#define CHOICE1ON	"\e[35;44mo1\e[0m\e[37m"
#define CHOICE2ON	"\e[35;44mo2\e[0m\e[37m"
#define CHOICE3ON	"\e[35;44mo3\e[0m\e[37m"
#define CHOICE4ON	"\e[35;44mo4\e[0m\e[37m"
#define CHOICE5ON	"\e[35;44mo5\e[0m\e[37m"
#define CHOICE6ON	"\e[35;44mo6\e[0m\e[37m"
#define CHOICE7ON       "\e[35;44mo7\e[0m\e[37m"
#define CHOICE8ON       "\e[35;44mo8\e[0m\e[37m"
#define CHOICE9ON       "\e[35;44mo9\e[0m\e[37m"
#define CHOICE10ON       "\e[35;44m1o\e[0m\e[37m"
#define CHOICE11ON       "\e[35;44m11\e[0m\e[37m"
#define CHOICE12ON       "\e[35;44m12\e[0m\e[37m"
#define CHOICE13ON       "\e[35;44m13\e[0m\e[37m"
#define CHOICE14ON       "\e[35;44m14\e[0m\e[37m"
#define CHOICE15ON       "\e[35;44m15\e[0m\e[37m"
#define CHOICE16ON       "\e[35;44m16\e[0m\e[37m"
#define CHOICE17ON       "\e[35;44m17\e[0m\e[37m"
#define CHOICE18ON       "\e[35;44m18\e[0m\e[37m"
#define CHOICE19ON       "\e[35;44m19\e[0m\e[37m"
#define CHOICE20ON       "\e[35;44m2o\e[0m\e[37m"

char *choices_on[] = {
	CHOICE1ON, CHOICE1ON, CHOICE2ON, CHOICE3ON, CHOICE4ON, CHOICE5ON, CHOICE6ON, CHOICE7ON, CHOICE8ON, CHOICE9ON, CHOICE10ON, CHOICE11ON, CHOICE12ON, CHOICE13ON, CHOICE14ON, CHOICE15ON, CHOICE16ON, CHOICE17ON, CHOICE18ON, CHOICE19ON, CHOICE20ON,
	};

char *choices_off[] = {
	CHOICE1, CHOICE1, CHOICE2, CHOICE3, CHOICE4, CHOICE5, CHOICE6, CHOICE7, CHOICE8, CHOICE9, CHOICE10, CHOICE11, CHOICE12, CHOICE13, CHOICE14, CHOICE15, CHOICE16, CHOICE17, CHOICE18, CHOICE19, CHOICE20,
	};

int choice = 1;

// Clear Screen structure

void dd_clrscr(struct dif *d)
{
	dd_sendstring(d,"\e[2J");
}

// Rezine's famous dd_ansipos structure :)  Thanks rezine!
void showbull(int curbull)
{
	dd_clrscr(d);

	// dd_typefile sucks.  gotta do this crap longhand.
 	if(curbull==1) dd_typefile(d,"/home/bbs/bulletins/bulletin.1.gfx",TYPE_WARN);
	else if(curbull==2) dd_typefile(d,"/home/bbs/bulletins/bulletin.2.gfx",TYPE_WARN);
	else if(curbull==3) dd_typefile(d,"/home/bbs/bulletins/bulletin.3.gfx",TYPE_WARN);
	else if(curbull==4) dd_typefile(d,"/home/bbs/bulletins/bulletin.4.gfx",TYPE_WARN);
	else if(curbull==5) dd_typefile(d,"/home/bbs/bulletins/bulletin.5.gfx",TYPE_WARN);
	else if(curbull==6) dd_typefile(d,"/home/bbs/bulletins/bulletin.6.gfx",TYPE_WARN);
       	else if(curbull==7) dd_typefile(d,"/home/bbs/bulletins/bulletin.7.gfx",TYPE_WARN);
       	else if(curbull==8) dd_typefile(d,"/home/bbs/bulletins/bulletin.8.gfx",TYPE_WARN);
       	else if(curbull==9) dd_typefile(d,"/home/bbs/bulletins/bulletin.9.gfx",TYPE_WARN);
       	else if(curbull==10) dd_typefile(d,"/home/bbs/bulletins/bulletin.10.gfx",TYPE_WARN);
       	else if(curbull==11) dd_typefile(d,"/home/bbs/bulletins/bulletin.11.gfx",TYPE_WARN);
       	else if(curbull==12) dd_typefile(d,"/home/bbs/bulletins/bulletin.12.gfx",TYPE_WARN);
       	else if(curbull==13) dd_typefile(d,"/home/bbs/bulletins/bulletin.13.gfx",TYPE_WARN);
       	else if(curbull==14) dd_typefile(d,"/home/bbs/bulletins/bulletin.14.gfx",TYPE_WARN);
        else if(curbull==15) dd_typefile(d,"/home/bbs/bulletins/bulletin.15.gfx",TYPE_WARN);
	else if(curbull==16) dd_typefile(d,"/home/bbs/bulletins/bulletin.16.gfx",TYPE_WARN);
       	else if(curbull==17) dd_typefile(d,"/home/bbs/bulletins/bulletin.17.gfx",TYPE_WARN);
       	else if(curbull==18) dd_typefile(d,"/home/bbs/bulletins/bulletin.18.gfx",TYPE_WARN);
       	else if(curbull==19) dd_typefile(d,"/home/bbs/bulletins/bulletin.19.gfx",TYPE_WARN);
       	else dd_typefile(d,"/home/bbs/bulletins/bulletin.20.gfx",TYPE_WARN);
}

void dd_ansipos(struct dif *d, int x, int y)
{
	char tmpstring[10];
	  sprintf(tmpstring,"\e[%i;%iH",y,x);
	  dd_sendstring(d,tmpstring);
}

// Checks if a string contains numeric characters, stolen from
// drunken join.  Thanks again rezine :)

int checkinput(char *check)
{
	int i;
	for(i=0;i<=strlen(check)-1;i++)
	{
		if (!isdigit(check[i])) return(0);
	}
	return(1);
}

// Litebar menu, simple and to the point.  Decided to use #define at the
// beginning instead of using a config file.  If you have the source,
// why in the hell would you need a config file?!

void litebar_menu(void)
{
	char buf[160];
	int chosen=0;
	int changed=0;
	int c=0;
	int choices=1;
	int curchoice=0;

	dd_ansipos(d,0,0);

	dd_typefile(d,"bulletinmenu",TYPE_MAKE);

	for (choices=1; choices<11; choices++)
	{
	  curchoice = LITEBARY + choices;
	  dd_ansipos(d,LITEBARX1,curchoice);
	  dd_sendstring(d,choices_off[choices]);
	}
	choices = 11;
	for (choices=11; choices<21; choices++)
	{
	  curchoice = LITEBARY + (choices - 10);
	  dd_ansipos(d,LITEBARX2,curchoice);
	  dd_sendstring(d,choices_off[choices]);
	}

	if(choice <= 10) {
		curchoice = LITEBARY + choice;
		dd_ansipos(d,LITEBARX1,curchoice);
		dd_sendstring(d,choices_on[choice]);
		dd_ansipos(d,0,0);
	}
	else {
		curchoice = LITEBARY + (choice - 10);
		dd_ansipos(d,LITEBARX2,curchoice);
		dd_sendstring(d,choices_on[choice]);
		dd_ansipos(d,0,0);
	}

	while(chosen == 0)
	{
		dd_ansipos(d,0,0);
		c = dd_hotkey(d, HOT_CURSOR);

		switch(c)
		{
		    case 'q':
		    case 'Q':
		    case 27: return; break;
		    case 13 : 
			showbull(choice);
			dd_pause(d);
			dd_clrscr(d);
			dd_typefile(d,"bulletinmenu",TYPE_MAKE);
			changed = 1;
			chosen = 0;
			break;
		    case 250:		// up arrow
			if(choice == 1)
			   choice = 10;
			else if(choice == 11)
			   choice = 20;
			else
			   --choice;
			changed = 1;
			chosen = 0;
			break;
		    case 251:		// down arrow
			if(choice == 20)
			   choice = 11;
			else if(choice == 10)
			   choice = 1;
			else
			   ++choice;
			changed = 1;
			chosen = 0;
			break;
		    case 253:		// left arrow
			if(choice <= 10) choice = choice + 10;
			else choice = choice - 10;
			changed = 1;
			chosen = 0;
			break;
		    case 252:		// right arrow
			if(choice <= 10) choice = choice + 10;
			else choice = choice - 10;
			changed = 1;
			chosen = 0;
		}

	if (changed != 0) {
		choices = 1;
		for (choices=1; choices<11; choices++)
		{
		  curchoice = LITEBARY + choices;
		  dd_ansipos(d,LITEBARX1,curchoice);
		  dd_sendstring(d,choices_off[choices]);
		}
		choices = 11;
		for (choices=11; choices<21; choices++)
		{
		  curchoice = LITEBARY + (choices - 10);
		  dd_ansipos(d,LITEBARX2,curchoice);
		  dd_sendstring(d,choices_off[choices]);
		}

		if(choice <= 10) {
		  curchoice = LITEBARY + choice;
		  dd_ansipos(d,LITEBARX1,curchoice);
		  dd_sendstring(d,choices_on[choice]);
		  dd_ansipos(d,0,0);
		}
		else {
		  curchoice = LITEBARY + (choice - 10);
		  dd_ansipos(d,LITEBARX2,curchoice);
		  dd_sendstring(d,choices_on[choice]);
		  dd_ansipos(d,0,0);
		}
		changed = 0;
	}
	if(chosen != 0)
	break;
    }
}

int main(int argc, char *argv[])
{
	char buf[1024];
	int i;
	char datafile[160];

	if (argc==1)
	{
	  printf("Must be run from DayDream, f00!\n");
	  exit(1);
	}

	d=dd_initdoor(argv[1]);
	if (d==0)
	{
	  printf("Couldn't find socket!!\n");
	  exit(1);
	}

	dd_getstrval(d,buf,DOOR_PARAMS);
	if(strcmp(buf,""))
	{
		if(checkinput(buf))
		{
			if(atoi(buf) < 21 && atoi(buf) > 0) {
				showbull(atoi(buf));
				dd_pause(d);
			}
			else
			{
				dd_sendstring(d,"Can't view that bulletin!");
				dd_pause(d);
			}
		}
	} else {

	dd_changestatus(d, "dd-bulls!");

	dd_clrscr(d);

	litebar_menu();

	}

	dd_clrscr(d);

	dd_close(d);
}
