# auto-validator 1.1
#
# written by netsurge%demonic/miserybbs.com
#
# original concept by dreammaster

uses user
uses cfg

# configuration options. please see included readme

const pass    = 'password'  # password for level 2 access
const bbsname = 'misery bbs'   # bbs name
const opname  = 'netsurge'     # sysops name

# set variables

const ver     = '1.1'
var	ch	char
var	str	string

# display header screen and version

procedure header
begin
CLS
DispFile (CfgTextPath + 'autoval')
writeln(' |CR|05[|13=|14!|07 ' + bbsname +' auto-validator version ' + ver)
writeln(' |CR|05[|13=|14!|07 by |15netsurge|08%|15demonic|08/|15miserybbs.com')
pend

# display readme screen

procedure readme
	begin
	header
	writeln('|CR|07 welcome to ' + bbsname + '. this module will auto validate your account.')
	writeln(' there are two validation levels. validation level one is for regular users')
	writeln(' and validation level two is for visiting sysops and requires a password.')
	writeln('') 
	writeln(' if you are a visiting sysop and would like to get the password please')
	writeln(' leave |15' + opname + ' |07feedback with your name and your bbs address.')
	write('|CR|PA')
pend

# validation level 1 (regular user)

procedure level1
	begin
	CLS

	upuser(20)			# set 20 to the security level for validation 1
	setusertime(120)	# set 120 to the time allowed for validation 1

	writeln('|CR|05[|13=|14!|07 checking your account   |08:|07|DE .|DE.|DE.|DE|15|[Y02|[X31done')
	writeln('|CR|05[|13=|14!|07 validating your account |08:|07|DE .|DE.|DE.|DE|15|[Y04|[X31done')
	writeln('|DE')
	writeln('|05[|13=|14!|07 your security class     |08:|15 |SD')
	writeln('|CR|05[|13=|14!|07 your security level     |08:|15 |SL')
	writeln('|CR|05[|13=|14!|07 your time per day is    |08:|15 |TL|07 min(s)')
	writeln('')
	writeln('|05[|13=|14!|07 thanks |15|UH |07you have been validated.')
	writeln('')
	writeln('|PA')
	halt
pend

# validation level 2 (visiting sysop)

procedure level2
	begin
	CLS

	upuser(100)			# set 100 to the security level for validation 2
	setusertime(500)	# set 500 to the time allowed for validation 2

	writeln('|CR|05[|13=|14!|07 checking your account   |08:|07|DE .|DE.|DE.|DE|15|[Y02|[X31done')
	writeln('|CR|05[|13=|14!|07 validating your account |08:|07|DE .|DE.|DE.|DE|15|[Y04|[X31done')
	writeln('|DE')
	writeln('|05[|13=|14!|07 your security class     |08:|15 |SD')
	writeln('|CR|05[|13=|14!|07 your security level     |08:|15 |SL')
	writeln('|CR|05[|13=|14!|07 your time per day is    |08:|15 |TL|07 min(s)')
	writeln('')
	writeln('|05[|13=|14!|07 thanks |15|UH |07you have been validated as a visiting sysop.')
	writeln('')
	writeln('|PA')
	halt
pend

# check level 2 password

procedure password
	begin
	cls
	menucmd ('-P','|CR|05[|13=|14!|07 please enter level 2 password|08 -> |15;' + pass)
	if ACS('OK') level2 
		elseif
  	not ACS('OK') then 
		write('|DE')
	endif
pend

# menu screen

procedure mainmenu
	begin
	writeln('')
	writeln('    |08[|071|08]|15 level 1 |08[|07regular user|08]   |05[|13recomended|05]')
	writeln('    |08[|072|08]|15 level 2 |08[|07visiting sysop|08] |05[|13password needed|05]')
	writeln('    |08[|07q|08]|15 hangup  |08[|07hangup|08]')
	writeln('    |08[|07?|08]|15 readme  |08[|07help|08]')
	writeln('')
pend

begin
	cls
	write('|05[|13=|14!|07 loading auto-validation module...|DE|DE|DE')
	repeat
	header
	mainmenu
	write('|05[|13=|14!|07 your command|08: |07')
	ch := upper(readkey)
	if ch = '1' then 
		level1 
	elseif
   	ch = '2' then 
		password 
	elseif
	ch = 'Q' then 
		hangup 
	elseif
	ch = '?' then 
		readme 
	endif

until ch = 'Q'
end
