/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __UTILS_H )
#define __UTILS_H

/*
 ***************************************************************************
                         Miscellaneous utilities
 ***************************************************************************
*/

#if !defined( __PBINC_H )
	#include "pbinc.h"
#endif

#if !defined( PB_SDK )
	#if !defined( __STDIO_H )
		#include <stdio.h>
	#endif
#endif

#if defined( __cplusplus )
	extern "C" {
#endif

extern dword tblCRC32[];   /* defined in CRC32.C    */
extern char __crc32[3][8]; /* defined in SFCHECK1.C */

/*
 * Updates the CRC32 value: c is the new int, crc is the current CRC32
*/
#define UpdateCRC32(c,crc) (tblCRC32[(byte)((c)^(crc)) & 0xff]^ul_shr(crc,8))

/*
 * Comparison function type
*/
typedef int (*FCMP)(const void *, const void *);

int   dosver( void );
int   truedosver( void );
void  detectOS( void );
void  idle( void );
int   isshare( void );
int   isstdin( void );
int   isstdout( void );

int   fileCRC32( const char *path, dword *CRC32 );
dword bufCRC32( const char *buf, size_t len );
int   fileCheck( const char *progpath );

void  *bsearch( const void *key, const void *b, size_t n, size_t w, FCMP f);
void  qsort( void *b, size_t n, size_t w, FCMP f);

#if defined( __cplusplus )
	}
#endif
#endif
