/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Work only offline: we already have Read/WriteUser online
 * However, these can work online too...
*/
#if !defined( PB_SDK )

#if !defined( __USERREC_H )
	#include "userrec.h"
#endif

#if !defined( PB_SDK )
	#if !defined( __STRING_H )
		#include <string.h>
	#endif
#endif

#if !defined( __USERSBBS_H )
	#include "usersbbs.h"
#endif
#if !defined( __USERSPB_H )
	#include "userspb.h"
#endif
#if !defined( __STRLIB_H )
	#include "strlib.h"
#endif
#if !defined( __UTILS_H )
	#include "utils.h"
#endif
#if !defined( __USERSIDX_H )
	#include "usersidx.h"
#endif
#if !defined( __USERSXI_H )
	#include "usersxi.h"
#endif

/*
 * global variables local to this module
*/
static RA_USERSBBS __ra;  /* holds the structure for I/O for USERS.BBS    */
static USERSPB     __pb;  /* holds the structure for I/O for USERPB.BBS   */

/*
 * local function prototypes
*/
static void  _ra2pbDate( byte *pb, const char *ra );
static void  _ra2pbTime( byte *pb, const char *ra );
static void  _pb2raDate( char *ra, const byte *pb );
static void  _pb2raTime( char *ra, const byte *pb );
static dword _setUserAccess( void );
static void  _cvtUserAccess( dword flags );
static dword _setUserAttrib( void );
static void  _cvtUserAttrib( dword flags );

/*
 * converts RA date format to PB style
*/
	void
_ra2pbDate( byte *pb, const char *ra )
{
	char date[9];
	int mon, day, yr;

	strfmpas( date, ra );
	sscanf( date, "%2d-%2d-%2d", &mon, &day, &yr );
	pb[0] = (byte)day; pb[1] = (byte)mon; pb[2] = (byte)yr;
}

/*
 * converts PB date format to RA style
*/
	void
_pb2raDate( char *ra, const byte *pb )
{
	char buf[9];

	sprintf( buf, "%02d-%02d-%02d", (int)pb[1], (int)pb[0], (int)pb[2] );
	strtopas( ra, buf );
}

/*
 * converts RA time format to PB style
*/
	void
_ra2pbTime( byte *pb, const char *ra )
{
	char t[6];
	int hour, min;

	strfmpas( t, ra );
	sscanf( t, "%2d:%2d", &hour, &min );
	pb[0] = (byte)hour; pb[1] = (byte)min; pb[2] = 0;
}

/*
 * converts PB time format to RA style
*/
	void
_pb2raTime( char *ra, const byte *pb )
{
	char buf[9];
	sprintf( buf, "%02d:%02d", (int)pb[0], (int)pb[1] );
	strtopas( ra, buf );
}

/*
 * sets the user access flags, __ra must contain valid data
*/
	dword
_setUserAccess( void )
{
	dword flags = 0L;
	 int  i;

	for( i = 0; i < 32; ++i ){
		if( __ra.aFlags[i >> 3] & (1 << (i & 0x07)) )
			flags |= ul_shl(1L, 31 - i);
	}
	return flags;
}

/*
 * converts the user access flags, modifes __ra
*/
	void
_cvtUserAccess( dword flags )
{
	int i;

	memset( __ra.aFlags, 0, 4 );
	for( i = 0; i < 32; ++i ){
		if( flags & ul_shl(1L, 31 - i) )
			__ra.aFlags[i >> 3] |= (1 << (i & 0x07));
	}
}

/*
 * sets the user attributes (__pb and __ra MUST contain valid info)
*/
	dword
_setUserAttrib( void )
{
	dword flags = 0L;

	if( __ra.attribute1 & RAF1_DELETED    ) flags |= UFLAG_DELETED;
	if( __ra.attribute1 & RAF1_ANSI       ) flags |= UFLAG_ANSI;
	if( __ra.attribute1 & RAF1_PAUSE      ) flags |= UFLAG_PAUSE;
	if( __ra.attribute1 & RAF1_CLEAR      ) flags |= UFLAG_CLEAR;
	if( __ra.attribute1 & RAF1_FSED       ) flags |= UFLAG_FSED;
	if( __ra.attribute1 & RAF1_NOKILL     ) flags |= UFLAG_NOKILL;
	if( __ra.attribute1 & RAF1_IGNORE     ) flags |= UFLAG_IGNORE;
	if( __ra.attribute1 & RAF1_QUIET      ) flags |= UFLAG_QUIET;
	if( __ra.attribute2 & RAF2_HOTKEYS    ) flags |= UFLAG_HOTKEYS;
	if( __ra.attribute2 & RAF2_HIDDEN     ) flags |= UFLAG_HIDDEN;
	if( __ra.attribute2 & RAF2_AVATAR     ) flags |= UFLAG_AVATAR;
	if( __ra.attribute2 & RAF2_GUEST      ) flags |= UFLAG_GUEST;
	if( __ra.attribute2 & RAF2_PAGEPRI    ) flags |= UFLAG_PAGEPRI;
	if( __pb.uFlags     & PBUF_NOIBM      ) flags |= UFLAG_NOIBM;
	if( __pb.uFlags 	& PBUF_ATTEN      ) flags |= UFLAG_ATTEN;
	if( __pb.uFlags 	& PBUF_NOTOPS     ) flags |= UFLAG_NOTOPS;
	if( __pb.uFlags 	& PBUF_AVTPLUS    ) flags |= UFLAG_AVTPLUS;
	if( __pb.uFlags 	& PBUF_LOCALONLY  ) flags |= UFLAG_LOCALONLY;
	if( __pb.uFlags 	& PBUF_MULTILOGIN ) flags |= UFLAG_MULTILOGIN;
	if( __pb.uFlags 	& PBUF_FREECHAT   ) flags |= UFLAG_FREECHAT;
	if( __pb.uFlags 	& PBUF_NORIP      ) flags |= UFLAG_NORIP;

	return flags;
}

/*
 * sets the attribute? and uFlags values in __pb and __ra
*/
	void
_cvtUserAttrib( dword flags )
{
	__ra.attribute1 = __ra.attribute2 = 0;
	__pb.uFlags = 0L;

	if( flags & UFLAG_DELETED    )  __ra.attribute1 |= RAF1_DELETED;
	if( flags & UFLAG_ANSI       )  __ra.attribute1 |= RAF1_ANSI;
	if( flags & UFLAG_PAUSE      )  __ra.attribute1 |= RAF1_PAUSE;
	if( flags & UFLAG_CLEAR      )  __ra.attribute1 |= RAF1_CLEAR;
	if( flags & UFLAG_FSED       )  __ra.attribute1 |= RAF1_FSED;
	if( flags & UFLAG_NOKILL     )  __ra.attribute1 |= RAF1_NOKILL;
	if( flags & UFLAG_IGNORE     )  __ra.attribute1 |= RAF1_IGNORE;
	if( flags & UFLAG_QUIET      )  __ra.attribute1 |= RAF1_QUIET;
	if( flags & UFLAG_HOTKEYS    )  __ra.attribute2 |= RAF2_HOTKEYS;
	if( flags & UFLAG_HIDDEN     )  __ra.attribute2 |= RAF2_HIDDEN;
	if( flags & UFLAG_AVATAR     )  __ra.attribute2 |= RAF2_AVATAR;
	if( flags & UFLAG_GUEST      )  __ra.attribute2 |= RAF2_GUEST;
	if( flags & UFLAG_PAGEPRI    )  __ra.attribute2 |= RAF2_PAGEPRI;
	if( flags & UFLAG_NOIBM      )  __pb.uFlags     |= PBUF_NOIBM;
	if( flags & UFLAG_ATTEN      )  __pb.uFlags     |= PBUF_ATTEN;
	if( flags & UFLAG_NOTOPS     )  __pb.uFlags     |= PBUF_NOTOPS;
	if( flags & UFLAG_AVTPLUS    )  __pb.uFlags     |= PBUF_AVTPLUS;
	if( flags & UFLAG_LOCALONLY  )  __pb.uFlags     |= PBUF_LOCALONLY;
	if( flags & UFLAG_MULTILOGIN )  __pb.uFlags     |= PBUF_MULTILOGIN;
	if( flags & UFLAG_FREECHAT   )  __pb.uFlags     |= PBUF_FREECHAT;
	if( flags & UFLAG_NORIP      )  __pb.uFlags     |= PBUF_NORIP;
}

/*
 * reads a user record into rec
*/
	int
ReadUser( int num, USER_REC *rec )
{
	if( -1 == ReadUsersBBS(num, &__ra) ) return -1;
	if( -1 == ReadUsersPB(num, &__pb) ) return -1;

	rec->record = (long)num;

	/*
	 * get the information from the ProBoard structure
	*/
	strcpy( rec->name, __pb.name );
	strcpy( rec->country, __pb.country );
	strcpy( rec->state, __pb.state );
	strcpy( rec->faxPhone, __pb.faxPhone );
	strcpy( rec->passWord, __pb.passWord );
	strcpy( rec->language, __pb.language );
	memcpy( rec->lastPwdChange, __pb.lastPwdChange, sizeof(DateType) );
	memcpy( rec->lastNewFilesCheck, __pb.lastNewFilesCheck, sizeof(DateType));
	memcpy( rec->tbTimePayback, __pb.tbTimePayback, sizeof(DateType) );
	memcpy( rec->tbKbPayback, __pb.tbKbPayback, sizeof(DateType) );
	memcpy( rec->tbLastUsed, __pb.tbLastUsed, sizeof(DateType) );
	memcpy( rec->mailCheckBoards, __pb.mailCheckBoards, 125 );
	rec->logLevel = __pb.logLevel;
	rec->tbTimeBalance = __pb.tbTimeBalance;
	rec->tbKbBalance = __pb.tbKbBalance;
	rec->tbTimeWithdrawn = __pb.tbTimeWithdrawn;
	rec->tbKbWithdrawn = __pb.tbKbWithdrawn;
	rec->tbTimeDeposited = __pb.tbTimeDeposited;
	rec->tbKbDeposited = __pb.tbKbDeposited;
	rec->tbTimeLoaned = __pb.tbTimeLoaned;
	rec->tbKbLoaned = __pb.tbKbLoaned;
	rec->expLevel = __pb.expLevel;
	rec->expFlagsOn = __pb.expFlagsOn;
	rec->expFlagsOff = __pb.expFlagsOff;
	rec->totalTimeUsed = __pb.totalTimeUsed;
	rec->qwkMaxMsgsPerArea = __pb.qwkMaxMsgsPerArea;
	rec->qwkMaxMsgs = __pb.qwkMaxMsgs;
	rec->qwkArchiver = __pb.qwkArchiver;
	rec->ripFont = __pb.ripFont;
	rec->checkMail = __pb.checkMail;
	rec->checkNewFiles = __pb.checkNewFiles;

	/*
	 * get the info from the RA structure
	*/
	strfmpas( rec->alias, __ra.alias );
	strfmpas( rec->city, __ra.city );
	strfmpas( rec->company, __ra.company );
	strfmpas( rec->address1, __ra.address1 );
	strfmpas( rec->address2, __ra.address2 );
	strfmpas( rec->address3, __ra.address3 );
	strfmpas( rec->comment, __ra.comment );
	strfmpas( rec->forwardTo, __ra.forwardTo );
	strfmpas( rec->voicePhone, __ra.voicePhone );
	strfmpas( rec->dataPhone, __ra.dataPhone );
	memcpy( rec->combinedBoards, (byte *)__ra.combinedBoards, 125 );
	rec->passWordCRC = __ra.passWordCRC;
	rec->level = __ra.level;
	rec->sex = __ra.sex;
	rec->dateFormat = __ra.dateFormat;
	rec->defaultProtocol = __ra.defaultProtocol;
	rec->screenWidth = __ra.screenWidth;
	rec->screenLength = __ra.screenLength;
	rec->timeUsed = (long)__ra.timeUsed;
	rec->timesCalled = __ra.timesCalled;
	rec->numDownloads = __ra.numDownloads;
	rec->kbDownloaded = __ra.kbDownloaded;
	rec->numUploads = __ra.numUploads;
	rec->kbUploaded = __ra.kbUploaded;
	rec->msgsPosted = __ra.msgsPosted;
	rec->kbToday = __ra.kbToday;
	rec->credit = __ra.credit;
	rec->pending = __ra.pending;
	rec->fileArea = __ra.fileArea;
	rec->msgArea = __ra.msgArea;
	rec->highMsgRead = __ra.highMsgRead;
	rec->fileGroup = __ra.fileGroup;
	rec->msgGroup = __ra.msgGroup;
	rec->aFlags = _setUserAccess();
	_ra2pbDate( rec->expDate, __ra.subDate );
	_ra2pbDate( rec->birthDate, __ra.birthDate );
	_ra2pbDate( rec->lastDate, __ra.lastDate );
	_ra2pbTime( rec->lastTime, __ra.lastTime );
	_ra2pbDate( rec->firstDate, __ra.firstDate );

	/*
	 * from both structures
	*/
	rec->uFlags = _setUserAttrib();
	return 0;
}


/*
 * writes a user record to file
*/
	int
WriteUser( USER_REC *rec )
{
	char crcBuf[36];
	USERSIDX_BBS recIDX;
	USERSXI_BBS  recXI;

	/*
	 * convert to the PB structure for the USERSPB.BBS file
	*/
	strcpy( __pb.name, rec->name );
	strcpy( __pb.country, rec->country );
	strcpy( __pb.state, rec->state );
	strcpy( __pb.faxPhone, rec->faxPhone );
	strcpy( __pb.passWord, rec->passWord );
	strcpy( __pb.language, rec->language );
	memcpy( __pb.lastPwdChange, rec->lastPwdChange, sizeof(DateType) );
	memcpy( __pb.lastNewFilesCheck, rec->lastNewFilesCheck, sizeof(DateType));
	memcpy( __pb.tbTimePayback, rec->tbTimePayback, sizeof(DateType) );
	memcpy( __pb.tbKbPayback, rec->tbKbPayback, sizeof(DateType) );
	memcpy( __pb.tbLastUsed, rec->tbLastUsed, sizeof(DateType) );
	memcpy( __pb.mailCheckBoards, rec->mailCheckBoards, 125 );
	__pb.logLevel = rec->logLevel;
	__pb.tbTimeBalance = rec->tbTimeBalance;
	__pb.tbKbBalance = rec->tbKbBalance;
	__pb.tbTimeWithdrawn = rec->tbTimeWithdrawn;
	__pb.tbKbWithdrawn = rec->tbKbWithdrawn;
	__pb.tbTimeDeposited = rec->tbTimeDeposited;
	__pb.tbKbDeposited = rec->tbKbDeposited;
	__pb.tbTimeLoaned = rec->tbTimeLoaned;
	__pb.tbKbLoaned = rec->tbKbLoaned;
	__pb.expLevel = rec->expLevel;
	__pb.expFlagsOn = rec->expFlagsOn;
	__pb.expFlagsOff = rec->expFlagsOff;
	__pb.totalTimeUsed = rec->totalTimeUsed;
	__pb.qwkMaxMsgsPerArea = rec->qwkMaxMsgsPerArea;
	__pb.qwkMaxMsgs = rec->qwkMaxMsgs;
	__pb.qwkArchiver = rec->qwkArchiver;
	__pb.ripFont = rec->ripFont;
	__pb.checkMail = rec->checkMail;
	__pb.checkNewFiles = rec->checkNewFiles;

	/*
	 * convert to the RA structure for the USERS.BBS file
	*/
	memcpy( (byte *)__ra.combinedBoards, rec->combinedBoards, 125 );
	memset( &((byte *)__ra.combinedBoards)[125], 0, 275 );
	strtopas( __ra.city, rec->city );
	strtopas( __ra.company, rec->company );
	strtopas( __ra.address1, rec->address1 );
	strtopas( __ra.address2, rec->address2 );
	strtopas( __ra.address3, rec->address3 );
	strtopas( __ra.comment, rec->comment );
	strtopas( __ra.forwardTo, rec->forwardTo );
	strtopas( __ra.alias, rec->alias );
	strtopas( __ra.voicePhone, rec->voicePhone );
	strtopas( __ra.dataPhone, rec->dataPhone );
	strtopas( __ra.name, rec->name );
	_pb2raDate( __ra.birthDate, rec->birthDate );
	_pb2raDate( __ra.lastDate, rec->lastDate );
	_pb2raTime( __ra.lastTime, rec->lastTime );
	_pb2raDate( __ra.firstDate, rec->firstDate );
	_pb2raDate( __ra.subDate, rec->expDate );
	_cvtUserAccess( rec->aFlags );
	strcpy( crcBuf, rec->passWord );
	__ra.passWordCRC = ~bufCRC32( strupr(crcBuf), strlen(crcBuf) );
	__ra.sex = rec->sex;
	__ra.dateFormat = rec->dateFormat;
	__ra.defaultProtocol = rec->defaultProtocol;
	__ra.screenWidth = rec->screenWidth;
	__ra.screenLength = rec->screenLength;
	__ra.timeUsed = (word)rec->timeUsed;
	__ra.timesCalled = rec->timesCalled;
	__ra.numDownloads = rec->numDownloads;
	__ra.kbDownloaded = rec->kbDownloaded;
	__ra.numUploads = rec->numUploads;
	__ra.kbUploaded = rec->kbUploaded;
	__ra.msgsPosted = rec->msgsPosted;
	__ra.level = rec->level;
	__ra.kbToday = rec->kbToday;
	__ra.credit = rec->credit;
	__ra.pending = rec->pending;
	__ra.fileArea = rec->fileArea;
	__ra.msgArea = rec->msgArea;
	__ra.highMsgRead = rec->highMsgRead;
	__ra.fileGroup = rec->fileGroup;
	__ra.msgGroup = rec->msgGroup;

	/*
	 * to both structures
	*/
	_cvtUserAttrib( rec->uFlags );

	/*
	 * Update USERSIDX.BBS
	*/
	strcpy( crcBuf, rec->name );
	recIDX.nameCRC32 = ~bufCRC32( strupr(crcBuf), strlen(crcBuf) );
	strcpy( crcBuf, rec->alias );
	recIDX.aliasCRC32 = ~bufCRC32( strupr(crcBuf), strlen(crcBuf) );

	/*
	 * Update USERSXI.BBS
	*/
	memset( &recXI, 0, sizeof(USERSXI_BBS) );

	/*
	 * do the actual writes
	*/
	if( -1 == WriteUsersPB( (int)rec->record, &__pb) ) return -1;
	if( -1 == WriteUsersBBS( (int)rec->record, &__ra) ) return -1;
	if( -1 == WriteUsersIDX( (int)rec->record, &recIDX ) ) return -1;
	if( -1 == WriteUsersXI( (int)rec->record, &recXI ) ) return -1;

	return 0;
}

#endif
