/*
 WHO CALLED ProBoard PEX Version and MS-DOS EXE
 Copyright (C) 1995 by Branislav L. Slantchev

 This file is part of WHO CALLED.

 WHO CALLED is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; version 2.

 WHO CALLED is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with WHO CALLED; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if !defined( __STRLIB_H )
#define __STRLIB_H

/*
 ***************************************************************************
                       String manipulation library
 ***************************************************************************
*/

#if !defined( __PBINC_H )
	#include "pbinc.h"
#endif

#if !defined( PB_SDK )
	#if !defined( __STDIO_H )
		#include <stdio.h>
	#endif
	#if !defined( __STRING_H )
		#include <string.h>
	#endif
	#if !defined( __CTYPE_H )
		#include <ctype.h>
	#endif
	#if !defined( __TIME_H )
		#include <time.h>
	#endif
	#if !defined( __STDARG_H )
		#include <stdarg.h>
	#endif
	#if !defined( __ALLOC_H )
		#include <alloc.h>
	#endif
#endif

#define strequ(a,b)   ( 0 == strcmp(a,b)  )
#define strnequ(a,b)  ( 0 != strcmp(a,b)  )
#define striequ(a,b)  ( 0 == stricmp(a,b) )
#define strinequ(a,b) ( 0 != stricmp(a,b) )

#if defined( __cplusplus )
	extern "C" {
#endif

char *strichr( const char *s, int ch );
char *stristr( const char *s1, const char *s2 );
char *strecpy( char *dest, const char *src );
char *strnecpy( char *dest, const char *src, size_t n );
char *strdel( char *s, size_t index, size_t n );
char *strins( char *s1, const char *s2, size_t index );
char *strtrm( char *s );
char *strrtrm( char *s );
char *strcma( char *dest, const char *src );
char *strtime( void );
char *strdate( void );
char *strcins( char *s, size_t index, int ch );
char *strcdel( char *s, size_t index );
char *strccat( char *s, int ch );
char *strtts( const char *s, int n );
char *strleft( char *dest, const char *src, size_t n );
char *stright( char *dest, const char *src, size_t n );
char *strmid( char *dest, const char *src, size_t index, size_t n );
char *strvcat( char *s, ... );
char *strcent( char *dest, const char *src, size_t n );
char *strneset( char *s, int ch, size_t n );
char *strfmpas( char *dest, const char *src );
char *strtopas( char *dest, const char *src );
char *strfupr( char *s, const char *sep );
char *strcrm( char *s, int c );
char *strcrep( char *s, int c1, int c2 );
char *strsrm( char *s1, const char *s2 );
char *strsrep( char *s1, const char *s2, const char *s3 );
char *stradd( char *dest, const char *s1, const char *s2 );

#if defined( __cplusplus )
	}
#endif

#endif
