/* Ethereal User Editor version 3.0 Standard */
/* FREEWARE */
/* (C) 1995 Alvin Brinson */
/* Originally Based on AEdit (C) 1994 by Gregory Gulick */

/* ETHICAL MOANS AND GROANS: */

/* If you use this source code, please give credit to all previous */
/* authors and do not charge cash for it! If you feel you must ask for */
/* cash, write something from scratch, please! */
/* Also, please include your complete SOURCE CODE and all needed modules */
/* along with your distribution. I helped you by releasing this, just as */
/* Gregroy Gulick helped me. Help other programmers as well. */

/* TECHNICAL STUFF */

/* This source code compiles without errors in TURBO C 2.0 using the    */
/* following commandlines for compiler and linker:                      */
/* tcc -c -ml uedit.c                                                   */
/* tlink uedit,uedit.pex,,PB_SDK /N /C                                  */
/* Can't guarantee success on any other compiler.                       */

/* More Bullshit */
/* I don't comment my source code well. I don't plan on it. */

#include "pb_sdk.h"

#define CR 1
#define NOCR 0

/* The following is a string constant that is used to print the user's*/
/* flag status.  Note the initial space.  This is so the string array*/
/* numbers coincide with Phillippe's flag numbers. (1 to 32 as opposed*/
/* to 0-31).*/

#define FLAGS   " ABCDEFGHIJKLMNOPQRSTUVWXYZ123456"

/* Prototypes*/

void main(int argc, char **argv);               /* Read Command Line Params*/
void no_memory(void);                           /* Out of memory*/
void press_enter(void);                         /* Press enter to continue*/
void top_header(void);                          /* Title, etc.*/
void bottom_header(void);                       /* Written by...*/
void user_info(void);                           /* Print user information*/
void pline(int ln, char color, char text[80]);  /* Print line information*/
void clr_window(void);                          /* Clear text window routine*/
void menu(void);                                /* Command entry routine*/
void flagmenu(void);                            /* Flags editing routine*/
void acc_menu(void);                            /* Accounting Menu */
void acc_show(void);                            /* Accounting Display */
void stat_menu(void);                           /* Stats Menu */
void stat_show(void);                           /* Stats Display */
void l1(void);                                  /* GotoXY line 1*/
void l2(void);                                  /* GotoXY line 2*/
void l3(void);                                  /* GotoXY line 3*/
void search_status(int loc, int num);           /* Searching status rec num*/
bool disabled(char test[10]);                   /* Mod disabled routine*/
void fill(int y, int crstat);                   /* Fill inactive with */
void cannot_edit(void);                         /* Displayed when cannot edit*/
void clr_topscr(void);                          /* Clear Main Display Area */
void showda_flags(void);                        /* Show Flags Data */
void showhelp(void);                            /* Show Help */
void clone_sub(void);                           /* part 1 of clone routine */
void clone_user(void);                          /* part 2 of clone routine */
void search_user(void);                         /* search routine , user */
void repeat_usearch(void);                      /* repeat user search routine */
void wipe_user(void);                           /* wipe current user record */
void wipe_action(void);                         /* action used by wipe & append */
void append_rec(void);                          /* appends blank record */

/* Global Variables*/

    char ch;                                    /* Multipurpose character*/
    char dataline[100];                         /* Temporary storage of Data*/
    char params[200];                           /* Command line parameters*/
    int cur_user_num;                           /* Current user number*/
    long sysop_level;                           /* Sysop access level*/
    int x;                                      /* Generic loop variable*/
    int clone_to;                               /* For Clone Function */
    int max_users;                              /* Read/Write for NumUsers*/

    char choice, search[40], temp[40], flag, buf[100], asc_value[2];
	bool match_found;
    int flag_num;


    USER_REC *rec, *recs;                       /* User record pointers*/
    USER_REC *temp_recs, *temp_rec;             /* Temp user rec pointers*/

    bool sysop       = TRUE;
    bool become      = FALSE;

/* -------------------------------------------------------------------------*/
/* Standard PowerPEX procedures, Press Enter, No Memory, etc.*/
/* -------------------------------------------------------------------------*/

void no_memory(void)
{
	printf("\f");
	SetColor(RED);
    printf("Insufficient memory to run PEX!\n");
    Log(LOG_FRIEND,"%s: Not Enough Memory to run User Editor!",CurUser->name);
    press_enter();

    exit();                                     /* Abort program*/
}

void press_enter(void)
{
	GotoXY(1,22);
    printf("\007Press [\003Enter\007] to Continue.\t");
}

/* -------------------------------------------------------------------------*/
/* Fancy screen function, Clear window, etc.*/
/* -------------------------------------------------------------------------*/

void cannot_edit(void)
{

    /* This function is run when the user tries to edit a field they are*/
    /* not allowed to edit, or attempts to edit their own account.*/
    /* only should happen on security violation now, sysops can edit */
    /* anything, co-sysops can't edit certain key feilds             */

	clr_window();
		pline(1,RED,"You cannot edit this field.");
    Log(LOG_FRIEND,"%s Tried to edit a disallowed field in the User Editor!",CurUser->name);
    press_enter();
}

void fill(int y, int crstat)
{
	int x;

    /* This procedure fills the field with "" if the user cannot access*/
    /* the specified field on the command line.  The variable crstat is the*/
    /* carriage return status variable.  If it is true, a new line is sent.*/
    /* If not, two spaces are printed for the purpose of seperating the*/
    /* fields correctly.*/

	for (x=1; x<=y; ++x)
		printf("\005");

	if (crstat == CR)
		printf("\n");
	else
		printf("  ");
}

void pline(int ln,char color, char text[80])
{
    switch (ln) {                               /* What line to print on?*/
		case 1 : GotoXY(1,20); break;
		case 2 : GotoXY(1,21); break;
		case 3 : GotoXY(1,22); break;
	}

	SetColor(color);
    printf("%s",text);                          /* Print text*/

}

void clr_window()                               /* Clear text window*/
{
    GotoXY(1,20); ClrEol();
    GotoXY(1,21); ClrEol();
    GotoXY(1,22); ClrEol();
}

void clr_topscr()                               /* Clear Display Area */
{
    GotoXY(1,4);
    for (x=0; x<=14; ++x)
       printf("                                                                              \n");
}

void search_status(int loc, int num)
{
    GotoXY(loc+1,20);
    printf("%d",num);
}

void l1(void)
{
    GotoXY(1,20);
}

void l2(void)
{
    GotoXY(1,21);
}

void l3(void)
{
    GotoXY(1,22);
}


/*

Global Menu Subroutines

*/

void showhelp(void)
{
        clr_topscr();
        GotoXY(1,4);
        printf("       \007Ethereal User Editor 3.0 Standard Release\n");
        printf("            \001Compiled Jan. 3, 1996\n\n");
        printf("        \007  [    \006- \005Previous User.     \007  ]    \006- \005Next User.         \n");
        printf("        \007CTRL-P \006- \005Message to User.   \007  =    \006- \005Jump to User#      \n");
        printf("        \007CTRL-B \006- \005First User.        \007CTRL-E \006- \005Last User.         \n");
        printf("        \007CTRL-U \006- \005Search Userfile.   \007CTRL-N \006- \005Repeat Search.     \n");
        printf("        \007CTRL-D \006- \005Delete User.       \007CTRL-W \006- \005Wipe User          \n");
        printf("        \007CTRL-Z \006- \005Become User.       \007CTRL-C \006- \005Clone User.        \n");
        printf("        \007CTRL-A \006- \005Append Record.     \007CTRL-R \006- \005Redraw Screen.     \n");
        printf("        \002(\007C\002) \007 1995 \004 Alvin Brinson");
        printf("                   \0071\002:\007106\002/\0077008 \006 FidoNet");

        clr_window();
        press_enter();
        clr_topscr();
}

void search_user()
{
    clr_window();
    pline(1,CYAN,"Search Name.");
                l3();
                SetColor(WHITE);
                printf("Enter search string : ");
                Input(search,36,INPUT_UPALL);
                if (strlen(search) == 0)
                    strcpy(search,CurUser->name);

                match_found = FALSE;

                clr_window();
                pline(1,WHITE,"Searching... ");
                for (x=0; x<=max_users-1 && match_found == FALSE; ++x) {
                    search_status(13,x+1);
                    ReadUser(temp_rec,x);
                    strcpy(temp,strupr(temp_rec->name));
                    if ((strstr(temp,search) != NULL) || (FuzzySearch(temp,search,80) >= 80)) {
                        cur_user_num = x;
                        match_found = TRUE;
                    }
                    strcpy(temp,strupr(temp_rec->alias));
                    if ((strstr(temp,search) != NULL) || (FuzzySearch(temp,search,80) >= 80)) {
                        cur_user_num = x;
                        match_found = TRUE;
                    }
                }
                if (match_found == FALSE) {
                    clr_window();
                    pline(1,RED,"No match found.");
                    press_enter();
                }
}

void repeat_usearch()
{
    if (strlen(search) == 0)
        strcpy(search,CurUser->name);
    clr_window();

    match_found = FALSE;

    clr_window();
    pline(1,WHITE,"Searching... ");
    for (x=cur_user_num+1; x<=max_users-1 && match_found == FALSE; ++x) {
        search_status(13,x+1);
        ReadUser(temp_rec,x);
        strcpy(temp,strupr(temp_rec->name));
        if ((strstr(temp,search) != NULL) || (FuzzySearch(temp,search,80) >= 80)) {
            cur_user_num = x;
            match_found = TRUE;
        }
        strcpy(temp,strupr(temp_rec->alias));
        if ((strstr(temp,search) != NULL) || (FuzzySearch(temp,search,80) >= 80)) {
            cur_user_num = x;
            match_found = TRUE;
        }
    }
    if (match_found == FALSE) {
        clr_window();
        pline(1,RED,"No match found.");
        press_enter();
    }
}


void wipe_action()
{
        strcpy(rec->name,"");
        strcpy(rec->alias,"");
        strcpy(rec->passWord,"");
        rec->level=0;
        strcpy(rec->country,"");
        strcpy(rec->state,"");
        strcpy(rec->city,"");
        strcpy(rec->company,"");
        strcpy(rec->address1,"");
        strcpy(rec->address2,"");
        strcpy(rec->address3,"");
        strcpy(rec->comment,"");
        strcpy(rec->forwardTo,"");
        rec->birthDate[1]=0;
        rec->birthDate[0]=0;
        rec->birthDate[2]=0;
        strcpy(rec->voicePhone,"");
        strcpy(rec->dataPhone,"");
        strcpy(rec->faxPhone,"");
        rec->sex=0;
        rec->dateFormat=0;
        rec->defaultProtocol=0;
        strcpy(rec->language,"");
        rec->screenWidth=80;
        rec->screenLength=24;
        rec->timeUsed=0;
        rec->timesCalled=0;
        rec->numDownloads=0;
        rec->kbDownloaded=0;
        rec->numUploads=0;
        rec->kbUploaded=0;
        rec->msgsPosted=0;
        rec->lastDate[0]=0;
        rec->lastDate[1]=0;
        rec->lastDate[2]=0;
        rec->lastTime[0]=0;
        rec->lastTime[1]=0;
        rec->lastTime[2]=0;
        rec->lastPwdChange[0]=0;
        rec->lastPwdChange[1]=0;
        rec->lastPwdChange[2]=0;
        rec->lastNewFilesCheck[0]=0;
        rec->lastNewFilesCheck[1]=0;
        rec->lastNewFilesCheck[2]=0;
        rec->aFlags=0;
        rec->uFlags=0;
        rec->logLevel=0;
        rec->totalTimeUsed=0;
        rec->expDate[0]=0;
        rec->expDate[1]=0;
        rec->expDate[2]=0;
        rec->expLevel=0;
        rec->expFlagsOn=0;
        rec->expFlagsOff=0;
        rec->firstDate[0]=0;
        rec->firstDate[1]=0;
        rec->firstDate[2]=0;
        rec->kbToday=0;
        rec->credit=0;
        rec->pending=0;
        rec->fileArea=1;
        rec->msgArea=1;
        rec->tbTimeBalance=0;
        rec->tbKbBalance=0;
        rec->tbTimeWithdrawn=0;
        rec->tbKbWithdrawn=0;
        rec->tbTimeDeposited=0;
        rec->tbKbDeposited=0;
        rec->tbTimeLoaned=0;
        rec->tbKbLoaned=0;
        rec->tbLastUsed[0]=0;
        rec->tbLastUsed[1]=0;
        rec->tbLastUsed[2]=0;
        rec->checkMail=0;
        rec->checkNewFiles=0;
        rec->highMsgRead=0;
        rec->qwkMaxMsgsPerArea=500;
        rec->qwkMaxMsgs=5000;
        rec->qwkArchiver=0;
        rec->ripFont=0;
        rec->tbTimePayback[0]=0;
        rec->tbTimePayback[1]=0;
        rec->tbTimePayback[2]=0;
        rec->tbKbPayback[0]=0;
        rec->tbKbPayback[1]=0;
        rec->tbKbPayback[2]=0;
        rec->fileGroup=0;
        rec->msgGroup=0;
}

void wipe_user()
{
    clr_window();
    pline(2,RED,"Wipe User? Are 100% absolutely positively sure? ");
    if (Ask(FALSE) == TRUE) {
        wipe_action();
    }
}

void clone_user()
{
    Log(LOG_SUSPICIOUS,"User # %u cloned into User # %u",cur_user_num,clone_to);
    cur_user_num = clone_to;
    rec->record = clone_to;
    WriteUser(rec);
}

void clone_sub()
{
            clr_window();
                pline(2,WHITE,"Clone User? Are You Sure? ");
                if (Ask(FALSE) == TRUE) {
                        clone_to = max_users;
                        clone_user();
                        clr_window();
                        pline(1,CYAN,"Edit User Name.");
                        pline(2,BLUE,"Must change name to avoid conflicts.");
                        l3();
                        printf("\007Enter New User Name : ");
                        Input(dataline,35,INPUT_ALL);
                            if (strlen(dataline) == 0)
                                strcpy(rec->name,"Cloned User");
                            strcpy(rec->name,dataline);
                            WriteUser(rec);
                            ++max_users;
                    }
                    else {
                        clr_window();
                        pline(1,RED,"Cannot clone into non-existant user record. Use 'CTRL-A' to append new record.\n");
                        press_enter();
    }
}

void append_rec()
{
            clr_window();
                pline(2,WHITE,"Append Record? ");
                if (Ask(TRUE) == TRUE) {
                    max_users = max_users + 1;
                    printf("Appending record at position %u...",max_users);
                    cur_user_num = max_users-1;
                    rec->record=cur_user_num;
                    wipe_action();
                }
}

/* -------------------------------------------------------------------------*/
/* Menu, User Information Procedures, Headers, etc.*/
/* -------------------------------------------------------------------------*/

void top_header(void)
{
	printf("\f");
    SetColor(MAGENTA);
    printf("\004\n");
    printf("\004 \007Ethereal User Editor 3.0 \004\n");
    printf("\n");
}

void showda_flags(void)
{
    clr_topscr();

    GotoXY(1,4);
    printf("\007[\003\007] Name  : \006%-25.25s  ",rec->name);

    GotoXY(1,5);
    printf("\007[\003A\007] Deleted : ");
    if (rec->uFlags & UFLAG_DELETED) {
        GotoXY(25,5);
        printf("\005Yes");
     }
     else {
        GotoXY(25,5);
        printf("\004No ");
     }

    GotoXY(1,6);
    printf("\007[\003B\007] Ansi Mode : ");
    if (rec->uFlags & UFLAG_ANSI) {
        GotoXY(25,6);
        printf("\005Yes");
     }
     else {
        GotoXY(25,6);
        printf("\004No ");
     }

    GotoXY(1,7);
    printf("\007[\003C\007] Pause Mode : ");
    if (rec->uFlags & UFLAG_PAUSE) {
        GotoXY(25,7);
        printf("\005Yes");
     }
     else {
        GotoXY(25,7);
        printf("\004No ");
     }

    GotoXY(1,8);
    printf("\007[\003D\007] Clear Screen : ");
    if (rec->uFlags & UFLAG_CLEAR) {
        GotoXY(25,8);
        printf("\005Yes");
     }
     else {
        GotoXY(25,8);
        printf("\004No ");
     }
    

    GotoXY(1,9);
    printf("\007[\003E\007] Hotkeys : ");
    if (rec->uFlags & UFLAG_HOTKEYS) {
        GotoXY(25,9);
        printf("\005Yes");
     }
     else {
        GotoXY(25,9);
        printf("\004No ");
     }

    GotoXY(1,10);
    printf("\007[\003F\007] IBM Graphics : ");
    if (rec->uFlags & UFLAG_NOIBM) {
        GotoXY(25,10);
        printf("\004No ");
     }
     else {
        GotoXY(25,10);
        printf("\005Yes");
     }

    GotoXY(1,11);
    printf("\007[\003G\007] Full Screen Ed : ");
    if (rec->uFlags & UFLAG_FSED) {
        GotoXY(25,11);
        printf("\005Yes");
     }
     else {
        GotoXY(25,11);
        printf("\004No ");
     }

    GotoXY(1,12);
    printf("\007[\003H\007] Don't Kill User : ");
    if (rec->uFlags & UFLAG_NOKILL) {
        GotoXY(25,12);
        printf("\005Don't Kill   ");
     }
     else {
        GotoXY(25,12);
        printf("\004Kill the Twit");
     }

    GotoXY(1,13);
    printf("\007[\003I\007] Ignore Downloads : ");
    if (rec->uFlags & UFLAG_IGNORE) {
        GotoXY(25,13);
        printf("\005Yes");
     }
     else {
        GotoXY(25,13);
        printf("\004No ");
     }

    GotoXY(1,14);
    printf("\007[\003J\007] Attention : ");
    if (rec->uFlags & UFLAG_ATTEN) {
        GotoXY(25,14);
        printf("\005Yes");
     }
     else {
        GotoXY(25,14);
        printf("\004No ");
     }

    GotoXY(1,15);
    printf("\007[\003K\007] Hide From Tops : ");
    if (rec->uFlags & UFLAG_NOTOPS) {
        GotoXY(25,15);
        printf("\005Yes");
     }
     else {
        GotoXY(25,15);
        printf("\004No ");
     }

    GotoXY(40,5);
    printf("\007[\003L\007] Hide from Lists : ");
    if (rec->uFlags & UFLAG_HIDDEN) {
        GotoXY(65,5);
        printf("\005Yes");
     }
     else {
        GotoXY(65,5);
        printf("\004No ");
     }

    GotoXY(40,6);
    printf("\007[\003M\007] Quiet : ");
    if (rec->uFlags & UFLAG_QUIET) {
        GotoXY(65,6);
        printf("\005Yes");
     }
     else {
        GotoXY(65,6);
        printf("\004No ");
     }

    GotoXY(40,7);
    printf("\007[\003N\007] Avatar : ");
    if (rec->uFlags & UFLAG_AVATAR) {
        GotoXY(65,7);
        printf("\005Yes");
     }
     else {
        GotoXY(65,7);
        printf("\004No ");
     }

    GotoXY(40,8);
    printf("\007[\003O\007] Avatar Plus : ");
    if (rec->uFlags & UFLAG_AVTPLUS) {
        GotoXY(65,8);
        printf("\005Yes");
     }
     else {
        GotoXY(65,8);
        printf("\004No ");
     }

    GotoXY(40,9);
    printf("\007[\003P\007] Guest Account : ");
    if (rec->uFlags & UFLAG_GUEST) {
        GotoXY(65,9);
        printf("\005Yes");
     }
     else {
        GotoXY(65,9);
        printf("\004No ");
     }

    GotoXY(40,10);
    printf("\007[\003R\007] Page Priority : ");
    if (rec->uFlags & UFLAG_PAGEPRI) {
        GotoXY(65,10);
        printf("\005Yes");
     }
     else {
        GotoXY(65,10);
        printf("\004No ");
     }

    GotoXY(40,11);
    printf("\007[\003S\007] Local Only : ");
    if (rec->uFlags & UFLAG_LOCALONLY) {
        GotoXY(65,11);
        printf("\005Yes");
     }
     else {
        GotoXY(65,11);
        printf("\004No ");
     }

    GotoXY(40,12);
    printf("\007[\003T\007] Multiple Logins : ");
    if (rec->uFlags & UFLAG_MULTILOGIN) {
        GotoXY(65,12);
        printf("\005Yes");
     }
     else {
        GotoXY(65,12);
        printf("\004No ");
     }

    GotoXY(40,13);
    printf("\007[\003U\007] Free Chat : ");
    if (rec->uFlags & UFLAG_FREECHAT) {
        GotoXY(65,13);
        printf("\005Yes");
     }
     else {
        GotoXY(65,13);
        printf("\004No ");
     }

    GotoXY(40,14);
    printf("\007[\003V\007] Disable RIP : ");
    if (rec->uFlags & UFLAG_NORIP) {
        GotoXY(65,14);
        printf("\005Yes");
     }
     else {
        GotoXY(65,14);
        printf("\004No ");
     }

}

void user_info(void)
{
	int x;

	GotoXY(1,4);
	printf("\007[\003N\007] Name  : \006%-25.25s  ",rec->name);

	printf("\007[\003V\007] Voice Phone   : ");
    if (sysop)
		printf("\006%-16.16s\n",rec->voicePhone);
	else
		fill(16,CR);

	printf("\007[\003A\007] Alias : ");
		printf("\006%-25.25s  ",rec->alias);

	printf("\007[\003D\007] Data Phone    : ");
    if (sysop)
		printf("\006%-16.16s\n",rec->dataPhone);
	else
		fill(16,CR);

	printf("\007[\003P\007] Pass  : ");
    if (sysop)
		printf ("\006%-25.25s  ",rec->passWord);
	else
		fill(25,NOCR);

    printf("\007[\003Z\007] Fax Phone     : ");
    if (sysop)
		printf("\006%-16.16s\n",rec->faxPhone);
	else
		fill(16,CR);

	printf("\007[\003C\007] City  :\006 ");
		printf("%-25.25s\n",rec->city);

	printf("\007[\003S\007] State :");
        printf("\006 %-25.25s  \n",rec->state);

    GotoXY(40,8);
    printf("\007[\003U\007] Language:\006 %s        \n",rec->language);

    printf("\007[\0031\007] Addr1 :\006 ");
    if (sysop)
        printf("%-25.25s  \n",rec->address1);
	else
		fill(25,NOCR);

    GotoXY(40,9);
    printf("\007[\003E\007] LogLevel : ");
        if (rec->logLevel == 1) printf("Normal    ");
        if (rec->logLevel == 2) printf("Suspicious");
        if (rec->logLevel == 3) printf("Dangerous ");
        if (rec->logLevel == 0) printf("Friend    ");
    printf("\n");

    printf("\007[\0032\007] Addr2 :\006 ");
    if (sysop)
		printf("%-25.25s\n",rec->address2);
	else
        fill(25,NOCR);

    GotoXY(40,10);
    printf("\007[\003I\007] First Login Date :   /  /      \n");
        GotoXY(64,10);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->firstDate[1],
            rec->firstDate[0],
            rec->firstDate[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->firstDate[0],
            rec->firstDate[1],
            rec->firstDate[2]);

/* End of First Login Date */

    printf("\007[\0033\007] Addr3 :\006 ");
    if (sysop)
        printf("%-25.25s",rec->address3);
    else
        fill(25,CR);

    GotoXY(1,12);
    printf("\007[\003L\007] Level : \006%-5u",rec->level);

    GotoXY(40,12);
    printf("\007[\003G\007] Gender : ");
        if (rec->sex == 1) printf("Male    ");
        if (rec->sex == 2) printf("Female  ");
        if (rec->sex == 0) printf("Unknown!");


    GotoXY(1,13);
    printf("\007[\003B\007] BirthDate :   /  /      \n");
        GotoXY(18,13);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->birthDate[1],
            rec->birthDate[0],
            rec->birthDate[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->birthDate[0],
            rec->birthDate[1],
            rec->birthDate[2]);

    GotoXY(40,13);
    printf("\007[\003\007] Screen : (\003X\007) %u    ",rec->screenWidth);
    printf("\007(\003Y\007) %u    ",rec->screenLength);

    GotoXY(40,11);
    printf("\007[\003J\007] Last Login Date  :   /  /      \n");
        GotoXY(64,11);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->lastDate[1],
            rec->lastDate[0],
            rec->lastDate[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->lastDate[0],
            rec->lastDate[1],
            rec->lastDate[2]);

/* End of Last Login Date */

    if (rec->uFlags & UFLAG_DELETED) {
        GotoXY(40,7);
        printf("\x11[DELETED]    \n\n");
	}
	else {
        GotoXY(40,7);
        printf("\007[\002Active User\007]\n\n");
	}

    GotoXY (1,14);


    printf("\007[\003F\007] Flags       : ");
	for (x=1; x<=32; ++x) {
		if (GetFlag(rec->aFlags,x) == TRUE)
			printf("\006%c",FLAGS[x]);
		else
			printf("\007-");
	}
    printf("\n");

    printf("\007[\003W\007] Forward : \006%-35.35s\n",rec->forwardTo);

    printf("\007[\003O\007] Company : \006%-50.50s\n",rec->company);

    printf("\007[\003T\007] Comment : ");
    if (sysop)
        printf("\006%-64.64s\n",rec->comment);
	else
		fill(64,CR);

    printf("\002CTL-F Flags \007-\002 CTL-G Accounting \007-\002 CTL-T Statistics");
}


void acc_show()
{
    clr_topscr();

    GotoXY(1,4);
    printf("\007[\003\007] Name  : \006%-25.25s  ",rec->name);

    GotoXY(1,5);

    printf("\007[\003G\007] Expire To : \006%-5u\n",rec->expLevel);

    printf("\007[\003H\007] expFlagsOff : ");
    for (x=1; x<=32; ++x) {
        if (GetFlag(rec->expFlagsOff,x) == TRUE)
            printf("\006%c",FLAGS[x]);
        else
            printf("\007-");
    }

    printf("\n");

    printf("\007[\003R\007] expFlagsOn  : ");
    for (x=1; x<=32; ++x) {
        if (GetFlag(rec->expFlagsOn,x) == TRUE)
            printf("\006%c",FLAGS[x]);
        else
            printf("\007-");
    }

    printf("\n");

    GotoXY(1,8);

    printf("\007[\003E\007] Expiration Date :   /  /      \n");
        GotoXY(23,8);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d    \n",
            rec->expDate[1],
            rec->expDate[0],
            rec->expDate[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d    \n",
            rec->expDate[0],
            rec->expDate[1],
            rec->expDate[2]);

    GotoXY(1,9);
    printf("\007[\003C\007] Credit: %d    ",rec->credit);

    GotoXY(40,9);
    printf("\007[\003P\007] Pending Credit: %d",rec->pending);


}

void stat_show()
{
    clr_topscr();

    GotoXY(1,4);
    printf("\007[\003\007] Name  : \006%-25.25s  ",rec->name);


    GotoXY(1,5);
    printf("\003Timebank:");

    GotoXY(1,6);
    printf("\007[\0031\007] Date Used Last:   /  /      \n");
        GotoXY(21,6);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->tbLastUsed[1],
            rec->tbLastUsed[0],
            rec->tbLastUsed[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->tbLastUsed[0],
            rec->tbLastUsed[1],
            rec->tbLastUsed[2]);


    GotoXY(1,7);
    printf("\007[\0032\007] Time Balance  : \006%-16d\n",rec->tbTimeBalance);

    GotoXY(1,8);
    printf("\007[\0033\007] W/Drawed Today: \006%u     ",rec->tbTimeWithdrawn);

    GotoXY(1,9);
    printf("\007[\0034\007] Deposit Today : \006%u     ",rec->tbTimeDeposited);

    GotoXY(1,10);
    printf("\007[\0035\007] Time on Loan  : \006%u     ",rec->tbTimeLoaned);

    GotoXY(1,11);
    printf("\007[\0036\007] Payback Date  :   /  /      \n");
        GotoXY(21,11);  /* fix this before finishing */
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->tbTimePayback[1],
            rec->tbTimePayback[0],
            rec->tbTimePayback[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->tbTimePayback[0],
            rec->tbTimePayback[1],
            rec->tbTimePayback[2]);

    GotoXY(40,5);
    printf("\003Bytebank:");

    GotoXY(40,7);
    printf("\007[\0037\007] Byte Balance  : \006%-16d\n",rec->tbKbBalance);

    GotoXY(40,8);
    printf("\007[\0038\007] W/Drawed Today: \006%u     ",rec->tbKbWithdrawn);

    GotoXY(40,9);
    printf("\007[\0039\007] Deposit Today : \006%u     ",rec->tbKbDeposited);

    GotoXY(40,10);
    printf("\007[\003A\007] Bytes on Loan : \006%u     ",rec->tbKbLoaned);

    GotoXY(40,11);
    printf("\007[\003B\007] Payback Date  :   /  /      \n");
        GotoXY(61,11);
        if (Config->europe == 0) {  /* American Date Format*/
            printf("%d/%d/%d\n",
            rec->tbKbPayback[1],
            rec->tbKbPayback[0],
            rec->tbKbPayback[2]);
        }
        else                /* European Date Format*/
            printf("%d/%d/%d\n",
            rec->tbKbPayback[0],
            rec->tbKbPayback[1],
            rec->tbKbPayback[2]);

    GotoXY(1,13);
    printf("\007[\003C\007] # Of Calls    : %u     ",rec->timesCalled);

    GotoXY(1,14);
    printf("\007[\003D\007] Time Used Ever: %u     ",rec->totalTimeUsed);

    GotoXY(1,15);
    printf("\007[\003E\007] # Msgs Posted : %u     ",rec->msgsPosted);

    GotoXY(1,16);
    printf("\007[\003F\007] Time Today    : %u     ",rec->timeUsed);

    GotoXY(40,13);
    printf("\007[\003G\007] # D/L's Ever  : %u     ",rec->numDownloads);

    GotoXY(40,14);
    printf("\007[\003H\007] KB D/L'd Ever : %u                ",rec->kbDownloaded);

    GotoXY(40,15);
    printf("\007[\003I\007] # U/L's Ever  : %u     ",rec->numUploads);

    GotoXY(40,16);
    printf("\007[\003J\007] KB U/L'd Ever : %u                ",rec->kbUploaded);

    GotoXY(40,17);
    printf("\007[\003K\007] KB D/L'd Today: %u                ",rec->kbToday);

}




void bottom_header()
{
    GotoXY(1,19);
    printf("\004\007\n\n\n\n");
	printf("\004\007\n");
}

/* -------------------------------------------------------------------------*/
/* Main Procedures (Main, Menu, etc.)*/
/* -------------------------------------------------------------------------*/

bool disabled(char test[10])
{
	if (strstr(params,test) != NULL)
		return(TRUE);
	else
		return(FALSE);
}



void menu(void)
{
	strcpy(search,"");

	top_header();
	bottom_header();

	do {
        choice = 0;
        ReadUser(rec,cur_user_num);
        if (cur_user_num == UserRecNr) {
            ReadUser (CurUser,cur_user_num);
        }
        user_info();
		clr_window();
		GotoXY(1,20);
		SetColor(CYAN);
		printf("Current User Number : \007%d", cur_user_num+1);
        pline(3,WHITE,"(Press ? for Commands) Command : ");
		choice = WaitKey();
		switch (toupper(choice)) {

            /* Next user*/

            case ']' : {
                if (cur_user_num + 1 >= max_users) {
				    clr_window();
                    pline(1,RED,"Cannot move forward.");
				    pline(3,WHITE,"Press [Enter] to Continue.\t");
				    clr_window();
				}
				else
				    ++cur_user_num;
				    break;
				}

            /* Previous user*/

            case '[' : {
				if (cur_user_num - 1 < 0) {
				    clr_window();
				    pline(1,RED,"Cannot move backwards.");
				    press_enter();
				    clr_window();
				}
				else
				    --cur_user_num;
				    break;
				}

            case '=' : {
                clr_window();
                l1();
                printf("\007Jump to what User Number (\0061\007-\006%u\007) \004: ",max_users);
                Input(dataline,5,INPUT_DIGITS);
                if ((atoi(dataline) < (max_users +1)) && (atoi(dataline) > 0)) {
                    cur_user_num = (atoi(dataline) -1);
                }
                break;
            }
/* End Jump to User# */

       /* The following case statement takes UEdit to the last record in*/
       /* the userlog.*/

	   case KEY_CTLE : {
            cur_user_num = max_users-1;
			break;
			   }

        case KEY_CTLF : { /* Flags Menu */
            flagmenu();
            clr_topscr();
            break;
        }

        case KEY_CTLG : { /* Accounting Menu */
            acc_menu();
            clr_topscr();
            break;
        }

        case KEY_CTLT : { /* Statistics Menu */
            stat_menu();
            clr_topscr();
            break;
        }


       /* The following case statement takes UEdit to the first record in*/
       /* the userlog.*/

	   case KEY_CTLB : {
			cur_user_num = 0;
			break;
			}

       /* The following case statement simply redraws the entire screen.*/

	   case KEY_CTLR : {
            printf("\f");
			top_header();
			bottom_header();
			break;
			}

	   case KEY_CTLD : {
            if (sysop)
            {
                rec->uFlags ^= UFLAG_DELETED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
		    }

       case KEY_CTLW : {
            if (sysop)
            {
                wipe_user();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

       case KEY_CTLA : {
            if (sysop)
            {
                append_rec();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

	   case KEY_CTLU : {
                        search_user();
                        break;
					   }

       /* The following case statment is nearly identical to the previous*/
       /* search routine.*/

	   case KEY_CTLN : {
                        repeat_usearch();
                        break;
					   }

/* New Post Routine */

       case KEY_CTLP : {
                        sprintf(dataline,"1 /T=\"%s\"",rec->name);
                        MenuFunction(MENU_WRITEMSG,dataline);
                        printf("\f");
                        top_header();
                        bottom_header();
                        break;
                    }


        case KEY_CTLZ : {
                    clr_window();
                    if (become) {
                        pline(1,GREEN,"Become This User? Are You Sure? ");
                        if (Ask(FALSE) == TRUE) {
                            pline(2,RED,"Reading User ... ");
                            ReadUser (CurUser,cur_user_num);
                            pline(2,WHITE,"You have become this user.");
                            Log(LOG_NORMAL,"Changed to become %s",CurUser->name);
                            press_enter();
                            }
                        }
                    else {
                        pline(1,RED,"You cannot access this function");
                        press_enter();
                    }
                    break;
                }

/* End of Become Routine */



        case KEY_CTLC : {
            clone_sub();
            break;
        }

/* End Clone User Routine */


           case 'F' : {
                        if (sysop) {
                            clr_window();
                            pline(1,CYAN,"Edit User Flags.");
							l3();
							printf("\007Enter Flag to Toggle ([\003Enter\007] to Abort) : ");
							flag = WaitKey();
							if (strchr("ABCDEFGHIJKLMNOPQRSTUVWXYZ123456",toupper(flag)) == NULL)
								break;

							sprintf(asc_value,"%d",toupper(flag));

							if ((atoi(asc_value) >= 49) && (atoi(asc_value) <= 54))
								flag_num = atoi(asc_value) - 22;
							else
								flag_num = atoi(asc_value)-64;

							if (GetFlag(rec->aFlags,flag_num) == TRUE)
									ClearFlag(rec->aFlags,flag_num)
							else
								SetFlag(rec->aFlags,flag_num)
							WriteUser(rec);
                        }
                        else
                            cannot_edit();
                        break;
					   }


            case 'L' : {
                        if (sysop) {
                            clr_window();
							pline(1,CYAN,"Edit Security Level.");
							l3();
							printf("\007Enter NEW Security Level ([\003Enter\007] to Abort) : ");
							Input(buf,5,INPUT_DIGITS);
							if (strlen(buf) == 0)
								break;
							rec->level = atol(buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }

            case 'G' : {
                if (rec->sex == 2) {
                    rec->sex = 0;
                }
                else {
                    ++rec->sex;
                }
                WriteUser(rec);
                break;
            }

            case 'E' : {
                if (rec->logLevel == 3) {
                    rec->logLevel = 0;
                }
                else {
                    ++rec->logLevel;
                }
                WriteUser(rec);
                break;
            }


            case 'N' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User Name.");
							l3();
							printf("\007Enter NEW User Name ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->name,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'A' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User Alias.");
							l3();
							printf("\007Enter NEW User Alias ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->alias,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'P' : {
                        if (sysop) {
						clr_window();
							pline(1,CYAN,"Edit User Password.");
							l3();
							printf("\007Enter NEW User Password ([\003Enter\007] to Abort) : ");
							Input(buf,15,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->passWord,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'C' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User City.");
							l3();
							printf("\007Enter NEW User City ([\003Enter\007] to Abort) : ");
							Input(buf,25,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->city,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
						}
			case 'S' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User State.");
							l3();
							printf("\007Enter NEW User State ([\003Enter\007] to Abort) : ");
							Input(buf,25,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->state,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }

            case 'U' : {
                        if (sysop) {
							clr_window();
                            pline(1,CYAN,"Change Language.");
							l3();
                            printf("\007Enter NEW Language ([\003Enter\007] to Abort) : ");
                            Input(buf,8,INPUT_UPALL);
							if (strlen(buf) == 0)
								break;
                            strcpy(rec->language,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
                       }


            case '1' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User Address (Line 1).");
							l3();
							printf("\007Enter NEW User Address ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->address1,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case '2' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User Address (Line 2).");
							l3();
							printf("\007Enter NEW User Address ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->address2,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case '3' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User Address (Line 3).");
							l3();
							printf("\007Enter NEW User Address ([\003Enter\007] to Abort) : ");
							Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->address3,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
			case 'T' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User Comment.");
							l2();
							printf("\007Enter NEW User Comment ([\003Enter\007] to Abort) : ");
							l3();
							Input(buf,79,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->comment,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }

            case 'W' : {
                        if (sysop) {
							clr_window();
                            pline(1,CYAN,"\001Note: \002Forwarding Not Implemented in PB 2.12!");
                            l2();
                            printf("\007Enter NEW Forward ([\003Enter\007] to Abort) : ");
							l3();
                            Input(buf,35,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
                            strcpy(rec->forwardTo,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
                       }

            case 'O' : {
                        if (sysop) {
							clr_window();
                            pline(1,CYAN,"Edit Company Name.");
                            l2();
                            printf("\007Enter NEW Company ([\003Enter\007] to Abort) : ");
							l3();
                            Input(buf,50,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
                            strcpy(rec->company,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
                       }

            case 'V' : {
                if (sysop) {
					clr_window();
					pline(1,CYAN,"Edit User Voice Phone Number.");
					l3();
					printf("\007Enter NEW Phone Number ([\003Enter\007] to Abort) : ");
					Input(buf,15,INPUT_ALL);
					if (strlen(buf) == 0)
						break;
					strcpy(rec->voicePhone,buf);
					WriteUser(rec);
				}
				else
					cannot_edit();
				break;
			   }


            case 'B' : {
                if (sysop) {
				    clr_window();
                    pline(1,CYAN,"Edit BirthDate.");
				    l3();
				    if (Config->europe == 0) {
					printf("\007Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[1] = atoi(buf);
					printf(" Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[0] = atoi(buf);
				    }
				    else {
					printf("\007 Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[0] = atoi(buf);
					printf("Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[1] = atoi(buf);
				    }
				    printf(" Year : ");
				    Input(buf,2,INPUT_DIGITS);
                    rec->birthDate[2] = atoi(buf);
				    WriteUser(rec);
				}
                else
                    cannot_edit();
                break;
                }


            case 'I' : {
                if (sysop) {
				    clr_window();
                    pline(1,CYAN,"Edit First Login Date.");
				    l3();
				    if (Config->europe == 0) {
					printf("\007Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[1] = atoi(buf);
					printf(" Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[0] = atoi(buf);
				    }
				    else {
					printf("\007 Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[0] = atoi(buf);
					printf("Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[1] = atoi(buf);
				    }
				    printf(" Year : ");
				    Input(buf,2,INPUT_DIGITS);
                    rec->firstDate[2] = atoi(buf);
				    WriteUser(rec);
				}
                else
                    cannot_edit();
                break;
                }


            case 'J' : {
                if (sysop) {
				    clr_window();
                    pline(1,CYAN,"Edit Last Login Date.");
				    l3();
				    if (Config->europe == 0) {
					printf("\007Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[1] = atoi(buf);
					printf(" Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[0] = atoi(buf);
				    }
				    else {
					printf("\007 Date : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[0] = atoi(buf);
					printf("Month : ");
					Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[1] = atoi(buf);
				    }
				    printf(" Year : ");
				    Input(buf,2,INPUT_DIGITS);
                    rec->lastDate[2] = atoi(buf);
				    WriteUser(rec);
				}
                else
                    cannot_edit();
                break;
                }


            case 'D' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit User Data Phone Number.");
							l3();
							printf("\007Enter NEW Phone Number ([\003Enter\007] to Abort) : ");
							Input(buf,15,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->dataPhone,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }
            case 'Z' : {
                        if (sysop) {
							clr_window();
                            pline(1,CYAN,"Edit User Fax Phone Number.");
							l3();
							printf("\007Enter NEW Phone Number ([\003Enter\007] to Abort) : ");
							Input(buf,15,INPUT_ALL);
							if (strlen(buf) == 0)
								break;
							strcpy(rec->faxPhone,buf);
							WriteUser(rec);
						}
						else
							cannot_edit();
						break;
					   }

            case 'X' : {
                    clr_window();
                    pline(1,CYAN,"Edit Screen Width.");
                    l2();
                    printf("\002Note: \001ProBoard does not seem to use this setting");
                    l3();
                    printf("\007Enter NEW Width ([\003Enter\007] to Abort) : ");
                    Input(buf,3,INPUT_ALL);
                        if (strlen(buf) == 0)
                            break;
                    rec->screenWidth = atol(buf);
                    WriteUser(rec);
                    break;
                }

            case 'Y' : {
                    clr_window();
                    pline(1,CYAN,"Edit Screen Length.");
                    l3();
                    printf("\007Enter NEW Heigth ([\003Enter\007] to Abort) : ");
                    Input(buf,3,INPUT_ALL);
                        if (strlen(buf) == 0)
                            break;
                    rec->screenLength = atol(buf);
                    WriteUser(rec);
                    break;
                }

			case 'M' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit Time Balance.");
							l3();
							printf("\007Enter NEW Time Balance ([\003Enter\007] to Abort) : ");
							Input(buf,3,INPUT_DIGITS);
							if (strlen(buf) == 0)
								break;
							rec->tbTimeBalance = atoi(buf);
							WriteUser(rec);

						}
						else
							cannot_edit();
						break;
					   }
			case 'K' : {
                        if (sysop) {
							clr_window();
							pline(1,CYAN,"Edit Kilobyte Balance.");
							l3();
							printf("\007Enter NEW Kilobyte Balance ([\003Enter\007] to Abort) : ");
							Input(buf,5,INPUT_DIGITS);
							if (strlen(buf) == 0)
								break;
							rec->tbKbBalance = atoi(buf);
							WriteUser(rec);

						}
						else
							cannot_edit();
						break;
					   }
			case '?' : {
                        showhelp();
                        break;
					   }

        } /* End of SWITCH statement*/
    } while (toupper(choice) != 'Q');
} /* End of FUNCTION*/

void flagmenu(void)
{
    /* The first part of flagmenu is almost a repeat of menu routine. */
    /* If change made to part of one, check the other */

	strcpy(search,"");

	do {
        choice = 0;
        ReadUser(rec,cur_user_num);
        showda_flags();
		clr_window();
		GotoXY(1,20);
		SetColor(CYAN);
		printf("Current User Number : \007%d", cur_user_num+1);
        pline(3,WHITE,"(Press ? for Commands / Q to Return To Edit Menu) Command : ");
		choice = WaitKey();
		switch (toupper(choice)) {

            /* Next user*/

            case ']' : {
                if (cur_user_num + 1 >= max_users) {
				    clr_window();
				    pline(1,RED,"Cannot move forward.");
				    pline(3,WHITE,"Press [Enter] to Continue.\t");
				    clr_window();
				}
				else
				    ++cur_user_num;
				    break;
				}

            /* Previous user*/

            case '[' : {
				if (cur_user_num - 1 < 0) {
				    clr_window();
				    pline(1,RED,"Cannot move backwards.");
				    press_enter();
				    clr_window();
				}
				else
				    --cur_user_num;
				    break;
				}

            case '=' : {
                clr_window();
                l1();
                printf("\007Jump to what User Number (\0061\007-\006%u\007) \004: ",max_users);
                Input(dataline,5,INPUT_DIGITS);
                if ((atoi(dataline) <= (max_users +1)) && (atoi(dataline) > 0)) {
                    cur_user_num = (atoi(dataline) -1);
                }
                break;
            }
/* End Jump to User# */


       /* The following case statement takes UEdit to the last record in*/
       /* the userlog.*/

	   case KEY_CTLE : {
            cur_user_num = max_users-1;
			break;
			   }

       /* The following case statement takes UEdit to the first record in*/
       /* the userlog.*/

	   case KEY_CTLB : {
			cur_user_num = 0;
			break;
			}

       /* The following case statement simply redraws the entire screen.*/

	   case KEY_CTLR : {
            printf("\f");
			top_header();
			bottom_header();
			break;
			}

	   case KEY_CTLD : {
            if (sysop) {
                rec->uFlags ^= UFLAG_DELETED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
		    }

       case KEY_CTLW : {
            if (sysop)
            {
                wipe_user();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

       case KEY_CTLA : {
            if (sysop)
            {
                append_rec();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }


       case KEY_CTLU : {
                        search_user();
                        break;
					   }

       /* The following case statment is nearly identical to the previous*/
       /* search routine.*/

	   case KEY_CTLN : {
                        repeat_usearch();
                        break;
					   }


       case KEY_CTLP : {
                        sprintf(dataline,"1 /T=\"%s\"",rec->name);
                        MenuFunction(MENU_WRITEMSG,dataline);
                        printf("\f");
                        top_header();
                        bottom_header();
                        break;
                    }


        case KEY_CTLZ : {
                    clr_window();
                    if (become == TRUE) {
                        pline(1,GREEN,"Become This User? Are You Sure? ");
                        if (Ask(FALSE) == TRUE) {
                            pline(2,RED,"Reading User ... ");
                            ReadUser (CurUser,cur_user_num);
                            Log(LOG_NORMAL,"Changed to become %s",CurUser->name);
                            pline(2,WHITE,"You have become this user.");
                            press_enter();
                            }
                        }
                    else {
                        pline(1,RED,"You cannot access this function");
                        press_enter();
                    }
                    break;
                }

/* End of Become Routine */


        case KEY_CTLC : {
            clone_sub();
            break;
        }

/* End Clone User Routine */

            case 'A' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_DELETED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'B' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_ANSI;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'C' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_PAUSE;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'D' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_CLEAR;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'E' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_HOTKEYS;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'F' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_NOIBM;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'G' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_FSED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'H' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_NOKILL;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'I' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_IGNORE;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'J' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_ATTEN;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'K' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_NOTOPS;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'L' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_HIDDEN;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'M' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_QUIET;
                clr_window();
                pline(1,RED,"Remember: \007As of 2.12, PB does NOT use the Quiet Flag!");
                pline(2,WHITE,"It is simply included for compatibility. Some PEXfiles may use it.\n");
                press_enter();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'N' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_AVATAR;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'O' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_AVTPLUS;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'P' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_GUEST;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'R' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_PAGEPRI;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'S' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_LOCALONLY;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'T' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_MULTILOGIN;
                clr_window();
                pline(1,RED,"Remember: \007As of 2.12, PB does NOT use the MultiLogin Flag!");
                pline(2,WHITE,"It is simply included for compatibility. Some PEXfiles may use it.\n");
                press_enter();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'U' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_FREECHAT;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

            case 'V' : {
            if (sysop) {
                rec->uFlags ^= UFLAG_NORIP;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }




            case '?' : {
                        showhelp();
                        break;
					   }

        } /* End of SWITCH statement*/
	} while (toupper(choice) != 'Q');
    choice=0;
} /* End of FUNCTION*/


void acc_menu()
{
    strcpy(search,"");
/*
    top_header();
    bottom_header();
*/

    do {
        choice = 0;
        ReadUser(rec,cur_user_num);
        acc_show();
        clr_window();
        GotoXY(1,20);
        SetColor(CYAN);
        printf("Current User Number : \007%d", cur_user_num+1);
        pline(3,WHITE,"(Press ? for Commands) Command : ");
        choice = WaitKey();
        switch (toupper(choice)) {

            /* Next user*/

            case ']' : {
                if (cur_user_num + 1 >= max_users) {
                    clr_window();
                    pline(1,RED,"Cannot move forward.");
                    pline(3,WHITE,"Press [Enter] to Continue.\t");
                    clr_window();
                }
                else
                    ++cur_user_num;
                    break;
                }

            /* Previous user*/

            case '[' : {
                if (cur_user_num - 1 < 0) {
                    clr_window();
                    pline(1,RED,"Cannot move backwards.");
                    press_enter();
                    clr_window();
                }
                else
                    --cur_user_num;
                    break;
                }


            case '=' : {
                clr_window();
                l1();
                printf("\007Jump to what User Number (\0061\007-\006%u\007) \004: ",max_users);
                Input(dataline,5,INPUT_DIGITS);
                if ((atoi(dataline) <= (max_users +1)) && (atoi(dataline) > 0)) {
                    cur_user_num = (atoi(dataline) -1);
                }
                break;
            }
/* End Jump to User# */

       case KEY_CTLE : {
            cur_user_num = max_users-1;
            break;
               }

       case KEY_CTLB : {
            cur_user_num = 0;
            break;
            }

       case KEY_CTLR : {
            printf("\f");
            top_header();
            bottom_header();
            break;
            }

       case KEY_CTLD : {
            if (sysop) {
                rec->uFlags ^= UFLAG_DELETED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

       case KEY_CTLW : {
            if (sysop)
            {
                wipe_user();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

       case KEY_CTLA : {
            if (sysop)
            {
                append_rec();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

       case KEY_CTLU : {
                        search_user();
                        break;
                       }

       /* The following case statment is nearly identical to the previous*/
       /* search routine.*/

       case KEY_CTLN : {
                        repeat_usearch();
                        break;
                       }

/* New Post Routine */

       case KEY_CTLP : {
                        sprintf(dataline,"1 /T=\"%s\"",rec->name);
                        MenuFunction(MENU_WRITEMSG,dataline);
                        printf("\f");
                        top_header();
                        bottom_header();
                        break;
                    }


        case KEY_CTLZ : {
                    clr_window();
                    if (become == TRUE) {
                        pline(1,GREEN,"Become This User? Are You Sure? ");
                        if (Ask(FALSE) == TRUE) {
                            pline(2,RED,"Reading User ... ");
                            ReadUser (CurUser,cur_user_num);
                            pline(2,WHITE,"You have become this user.");
                            Log(LOG_NORMAL,"Changed to become %s",CurUser->name);
                            press_enter();
                            }
                        }
                    else {
                        pline(1,RED,"You cannot access this function");
                        press_enter();
                    }
                    break;
                }

/* End of Become Routine */



        case KEY_CTLC : {
            clone_sub();
            break;
        }

/* End Clone User Routine */

            case '?' : {
                        showhelp();
                        break;
					   }

            case 'G' : {
                        if (sysop) {
                            clr_window();
                            pline(1,CYAN,"Edit Expiration Level.");
                            l3();
                            printf("\007Enter NEW Expiration Level ([\003Enter\007] to Abort) : ");
                            Input(buf,5,INPUT_DIGITS);
                            if (strlen(buf) == 0)
                                break;
                            rec->expLevel = atol(buf);
                            WriteUser(rec);
                        }
                        else
                            cannot_edit();
                        break;
                       }

            case 'H' : {
                        if (sysop) {
                            clr_window();
                            pline(1,CYAN,"Edit Expire Off Flags.");
                            l3();
                            printf("\007Enter Flag to Toggle ([\003Enter\007] to Abort) : ");
                            flag = WaitKey();
                            if (strchr("ABCDEFGHIJKLMNOPQRSTUVWXYZ123456",toupper(flag)) == NULL)
                                break;

                            sprintf(asc_value,"%d",toupper(flag));

                            if ((atoi(asc_value) >= 49) && (atoi(asc_value) <= 54))
                                flag_num = atoi(asc_value) - 22;
                            else
                                flag_num = atoi(asc_value)-64;

                            if (GetFlag(rec->expFlagsOff,flag_num) == TRUE)
                                    ClearFlag(rec->expFlagsOff,flag_num)
                            else
                                SetFlag(rec->expFlagsOff,flag_num)
                            WriteUser(rec);
                        }
                        else
                            cannot_edit();
                        break;
            }

            case 'R' : {
                        if (sysop) {
                            clr_window();
                            pline(1,CYAN,"Edit Expire On Flags.");
                            l3();
                            printf("\007Enter Flag to Toggle ([\003Enter\007] to Abort) : ");
                            flag = WaitKey();
                            if (strchr("ABCDEFGHIJKLMNOPQRSTUVWXYZ123456",toupper(flag)) == NULL)
                                break;

                            sprintf(asc_value,"%d",toupper(flag));

                            if ((atoi(asc_value) >= 49) && (atoi(asc_value) <= 54))
                                flag_num = atoi(asc_value) - 22;
                            else
                                flag_num = atoi(asc_value)-64;

                            if (GetFlag(rec->expFlagsOn,flag_num) == TRUE)
                                    ClearFlag(rec->expFlagsOn,flag_num)
                            else
                                SetFlag(rec->expFlagsOn,flag_num)
                            WriteUser(rec);
                        }
                        else
                            cannot_edit();
                        break;
            }


            case 'E' : {
                if (sysop) {
                    clr_window();
                    pline(1,CYAN,"Edit Expiration Date.");
                    l3();
                    if (Config->europe == 0) {
                    printf("\007Month : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->expDate[1] = atoi(buf);
                    printf(" Date : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->expDate[0] = atoi(buf);
                    }
                    else {
                    printf("\007 Date : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->expDate[0] = atoi(buf);
                    printf("Month : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->expDate[1] = atoi(buf);
                    }
                    printf(" Year : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->expDate[2] = atoi(buf);
                    WriteUser(rec);
                }
                else
                    cannot_edit();
                break;
                }


        case 'C' : {
            clr_window();
            pline(1,CYAN,"Editing Credit Amount");
            l3();
            printf("\007Enter NEW Credit ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->credit = atol(buf);
            WriteUser(rec);
            break;
        }

        case 'P' : {
            clr_window();
            pline(1,CYAN,"Editing Pending Credit Amount");
            l3();
            printf("\007Enter NEW Pending Credit ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->pending = atol(buf);
            WriteUser(rec);
            break;
        }



        } /* End of SWITCH statement*/
	} while (toupper(choice) != 'Q');
    choice = 0;
} /* End of FUNCTION ACC_menu */


void stat_menu()
{
    strcpy(search,"");
/*
    top_header();
    bottom_header();
*/
    do {
        choice = 0;
        ReadUser(rec,cur_user_num);
        stat_show();
        clr_window();
        GotoXY(1,20);
        SetColor(CYAN);
        printf("Current User Number : \007%d", cur_user_num+1);
        pline(3,WHITE,"(Press ? for Commands) Command : ");
        choice = WaitKey();
        switch (toupper(choice)) {

            /* Next user*/

            case ']' : {
                if (cur_user_num + 1 >= max_users) {
                    clr_window();
                    pline(1,RED,"Cannot move forward.");
                    pline(3,WHITE,"Press [Enter] to Continue.\t");
                    clr_window();
                }
                else
                    ++cur_user_num;
                    break;
                }

            /* Previous user*/

            case '[' : {
                if (cur_user_num - 1 < 0) {
                    clr_window();
                    pline(1,RED,"Cannot move backwards.");
                    press_enter();
                    clr_window();
                }
                else
                    --cur_user_num;
                    break;
                }


            case '=' : {
                clr_window();
                l1();
                printf("\007Jump to what User Number (\0061\007-\006%u\007) \004: ",max_users);
                Input(dataline,5,INPUT_DIGITS);
                if ((atoi(dataline) <= (max_users +1)) && (atoi(dataline) > 0)) {
                    cur_user_num = (atoi(dataline) -1);
                }
                break;
            }
/* End Jump to User# */

       case KEY_CTLE : {
            cur_user_num = max_users-1;
            break;
               }

       case KEY_CTLB : {
            cur_user_num = 0;
            break;
            }

       case KEY_CTLR : {
            printf("\f");
            top_header();
            bottom_header();
            break;
            }

       case KEY_CTLD : {
            if (sysop) {
                rec->uFlags ^= UFLAG_DELETED;
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }

       case KEY_CTLW : {
            if (sysop)
            {
                wipe_user();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }


       case KEY_CTLA : {
            if (sysop)
            {
                append_rec();
                WriteUser(rec);
            }
            else
                cannot_edit();
            break;
            }


       case KEY_CTLU : {
                        search_user();
                        break;
                       }

       /* The following case statment is nearly identical to the previous*/
       /* search routine.*/

       case KEY_CTLN : {
                        repeat_usearch();
                        break;
                       }

/* New Post Routine */

       case KEY_CTLP : {
                        sprintf(dataline,"1 /T=\"%s\"",rec->name);
                        MenuFunction(MENU_WRITEMSG,dataline);
                        printf("\f");
                        top_header();
                        bottom_header();
                        break;
                    }


        case KEY_CTLZ : {
                    clr_window();
                    if (become == TRUE) {
                        pline(1,GREEN,"Become This User? Are You Sure? ");
                        if (Ask(FALSE) == TRUE) {
                            pline(2,RED,"Reading User ... ");
                            ReadUser (CurUser,cur_user_num);
                            pline(2,WHITE,"You have become this user.");
                            Log(LOG_NORMAL,"Changed to become %s",CurUser->name);
                            press_enter();
                            }
                        }
                    else {
                        pline(1,RED,"You cannot access this function");
                        press_enter();
                    }
                    break;
                }

/* End of Become Routine */



        case KEY_CTLC : {
            clone_sub();
            break;
        }

/* End Clone User Routine */

            case '?' : {
                        showhelp();
                        break;
					   }

           case '1' : {
                    clr_window();
                    pline(1,CYAN,"Edit Date Timebank Last Used.");
                    l3();
                    if (Config->europe == 0) {
                    printf("\007Month : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbLastUsed[1] = atoi(buf);
                    printf(" Date : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbLastUsed[0] = atoi(buf);
                    }
                    else {
                    printf("\007 Date : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbLastUsed[0] = atoi(buf);
                    printf("Month : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbLastUsed[1] = atoi(buf);
                    }
                    printf(" Year : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbLastUsed[2] = atoi(buf);
                    WriteUser(rec);
                break;
                }

        case '2' : {
            clr_window();
            pline(1,CYAN,"Editing Timebank Balance");
            l3();
            printf("\007Enter NEW Balance ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->tbTimeBalance = atoi(buf);
            WriteUser(rec);
            break;
        }

        case '3' : {
            clr_window();
            pline(1,CYAN,"Editing Amount Withdrawn Today");
            l3();
            printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->tbTimeWithdrawn = atoi(buf);
            WriteUser(rec);
            break;
        }

        case '4' : {
            clr_window();
            pline(1,CYAN,"Editing Amount Deposited Today");
            l3();
            printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->tbTimeDeposited = atol(buf);
            WriteUser(rec);
            break;
        }

        case '5' : {
            clr_window();
            pline(1,CYAN,"Editing Time On Loan");
            l3();
            printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->tbTimeLoaned = atol(buf);
            WriteUser(rec);
            break;
        }

           case '6' : {
                    clr_window();
                    pline(1,CYAN,"Edit Date for Time Payback.");
                    l3();
                    if (Config->europe == 0) {
                    printf("\007Month : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbTimePayback[1] = atoi(buf);
                    printf(" Date : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbTimePayback[0] = atoi(buf);
                    }
                    else {
                    printf("\007 Date : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbTimePayback[0] = atoi(buf);
                    printf("Month : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbTimePayback[1] = atoi(buf);
                    }
                    printf(" Year : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbTimePayback[2] = atoi(buf);
                    WriteUser(rec);
                break;
                }


        case '7' : {
            clr_window();
            pline(1,CYAN,"Editing Bytebank Balance");
            l3();
            printf("\007Enter NEW Balance ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->tbKbBalance = atoi(buf);
            WriteUser(rec);
            break;
        }

        case '8' : {
            clr_window();
            pline(1,CYAN,"Editing Amount Withdrawn Today");
            l3();
            printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->tbKbWithdrawn = atoi(buf);
            WriteUser(rec);
            break;
        }

        case '9' : {
            clr_window();
            pline(1,CYAN,"Editing Amount Deposited Today");
            l3();
            printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->tbKbDeposited = atol(buf);
            WriteUser(rec);
            break;
        }

        case 'A' : {
            clr_window();
            pline(1,CYAN,"Editing Kb On Loan");
            l3();
            printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
            Input(buf,5,INPUT_DIGITS);
                if (strlen(buf) == 0)
                break;
            rec->tbKbLoaned = atol(buf);
            WriteUser(rec);
            break;
        }

           case 'B' : {
                    clr_window();
                    pline(1,CYAN,"Edit Date for Kb Payback.");
                    l3();
                    if (Config->europe == 0) {
                    printf("\007Month : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbKbPayback[1] = atoi(buf);
                    printf(" Date : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbKbPayback[0] = atoi(buf);
                    }
                    else {
                    printf("\007 Date : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbKbPayback[0] = atoi(buf);
                    printf("Month : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbKbPayback[1] = atoi(buf);
                    }
                    printf(" Year : ");
                    Input(buf,2,INPUT_DIGITS);
                    rec->tbKbPayback[2] = atoi(buf);
                    WriteUser(rec);
                break;
                }

            case 'C' : {
                clr_window();
                pline(1,CYAN,"Edit # of Calls.");
                l3();
                printf("\007Enter # of Calls ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->timesCalled = atol(buf);
                WriteUser(rec);
               break;
            }

            case 'D' : {
                clr_window();
                pline(1,CYAN,"Edit Time Used Ever.");
                l3();
                printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->totalTimeUsed = atol(buf);
                WriteUser(rec);
               break;
            }

            case 'E' : {
                clr_window();
                pline(1,CYAN,"Edit # Msgs Posted");
                l3();
                printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->msgsPosted = atol(buf);
                WriteUser(rec);
               break;
            }

            case 'F' : {
                clr_window();
                pline(1,CYAN,"Edit Time Used Today.");
                l3();
                printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->timeUsed = atol(buf);
                WriteUser(rec);
               break;
            }

            case 'G' : {
                clr_window();
                pline(1,CYAN,"Edit Total Downloads.");
                l3();
                printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->numDownloads = atol(buf);
                WriteUser(rec);
               break;
            }

            case 'H' : {
                clr_window();
                pline(1,CYAN,"Edit Total Download Kilobytes.");
                l3();
                printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->kbDownloaded = atol(buf);
                WriteUser(rec);
               break;
            }

            case 'I' : {
                clr_window();
                pline(1,CYAN,"Edit Total Uploads.");
                l3();
                printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->numUploads = atol(buf);
                WriteUser(rec);
               break;
            }

            case 'J' : {
                clr_window();
                pline(1,CYAN,"Edit Total Upload Kilobytes.");
                l3();
                printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->kbUploaded = atol(buf);
                WriteUser(rec);
               break;
            }

            case 'K' : {
                clr_window();
                pline(1,CYAN,"Edit Kilobytes Downloaded Today.");
                l3();
                printf("\007Enter NEW Amount ([\003Enter\007] to Abort) : ");
                Input(buf,6,INPUT_DIGITS);
                if (strlen(buf) == 0)
                   break;
                rec->kbToday = atol(buf);
                WriteUser(rec);
               break;
            }

        } /* End of SWITCH statement*/
	} while (toupper(choice) != 'Q');
    choice = 0;
} /* End of FUNCTION stat_menu */



void main(int argc, char **argv)
{
    Log(LOG_FRIEND,"%s Ran the User Editor!",CurUser->name);

    /* Test for ANSI and/or AVATAR*/

    if ((CurUser->uFlags & UFLAG_ANSI) ||
	(CurUser->uFlags & UFLAG_AVATAR) ||
	(CurUser->uFlags & UFLAG_AVTPLUS)) {
	if ((rec = (USER_REC *) calloc(1,1500)) == NULL)
	    no_memory();

	if ((temp_rec = (USER_REC *) calloc(1,1500)) == NULL)
	    no_memory();

	recs = rec;
	temp_recs = temp_rec;

    sysop_level = atol(argv[1]);                /* sysop level not currently */
                                                /* used, but left in for */
                                                /* compatibility w/ older */
                                                /* menus */

    strncpy(params,argv[2],198);                /* Copy first 199 characters*/
    strupr(params);                             /* Convert to upper case*/

    if (argc > 1) {                             /* test for options */
        if (disabled("CS"))                     /* set co-sysop mode */
            sysop = FALSE;
        if (disabled("BC"))                     /* turn ON become user */
            become = TRUE;
    }

    max_users = NumUsers;
    cur_user_num = 0;
	ReadUser(rec,cur_user_num);

    menu();                                     /* Acutal command entry */

	free(recs);
	free(temp_recs);
    }
    else {
    printf("\nSorry, The Ethereal User Editor requires ANSI or AVATAR.\n\n");
	press_enter();
    }
}
