@echo off
goto Begin

This file is the protocol module for ProBoard v2.0x
Copyright (C) 1995 by Branislav L. Slantchev
A Product of Silicon Creations, Inc.
Part of the PB-GNU Project

Parameters:
        %1 == /r - receive file(s)
        %1 == /s - send file(s)
        %2 == <keyword> (X, XCRC, XCHK, X1K, Y, Y1K, YG, Z, ZED, HS, HYD)
        %3 == port
        %4 == speed
        %5 == control file or file to send (send only)

:Begin
	xu port:1:off
	for %%a in (-s -S) do if %1$ == %%a$ goto sendOK
	for %%a in (-r -R) do if %1$ == %%a$ goto recvOK
	echo **
	echo **  %0: unknown function '%1', must be '-s' or '-r'.  **
	echo **
	goto End
:sendOk
	set XFR=Send
	goto getProto
:recvOk
	set XFR=Recv
:getProto
	for %%a in (x xmodem Xmodem) do if %%a$ == %2$ goto X_%XFR%
	for %%a in (xcrc XCRC Xcrc) do if %%a$ == %2$ goto XCRC_%XFR%
	for %%a in (xchk XChk Xchk) do if %%a$ == %2$ goto XCHK_%XFR%
	for %%a in (x1k X1k X1K) do if %%a$ == %2$ goto X1K_%XFR%
	for %%a in (y ymodem Ymodem) do if %%a$ == %2$ goto Y_%XFR%
	for %%a in (y1k Y1k Y1K) do if %%a$ == %2$ goto Y1K_%XFR%
	for %%a in (yg ymodemg YmodemG) do if %%a$ == %2$ goto YG_%XFR%
	for %%a in (z zmodem Zmodem) do if %%a$ == %2$ goto Z_%XFR%
	for %%a in (zed zedzap ZedZap) do if %%a$ == %2$ goto Zed_%XFR%
	for %%a in (hs hslink HSLink) do if %%a$ == %2$ goto HS_%XFR%
	for %%a in (hyd hydra Hydra) do if %%a$ == %2$ goto Hyd_%XFR%
	echo **
	echo **  %0: unknown protocol selected: '%2'.  **
	echo **
goto End

::  Zmodem (Omen's GSZ.EXE)
:Z_Send
	gsz F port %3 ha cts estimate 0 %4 sz -rr -m -Z @%5
	goto End
:Z_Recv
	gsz F port %3 ha cts estimate 0 %4 restrict rz -rr -m -Z
goto End

::  Ymodem (Omen's GSZ.EXE)
:Y_Send
	gsz F port %3 ha cts estimate 0 %4 sb @%5
	goto End
:Y_Recv
	gsz F port %3 ha cts estimate 0 %4 restrict rb
goto End

::  Xmodem (Omen's GSZ.EXE)
:X_Send
	gsz F port %3 ha cts estimate 0 %4 sx %5
	goto End
:X_Recv
	gsz F port %3 ha cts estimate 0 %4 restrict rx
goto End

::  HSLink
:HS_Send
	hslink -p%3 -nt @%5
	goto End
:HS_Recv
	hslink -p%3
goto End

::  HydraCOM
:Hyd_Send
	hydracom port %3 speed %4 send @%5
	goto End
:Hyd_Recv
	hydracom port %3 speed %4 get
goto End

::  ZedZap (CEXYZ)
:Zed_Send
	cexyz /p%3 /l38400 /b%4 /ufas /szap @%5
	goto End
:Zed_Recv
	cexyz /p%3 /l38400 /b%4 /ufas /rzap
goto End

::  Xmodem-CRC
:XCRC_Send
	cexyz /p%3 /l38400 /b%4 /ufas /sxcrc %5
	goto End
:XCRC_Recv
	cexyz /p%3 /l38400 /b%4 /ufas /rxcrc
goto End

::  Xmodem 1K
:X1K_Send
	cexyz /p%3 /l38400 /b%4 /ufas /sx1k %5
	goto End
:X1K_Recv
	cexyz /p%3 /l38400 /b%4 /ufas /rx1k
goto End

::  Xmodem Checksum
:XCHK_Send
	cexyz /p%3 /l38400 /b%4 /ufas /sxchk %5
	goto End
:XCHK_Recv
	cexyz /p%3 /l38400 /b%4 /ufas /rxchk
goto End

::  Ymodem G
:YG_Send
	cexyz /p%3 /l38400 /b%4 /ufas /syg @%5
	goto End
:YG_Recv
	cexyz /p%3 /l38400 /b%4 /ufas /ryg
goto End

::  Ymodem 1K
:Y1K_Send
	cexyz /p%3 /l38400 /b%4 /ufas /sy1k @%5
	goto End
:Y1K_Recv
	cexyz /p%3 /l38400 /b%4 /ufas /ry1k
goto End

:End
	set XFR=
	xu port:1:on
