// PB/Credit v1.01 - PowerPEX
// Written by Gregory Gulick
// Copyright 1994

// This program gives credit to the uploader of a file when the file
// is downloaded by someone else.  The command line works in this manner:
//
//	PBCREDIT D				- Download edition, run after download complete.
//  PBCREDIT L 10 [A/B/R]   - Logon edition.  10 = amount to credit the user,
//							  A = Ask where to place time, B = Place time
//							  immediately in bank, R = Place time into real-
//							  time BBS time limit.

#include <pb_sdk.h>

#define CTRUE 0
#define CFALSE -1

#define credit 10

// Global Variable declarations

char filename[100][100];                        // Downloaded filename
int  total_downloaded=0;                        // Total files downloaded
char reg_name[50];                              // Registration name
int ucredit=0;									// How much per upload?
int location;									// Where to put time?

char ch;                                        // Generic char

// Function Prototypes

void main(int argc, char **argv);               // Reads command line
void read_pbcredit_log(void);                   // Obtain uploaded filenames
void read_upload_log(void);                     // Search UPLOAD.LOG
void logo(void);                                // Logo
void press_enter(void);                         // Press enter to continue
void search_accounts(void);						// Search accounts
void no_memory(void);   						// Otta memory?

void no_memory(void)
{
	printf("\f");
	SetColor(RED);
	Log(LOG_FRIEND,"PB/Credit reports: Insufficient memory.");
	printf("Insufficient Memory to run PB/Credit!\n");
	press_enter();
	exit();
}

void read_pbcredit_log(void)
{
	FILE *fp;		                            // File pointer
	char data[100];                             // String for reading file
	char *temp, *ftp;                           // Temp pointers

	char *temps,*ftps;							// Start of similar pointers

	if ((temp = (char *) calloc(1,100)) == NULL)// Free memory?
		no_memory();
	if ((ftp = (char *) calloc(1,100)) == NULL) // Free memory?
		no_memory();

	temps = temp;
	ftps = ftp;

	fp = fopen("PBCREDIT.LOG","r");
	   while ((fgets(data,90,fp) != NULL) && (total_downloaded < 101)) {
			 ++total_downloaded;                // Increment total downloads
			 temp = strrchr(data,'\\');         // Rev search for '\'
			 ++temp;                            // Skip the backslash
			 ftp=strstr(temp," ");              // Look for space
			 strncpy(filename[total_downloaded],temp,strlen(temp)-strlen(ftp));
	   }
	fclose(fp);                                 // Close PBCREDIT.LOG
	free(temps);
	free(ftps);
}

void read_upload_log()
{
	FILE *fp, *cf;                              // File pointers
	char data[100];                             // String from file
    int x,y,z;                                  // Generic loop variable
	char user_to_credit[100];                   // Name of user to credit.

    strcpy(data,"");
    strcpy(user_to_credit,"");

	SetColor(WHITE);
    printf("\nSearching upload log for file origin...\n");

    fp = fopen("UPLOAD.LOG","r");               // Open UPLOAD.LOG
	   while (fgets(data,90,fp) != NULL) {
			 for (x=1;x<=total_downloaded;++x) {
                 if (strstr(data,filename[x]) != NULL) {
                    for (y=46,z=0;data[y]!='\n';++y,++z) {
                        user_to_credit[z] = data[y];
					}
                 user_to_credit[z] = NULL;      // Total Name

				 SetColor(WHITE);
				 printf("\n   ");
                 SetColor(CYAN);
				 printf("Crediting ");
                 SetColor(MAGENTA);
                 printf("%s ",user_to_credit);
                 SetColor(CYAN);
				 printf("for uploading %s.",filename[x]);

				 // Open the account file

				 if (access("PBCREDIT.ACT",00) == CFALSE)
					cf = fopen("PBCREDIT.ACT","w");
				 else
					cf = fopen("PBCREDIT.ACT","a");

				 fprintf(cf,"%s||%s downloaded %s.\n",
					 user_to_credit,
					 CurUser->name,
					 filename[x]);

				 fclose(cf);                    // Close file
				 }
			 }
	   }
	fclose(fp);                                 // Close UPLOAD.LOG
}

void search_accounts(void)
{
	FILE *fp, *naf;								// fp - file pointer
	char *data, *part2;							// naf - new account file
	char uploader[100],downloader[100];
	int num=0;

	char *datas, *part2s;						// Point to start of sim ptrs

	if ((data = (char *) calloc(1,100)) == NULL)	// No memory?
		no_memory();
	if ((part2 = (char *) calloc(1,100)) == NULL)	// No memory
		no_memory();

	datas = data;								// For freeing memory
	part2s = part2;

	SetColor(WHITE);
	printf("\nSearching for downloads of files you've uploaded...");

	if (access("PBCREDIT.ACT",00) == 0) {		// If account file exists
		fp = fopen("PBCREDIT.ACT","r");
		naf = fopen("PBCREDIT.$$$","w");
		while (fgets(data,90,fp) != NULL) {
			// This procedure get's the uploader and downloader info.
			part2 = strstr(data,"||");
			strset(uploader,NULL);
			strset(downloader,NULL);
			strncpy(uploader,data,(strlen(data)-strlen(part2)));
			++part2;++part2;					// Skip the bars
			strcpy(downloader,part2);
			// This procedure checks if the current user was the uploader
			if (strstr(uploader,CurUser->name) != NULL) {
				// This procedure assures no credit to downloading own file
				if (strstr(part2,CurUser->name) == NULL) {
					if (num == 0)
						printf("\n\n");			// If first one, send blanks
					SetColor(WHITE);
					printf("   ");
					SetColor(CYAN);
					printf("%s",downloader);
					++num;
				}
			}
			else
				fprintf(naf,"%s",data);			// Print new account file
		}
		if (num > 0) {

			// Routine to place time.

			if (location == 1) {
				SetColor(BLUE);
				printf("\nYou have been credited %d minutes!\n",ucredit*num);
				SetColor(WHITE);
				printf("\nWhere would you like to place the credited time?\n\n");

				SetColor(WHITE);
				printf("[");
				SetColor(YELLOW);
				printf("C");
				SetColor(WHITE);
				printf("] Current Time Limit\n");
				printf("[");
				SetColor(YELLOW);
				printf("T");
				SetColor(WHITE);
				printf("] Time Bank");
				printf("\n\nWhich? ");

				ch = WaitKeys("TC");
				switch (toupper(ch)) {
					case 'T' : {
								location = 2;
								printf("Time Bank!\n\n");
								break;
							   }
					case 'C' : {
								location = 3;
								printf("Current Time Limit!\n\n");
								break;
							   }
				}
			}
			switch (location) {
				case 2 : {
							CurUser->tbTimeBalance = CurUser->tbTimeBalance + ucredit*num;
							SetColor(WHITE);
							printf("\n%d minutes deposited in your Time Bank account.",ucredit*num);
							break;
						 }
				case 3 : {
							AddTime(ucredit*num);
							SetColor(WHITE);
							printf("\n%d minutes added to your current time limit.",ucredit*num);
							break;
						 }
			}

		}
		else {
			SetColor(CYAN);
			printf(" None found.");
		}
		fclose(fp);								// Close account file
		fclose(naf);							// Clone new account file
		remove("PBCREDIT.ACT");               	// Kill account file
		rename("PBCREDIT.$$$","PBCREDIT.ACT");	// Rename new account file
	}
	else {										// If no account file
		SetColor(CYAN);
		printf(" None found.");
		press_enter();
		free(part2s);
		free(datas);
		exit();
	}
	free(datas);
	free(part2s);
}


void logo(void)
{
	int name_len=0, board_len=0;                // Len of name and board
	FILE *dfp;                                  // Decrypt file pointer
	char key_name[100], key_board[100];         // Registration variables
	char test_name[100];                        // Name for comparison
	char data[100], ch;                         // String for reading file
	int x,y;                                    // Generic loop variables
	char space[100];
	char reg[100];
	int reg_flag=0;

	strcpy(key_name,"");
	strcpy(test_name,"");
	strcpy(key_board,"");
	strcpy(data,"");

	strcpy(reg_name,"deretsigernU");            // Default name is unreg
	strrev(reg_name);                           // Revers the sucker

	if (access("POWERPEX.KEY",00) == CTRUE) {   // If there is a key...
	   dfp=fopen("POWERPEX.KEY","r");           // Open the key
	   fgets(data,5,dfp);                       // Read name length
	   name_len=atoi(data);                     // Convert name len to int
	   fgets(data,5,dfp);                       // Read board length
	   board_len=atoi(data);                    // Convert board len to int
	   if ((name_len > 2) && (board_len > 1)) { // If valid lengths
		  strcpy(key_name,"\x0");               // Clear key_name
		  strcpy(key_board,"\x0");              // Clear board_name
		  for (x=0;x!=name_len;++x) {           // Loop to get sysop name
			  ch = fgetc(dfp);                  // Read sysop name character
			  key_name[x]=ch;                   // Move it to the proper loc
			  for (y=1;y<31;++y) {              // Loop to read junk
				  ch = fgetc(dfp);              // Read junk
			  }
		  }
		  key_name[x]=NULL;
		  strrev(key_name);
		  for (x=0;x!=board_len;++x) {
			  ch = fgetc(dfp);
			  key_board[x]=ch;
			  for (y=1;y<31;++y) {
				  ch = fgetc(dfp);
			  }
		  }
		  key_board[x]=NULL;
		  strrev(key_board);
	   }
	   if((strcmp(key_name,Config->sysopname) == 0) && (strcmp(key_board,Config->bbsname) ==0)) {
		   strcpy(reg_name,key_name);
		   reg_flag = 1;
	   }
	   fclose(dfp);
	}

	printf("\f");
	strcpy(space,"                           ");
	SetColor(BLUE);
	printf("%sPB/Credit - Version 1.01\n",space);
	strcpy(space,"            ");
	SetColor(CYAN);
	printf("%sA PowerPEX Developed by Gregory Gulick and Gil Gulick\n",space);
	strcpy(space,"                 ");
	SetColor(MAGENTA);
	printf("%sWritten by Gregory Gulick  Copyright 1994",space);
	SetColor(WHITE);
	printf("\n\n");
	strcpy(reg,"Registered to ");
	strcat(reg,reg_name);
	for (x=1;x!=(40-(strlen(reg)/2));++x)
		printf(" ");
	if (reg_flag == 1)
		SetColor(YELLOW);
	else
		SetColor(0x11);
	printf("%s\n",reg);
}

void press_enter(void)
{
	SetColor(WHITE);
	printf("\n\nPress [");
	SetColor(YELLOW);
	printf("Enter");
	SetColor(WHITE);
	printf("] to Continue.");
	ch=WaitKeys("\r");
}

void main(int argc, char **argv)
{

	// If PBCREDIT.LOG and UPLOAD.LOG do not exist, the program does not
	// execute.

	if (argc < 2) {
		SetColor(RED);
		printf("\nNot enough command line arguments.  See documentation.");
		press_enter();
		exit();
	}

	if ((strcmp(argv[1],"D") == 0) || (strcmp(argv[1],"d") == 0)) {
	   if ((access("PBCREDIT.LOG",00) == CTRUE) && (access("UPLOAD.LOG",00) == CTRUE)) {
		  logo();
		  read_pbcredit_log();
		  read_upload_log();
		  remove("PBCREDIT.LOG");
		  press_enter();
	   }
	}
	if (((strcmp(argv[1],"L") == 0) || (strcmp(argv[1],"l") == 0)) && (argc == 4)) {
		logo();
		ucredit=atoi(argv[2]);

		// location is an integer variable that places the credited time
		// in the right spot.  Here are the locations:
		//
		// 1 = ask for location
		// 2 = place time in bank
		// 3 = place time in real-time bbs

		if ((strcmp(argv[3],"a") == 0) || (strcmp(argv[3],"A") == 0))
			location = 1;
		else if ((strcmp(argv[3],"b") == 0) || (strcmp(argv[3],"B") == 0))
			location = 2;
		else if ((strcmp(argv[3],"r") == 0) || (strcmp(argv[3],"R") == 0))
			location = 3;
		else
			location = 3;
		if (ucredit == 0)
			ucredit = 10;
		search_accounts();
		press_enter();
	}
}
