// ATran v1.0 -- PowerPEX
// Written by Gregory Gulick
// Copyright 1994 - All Rights Reserved

#include <pb_sdk.h>

#define CTRUE 0
#define CFALSE -1

// Prototypes

void main(int argc, char **argv);
void no_memory(void);
void header(void);
void press_enter(void);
void read_cmd_line(char command_line[100]);
void get_pex_directory(char command_line[100]);
void read_protocol_info(void);
void display_protocols(void);

// Global Variables

	char ch;									// Multipurpose character
	char argument[100][100];					// Command line arguments
	int total_arguments = 0;					// Total number of arguments
	int num_of_prots;							// Number of defined protocols
	char p_description[100][100];				// Protocol description
	bool DESCRIPTIONS;							// Protocol descriptions available?
	char valid_chars[100];						// Valid protocol characters.
	char PEX_DIRECTORY[100];					// Location of PEXes
    char prot_filename[100];                    // PROTOCOL.PRO

struct protocol_type {							// Setup the protocol array struct
	char name[50];
	char key;
	char flags;
	char logfile[60];
	char ctlfile[60];
	char dlcom[128];
	char ulcom[128];
	char dlstring[80];
	char ulstring[80];
	char dlkeyword[40];
	char ulkeyword[40];
	int wordnr;
} protocol[50];

// -------------------------------------------------------------------------
// These are the general purpose, PEX utilities I use in every program:
//
//	* No Memory alert
//  * Program header
//  * Press enter to continue
//  * Read command line parsed by commas
//  * Read PEX directory
// -------------------------------------------------------------------------

void no_memory(void)
{
	printf("\f");
	SetColor(RED);
	printf("Insufficient memory to run PowerPEX!\n");
	press_enter();
	exit();										// Abort program
}

void press_enter(void)
{
	SetColor(WHITE);
	printf("\nPress [");
	SetColor(YELLOW);
	printf("Enter");
	SetColor(WHITE);
	printf("] to Continue.");
	ch=WaitKeys("\r");
}

void header(void)
{
		printf("\f");
		SetColor(WHITE);
        printf("ATran v1.0 ");
		SetColor(CYAN);
		printf(" ");
		SetColor(BLUE);
        printf("A PowerPEX by Gregory Gulick          ");
		SetColor(CYAN);
		printf("          (C) Copyright 1994\n");
		SetColor(MAGENTA);
		printf("\n\n");
}

void read_cmd_line(char command_line[100])
{

	// This function parses the command line and places the results in the
	// variable "argument[]" starting at element 1.  This is used to get
	// around the 8 or 9 parameter limit on the command line.

	char *token;

	char tokensep[]=",";

	token = strtok(command_line,tokensep);

	while (token != NULL) {
		++total_arguments;
		strcpy(argument[total_arguments],token);
		token = strtok(NULL, tokensep);
	}
}

void get_pex_directory(char command_line[100])
{

	// This function returns the user's PEX directory by parsing command
	// line parameter 0 which is the program's full pathname and filename.
	// The result is placed in the global variable PEX_DIRECTORY and can
	// be used by other funtions.

	char *location, *locations;

	if ((location = (char *) calloc(1,100)) == NULL)
		no_memory();

	locations = location;

	location = strrchr(command_line,'\\');
	strncpy(PEX_DIRECTORY, command_line,
		strlen(command_line)-strlen(location)+1);

	free(locations);
}


// -------------------------------------------------------------------------
// Beginning of main program body
// -------------------------------------------------------------------------

void read_protocol_info(void)
{
	FILE *fp;
	int loop = 0;
	char data[100];								// Read from file.

	num_of_prots = 0;							// Reset number of protocols to 0

    fp = fopen(prot_filename,"rb");            // Open for binary read

	// Note: The number of protocols starts at zero.  This is due to using
	// a C array to store the protocol information.  To get an actual number of
	// protocols, you will need to display or use an incremented num_of_prots.

	do {
		fread(&protocol[num_of_prots], sizeof(struct protocol_type),1,fp);
		if (feof(fp)) {
			--num_of_prots;
			break;
		}
		else
			++num_of_prots;
	} while (!feof(fp));

	fclose(fp);									// Close PROTOCOL.PRO

	// This next routine gathers the protocol keys and and creates a
	// string, valid_chars[], that contains the valid characters that
	// the user may enter.

	for (loop = 0; loop <= num_of_prots; ++loop)
		valid_chars[loop] = protocol[loop].key;

	++loop;
	valid_chars[loop] = '\x0';					// Place null on valid_chars

	// The next line resest loop to 0 since it is used, but not redefined
	// in the next few lines.

	loop = 0;

	// Read protocol descriptions if they exist.

	DESCRIPTIONS = FALSE;

	if (access("PROTOCOL.DSC",00) == CTRUE) {
		fp = fopen("PROTOCOL.DSC","r");
		fgets(data,100,fp);

		// The following line gets rid of the NEWLINE code.

		strncpy(p_description[loop], data, strlen(data) - 1);
		++loop;
		while((fgets(data,100,fp) != NULL) && (loop <= 50)) {
			if (strchr(data,'\x0') == NULL)
				data[100] = '\x0';
			strncpy(p_description[loop], data, strlen(data) - 1);
			++loop;
		}
		fclose(fp);

		// The next line test to see if there are an equal number of descriptions
		// as protocols read from PROTOCOL.PRO.  If not, no DESCRIPTIONS remains
		// FALSE.  Loop is decremented by one to coincide with C's method of
		// starting arrays with zero.

		if (loop-1 == num_of_prots)
			DESCRIPTIONS = TRUE;
	}
}

void display_protocols(void)
{
	int loop, x;								// Loop variables

	for (loop = 0; loop <= num_of_prots; ++loop) {
        printf("\007[\003%c\007] \007%1.20s",protocol[loop].key,
            protocol[loop].name);

		// If file descriptions are available, print them.

		if (DESCRIPTIONS == TRUE) {
			for (x = strlen(protocol[loop].name); x <= 22; ++x)
                printf("");
			printf(" \006%s\n", p_description[loop]);
		}
		else
			printf("\n");
	}
}

void main(int argc, char **argv)
{
	char transfer_data[100];					// Tranfer data area
    int loop;                                   // Loop variable

	get_pex_directory(argv[0]);

    // Check if PROTOCOL.PRO exists.  It must be located in the system
    // path.  The next sprintf() statement builds the filename with the
    // ProBoard system path.

    sprintf(prot_filename,"%sPROTOCOL.PRO",SysPath);

    if (access(prot_filename,00) == CFALSE) {
		printf("\fPROTOCOL.PRO not found.\n");
		press_enter();
		exit();
	}

	// If we are asking for a default protocol...

	if (stricmp(argv[1],"/ASK") == 0) {
		header();								// Display program header
		read_protocol_info();					// Read protocol info
		printf("\006Please select your default transfer protocol:\n\n");
		display_protocols();					// Display protocol info
		printf("\n\007[\003*\007] \007None.  \006(Select at transfer time)\n");
		printf("\n\007Selection? ");			// Prompt
		valid_chars[num_of_prots + 1] = '*';	// Place * in valid_chars
		valid_chars[num_of_prots + 2] = '\x0';	// Place null in valid_chars
		ch = WaitKeys(valid_chars); 			// Test for valid input
		if (ch == '*')
			CurUser->defaultProtocol = ' ';
		else
			CurUser->defaultProtocol = ch;
		exit(); 								// Leave program
	}

    // If we are uploading or downloading...

    if ((stricmp(argv[1],"/D") == 0) || (stricmp(argv[1],"/U") == 0)) {
        read_cmd_line(argv[2]);
        if (CurUser->defaultProtocol == ' ') {
            updown_start:                       // GOTO Label
            header();
            read_protocol_info();
            display_protocols();
            printf("\n\007[\003*\007] Select default protocol.\n");
            printf("\007[\003-\007] Abort.\n");
            valid_chars[num_of_prots + 1] = '-';    // Place - in valid_chars
            valid_chars[num_of_prots + 2] = '*';    // Place * in valid_chars
            valid_chars[num_of_prots + 3] = '\x0';  // Place null in valid_chars
            printf("\n\007Selection? ");
            ch = WaitKeys(valid_chars);             // Test for valid input
            printf("%c",ch);
            if (ch == '-')
                exit();
            else if (ch == '*') {
                printf("\n\nEnter default protocol (\003*\007 for none): ");
                ch = WaitKeys(valid_chars);
                printf("%c\n",ch);
                if ((ch == '*') || (ch == '-')) {
                    CurUser->defaultProtocol = ' ';
                    goto updown_start;
                }
                else {
                    CurUser->defaultProtocol = ch;
                    sprintf(transfer_data,"/K=%c ", ch);
                }
                press_enter();
            }
            else
                sprintf(transfer_data,"/K=%c ", ch);
        }
        else
            sprintf(transfer_data,"/K=%c ", CurUser->defaultProtocol);
        for (loop = 1; loop <= total_arguments; ++loop) {
            strcat(transfer_data,argument[loop]);
            strcat(transfer_data," ");
        }
        strcat(transfer_data,"\x0");

        if (stricmp(argv[1],"/D") == 0)
            MenuFunction(MENU_DOWNLOAD, transfer_data);
        else if (stricmp(argv[1],"/U") == 0)
            MenuFunction(MENU_UPLOAD, transfer_data);
		exit();
	}
}
